/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** COLISION.CC: This file is part of the BETATRON library and can be used
 **              and/or distributed only under the terms of the GNU Library
 **              General Public License. See doc/readme.1st for details.
 */


#include "world.h"
#include "plvga.h"
#include <string.h>

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------


char TOworld::collision(TOobject *spr1,TOobject *spr2)
{
 unsigned short len1,hei1,len2,hei2;
 unsigned short x11,y11,x12,y12;
 unsigned short x21,y21,x22,y22;
 unsigned short xc1,yc1,xc2,yc2;   // xcommon1 ...
 char bool0;
 short i;
 char linecolid=0, columncolid=0; // 1:an iparxei collision se kapoia
				  // apo tis dio diastaseis
 char *mask1,*mask2;	// deiktes stis collide maskes ton dio sprites
 short dxx,dyy;        // dxx= x11-x21 , dyy=y11-y21


 TPframedescr frame1,frame2;
  x11 = spr1->x;  y11 = spr1->y;
  x21 = spr2->x;  y21  = spr2 ->y;

 if (!spr1->framesbit)
  {
   len1=spr1->slen; hei1 = spr1->shei; }
  else
  {
   frame1=framesdescr[((TOsprite *)spr1)->framebase+((TOsprite *)spr1)->framenow];
   len1=frame1->len;
   hei1=frame1->hei;
   x11+=frame1->xdispl;
   y11+=frame1->ydispl;
  }

 if (!spr2->framesbit)
  {
   len2=spr2->slen; hei2 = spr2->shei; }
  else
  {
   frame2=framesdescr[((TOsprite *)spr2)->framebase+((TOsprite *)spr2)->framenow];
   len2=frame2->len;
   hei2=frame2->hei;
   x21+=frame2->xdispl;
   y21+=frame2->ydispl;
  }

  x12 = x11 + len1 -1;	y12 = y11 +hei1-1;
  x22 = x21  + len2-1;	y22 = y21 + hei2 -1;

  xc1=x21; xc2=x22; yc1=y21;  yc2=y22;

  // ean ena toulaxiston apo ta dio sprites den exei frames
  // i ean ena toulaxiston apo ta dio sprite frames den exei collide maska
  // i ta koutia tous den simpiptoun tote fige


  MACROcmplace(x11,y11,x12,y12,xc1,yc1,xc2,yc2,bool0);

  if ( (!spr1->framesbit) || (!spr2->framesbit) ||
       (!bool0) || (!frame1->colidemask) || (!frame2->colidemask) )
   return bool0;

//  algorithmos collision detection
//  bres to koino tmima ton dio koution pou perivaloun ta sprites
//  an den iparxei koino meros tote collision=false
// 1. Gia kathe mia koini grammi ton plaision vres an kai ta
//    antistoixa tmimata ton sprites pou orizontai apo tin collide
//    maska tous temnontai
// 2. To idio kane kai gia tis koines stiles
//
// An toulaxiston mia grammi KAI mia stili temnontai tote collision = TRUE
// else collision = FALSE

// Grigoros elegxos gia to an temnontai dio tmimata pou exoun koino aksona
// Esto dio tmimata se koino aksona
//  **	 **
// Ax1			Ax2	 Bx1	     Bx2
//  An (Bx1-Ax2)*(Bx2-Ax1) > 0 ta tmimata DEN temnontai diaforetika temnontai

// pio periliptiki perigrafi tou algorithmou collision
// for i=yc1 to yc2
// {  line1x1 = (x11-xc1) + collidemask1[ (i-y11)*2]
//    line1x2 = (x11-xc1) + collidemask1[ (i-y11)*2 +1]
//    line2x1 = (x21-xc1) + collidemask2[ (i-y21)*2]
//    line2x2 = (x21-xc1) + collidemask2[ (i-y21)*2 +1]
//	if (  (line2x2 - line1x1) *(line2x2 - line1x2) < 0) then
//    {  xcolide=true ; break; }
//    }
// line2x2-line1x1 =  x21-x11  + (mask2x2-mask1x1)
// line2x1-line1x2 =  x21-x11  + (mask2x1-mask1x2)



 mask1=frame1->colidemask;
 mask2=frame2->colidemask;



// elegkse ean iparxei collision se grammes prota
   dxx = x21-x11;
// min ksexaseis na prostheseis stis maskes yc1-y11 kai yc1 -y21

asm ("                           \n \
	pusha								  \n \
	movl	   %1,%%esi						  \n \
	movl	   %2,%%edi						  \n \
	xorl	%%eax,%%eax						  \n \
									  \n \
	movw	 %3,%%ax						  \n \
	subw	 %4,%%ax						  \n \
	shlw	$1,%%ax 						  \n \
	addl	%%eax,%%esi						  \n \
									  \n \
	movw	 %3,%%ax						  \n \
	subw	 %5,%%ax						  \n \
	shlw	$1,%%ax 						  \n \
	addl	%%eax,%%edi						  \n \
									  \n \
									  \n \
	movw	 %3,%%cx   # arxise apo to koino y			  \n \
col_vloop:								  \n \
	cmpw	 %6,%%cx   # ftasame sto telos tou koinou tmimatos	  \n \
	jg	col_fin      # fige					  \n \
									  \n \
	movb	1(%%edi),%%al	# al mask2x2				  \n \
	xorb	%%ah,%%ah						  \n \
	movb	(%%esi),%%bl	# bl mask1x1				  \n \
	xorb	%%bh,%%bh						  \n \
	subw	%%bx,%%ax	#ax mask2x2 - mask1x1			  \n \
	movw	 %7,%%dx						  \n \
	addw	%%ax,%%dx	# dx = x21-x11 + mask2x2 - mask1x1	  \n \
									  \n \
	movb	(%%edi),%%al	# al mask2x1				  \n \
	xorb	%%ah,%%ah						  \n \
	movb	1(%%esi),%%bl	# bl mask1x2				  \n \
	xorb	%%bh,%%bh						  \n \
	subw	%%bx,%%ax	#ax mask2x1 - mask1x2			  \n \
	addw	 %7,%%ax	#ax = x21-x11 + mask2x1 - mask1x2	  \n \
# vrikame tis dio diafores tora prepei na tis pollaplasiasoume		  \n \
	imulw	%%dx		# ax=ax*dx				  \n \
	cmpw  $0,%%ax							  \n \
	jg	   col_goon	# an einai thetiko den exoume collision st\n \
	movb	$1,%0		# exoume colision orizontio fige	  \n \
	jmp	col_fin 					  \n \
col_goon:								  \n \
	addl	$2,%%edi	# epomeni grammi sti maska2		  \n \
	addl	$2,%%esi	# epomeni grammi sti maska1		  \n \
	incw	%%cx							  \n \
	jmp	col_vloop		  \n \
col_fin:    \n \
   popa": "=m" (linecolid): "m" (mask1),"m" (mask2),"m" (yc1),"m" (y11),
			    "m" (y21), "m" (yc2), "m" (dxx): "memory","cc");







  // etoimasou na elegxseis kai tis stiles
 dyy = y21 - y11;

 mask1 += (hei1<<1) + (( xc1 - x11) <<1); // pigaine stis stiles , stis koines stiles
 mask2 += (hei2<<1) + (( xc1 - x21) <<1);


 asm ("  \n \
	pusha								\n \
	movl	   %1,%%esi						\n \
	movl	   %2,%%edi						\n \
									\n \
	movw	 %3,%%cx # arxise apo to koino x			\n \
col_hloop:								\n \
	cmpw	 %4,%%cx # ftasame sto telos tou koinou tmimatos	\n \
	jg	col_fin2	   # fige				\n \
									\n \
	movb	1(%%edi),%%al	# al mask2y2				\n \
	xorb	%%ah,%%ah						\n \
	movb	(%%esi),%%bl	# bl mask1y1				\n \
	xorb	%%bh,%%bh						\n \
	subw	%%bx,%%ax #ax mask2y2 - mask1y1 			\n \
	movw	 %5,%%dx						\n \
	addw	%%ax,%%dx # dx = y21-y11 + mask2y2 - mask1y1		\n \
									\n \
	movb	(%%edi),%%al	# al mask2y1				\n \
	xorb	%%ah,%%ah						\n \
	movb	1(%%esi),%%bl	# bl mask1y2				\n \
	xorb	%%bh,%%bh						\n \
	subw	%%bx,%%ax #ax mask2y1 - mask1y2 			\n \
	addw	 %5,%%ax #ax = y21-y11 + mask2y1 - mask1y2		\n \
# vrikame tis dio diafores tora prepei na tis pollaplasiasoume		\n \
	imulw	%%dx	# ax=ax*dx					\n \
	cmpw	$0,%%ax 						\n \
	jg	col_goon2	# an einai thetiko den exoume collision \n \
	movb	$1,%0		# exoume colision katheto, fige 	\n \
	jmp	col_fin2						\n \
col_goon2:								\n \
	addl	$2,%%edi # epomeni grammi sti maska2			\n \
	addl	$2,%%esi # epomeni grammi sti maska1			\n \
	incw	%%cx							\n \
	jmp	col_hloop						\n \
col_fin2:								\n \
	popa":"=m" (columncolid): "m" (mask1),"m" (mask2),"m" (xc1),"m" (xc2),
			     "m" (dyy): "memory","cc");



  // epestrepse true mono an exoume kai orizontio kai katheto collision
  return (linecolid  && columncolid);

}






//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
// ftiaxnei mia colide mask
// opou pdata deiktis se pinaka sprlen*sprhei  bytes
// pou periexei to spr frame
// mask deiktis se pinaka 2*(sprlen+sprhei) pou tha periexei ti
// maska
// prota topothetountai 2 bytes gia kathe grammi tou frame sinolika 2*sprhei
// to 1o apo ta dio bytes einai i apomakrinsi apo ti stili 0 tou protou
// mia transparent pixel autis tis grammis, eno to allo byte einai i
// apomakrinsi tou teleutaiou mi transparent pixel autis tis grammis
// Sti sinexeia topothetountai 2 bytes gia kathe stili ta opoia
// exoun analogo rolo

void pl_makecolidmask(char *pdata,short sprlen, short sprhei,char *mask)
{
 int i,j;
 char *p; // tmp deiktis

 // Prota ftiakse ti mask pou afora tis grammes

 p=pdata;
 for (i=0;i<sprhei;i++)
 {
  for (j=0;;j++)
  {
   if (j==sprlen)
   {
     mask[i<<1]=0; // ola ta pixel einai transparent vale oti to proto mi
		   // trasnparent einai sti thesi 0
     break;	 // vges apo to vroxo
   }

   if (p[j])  // vrikame mi transparent pixel
   {	mask[i<<1]=j; break; }
  }

 for (j=sprlen-1;;j--)
 {
   if (j<0)
    {
     mask[(i<<1)+1]=0; break;}
    if (p[j]) // non transparent
     {mask[(i<<1)+1]=j; break; }
  }
  p+=sprlen;   // pigaine stin parakato grammi
 }

 p=pdata;
 mask+=(sprhei<<1); // o deiktis sti maska pou afora tis stiles



 for (j=0; j<sprlen; j++)   // gia kathe mia stili
 {
  p=pdata+j;

  for (i=0;;i++)
  {
   if (i==sprhei) { mask[j<<1]=0; break; } //den iparxei non transparent pixel
   if (*p) { mask[j<<1]=i; break; }
   p+=sprlen;  //epomeno pixel tis stilis
  }

  p=pdata+j+ (sprhei-1)*sprlen;
  for (i=sprhei-1;;i--)
  {
   if (i<0) { mask[(j<<1)+1]=0; break; }
   if (*p)  { mask[(j<<1)+1]=i; break; }
   p-=sprlen;
  }
}


}


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

short TOworld::makeframecolidmask(unsigned short descrno)
{

 TPframedescr descr=framesdescr[descrno];
 static unsigned char edge0[500],edge1[500];
 char subframesno=descr->bitmapsno;
 short int i,j,k;
 unsigned short fx,fy,sfno;
 unsigned short *fdata;
 TPbitmap pbit;
 char *bitdata;
 char *bdata;
 char *collisiondata;
 short l,h;
 long errc;
 char *raw=NULL;

// an den exei desmeuthei mnimi gia tin collision maska prospathise
// na desmeuseis
 if (!descr) return ERR_NULLDESCR;
 if (!descr->colidemask)
 if (!(descr->colidemask= (char *) malloc((descr->len+descr->hei)<<1)) )
 return ERR_OUTOFMEM;

#define free_ret(val) { free(descr->colidemask); descr->colidemask=NULL; return val; }

 collisiondata=descr->colidemask;

 // prota tha doulepsoume me tis grammes
  memset(edge0,255,500); // arxikopoiise aristeri edgelist sto megisto arithmo
  memset(edge1,0,500)  ; // arxikopoiise deksia edgelist ston elaxisto arithmo
  fdata=(unsigned short *)(descr->data);

 for (i=0;i<subframesno;i++)
 {
   fx=*(fdata);
   fy=*(fdata+1);
   sfno=*(fdata+2);
   fdata+=3; // pigaine stin perigrafi tou epomenou subframe
   pbit=bitmaps+sfno;
   bdata=pbit->data;
   if (!bdata) continue;
   l=pbit->len; h=pbit->hei;

   switch (pbit->format)
   {

    case FR_4PLANES:
		   for (j=0;j<h;j++) // gia oles tis grammes tou bitmap
		   {
		    if ( fx < edge0[j+fy]) edge0[j+fy]=fx; // valto stin edge list.
		    if ( l-1+fx > edge1[j+fy]) edge1[j+fy]=l-1+fx; // valto stin edge list.
		   }

		   break;

    case FR_RLE:
		  if ( !(raw=pl_rle2raw(bdata,l,h)) ) free_ret(ERR_OUTOFMEM);
		  bdata=raw;

    case FR_RAW:

		 bitdata=bdata;

		 for (j=0;j<h;j++,bitdata+=l) // gia oles tis grammes tou bitmap
		 {
		  for (k=0;k<l;k++)
		  if (bitdata[k]) // vrikame mi transparent pixel
		  {
		   if ( k+fx < edge0[j+fy]) edge0[j+fy]=k+fx; // valto stin edge list.
		   break;   // kai pigaine ston epomeno vroxo
		  }

		  for (k=l-1; k>=0; k--)
		  if (bitdata[k]) // vrikame mi transparent pixel
		  {
		   if ( k+fx > edge1[j+fy]) edge1[j+fy]=k+fx; // valto stin edge list.
		   break;   // kai pigaine ston epomeno vroxo
		  }
		 }

		 if (raw) { free(raw); raw=NULL; }
		 break;

	} //switch

  }  // teleiosan ta sub frames

  for (i=0;i<descr->hei;i++) // grapse tin colidmask apo tis edge lists sti thesi tis
  {
   (*collisiondata)=edge0[i];
   collisiondata++;
   (*collisiondata)=edge1[i];
   collisiondata++;
  }

 // etoimasou na kaneis ta idia kai gia tis stiles.

  memset(edge0,255,500); // arxikopoiise pano edgelist sto megisto arithmo
  memset(edge1,0,500)  ; // arxikopoiise kato edgelist ston elaxisto arithmo

 fdata=(unsigned short *)(descr->data);
 for (i=0;i<subframesno;i++)
 {
   fx=*(fdata);
   fy=*(fdata+1);
   sfno=*(fdata+2);
   fdata+=3; // pigaine stin perigrafi tou epomenou subframe
   pbit=bitmaps+sfno;
   bdata=pbit->data;
   if (!bdata) continue;
   l=pbit->len; h=pbit->hei;


   switch (pbit->format)
   {

    case FR_4PLANES:   // if format is 4 planes it is a solid bitmap
		       // just get the bounding box

	       for (j=0;j<l;j++) // gia oles tis stiles tou bitmap
	       {
		if ( fy < edge0[j+fx]) edge0[j+fx]=fy; // valto stin edge list.
		if ( h-1+fy > edge1[j+fx]) edge1[j+fx]=h-1+fy; // valto stin edge list.
	       }
	       break;

    case  FR_RLE:   // try to convert it in RAW format
		  if ( !(raw=pl_rle2raw(bdata,l,h)) ) free_ret(ERR_OUTOFMEM);
		  bdata=raw;
		  // dont' break;

    case  FR_RAW:
	    for (j=0;j<l;j++) // gia oles tis stiles tou bitmap
	    {
	      bitdata=bdata+j;

	      for (k=0;k<h;k++,bitdata+=l)
	      if (*bitdata) // vrikame mi transparent pixel
	      {
	       if ( k+fy < edge0[j+fx]) edge0[j+fx]=k+fy; // valto stin edge list.
	       break;	// kai pigaine ston epomeno vroxo
	      }

	      bitdata=bdata+j+ (h-1)*(l);

	      for (k=h-1; k>=0; k--,bitdata-=l)
	      if (*bitdata) // vrikame mi transparent pixel
	      {
	       if ( k+fy > edge1[j+fx]) edge1[j+fx]=k+fy; // valto stin edge list.
	       break;	// kai pigaine ston epomeno vroxo
	      }
	    } // for

	    if (raw) { free(raw); raw=NULL; }
	    break;

    }// switch

  }  // teleiosan ta sub frames

  for (i=0;i<descr->len;i++) // grapse tin colidmask apo tis edge lists sti thesi tis
  {
   (*collisiondata)=edge0[i];
   collisiondata++;
   (*collisiondata)=edge1[i];
   collisiondata++;
  }


 return ERR_NOERR;
}


