/*  Example programs for BETATRON game library.
 ** Copyright (C) 1997 Liouros Thanasis, liouros@hotmail.com
 **
 ** ex1b.cc:	This file is part of the example programs for BETATRON game
 **		library and can be used and/or distributed only under the terms
 **		of the GNU General Public License. See doc/examples.txt for
 **		details.
 */

#include <string.h>
#include "world.h"
#include "plkeys.h"
#include "plvesa.h"
#include <stdlib.h>

TOworld myworld;

#define        WLEN		    62
#define        WHEI		    52


// 2 tiles are enough for this example
char mytiles[2][256];

unsigned short letters[31*11]= {
1, 0, 0,  0, 1, 1, 1,  0, 0, 1, 0,  0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 0, 0,  0, 1, 0, 0,  0, 0, 1, 0,  0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 1, 1,  0, 1, 1, 0,  0, 1, 1, 1,  0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0,
1, 0, 1,  0, 1, 0, 0,  0, 0, 1, 0,  0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0,
1, 1, 1,  0, 1, 1, 1,  0, 0, 1, 1,  0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0,
0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0,  0, 0, 0, 0,  0, 1, 1, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0,  0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0,  0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0,  0, 0, 0, 0,  0, 1, 1, 1,  0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
			};

// the background layer
unsigned short mybacklayer[WLEN*WHEI];

// this action belongs to exitobj
void exitaction(TOobject *s)
{
 char ch;

  // scroll steps:    4 pixels/frame for horizontal scrolling (can be up to 16)
  //		  and 3 pixels/frame for vertical scrolling (can be up to 16)
 static char ddx=4,ddy=3;
 TOworld *w=s->owner;	    // get a pointer to myworld

 if (pl_testkey(mcR))
 {
   // restore the hardware state of the VESA mode
   if (w->curmode!=gmMODEX320x200) pl_restoreVESAstate();
   w->refresh(); // tell the world to refresh the view
 }

 if (pl_testkey(mcESC)) w->exitbit=1;

     if (pl_testkey(mcLARROW)) w->scrollR(-ddx);      // scroll left
else if (pl_testkey(mcRARROW)) w->scrollR(ddx);       // scroll right

     if (pl_testkey(mcUARROW))	w->scrollD(-ddy);     // scroll up
else if (pl_testkey(mcDARROW))	w->scrollD(ddy);      // scroll down

};



void main(int c,char **v)
{
 char ch1,ch2;
 int i,j;
 TOobject exitobj;     // this is the exit object
		       // it is used to make TOworld::animate() exit
		       // and in this example to do some scrolling too
 Tplmode *modes;
 int modesno;
 int modenumber;

 // set the dimensions of the world
 myworld.setdimensions(WLEN,WHEI);
 // set the background layer pointer to the external array 'mybacklayer'
 myworld.setlayer(LAY_BACK,mybacklayer);
 // fill the background layer with tile number 0
 memset(mybacklayer,WLEN*WHEI*sizeof(short),0);

 // put the red letters in the background layer
 for (i=0;i<31;i++)
 for (j=0;j<11;j++)
 myworld.setlayervalue(LAY_BACK,i+18,j+15,letters[j*31+i]);

 // make foreground layer
 // BETATRON always needs at least background and foreground layers
 // to work. So we create the foreground layer even if it is not used in
 // this example
 CHECK(myworld.makelayer(LAY_FORE));

 // reserve memory for 2 tile pointers
 CHECK(myworld.maketiles(2));

 // set color 246 to red
 myworld.rgbset(246,56,0,0);

 // fill tile 1 with red coll
 memset(mytiles[1],246,256);

 // make a funny image for tile 0
 for (i=0;i<16;i++)
 for (j=0;j<16;j++)
  mytiles[0][i*16+j]=67+j+i;


 // insert the tiles in the world
 for (i=0;i<2;i++) myworld.settile(i,mytiles[i]);


 // initialize the exit object
 exitobj.init(0,0,0,0,0);
 // set the active action of the exit object to 'exitaction'
 exitobj.nextaction=exitaction;
 // add 'exitobj' to the world, in object list 0 and priority list 0
 myworld.addobj(0,&exitobj,0);

 modesno=0;
 if (pl_initvesa()==ERR_NOERR) // ERR_NOERR==0
 {
  CHECK(modesno=pl_getvesamodes(modes));
 }
 printf("Example program 1b. Copyright 1997 Liouros Thanasis\n");
 printf("--------------------------------------------------\n");
 printf("This program comes with NO WARRANTY.\n");
 printf("See doc/examples.txt for details.\n\n");
 printf("Use the arrows to move the view window. ESC to exit.\n\n");

 printf("Mode number   Xresolution   Yresolution\n");
 printf("0x%.3x         %d           %d\n",0,320,200);
 for (i=0;i<modesno;i++)
  printf("0x%.3x         %d           %d\n",modes[i].modeno,modes[i].Xres,modes[i].Yres);

 printf("Enter mode number: ");
 scanf("%x",&modenumber);

 // Convert the tiles to 4PLANES format if the mode is modex 320x200
 // (VESA 2.00 modes need the tiles in RAW format)
 if (modenumber==gmMODEX320x200) myworld.tilesto4PLANES();

 // try to initialize the values for the desired mode
 CHECK( myworld.initmode(modenumber)  );
 // try to set the desired mode
 CHECK(myworld.setmode());
 // save the VESA mode state so it can be restored, in case it is corrupted
 if (modenumber!=gmMODEX320x200) pl_saveVESAstate();
 // move the view window to pixel coordinates (0,0)
 myworld.jumpto(0,0);

 pl_installkeys();  // install BETATRON keyboard handler
 // and start the game engine
 myworld.animate();
 pl_keysdone();   // restore the original keyboard handler
 pl_donevesa();
 // set text mode
 pl_setvideomode(3);
}
