#include <conio.h>
#include <go32.h>
#include <keys.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/farptr.h>

#include "colour.h"
#include "config.h"
#include "desktop.h"
#include "dialog.h"
#include "dlgobj.h"
#include "error.h"
#include "event.h"
#include "menu.h"
#include "misc.h"
#include "mouse.h"
#include "refresh.h"
#include "statbar.h"

/*

	desktop.c

		Desktop stuff

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	DATA
*/

T_Group	*gDesktop = NULL;

static	T_StatusBar	*sDesktop_StatusBar = NULL;

/*
	FUNCTION	PROTOTYPES
*/

static	bool	DesktopBackground_EventHandler( void *aBackground, T_EventRec *aEvent );
static	void	DesktopBackground_Draw( T_MinimumDesktopObject *aBackground, T_EventDrawParameters *aParams );

extern	void	Desktop_InitialiseMenuBar( T_MenuBar *aMenuBar );

/*
	FUNCTION	DEFINITIONS
*/

void	Desktop_Initialise( void )
{
	T_MenuBar					*lMenuBar;
	T_MinimumDesktopObject	*lBackground;

	gDesktop = Group_Initialise( 0, 0, gScreen_Width-1, gScreen_Height-1, FLAG_NOCLOSEBUTTON );

	P_InitVar( lBackground, T_MinimumDesktopObject );

	lBackground->fEventHandler = DesktopBackground_EventHandler;

	Group_AddObject( gDesktop, lBackground, 0, 1, gDesktop->fX2-gDesktop->fX1, gDesktop->fY2-gDesktop->fY1-1, FLAG_NONE );

	lMenuBar = MenuBar_Initialise( gDesktop->fX1, gDesktop->fY1, gDesktop->fX2, gDesktop->fY2-1 );

	Desktop_InitialiseMenuBar( lMenuBar );

	Group_AddObject( gDesktop, lMenuBar, 0, 0, gDesktop->fX2-gDesktop->fX1, gDesktop->fY2-gDesktop->fY1-1, FLAG_NONE );

	sDesktop_StatusBar = StatusBar_Initialise();

	Group_AddObject( gDesktop, sDesktop_StatusBar, 0, gDesktop->fY2-gDesktop->fY1, gDesktop->fX2-gDesktop->fX1, gDesktop->fY2-gDesktop->fY1, FLAG_NONE );

	Mouse_TurnCursorOn();
}

void	Desktop_Terminate( void )
{
	Mouse_TurnCursorOff();

	Group_Kill(	gDesktop );

	textmode( C80 );
}

inline	void	Desktop_SetStatusString( const char *aString )
{
	if ( gDesktop->fVisible )
	{
		StatusBar_SetStatusString( sDesktop_StatusBar, aString );
	}
}

bool	DesktopBackground_EventHandler( void *aBackground, T_EventRec *aEvent )
{
	bool	lRetVal = false;

	switch ( aEvent->fMessage )
	{
		case	EVENT_KILL:
			lRetVal = true;
			break;
		case	EVENT_DRAW:
			DesktopBackground_Draw( aBackground, &aEvent->fParameters.fDrawParams );
			lRetVal = true;
			break;
		case	EVENT_COMMANDENABLED:
		case	EVENT_KEYPRESS:
		case	EVENT_LEFTMOUSECLICK:
		case	EVENT_RIGHTMOUSECLICK:
		case	EVENT_CANFOCUS:
		case	EVENT_SHOW:
		case	EVENT_HIDE:
			break;
		default:
			FatalError( "Unhandled message" );
			break;
	}
	return lRetVal;
}

void	DesktopBackground_Draw( T_MinimumDesktopObject *aBackground, T_EventDrawParameters *aParams )
{
	int	i, lX1, lY1, lX2, lY2;
	char	lStr[aBackground->fWidth+1];

	T_Buffer	*lBuffer = aParams->fBuffer;

	lX1 = aParams->fX;
	lX2 = lX1+aBackground->fWidth-1;
	lY1 = aParams->fY;
	lY2 = lY1+aBackground->fHeight-1;

	memset( lStr, '', aBackground->fWidth );

   for ( i = lY2; i >= lY1; i-- )
   {
		Buffer_Print( lBuffer, lX1, i, lX2, i, lStr, COLOUR_BACKGROUND );
   }
}


