#ifndef	__CDESKTOP_GROUP_H__
#define	__CDESKTOP_GROUP_H__

#ifdef	__cplusplus
extern "C" {
#endif

/*

	group.h

		Handles the	object groups (ie dialogs, menu bars and the desktop)

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	MODAL CLOSING COMMANDS
*/

#define	ENDMODAL_NONE					-1
#define	ENDMODAL_OK						0
#define	ENDMODAL_CANCEL				1
#define	ENDMODAL_YES					2
#define	ENDMODAL_NO						3
#define	ENDMODAL_CLOSE					4
#define	ENDMODAL_EXECUTECOMMAND		5

/*
	STRUCTURE DEFINITIONS
*/

typedef	struct	S_Group
{
	int	fX1, fY1, fX2, fY2, fFlags;	/* offset in the physical screen */

	int	fCloseModalCommand, fCloseModalID;	/// create union for arguments if more than just id needed

	int	fVisible;	/* keeps count, so every show must be matched by a hide */

	struct S_ObjectRec	*fObjectList, *fFocused;
} T_Group;

/*
	FUNCTION PROTOTYPES
*/

extern	T_Group		*Group_Initialise( int aX1, int aY1, int aX2, int aY2, int aFlags );
extern	void			Group_AddObject( T_Group *aGroup, void *aObject, int aX1, int aY1, int aX2, int aY2, int aFlags );
extern	void			Group_RedrawObject( T_Group *aGroup, void *aObject );
extern	void			Group_RemoveObject( T_Group *aGroup, void *aObject );
extern	bool			Group_HandleLeftMousePress( T_Group *aGroup, int aColumn, int aRow );
extern	bool			Group_HandleRightMousePress( T_Group *aGroup, int aColumn, int aRow );
extern	void			Group_FocusNext( T_Group *aGroup );
extern	void			Group_FocusPrevious( T_Group *aGroup );
extern	void			Group_FocusObject( T_Group *aGroup, void *aObject );
extern	bool			Group_HandleKeypress( T_Group *aGroup, int aKeypress );
extern	bool			Group_Broadcast( T_Group *aGroup, T_EventRec *aEvent );
extern	void			Group_GoModal( T_Group *aGroup );
extern	void			Group_Kill( T_Group *aGroup );
extern	struct S_ObjectRec	*Group_FindObject( T_Group *aGroup, void *aObject );

/*
	EXTERNAL VARIABLES
*/

extern	T_Group	*gEvent_ModalGroup;

#ifdef	__cplusplus
}
#endif

#endif




