/********************************************************


                         CEKANI

           .ANI File Loader Library to DJGPP.

      Copyright (c) 2000 by Cristian EmmericK (CEK)

              E-mail: cek@mailbr.com.br

                 ICQ(UIN): 52438873


*********************************************************

                        FILE INFO:

  ANIVIEW.C

  This is a tool to you browser yours .ANI files, and
convert them to bmp.


********************************************************/

#include <fcntl.h>
#include <sys/stat.h>


#include "allegro.h"

#include "cekani.h"
#include "aniview.h"
#include "tdgui.h"


#define WHITE  makecol16(255,255,255)
#define BLACK  makecol16(  0,  0,  0)
#define BAR    makecol16(  0,  0,128)
#define FORE   makecol16(191,191,191)
#define BACK   makecol16(127,127,127)
#define GREEN  makecol16(  0,255,  0)


void PUT_IMAGE(int x, int y, BITMAP *src, BITMAP *dest)
{
  blit(src,dest,0,0,x,y,src->w,src->h);
}

void PUT_MASK(int x, int y, BITMAP *src, BITMAP *dest)
{
  masked_blit(src,dest,0,0,x,y,src->w,src->h);
}


void next();
void showactual();
void load_animation();
void next_anim();
void fbshow();
void stopani();

CURSOR *cursor;
BITMAP *guibmp;

char *hlp;
char cursorinam[256]="";
char cursorsize[256]="";
char cursorauthor[256]="";
char cursorwidth[256]="";
char cursorheight[256]="";
char cursorframes[256]="";
char cursorsteps[256]="";
char cursorcdepth[256]="";
int  fileok=0;
int  loop=1;
int  stop=0;
int  finished=0;
char currentstep[256]="";
char frame[256]="";
char rate[256]="";
char xhotspot[256]="";
char yhotspot[256]="";
int  zoom=1;
char charzoom[256]="";
int  framecurrent=1;
char charframecurrent[256]="";
char temp[256]="";
char anipath[256]=".\\";
char anifile[256]="";
char title[256]="CEKANI - ANIViewer v1.0, by Cristian EmmericK (CEK) - []";
extern DIALOG the_dialog[];
char helptxt[100000]="";

DATAFILE *datafile;




void load_animation()
{
  showactual();
  remove_int(load_animation);
}
END_OF_FUNCTION(load_animation);



void play_animation()
{
  if(stop==1) remove_int(play_animation);

  sprintf(currentstep,"%d    "   ,framecurrent);
  sprintf(frame,"%d    "   ,cursor_seq(cursor,framecurrent-1));
  sprintf(rate,"%d    "   ,cursor_rate(cursor,framecurrent-1));
  sprintf(xhotspot,"%d    "   ,cursor_xhotspot(cursor,framecurrent-1));
  sprintf(yhotspot,"%d    "   ,cursor_yhotspot(cursor,framecurrent-1));
  SEND_MESSAGE((the_dialog+34), MSG_DRAW, 0);
  SEND_MESSAGE((the_dialog+35), MSG_DRAW, 0);
  SEND_MESSAGE((the_dialog+36), MSG_DRAW, 0);
  SEND_MESSAGE((the_dialog+37), MSG_DRAW, 0);
  SEND_MESSAGE((the_dialog+38), MSG_DRAW, 0);

  finished=1;
  remove_int(play_animation);

}
END_OF_FUNCTION(play_animation);



void timer_animation()
{
  if(fileok==1)
  {
    if(stop==1) {remove_int(timer_animation); remove_int(play_animation);}
    if(finished==1)
    {
      finished=0;
      showactual();
      install_int(play_animation,cursor_rate(cursor,framecurrent-1)*(1000/60));
      next_anim();
    }
  }
}
END_OF_FUNCTION(timer_animation);


void next_anim()
{
  if(fileok==1)
  {
    framecurrent++;

    if(framecurrent<1) framecurrent=1;
    if(framecurrent>cursor_steps(cursor))
    {
      if(loop==0) remove_int(timer_animation);
      else framecurrent=1;
    }
  }
}


void fbshow()
{
  billfile_select("File Select",anipath,"ANI");

  strcpy(anifile,anipath);
  strcpy(anifile,get_filename(anifile));

  strupr(anipath);
  strupr(anifile);

  sprintf(title,"CEKANI - ANIViewer v1.0, by Cristian EmmericK (CEK) - [%s]",anifile);
}


int quit()
{
  stopani();

  if(billalert("Quit?", "Really want to quit?", NULL, "Yes", "Cancel", 'y', 27) == 1)
  return D_CLOSE;
  else
  return D_O_K;
}


void showactual()
{
  if(fileok==1)
  {
    clear_to_color(guibmp,FORE);
    set_pallete(cursor_pallete(cursor,framecurrent-1));

    cursor_blit(guibmp,cursor,framecurrent-1,0,0);

    scare_mouse();
    vsync();
    rectfill(screen,15,200,15+128,200+128,BACK);
    rect(screen,15,200,15+128,200+128,BLACK);

    stretch_blit(guibmp,screen,0,0,cursor_width(cursor),cursor_height(cursor),16,201,cursor_width(cursor)+zoom,cursor_height(cursor)+zoom);
    unscare_mouse();
    unselect_palette();
  }
}


int load()
{
  stopani();
  fbshow();

  cursor=load_ani(anipath);
  if(!cursor)
  {
    sprintf(temp,"There was an error while trying to load the %s file!",anifile);
    billalert("Error Loading...",temp, NULL, "OK", 0,0,0);

    strcpy(anifile,"");

    sprintf(title,"CEKANI - ANIViewer v1.0, by Cristian EmmericK (CEK) - [%s]",anifile);
    strcpy(cursorinam,"");
    strcpy(cursorsize,"");
    strcpy(cursorauthor,"");
    strcpy(cursorwidth,"");
    strcpy(cursorheight,"");
    strcpy(cursorframes,"");
    strcpy(cursorsteps,"");
    strcpy(cursorcdepth,"");
    strcpy(charframecurrent,"    ");
    strcpy(charzoom,"    ");

    strcpy(currentstep,"    ");
    strcpy(frame,"    ");
    strcpy(rate,"    ");
    strcpy(xhotspot,"    ");
    strcpy(yhotspot,"    ");

    zoom=0;
    fileok=0;
    framecurrent=1;
    SEND_MESSAGE((the_dialog + 25), MSG_DRAW, 0);

    stopani();

    return D_REDRAW;

  }

  framecurrent=1;

  sprintf(title,"CEKANI - ANIViewer v1.0, by Cristian EmmericK (CEK) - [%s]",anifile);
  strncpy(temp,cursor_getname(cursor),50);
  sprintf(cursorinam,"%s"         ,temp);
  sprintf(cursorsize,"%d bytes "   ,cursor_getsize(cursor));
  strncpy(temp,cursor_getauthor(cursor),50);
  sprintf(cursorauthor,"%s"       ,temp);
  sprintf(cursorwidth,"%d pixels     " ,cursor_width(cursor));
  sprintf(cursorheight,"%d pixels    ",cursor_height(cursor));
  sprintf(cursorframes,"%d    "       ,cursor_frames(cursor));
  sprintf(cursorsteps,"%d     "        ,cursor_steps(cursor));
  sprintf(cursorcdepth,"%d bit      "   ,cursor_getcolordepth(cursor));
  sprintf(charframecurrent,"%d    "   ,framecurrent);
  zoom=0;
  sprintf(charzoom,"%d    "   ,zoom);

  fileok=1;

  sprintf(currentstep,"%d    "   ,framecurrent);
  sprintf(frame,"%d    "   ,cursor_seq(cursor,framecurrent-1));
  sprintf(rate,"%d    "   ,cursor_rate(cursor,framecurrent-1));
  sprintf(xhotspot,"%d    "   ,cursor_xhotspot(cursor,framecurrent-1));
  sprintf(yhotspot,"%d    "   ,cursor_yhotspot(cursor,framecurrent-1));


  clear_to_color(guibmp,FORE);
  install_int(load_animation,100);

  return D_REDRAW;
}

void back()
{
  if(fileok==1)
  {
    stopani();
    framecurrent--;

    if(framecurrent<1) framecurrent=1;
    if(framecurrent>cursor_steps(cursor)) framecurrent=cursor_steps(cursor);
    sprintf(currentstep,"%d    "   ,framecurrent);
    sprintf(frame,"%d    "   ,cursor_seq(cursor,framecurrent-1));
    sprintf(rate,"%d    "   ,cursor_rate(cursor,framecurrent-1));
    sprintf(xhotspot,"%d    "   ,cursor_xhotspot(cursor,framecurrent-1));
    sprintf(yhotspot,"%d    "   ,cursor_yhotspot(cursor,framecurrent-1));
    SEND_MESSAGE((the_dialog+34), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+35), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+36), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+37), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+38), MSG_DRAW, 0);

    showactual();
  }
}

void next()
{
  if(fileok==1)
  {
    stopani();

    framecurrent++;

    if(framecurrent<1) framecurrent=1;
    if(framecurrent>cursor_steps(cursor)) framecurrent=cursor_steps(cursor);
    sprintf(currentstep,"%d    "   ,framecurrent);
    sprintf(frame,"%d    "   ,cursor_seq(cursor,framecurrent-1));
    sprintf(rate,"%d    "   ,cursor_rate(cursor,framecurrent-1));
    sprintf(xhotspot,"%d    "   ,cursor_xhotspot(cursor,framecurrent-1));
    sprintf(yhotspot,"%d    "   ,cursor_yhotspot(cursor,framecurrent-1));
    SEND_MESSAGE((the_dialog+34), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+35), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+36), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+37), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+38), MSG_DRAW, 0);
    showactual();
  }
}

void zoomin()
{
  if(fileok==1)
  {
    zoom+=8;

    if(zoom<0) zoom=0;
    if(zoom>(127-cursor_height(cursor))) zoom=(127-cursor_height(cursor));

    showactual();
  }
}

void zoomout()
{
  if(fileok==1)
  {
    zoom-=8;

    if(zoom<0) zoom=0;
    if(zoom>(127-cursor_height(cursor))) zoom=(127-cursor_height(cursor));

    showactual();
  }
}


void play()
{
  if(fileok==1)
  {
    framecurrent=1;

    finished=0;
    stop=0;
    sprintf(currentstep,"%d    "   ,framecurrent);
    sprintf(frame,"%d    "   ,cursor_seq(cursor,framecurrent-1));
    sprintf(rate,"%d    "   ,cursor_rate(cursor,framecurrent-1));
    sprintf(xhotspot,"%d    "   ,cursor_xhotspot(cursor,framecurrent-1));
    sprintf(yhotspot,"%d    "   ,cursor_yhotspot(cursor,framecurrent-1));
    SEND_MESSAGE((the_dialog+34), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+35), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+36), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+37), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+38), MSG_DRAW, 0);
    showactual();

    install_int(timer_animation,30);
    install_int(play_animation,cursor_rate(cursor,framecurrent-1)*15);
    finished=1;
  }
}

void stopani()
{
  if(fileok==1)
  {
    stop=1;
    remove_int(timer_animation);
    remove_int(play_animation);

    sprintf(currentstep,"%d    "   ,framecurrent);
    sprintf(frame,"%d    "   ,cursor_seq(cursor,framecurrent-1));
    sprintf(rate,"%d    "   ,cursor_rate(cursor,framecurrent-1));
    sprintf(xhotspot,"%d    "   ,cursor_xhotspot(cursor,framecurrent-1));
    sprintf(yhotspot,"%d    "   ,cursor_yhotspot(cursor,framecurrent-1));
    SEND_MESSAGE((the_dialog+34), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+35), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+36), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+37), MSG_DRAW, 0);
    SEND_MESSAGE((the_dialog+38), MSG_DRAW, 0);
    showactual();
  }
}


int saveframe()
{
  FILE *fp;
  char *ext = "BMP";
  char buf[256], name[256],verify[256];
  int i;

  stopani();

  if(fileok==1)
  {
    sprintf(buf, "Exporting frame %d ", framecurrent);
    strcpy(temp,anifile);
    *get_extension(temp)=0;
    temp[strlen(temp)-1]=0;
    temp[4]=0;
    sprintf(name, ".\\%s%04d.BMP ",temp, framecurrent);

    if(billfile_select(buf, name, ext))
    {
      strupr(name);
      sprintf(temp,"%s",name);
      strcpy(verify,"");
      strcpy(verify,get_filename(name));

      if(verify[0]==0) billalert("Error Exporting...","There was an error while trying to export the file",name,"OK", 0,0,0);
      else
      {
        fp=fopen(name,"rb");
        if(fp)
        {
          sprintf(temp,"The file %s already exists!!!",get_filename(name));
          if(billalert("Error Exporting...",temp,"Do you want to overwrite it?","Yes", "No", 'y', 27) == 1)
          {
            fclose(fp);
            save_bmp(name,cursor_image(cursor,framecurrent-1),cursor_pallete(cursor,framecurrent-1));
          }
          else {fclose(fp);}
        }
        else save_bmp(name,cursor_image(cursor,framecurrent-1),cursor_pallete(cursor,framecurrent-1));
      }
    }
  }
}


int saveall()
{
  FILE *fp;
  char *ext = "BMP";
  char buf[256], name[256],verify[256],name2[256];
  int i;
  long a;

  stopani();

  if(fileok==1)
  {
    sprintf(buf, "Exporting all frames... ", framecurrent);
    strcpy(temp,anifile);
    *get_extension(temp)=0;
    temp[strlen(temp)-1]=0;
    temp[4]=0;
    sprintf(name,".\\%s.BMP ",temp);

    if(billfile_select(buf,name,ext))
    {
      strupr(name);
      sprintf(temp,"%s",name);
      strcpy(verify,"");
      strcpy(verify,get_filename(name));

      if(verify[0]==0) billalert("Error Exporting...","There was an error while trying to export the file",name,"OK", 0,0,0);
      else
      {
        *get_filename(temp)=0;
        *get_extension(verify)=0;
        verify[strlen(verify)-1]=0;
        verify[4]=0;

        for(a=0;a<cursor_steps(cursor);a++)
        {
          sprintf(name2,"%s%s%04d.BMP ",temp,verify,a);
          save_bmp(name2,cursor_image(cursor,a),cursor_pallete(cursor,a));
        }
      }
    }
  }
}


int saveinfo()
{
  FILE *fp;
  char *ext = "TXT";
  char buf[256], name[256],verify[256];
  int i;
  long a;

  stopani();

  if(fileok==1)
  {
    sprintf(buf, "Exporting info ... ");
    strcpy(temp,anifile);
    *get_extension(temp)=0;
    temp[strlen(temp)-1]=0;
    temp[8]=0;
    sprintf(name, ".\\%s.TXT",temp);

    if(billfile_select(buf, name, ext))
    {
      strupr(name);
      sprintf(temp,"%s",name);
      strcpy(verify,"");
      strcpy(verify,get_filename(name));

      if(verify[0]==0) billalert("Error Exporting...","There was an error while trying to export the file",name,"OK", 0,0,0);
      else
      {
        fp=fopen(name,"rb");
        if(fp)
        {
          sprintf(temp,"The file %s already exists!!!",get_filename(name));
          if(billalert("Error Exporting...",temp,"Do you want to overwrite it?","Yes", "No", 'y', 27) == 1)
          {

            fclose(fp);
            fp=fopen(name,"wb");
            fprintf(fp,"*********************************************************\r\n");
            fprintf(fp,"*                     ANIViewer v1.0                    *\r\n");
            fprintf(fp,"*                         CEKANI                        *\r\n");
            fprintf(fp,"*           .ANI File Loader Library to DJGPP.          *\r\n");
            fprintf(fp,"*      Copyright (c) 2000 by Cristian EmmericK (CEK)    *\r\n");
            fprintf(fp,"*                E-mail: cek@mailbr.com.br              *\r\n");
            fprintf(fp,"*                   ICQ(UIN): 52438873                  *\r\n");
            fprintf(fp,"*********************************************************\r\n");

            fprintf(fp,"\r\n- SART OF %s INFO -\r\n",anifile);

            fprintf(fp,"\r\n  File Name: %s",anifile);
            fprintf(fp,"\r\n       Name: %s",cursor_getname(cursor));
            fprintf(fp,"\r\n     Author: %s",cursor_getauthor(cursor));
            fprintf(fp,"\r\n       Size: %ld bytes",cursor_getsize(cursor));
            fprintf(fp,"\r\n      Width: %d pixels",cursor_width(cursor));
            fprintf(fp,"\r\n     Height: %d pixels",cursor_height(cursor));
            fprintf(fp,"\r\n     Frames: %d",cursor_frames(cursor));
            fprintf(fp,"\r\n      Steps: %d",cursor_steps(cursor));
            fprintf(fp,"\r\nColor Depth: %d bits\r\n\r\n",cursor_getcolordepth(cursor));
            fprintf(fp,"- STEP -  - FRAME -  - RATE -  - (X  -  Y) HOT SPOT \r\n\r\n");
            for(a=0;a<cursor_steps(cursor);a++)   fprintf(fp,"%4d:      %4d        %4d      %2d  - %2d \r\n",a+1,cursor_seq(cursor,a),cursor_rate(cursor,a),cursor_xhotspot(cursor,a),cursor_yhotspot(cursor,a));
            fprintf(fp,"\r\n- END OF %s INFO -",anifile);

            fclose(fp);
          }
          else {fclose(fp);}
        }

        else
        {
          fclose(fp);
          fp=fopen(name,"wb");
          fprintf(fp,"*********************************************************\r\n");
          fprintf(fp,"*                     ANIViewer v1.0                    *\r\n");
          fprintf(fp,"*                         CEKANI                        *\r\n");
          fprintf(fp,"*           .ANI File Loader Library to DJGPP.          *\r\n");
          fprintf(fp,"*      Copyright (c) 2000 by Cristian EmmericK (CEK)    *\r\n");
          fprintf(fp,"*                E-mail: cek@mailbr.com.br              *\r\n");
          fprintf(fp,"*                   ICQ(UIN): 52438873                  *\r\n");
          fprintf(fp,"*********************************************************\r\n");

          fprintf(fp,"\r\n- SART OF %s INFO -\r\n",anifile);

          fprintf(fp,"\r\n  File Name: %s",anifile);
          fprintf(fp,"\r\n       Name: %s",cursor_getname(cursor));
          fprintf(fp,"\r\n     Author: %s",cursor_getauthor(cursor));
          fprintf(fp,"\r\n       Size: %ld bytes",cursor_getsize(cursor));
          fprintf(fp,"\r\n      Width: %d pixels",cursor_width(cursor));
          fprintf(fp,"\r\n     Height: %d pixels",cursor_height(cursor));
          fprintf(fp,"\r\n     Frames: %d",cursor_frames(cursor));
          fprintf(fp,"\r\n      Steps: %d",cursor_steps(cursor));
          fprintf(fp,"\r\nColor Depth: %d bits\r\n\r\n",cursor_getcolordepth(cursor));
          fprintf(fp,"- STEP -  - FRAME -  - RATE -  - (X  -  Y) HOT SPOT \r\n\r\n");
          for(a=0;a<cursor_steps(cursor);a++)   fprintf(fp,"%4d:      %4d        %4d      %2d  - %2d \r\n",a+1,cursor_seq(cursor,a),cursor_rate(cursor,a),cursor_xhotspot(cursor,a),cursor_yhotspot(cursor,a));

          fprintf(fp,"\r\n- END OF %s INFO -",anifile);

          fclose(fp);
        }
      }
    }
  }
}




DIALOG help_dialog[] =
{
/* (dialog proc)                 (x)   (y)   (w)   (h)   (fg)  (bg)  (key)     (flags)  (d1)  (d2)  (dp) */

{ d_billwin_proc,                 79, 90,  482,  300,   255,    0,     0,          0,    0,    0,  "ANIViewer Help"},
{ d_billtextbox_proc,           3+79, 108, 475,  278,   255,    0,     0,          0,    0,    0,  helptxt },
{ d_billbutton_proc,             545, 94,  10,   10,     0,     0,     0,      D_EXIT,   0,    0,  "x",  },

{ NULL,                           0,   0,    0,    0,     0,    0,     0,       NULL,    0,    0,  NULL }

};



char *LOAD(char *filename)
{
  FILE *fp;
  char *data;

  int  handle;
  long c,c2;

  handle=open(filename,O_BINARY|O_RDONLY);
  c=(unsigned)filelength(handle);
  close(handle);

  data=(char *)malloc(c);
  if(data==NULL) return NULL;
  if(!fopen(filename,"rb")) return NULL;
  fclose(fp);
  fp=fopen(filename,"rb");
  if(!fp) return NULL;
  for(c2=0;c2<c;c2++)
  data[c2]=fgetc(fp);

  data[c2]=0;
  fclose(fp);
  return(data);
}

int helpwindow()
{
  stopani();
  hlp=LOAD("aniview.txt");
  if(hlp==NULL) billalert("Error Exporting...","Couldn't find ANIVIEW.TXT!!!",NULL,"OK", 0,0,0);
  else
  {
    strcpy(helptxt,hlp);
    init_moveable(help_dialog);
    do_dialog(help_dialog,0);
    shutdown_moveable(help_dialog);
  }
  free(hlp);
  return D_O_K;
}


DIALOG about_dialog[] =
{
/* (dialog proc)                 (x)   (y)   (w)   (h)   (fg)  (bg)  (key)     (flags)  (d1)  (d2)  (dp) */

{ d_billwin_proc,                 79,   90,  482,  250,   255,    0,     0,          0,    0,    0,  "About ANIViewer v1.0"},
{ d_billbutton_proc,             545,   94,   10,   10,     0,    0,     0,      D_EXIT,   0,    0,  "x" },
{ d_billtext_proc,                95,  130,    0,    0,     0,    0,     0,          0,    0,    0,  "                     ANIViewer v1.0                    " },
{ d_billtext_proc,                95,  140,    0,    0,     0,    0,     0,          0,    0,    0,  "                         CEKANI                        " },
{ d_billtext_proc,                95,  150,    0,    0,     0,    0,     0,          0,    0,    0,  "           .ANI File Loader Library to DJGPP.          " },
{ d_billtext_proc,                95,  160,    0,    0,     0,    0,     0,          0,    0,    0,  "      Copyright (c) 2000 by Cristian EmmericK (CEK)    " },
{ d_billtext_proc,                95,  170,    0,    0,     0,    0,     0,          0,    0,    0,  "                E-mail: cek@mailbr.com.br              " },
{ d_billtext_proc,                95,  180,    0,    0,     0,    0,     0,          0,    0,    0,  "                   ICQ(UIN): 52438873                  " },
{ d_billtext_proc,                95,  190,    0,    0,     0,    0,     0,          0,    0,    0,  "               http://cekpage.tripod.com/              " },
{ d_billtext_proc,                95,  220,    0,    0,     0,    0,     0,          0,    0,    0,  "                  - Special Thanks To -                " },
{ d_billtext_proc,                95,  240,    0,    0,     0,    0,     0,          0,    0,    0,  "                       DJ  Delorie    " },
{ d_billtext_proc,                95,  250,    0,    0,     0,    0,     0,          0,    0,    0,  "                    Shawn  Hargreaves" },
{ d_billtext_proc,                95,  260,    0,    0,     0,    0,     0,          0,    0,    0,  "                      Dan  Huizenga" },

{ d_billbutton_proc,             270,  290,   100,   20,     0,    0,     0,      D_EXIT,   0,    0,  "OK" },


{ NULL,                            0,    0,    0,    0,     0,    0,     0,       NULL,    0,    0,  NULL }

};

int about()
{
  stopani();

  init_moveable(about_dialog);
  do_dialog(about_dialog,0);
  shutdown_moveable(about_dialog);
}


MENU help[] =
{
   { "Help\t(F1)",                  helpwindow,    NULL },
   { "",                            NULL,          NULL },
   { "&About",                      about,         NULL },
   { NULL,                          NULL,          NULL }
};

MENU my_menu[] =
{
   { "&Load\t(ctrl+l)",             load,          NULL },
   { "",                            NULL,          NULL },
   { "&Quit\t(ctrl+x)",             quit,          NULL },
   { NULL,                          NULL,          NULL }
};

MENU export[] =
{
   { "Frame ",                      saveframe,     NULL },
   { "All ",                        saveall,       NULL },
   { "Info ",                       saveinfo,      NULL },
   { NULL,                          NULL,          NULL }
};

MENU menu[] =
{ 
   { "&File",                       NULL,          my_menu },
   { "&Export",                     NULL,          export },
   { "&Help",                       NULL,          help },
   { NULL,                          NULL,          NULL }
};


#define C(x)      (x - 'a' + 1)

DIALOG the_dialog[] =
{
/* (dialog proc)                 (x)   (y)   (w)   (h)   (fg)  (bg)  (key)     (flags)  (d1)  (d2)  (dp) */

{ d_billwin_proc,                 0,   0,  639,  479,   255,    0,     0, D_DISABLED,    0,    0,  title },
{ d_billmenu_proc,                3,  18,    0,    0,     0,    0,     0,          0,    0,    0,  menu },
{ d_billhline_proc,               3,  31,  632,    0,     0,    0,     0,          0,    0,    0,  NULL},
{ d_billtext_proc,               15,  40,    0,    0,     0,    0,     0,          0,    0,    0,  "-- .ANI File Proprieties --" },
{ d_billtext_proc,               15,  70,    0,    0,     0,    0,     0,          0,    0,    0,  "       File:" },
{ d_billtext_proc,               15,  80,    0,    0,     0,    0,     0,          0,    0,    0,  "       Size:" },
{ d_billtext_proc,               15,  90,    0,    0,     0,    0,     0,          0,    0,    0,  "       Name:" },
{ d_billtext_proc,               15, 100,    0,    0,     0,    0,     0,          0,    0,    0,  "     Author:" },
{ d_billtext_proc,               15, 110,    0,    0,     0,    0,     0,          0,    0,    0,  "      Width:" },
{ d_billtext_proc,               15, 120,    0,    0,     0,    0,     0,          0,    0,    0,  "     Height:" },
{ d_billtext_proc,               15, 130,    0,    0,     0,    0,     0,          0,    0,    0,  "     Frames:" },
{ d_billtext_proc,               15, 140,    0,    0,     0,    0,     0,          0,    0,    0,  "      Steps:" },
{ d_billtext_proc,               15, 150,    0,    0,     0,    0,     0,          0,    0,    0,  "Color Depth:" },
{ d_billtext_proc,              115,  70,    0,    0,     0,    0,     0,          0,    0,    0,  anifile },
{ d_billtext_proc,              115,  80,    0,    0,     0,    0,     0,          0,    0,    0,  cursorsize },
{ d_billtext_proc,              115,  90,    0,    0,     0,    0,     0,          0,    0,    0,  cursorinam },
{ d_billtext_proc,              115, 100,    0,    0,     0,    0,     0,          0,    0,    0,  cursorauthor },
{ d_billtext_proc,              115, 110,    0,    0,     0,    0,     0,          0,    0,    0,  cursorwidth },
{ d_billtext_proc,              115, 120,    0,    0,     0,    0,     0,          0,    0,    0,  cursorheight },
{ d_billtext_proc,              115, 130,    0,    0,     0,    0,     0,          0,    0,    0,  cursorframes },
{ d_billtext_proc,              115, 140,    0,    0,     0,    0,     0,          0,    0,    0,  cursorsteps },
{ d_billtext_proc,              115, 150,    0,    0,     0,    0,     0,          0,    0,    0,  cursorcdepth },
{ d_billhline_proc,               3, 170,  632,    0,     0,    0,     0,          0,    0,    0,  NULL},
{ d_callback_billbutton_proc,    15, 180,   62,   16,     0,    0,     0,          0,    0,    0,  "<< Back", back},
{ d_callback_billbutton_proc,    81, 180,   62,   16,     0,    0,     0,          0,    0,    0,  "Next >>", next},
{ d_callback_billbutton_proc,    15, 333,   62,   16,     0,    0,     0,          0,    0,    0,  "Zoom +", zoomin},
{ d_callback_billbutton_proc,    81, 333,   62,   16,     0,    0,     0,          0,    0,    0,  "- Zoom", zoomout},
{ d_callback_billbutton_proc,   147, 180,   62,   16,     0,    0,     0,          0,    0,    0,  "Play", play},
{ d_callback_billbutton_proc,   213, 180,   62,   16,     0,    0,     0,          0,    0,    0,  "Stop", stopani},
{ d_billtext_proc,              148, 205,    0,    0,     0,    0,     0,          0,    0,    0,  "Current Step:" },
{ d_billtext_proc,              148, 215,    0,    0,     0,    0,     0,          0,    0,    0,  "       Frame:" },
{ d_billtext_proc,              148, 225,    0,    0,     0,    0,     0,          0,    0,    0,  "        Rate:" },
{ d_billtext_proc,              148, 235,    0,    0,     0,    0,     0,          0,    0,    0,  "  X Hot Spot:" },
{ d_billtext_proc,              148, 245,    0,    0,     0,    0,     0,          0,    0,    0,  "  Y Hot Spot:" },
{ d_billtext_proc,              258, 205,    0,    0,     0,    0,     0,          0,    0,    0,  currentstep },
{ d_billtext_proc,              258, 215,    0,    0,     0,    0,     0,          0,    0,    0,  frame },
{ d_billtext_proc,              258, 225,    0,    0,     0,    0,     0,          0,    0,    0,  rate },
{ d_billtext_proc,              258, 235,    0,    0,     0,    0,     0,          0,    0,    0,  xhotspot },
{ d_billtext_proc,              258, 245,    0,    0,     0,    0,     0,          0,    0,    0,  yhotspot },
{ d_billvline_proc,             350, 172,    0,  305,     0,    0,     0,          0,    0,    0,  NULL},
{ d_billtext_proc,              415, 178,    0,    0,     0,    0,     0,          0,    0,    0,  "-- EXPORT Options --" },
{ d_billtext_proc,              360, 205,    0,    0,     0,    0,     0,          0,    0,    0,  "   ANIViewer gives you the option" },
{ d_billtext_proc,              360, 215,    0,    0,     0,    0,     0,          0,    0,    0,  "to export a .ANI objects like its" },
{ d_billtext_proc,              360, 225,    0,    0,     0,    0,     0,          0,    0,    0,  "frames to .BMP files and its info" },
{ d_billtext_proc,              360, 235,    0,    0,     0,    0,     0,          0,    0,    0,  "to a .TXT file.                  " },
{ d_billtext_proc,              360, 245,    0,    0,     0,    0,     0,          0,    0,    0,  "   The option \"ALL\"  will exports" },
{ d_billtext_proc,              360, 255,    0,    0,     0,    0,     0,          0,    0,    0,  "all the .ANI frames to .BMP files" },
{ d_billtext_proc,              360, 265,    0,    0,     0,    0,     0,          0,    0,    0,  "like: ANIM0000.BMP,  ANIM0001.BMP" },
{ d_billtext_proc,              360, 275,    0,    0,     0,    0,     0,          0,    0,    0,  "and so on.  But you  have to give" },
{ d_billtext_proc,              360, 285,    0,    0,     0,    0,     0,          0,    0,    0,  "the first four characters, and be" },
{ d_billtext_proc,              360, 295,    0,    0,     0,    0,     0,          0,    0,    0,  "careful because it won't tell you" },
{ d_billtext_proc,              360, 305,    0,    0,     0,    0,     0,          0,    0,    0,  "if such name already exist and it" },
{ d_billtext_proc,              360, 315,    0,    0,     0,    0,     0,          0,    0,    0,  "will overwrite them  without ask-" },
{ d_billtext_proc,              360, 325,    0,    0,     0,    0,     0,          0,    0,    0,  "ing!!!!" },
{ d_billtext_proc,              360, 335,    0,    0,     0,    0,     0,          0,    0,    0,  "   The option \"FRAME\" will export" },
{ d_billtext_proc,              360, 345,    0,    0,     0,    0,     0,          0,    0,    0,  "only the current frame.          " },
{ d_billtext_proc,              360, 355,    0,    0,     0,    0,     0,          0,    0,    0,  "   The option \"INFO\" will exports" },
{ d_billtext_proc,              360, 365,    0,    0,     0,    0,     0,          0,    0,    0,  "the .ANI info like: its sequence," },
{ d_billtext_proc,              360, 375,    0,    0,     0,    0,     0,          0,    0,    0,  "their frame's rate and so on." },
{ d_callback_billbutton_proc,   390, 410,   62,   16,     0,    0,     0,          0,    0,    0,  "Frame",saveframe },
{ d_callback_billbutton_proc,   460, 410,   62,   16,     0,    0,     0,          0,    0,    0,  "All",saveall },
{ d_callback_billbutton_proc,   530, 410,   62,   16,     0,    0,     0,          0,    0,    0,  "Info",saveinfo },

{ d_keyboard_proc,                0,    0,   0,    0,     0,    0,     0,    0,     KEY_F1,    0,  helpwindow },
{ d_keyboard_proc,                0,    0,   0,    0,     0,    0,     0,    0,     KEY_ESC,   0,  quit },
{ d_keyboard_proc,                0,    0,   0,    0,     0,    0,   C('x'),       0,    0,    0,  quit },
{ d_keyboard_proc,                0,    0,   0,    0,     0,    0,   C('l'),       0,    0,    0,  load },


{ NULL,                           0,   0,    0,    0,     0,    0,     0,       NULL,    0,    0,  NULL }

};



void main()
{
  BITMAP *bmp;
  int cekcount=0,time=0;
  int wi=340,he=70;
  unsigned long count=0;
  char *temp;
  int pressed=0;
  int what=-1;

  allegro_init();
  install_keyboard();
  install_timer();
  install_mouse();
  bill_init();


  set_color_depth(16);
  set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
  bmp=create_bitmap(640,480);
  guibmp=create_bitmap(640,480);
  clear_to_color(screen,0);

  datafile=load_datafile("aniview.dat");

  text_mode(-1);
  count=0;

  LOCK_FUNCTION(load_animation);
  LOCK_FUNCTION(play_animation);
  LOCK_FUNCTION(load_animation);


  while(1)
  {
    clear_to_color(bmp,WHITE);

    if(cekcount==0) PUT_IMAGE((640/2)-(wi/2)-10,(480/2)-(he/2)-50,datafile[CEKANI01].dat,bmp);
    if(cekcount==1) PUT_IMAGE((640/2)-(wi/2)-10,(480/2)-(he/2)-50,datafile[CEKANI02].dat,bmp);
    if(cekcount==2) PUT_IMAGE((640/2)-(wi/2)-10,(480/2)-(he/2)-50,datafile[CEKANI03].dat,bmp);
    if(cekcount==3) PUT_IMAGE((640/2)-(wi/2)-10,(480/2)-(he/2)-50,datafile[CEKANI04].dat,bmp);

    PUT_IMAGE((640/2)-(wi/2)-10+wi-156,(480/2)-(he/2)-50+he+5,datafile[ANIVIEW].dat,bmp);
    PUT_IMAGE((640/2)-(329/2)-5,350,datafile[TEXT].dat,bmp);
    if(count>80) if(mouse_b&1 || mouse_b&2) {PUT_IMAGE(0,0,bmp,screen); goto end;} // Hi Labels, how long?
    if(count>80) textout_centre(bmp,datafile[FONT1].dat, "CLICK TO ENTER",640/2,470,0);
    if(count>80) PUT_MASK(mouse_x,mouse_y,datafile[MOUSE].dat,bmp);

    PUT_IMAGE(0,0,bmp,screen);
    vsync();
    vsync();

    time++;
    count++;
    if(time>3) time=0;
    if(time==0) cekcount++;
    if(cekcount>3) cekcount=0;
  }

  end:
  text_mode(-1);

  set_mouse_sprite(datafile[MOUSE].dat);

  set_gui_mode(1);
  init_moveable(the_dialog);
  do_dialog(the_dialog,0);
  shutdown_moveable(the_dialog);

  remove_keyboard();
  remove_timer();
  remove_mouse();
  free(hlp);
  free(helptxt);
  allegro_exit();

}

