/*
 * Copyright (C) 1996-1998 Ilya Ryzhenkov (orangy@inetlab.com)
 */
#include "helpdefs.h"
#include "dlmstr.h"

static void Err(char *text)
{
 printf("\nEXE FATAL : %s\n",text);
 exit(1);
}

char *buf;
void MakeExe(TDlm *dlm,char *fname,char *stub)
{
 int fout,fstub;
 unsigned long stubsize;

 if (!stub)
 {
  stub=getenv("DLMSTUBNAME"); 
  if (!stub) stub="dlmstub.exe";
 }

 fout=open(fname,O_RDWR|O_CREAT|O_TRUNC|O_BINARY,S_IRUSR|S_IWUSR);
 if (fout==-1) Err("Can't open output file");
 fstub=open(stub,O_RDONLY|O_BINARY);
 if (fstub==-1) Err("Can't open stub file");
 stubsize=filelength(fstub);
 if (stubsize==-1) Err("Can't get stub's length");
 buf=NEWAR(char,stubsize);
 if (!buf) Err("Not enough memory");
 if (read(fstub,buf,stubsize)!=stubsize) Err("Error reading stub");
 if (write(fout,buf,stubsize)!=stubsize) Err("Error writing outfile");
 FREE(buf);
 close(fstub);
 close(fout);

 WriteDlm(dlm,fname,1);
 fout=open(fname,O_RDWR|O_BINARY|O_APPEND,S_IRUSR|S_IWUSR);
 if (fout==-1) Err("Can't open output file");
 if (write(fout,&stubsize,sizeof(stubsize))!=sizeof(stubsize))
  Err("Error writing outfile");
 close(fout);
}
