/*
 Copyright (C) 1996 By Ilya P. Ryzhenkov, see COPYDLM.TXT for details
*/
#ifndef __include_dlmimage_h_
#define __include_dlmimage_h_

 #include "dlm.h"

typedef struct tagDlmImage {
 unsigned long LoadCount;
 char *filename;
 unsigned short NumSect;
 unsigned long NumSym;
 unsigned long NumRel;
 unsigned long StrSize;             /* Size of string table */
 unsigned long VSize;               /* Size of section's image */
 DLMSCN *Sections;         /* Section headers */
 char   *Base;             /* Base address for section data*/
 DLMSYM *Symbols;          /* Symbols */
 char   *Strings;          /* Symbol names (string table) */
 DLMREL *Relocs;           /* Relocation table */
 unsigned long *RelVal;   /* Values from relocation places */
 void *eh_buf;            /* Buffer for holding exception information */
 unsigned long cached_pos,cached_idx;
} TDlm;

int _dlm_load(char *path); /* load dlm */
int _dlm_unload(char *path); /* unload dlm */
int _dlm_isloaded(char *path); /* check if loaded */
void _dlm_set_search_path(char* path); /* set path for dlm searching */
extern int dlmerrno;
extern int dlmflags;
void _dlm_unload_all(void);
void *_dlm_lookup(char *name);
void *_dlm_new_named(unsigned long size,char *name,void*);
unsigned long _dlm_extra_size(char *name);
int _dlm_remove_user(char *name);
int _dlm_export_user(char *name, void *addr);



#endif