/*
    Static linkage support for dynamically-loadable-modules

    Copyright (C) 2000 Andrew Zabolotny <bit@eltech.ru>
    Partly based on work by Charles Sandmann and DJ Delorie.

    Usage of this library is not restricted in any way.
    The full license text can be found in the file dxe.txt.
*/

#include <io.h>
#include <unistd.h>
#include <string.h>
#include <dlfcn.h>

#define OUTPUT(s)	write (0, s, strlen (s))

static void _dlerrstatmod (const char *module)
{
  char *err;
  OUTPUT (module);
  OUTPUT (": module loading failed (");
  err = dlerror ();
  OUTPUT (err);
  OUTPUT (")\n");
  abort ();
}

static void _dlerrstatsym (const char *module, const char *symbol)
{
  OUTPUT (module);
  OUTPUT (": module does not contain required symbol `");
  OUTPUT (symbol);
  OUTPUT ("'\n");
  abort ();
}

void (*dlerrstatmod) (const char *module) = _dlerrstatmod;
void (*dlerrstatsym) (const char *module, const char *symbol) = _dlerrstatsym;

void dlstatbind (const char *module, dxe_h *handle, char *stubs, char *syms)
{
  if (*handle) return;
  *handle = dlopen (module, RTLD_GLOBAL);
  if (!*handle) dlerrstatmod (module);
  while (*syms)
  {
    long symoff = (long)dlsym (*handle, syms);
    if (!symoff) dlerrstatsym (module, syms);
    *stubs = 0xe9;	/* jmp long */
    *(long *)(stubs + 1) = symoff - (long)stubs - 5;
    stubs += 8;
    syms = strchr (syms, 0) + 1;
  }
}

void dlstatunbind (const char *module, dxe_h *handle, char *stubs, char *syms,
  long loader)
{
  if (!*handle) return;
  while (*syms)
  {
    *stubs = 0xe8;	/* call */
    *(long *)(stubs + 1) = loader - (long)stubs - 5;
    stubs += 8;
    syms = strchr (syms, 0) + 1;
  }
  dlclose (*handle);
  *handle = NULL;
}
