/*
    Wrapper functions for Unix-like run-time dynamic loading.

    Copyright (C) 2000 Andrew Zabolotny <bit@eltech.ru>
    Partly based on work by Charles Sandmann and DJ Delorie.

    Usage of this library is not restricted in any way.
    The full license text can be found in the file dxe.txt.
*/

#ifndef	__DLFCN_H__
#define	__DLFCN_H__

#include "dxe2.h"

#ifdef __cplusplus
extern "C" {
#endif

/* The MODE argument to `dlopen' contains one of the following: */
#define RTLD_LAZY	0x001	/* Lazy function call binding.  */
#define RTLD_NOW	0x002	/* Immediate function call binding.  */

/* If the following bit is set in the MODE argument to `dlopen',
   the symbols of the loaded object and its dependencies are made
   visible as if the object were linked directly into the program. */
#define RTLD_GLOBAL	0x100

/* Unix98 demands the following flag which is the inverse to RTLD_GLOBAL.
   The implementation does this by default and so we can define the
   value to zero.  */
#define RTLD_LOCAL	0

/* If the first argument to `dlsym' is set to RTLD_DEFAULT the run-time
   address of the symbol called NAME in the global scope is returned. */
#define RTLD_DEFAULT	NULL

/* Open the shared object FILE and map it in; return a handle that can be
   passed to `dlsym' to get symbol values from it.  */
extern dxe_h dlopen (const char *filename, int mode);

/* Unmap and close a shared object opened by `dlopen'.
   The handle cannot be used again after calling `dlclose'.  */
extern int dlclose (dxe_h handle);

/* Find the run-time address in the shared object HANDLE refers to
   of the symbol called NAME.  */
extern void *dlsym (dxe_h handle, const char *name);

/* When any of the above functions fails, call this function
   to return a string describing the error.  Each call resets
   the error string so that a following call returns null. */
extern char *dlerror ();

#ifdef __cplusplus
}
#endif

#endif /* __DLFCN_H__ */
