diff -ruN jptui/callback.cpp jptui.const/callback.cpp
--- jptui/callback.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/callback.cpp	Tue Jun  5 17:51:08 2001
@@ -14,13 +14,15 @@
 
 #include "Callback.h"
 
-void InitCallback(void (*&callback_action)(char *),char (*&callback_argument))
+void InitCallback(void (*&callback_action)(const char *),
+                  const char *&callback_argument)
 {
   callback_action=NULL;
   callback_argument=NULL;
 }
 
-void DestroyCallback(void (*&callback_action)(char *),char (*&callback_argument))
+void DestroyCallback(void (*&callback_action)(const char *), 
+                     const char *&callback_argument)
 {
   callback_action=NULL;
   if (callback_argument!=NULL)
@@ -30,19 +32,21 @@
     }
 }
 
-void SetCallback(void (*&callback_action)(char *),char (*&callback_argument),
-                 void (*action)(char *),char *argument)
+void SetCallback(void (*&callback_action)(const char *), 
+                 const char *&callback_argument,
+                 void (*action)(const char *), const char *argument)
 {
   callback_action=action;
 
   if (callback_argument!=NULL)
     delete[] callback_argument;
 
-  callback_argument=new char [strlen(argument)+1];
-  strcpy(callback_argument,argument);
+  char *tmp = new char[strlen(argument)+1]; strcpy(tmp, argument);
+  callback_argument = tmp;
 }
 
-void CallCallback(void (*callback_action)(char *),char (*callback_argument))
+void CallCallback(void (*callback_action)(const char *), 
+                  const char *callback_argument)
 {
   if ((JPCallbacksEnabled()) && (callback_action!=NULL))
     callback_action(callback_argument);
@@ -52,13 +56,15 @@
 
 
 
-void InitCallback(void (*&callback_action)(PObject,char *),char (*&callback_argument))
+void InitCallback(void (*&callback_action)(PObject, const char *), 
+                  const char *&callback_argument)
 {
   callback_action=NULL;
   callback_argument=NULL;
 }
 
-void DestroyCallback(void (*&callback_action)(PObject,char *),char (*&callback_argument))
+void DestroyCallback(void (*&callback_action)(PObject, const char *),
+                     const char *&callback_argument)
 {
   callback_action=NULL;
   if (callback_argument!=NULL)
@@ -68,33 +74,37 @@
     }
 }
 
-void SetCallback(void (*&callback_action)(PObject,char *),char (*&callback_argument),
-                 void (*action)(PObject,char *),char *argument)
+void SetCallback(void (*&callback_action)(PObject, const char *),
+                 const char *&callback_argument,
+                 void (*action)(PObject, const char *), const char *argument)
 {
   callback_action=action;
 
   if (callback_argument!=NULL)
     delete[] callback_argument;
 
-  callback_argument=new char [strlen(argument)+1];
-  strcpy(callback_argument,argument);
+  char *tmp = new char[strlen(argument)+1]; strcpy(tmp, argument);
+  callback_argument = tmp;
 }
 
-void CallCallback(PObject object,void (*callback_action)(PObject,char *),char (*callback_argument))
+void CallCallback(PObject object, void (*callback_action)(PObject, const char *),
+                  const char *callback_argument)
 {
   if ((JPCallbacksEnabled()) && (callback_action!=NULL))
-    callback_action(object,callback_argument);
+    callback_action(object, callback_argument);
 }
 
 
 
-void InitCallback(void (*&callback_action)(PObject,int,char *),char (*&callback_argument))
+void InitCallback(void (*&callback_action)(PObject, int, const char *),
+                  const char *&callback_argument)
 {
   callback_action=NULL;
   callback_argument=NULL;
 }
 
-void DestroyCallback(void (*&callback_action)(PObject,int,char *),char (*&callback_argument))
+void DestroyCallback(void (*&callback_action)(PObject, int, const char *),
+                     const char *&callback_argument)
 {
   callback_action=NULL;
   if (callback_argument!=NULL)
@@ -104,20 +114,23 @@
     }
 }
 
-void SetCallback(void (*&callback_action)(PObject,int,char *),char (*&callback_argument),
-                 void (*action)(PObject,int,char *),char *argument)
+void SetCallback(void (*&callback_action)(PObject, int, const char *),
+                 const char *&callback_argument,
+                 void (*action)(PObject, int, const char *), 
+		 const char *argument)
 {
   callback_action=action;
 
   if (callback_argument!=NULL)
     delete[] callback_argument;
 
-  callback_argument=new char [strlen(argument)+1];
-  strcpy(callback_argument,argument);
+  char *tmp = new char[strlen(argument)+1]; strcpy(tmp, argument);
+  callback_argument = tmp;
 }
 
-void CallCallback(PObject object,void (*callback_action)(PObject,int,char *),char (*callback_argument),int index)
+void CallCallback(PObject object, void (*callback_action)(PObject, int, const char *),
+                  int index, const char *callback_argument)
 {
   if ((JPCallbacksEnabled()) && (callback_action!=NULL))
-    callback_action(object,index,callback_argument);
+    callback_action(object, index, callback_argument);
 }
diff -ruN jptui/callback.h jptui.const/callback.h
--- jptui/callback.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/callback.h	Tue Jun  5 17:51:08 2001
@@ -9,26 +9,41 @@
 
 #include "Types.h"
 
-void InitCallback(void (*&callback_action)(char *),char (*&callback_argument));
-void SetCallback(void (*&callback_action)(char *),char (*&callback_argument),
-                 void (*action)(char *),char *argument);
-void DestroyCallback(void (*&callback_action)(char *),char (*&callback_argument));
-void CallCallback(void (*callback_action)(char *),char (*callback_argument));
+void InitCallback(void (*&callback_action)(const char *), 
+                  const char *&callback_argument);
+void SetCallback(void (*&callback_action)(const char *), 
+                 const char *&callback_argument, void (*action)(const char *),
+                 const char *argument);
+void DestroyCallback(void (*&callback_action)(const char *), 
+                     const char *&callback_argument);
+void CallCallback(void (*callback_action)(const char *), 
+                  const char *callback_argument);
 
 
 
-void InitCallback(void (*&callback_action)(PObject,char *),char (*&callback_argument));
-void SetCallback(void (*&callback_action)(PObject,char *),char (*&callback_argument),
-                 void (*action)(PObject,char *),char *argument);
-void DestroyCallback(void (*&callback_action)(PObject,char *),char (*&callback_argument));
-void CallCallback(PObject object,void (*callback_action)(PObject,char *),char (*callback_argument));
+void InitCallback(void (*&callback_action)(PObject, const char *), 
+                  const char *&callback_argument);
+void SetCallback(void (*&callback_action)(PObject, const char *), 
+                 const char *&callback_argument,
+                 void (*action)(PObject, const char *), const char *argument);
+void DestroyCallback(void (*&callback_action)(PObject, const char *), 
+                     const char *&callback_argument);
+void CallCallback(PObject object, 
+                  void (*callback_action)(PObject, const char *),
+	          const char *callback_argument);
 
 
 
-void InitCallback(void (*&callback_action)(PObject,int,char *),char (*&callback_argument));
-void SetCallback(void (*&callback_action)(PObject,int,char *),char (*&callback_argument),
-                 void (*action)(PObject,int,char *),char *argument);
-void DestroyCallback(void (*&callback_action)(PObject,int,char *),char (*&callback_argument));
-void CallCallback(PObject object,void (*callback_action)(PObject,int,char *),char (*callback_argument),int index);
+void InitCallback(void (*&callback_action)(PObject, int, const char *), 
+                  const char *&callback_argument);
+void SetCallback(void (*&callback_action)(PObject, int, const char *), 
+                 const char *&callback_argument, 
+                 void (*action)(PObject, int, const char *), 
+                 const char *argument);
+void DestroyCallback(void (*&callback_action)(PObject, int, const char *), 
+                     const char *&callback_argument);
+void CallCallback(PObject object, 
+                  void (*callback_action)(PObject, int, const char *),
+                  int index, const char *callback_argument);
 
 #endif
diff -ruN jptui/data/jpvocab.eng jptui.const/data/jpvocab.eng
--- jptui/data/jpvocab.eng	Sun Nov  2 23:03:36 1997
+++ jptui.const/data/jpvocab.eng	Tue Jun  5 17:51:10 2001
@@ -25,6 +25,9 @@
    55,"~Abort"
    56,"~Retry"
    57,"~Ignore"
+   58,"~Continue"
+   59,"Yes To ~All"
+   60,"~Review"
 
    70,"~Name :"
    71,"~Search :"
diff -ruN jptui/debug.cpp jptui.const/debug.cpp
--- jptui/debug.cpp	Sun May 24 17:48:18 1998
+++ jptui.const/debug.cpp	Tue Jun  5 17:51:10 2001
@@ -50,7 +50,7 @@
 /* dans le source o a eu lieu l'erreur                                     */
 /****************************************************************************/
 
-void ProgrammingError(int error_nb,char *file,int line)
+void ProgrammingError(int error_nb, const char *file, int line)
 {
   char *text;
 
diff -ruN jptui/debug.h jptui.const/debug.h
--- jptui/debug.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/debug.h	Tue Jun  5 17:51:10 2001
@@ -17,7 +17,7 @@
 
  #ifndef NDEBUG
 
-   void    ProgrammingError(int error_nb,char *file,int line);
+   void    ProgrammingError(int error_nb, const char *file, int line);
 
    // These functions display the available memory.
 
@@ -45,7 +45,7 @@
 
  #  define NO_DEBUG(instruction)
  #  define DEBUG(instruction)           instruction
- #  define DEBUG_STOP()                 ProgrammingError(0,__FILE__,__LINE__)
+ #  define DEBUG_STOP()                 ProgrammingError(0, __FILE__, __LINE__)
  #  define DEBUG_TEST(condition)        ((condition) ? (void)0 : DEBUG_STOP())
  #  define DEBUG_SHOW_MEMORY()          ShowMemory()
  #  define DEBUG_HIDE_MEMORY()          HideMemory()
diff -ruN jptui/errors.cpp jptui.const/errors.cpp
--- jptui/errors.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/errors.cpp	Tue Jun  5 17:51:10 2001
@@ -40,7 +40,7 @@
 /* Quitte l'application et affiche le message d'erreur                      */
 /****************************************************************************/
 
-void FatalError(char *message)
+void FatalError(const char *message)
 {
   TextError(message);
   AbortProgram();
@@ -52,7 +52,7 @@
 /* Ferme l'cran "graphique" et et affiche le message d'erreur              */
 /****************************************************************************/
 
-void TextError(char *message)
+void TextError(const char *message)
 {
   CloseScreen();
   cerr << "\n\n" << message << "\n\n";
diff -ruN jptui/errors.h jptui.const/errors.h
--- jptui/errors.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/errors.h	Tue Jun  5 17:51:10 2001
@@ -17,14 +17,14 @@
 
 // Erreur anormale -> Quitte brutalement l'application (abort)
 
-void ProgrammingError(int error_nb,char *file,int line);
+void ProgrammingError(int error_nb, const char *file, int line);
 
 // Erreur fatale -> Quitte l'application (abort)
 
-void FatalError(char *message);
+void FatalError(const char *message);
 
 // Messages en mode texte (ferme l'cran "graphique" si besoin)
 
-void TextError(char *message);
+void TextError(const char *message);
 
 #endif
\ No newline at end of file
diff -ruN jptui/filebox.cpp jptui.const/filebox.cpp
--- jptui/filebox.cpp	Sun May 31 19:19:46 1998
+++ jptui.const/filebox.cpp	Tue Jun  5 17:51:10 2001
@@ -53,8 +53,8 @@
 static char                    s_file[MAX_PATH]="";
 static char                    s_current_dir_mask[MAX_PATH]="";
 
-static char 		       *s_ok_button_caption=NULL;
-static char 		       *s_cancel_button_caption=NULL;
+static char *s_ok_button_caption=NULL;
+static char *s_cancel_button_caption=NULL;
 
 static PWindow                 s_window=NULL;
 static PLabel                  s_label=NULL;
@@ -75,13 +75,13 @@
 class TFileDialogEditZone:public TEditZone
 {
   public:
-		    TFileDialogEditZone(char *default_mask);
+		    TFileDialogEditZone(const char *default_mask);
 		   ~TFileDialogEditZone();
 	    void    m_refresh_file_list_from_string();
 
 };
 
-TFileDialogEditZone::TFileDialogEditZone(char *default_mask)
+TFileDialogEditZone::TFileDialogEditZone(const char *default_mask)
 		    :TEditZone(s_window,
 			       9,15,
 			       -7,0,
@@ -96,7 +96,7 @@
 {
 }
 
-static void FileChosenCall(PObject /*sender*/,char */*arg*/);
+static void FileChosenCall(PObject /*sender*/, const char */*arg*/);
 
 void TFileDialogEditZone::m_refresh_file_list_from_string()
 {
@@ -123,7 +123,7 @@
 /* Function called when the user presses the "cancel" button of the dialog  */
 /****************************************************************************/
 
-static void CancelButtonPressedCall(PObject /*sender*/,char */*arg*/)
+static void CancelButtonPressedCall(PObject /*sender*/, const char */*arg*/)
 {
   JPStop();
 }
@@ -134,7 +134,7 @@
 /* Function called when the user presses the "ok" button of the dialog      */
 /****************************************************************************/
 
-static void OKButtonPressedCall(PObject /*sender*/,char */*arg*/)
+static void OKButtonPressedCall(PObject /*sender*/, const char */*arg*/)
 {
   PObject object=s_window->m_get_previous_focused_object();
   TFLBError error_code;
@@ -163,7 +163,7 @@
 /* box which displays file names					    */
 /****************************************************************************/
 
-static void FileChosenCall(PObject /*sender*/,char */*arg*/)
+static void FileChosenCall(PObject /*sender*/, const char */*arg*/)
 {
   s_file_chosen=TRUE;
   JPStop();
@@ -175,7 +175,7 @@
 /* Function called when the caption of the ok button may have to be changed */
 /****************************************************************************/
 
-static void ChangeOkButtonCaptionCall(PObject sender,char */*arg*/)
+static void ChangeOkButtonCaptionCall(PObject sender, const char */*arg*/)
 {
   static boolean s_open_dir_caption = FALSE;
   int   selected_item_index;
@@ -214,9 +214,9 @@
 /* combo box which displays available drives and the parent directories     */
 /****************************************************************************/
 
-static void FileRefreshDoneCall(PObject sender,char */*arg*/);
+static void FileRefreshDoneCall(PObject sender, const char */*arg*/);
 
-static void DirChangedCall(PObject /*sender*/,char */*arg*/)
+static void DirChangedCall(PObject /*sender*/, const char */*arg*/)
 {
   int first;
   int level;
@@ -278,7 +278,7 @@
 /* the list-box which displays file names				    */
 /****************************************************************************/
 
-static void FileRefreshDoneCall(PObject sender,char */*arg*/)
+static void FileRefreshDoneCall(PObject sender, const char */*arg*/)
 {
   int item_to_select=0;
   int level;
@@ -419,11 +419,11 @@
 /* Allows the users to select a existing file or enter a new filename       */
 /****************************************************************************/
 
-char *FileSelectionBox(char *title,char *mask,
-		       char *ok_button_caption,
-		       char *cancel_button_caption)
+char *FileSelectionBox(const char *title, const char *mask,
+		       const char *ok_button_caption,
+		       const char *cancel_button_caption)
 {
-  char *caption;
+  const char *caption;
   char full_path_mask[MAX_PATH];
 
   TMousePointer pointer;
@@ -497,8 +497,8 @@
 
   // Defines the callbacks
 
-  s_cancel_button->m_set_pressed_callback(CancelButtonPressedCall,"");
-  s_ok_button->m_set_pressed_callback(OKButtonPressedCall,"");
+  s_cancel_button->m_set_pressed_callback(CancelButtonPressedCall, "");
+  s_ok_button->m_set_pressed_callback(OKButtonPressedCall, "");
   s_file_list_box->m_set_refresh_done_callback(FileRefreshDoneCall,"");
   s_file_list_box->m_set_file_chosen_callback(FileChosenCall,"");
   s_file_list_box->m_set_focus_taken_callback(ChangeOkButtonCaptionCall,"");
diff -ruN jptui/filebox.h jptui.const/filebox.h
--- jptui/filebox.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/filebox.h	Tue Jun  5 17:51:10 2001
@@ -10,8 +10,8 @@
 // Returns the full name of the selected file
 // or "" if no file is selected
 
-char *FileSelectionBox(char *title,char *mask,
-		       char *ok_button_caption="",
-		       char *cancel_button_caption="");
+char *FileSelectionBox(const char *title, const char *mask,
+		       const char *ok_button_caption="",
+		       const char *cancel_button_caption="");
 
 #endif
\ No newline at end of file
diff -ruN jptui/files.cpp jptui.const/files.cpp
--- jptui/files.cpp	Sun Jun 22 11:49:10 1997
+++ jptui.const/files.cpp	Tue Jun  5 17:51:10 2001
@@ -36,7 +36,7 @@
 /* Indique si un fichier existe ou non                                      */
 /****************************************************************************/
 
-boolean FileExists(char *file_name)
+boolean FileExists(const char *file_name)
 {
   int handle;
 
@@ -120,7 +120,7 @@
 /* Returns a boolean which indicates success or failure                     */
 /****************************************************************************/
 
-boolean FullPath(char *full_path,char *path)
+boolean FullPath(char *full_path, const char *path)
 {
   boolean success=TRUE;
   char last_char;
@@ -194,7 +194,7 @@
 /* returned unchanged)							    */
 /****************************************************************************/
 
-void FullPathOfFileInExeDir(char *full_path,char *file_name)
+void FullPathOfFileInExeDir(char *full_path, const char *file_name)
 {
   char *ptr;
   char *exe_name;
@@ -212,7 +212,7 @@
       exe_name=__dos_argv0;
       #endif
 
-      strcpy(full_path,exe_name);
+      strcpy(full_path, exe_name);
       ptr=strrchr(full_path,'\\');
       if (ptr==NULL)
 	ptr=full_path;
diff -ruN jptui/files.h jptui.const/files.h
--- jptui/files.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/files.h	Tue Jun  5 17:51:10 2001
@@ -34,7 +34,7 @@
 
 // Returns TRUE if the file 'file_name' exists
 
-boolean FileExists(char *file_name);
+boolean FileExists(const char *file_name);
 
 // Returns the current directory of the current drive
 
@@ -46,7 +46,7 @@
 // If a drive is indicated, this drive must exist
 // Returns a boolean which indicates success or failure
 
-boolean FullPath(char *full_path,char *path);
+boolean FullPath(char *full_path, const char *path);
 
 /* Returns the full path of a file located in the directory of your .exe    */
 /* file									    */
@@ -55,7 +55,7 @@
 /* (if file_name have some directory information, this file name is         */
 /* returned unchanged)							    */
 
-void FullPathOfFileInExeDir(char *full_path,char *file_name);
+void FullPathOfFileInExeDir(char *full_path, const char *file_name);
 
 // Checks whether a drive exists or not
 // 0='A', 1='B' ...
diff -ruN jptui/inputbox.cpp jptui.const/inputbox.cpp
--- jptui/inputbox.cpp	Mon Jun 30 21:45:40 1997
+++ jptui.const/inputbox.cpp	Tue Jun  5 17:51:10 2001
@@ -19,7 +19,6 @@
 
 #include "TEdzone.h"
 #include "TLabel.h"
-#include "TPassEdz.h"
 #include "TPushBut.h"
 #include "TWindow.h"
 
@@ -47,9 +46,9 @@
 /*                                 FONCTIONS                              */
 /*ͼ*/
 
-static char *InputBoxButtonText(int button_number)
+static const char *InputBoxButtonText(int button_number)
 {
-  return(GetString((button_number==0)?VOC_OK_CAPTION:VOC_CANCEL_CAPTION));
+  return(GetString(button_number==0 ? VOC_OK_CAPTION : VOC_CANCEL_CAPTION));
 }
 
 static int InputBoxButtonWidth()
@@ -61,7 +60,7 @@
   }
 
 
-static void InputBoxButtonPressedCall(PObject /*sender*/,char *button_number)
+static void InputBoxButtonPressedCall(PObject /*sender*/, const char *button_number)
 {
   s_button_pressed=button_number[0]-'0';
   JPStop();
@@ -87,9 +86,9 @@
 /****************************************************************************/
 
 
-void InputBox(char *title,char *message,int window_style,
-	      char *default_string,int max_length,char *return_string,
-	      int type)
+void InputBox(const char *title, const char *message, int window_style,
+	      const char *default_string, int max_length, 
+              char *return_string, int type)
 {
   TMousePointer pointer;
 
@@ -199,28 +198,15 @@
 			    InputBoxButtonText(1),
                             PB_CANCEL);
 
-  if (type == IB_PASSWORD)
-    {
-      edzone=new TPasswordEditZone(input_box,
-			   (window_width-edzone_width)>>1,
-			   window_height-MARGIN_HEIGHT-1,
-			   0,0,
-			   "",
-			   edzone_width-2,
-			   max_length,
-			   default_string);
-    }
-  else
-    {
-      edzone=new TEditZone(input_box,
-			   (window_width-edzone_width)>>1,
-			   window_height-MARGIN_HEIGHT-1,
-			   0,0,
-			   "",
-			   edzone_width-2,
-			   max_length,
-			   default_string);
-    }
+  edzone = new TEditZone(input_box,
+	   		 (window_width-edzone_width)>>1,
+	   		 window_height-MARGIN_HEIGHT-1,
+	   		 0,0,
+	   		 "",
+			 edzone_width-2,
+			 max_length,
+			 default_string);
+  if (type == IB_PASSWORD) edzone->set_password_mode(true);
 
   button[0]->m_set_pressed_callback(InputBoxButtonPressedCall,"0");
   button[1]->m_set_pressed_callback(InputBoxButtonPressedCall,"1");
diff -ruN jptui/inputbox.h jptui.const/inputbox.h
--- jptui/inputbox.h	Mon Jun 30 21:24:34 1997
+++ jptui.const/inputbox.h	Tue Jun  5 17:51:10 2001
@@ -23,9 +23,9 @@
 /*                                 FONCTIONS                              */
 /*ͼ*/
 
-void InputBox(char *title,char *message,int window_style,
-	      char *default_string,int max_length,char *return_string,
-	      int type=IB_STRING);
+void InputBox(const char *title, const char *message, int window_style,
+	      const char *default_string, int max_length, 
+	      char *return_string, int type=IB_STRING);
 
 
 #endif
\ No newline at end of file
diff -ruN jptui/jpdata.cpp jptui.const/jpdata.cpp
--- jptui/jpdata.cpp	Sun May 24 17:49:56 1998
+++ jptui.const/jpdata.cpp	Tue Jun  5 17:51:10 2001
@@ -81,7 +81,7 @@
 
 
 #pragma pack(1)
-#pragma option -a-
+//#pragma option -a-
 struct exedat_header
 {
   char header[8];       // identification = "EXEDAT"
@@ -446,7 +446,7 @@
 // This buffer must be freed by delete [].
 // Returns a pointer to the buffer or NULL if an error occurs.
 
-void LoadDataFile(char *file_name,char *(&buffer),long &length)
+void LoadDataFile(const char *file_name, char *&buffer, long& length)
 {
   int handle;
 
@@ -540,7 +540,7 @@
   length=indexblock.original_length;
 }
 
-char *GetInvalidDataFileMessage()
+const char *GetInvalidDataFileMessage()
 {
   char *text;
   int temp;
diff -ruN jptui/jpdata.h jptui.const/jpdata.h
--- jptui/jpdata.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/jpdata.h	Tue Jun  5 17:51:10 2001
@@ -13,11 +13,11 @@
 // (no data file or incorrect data file).
 // file_name must be at most 12 characters length
 
-void LoadDataFile(char *file_name,char *(&buffer),long &length);
+void LoadDataFile(const char *file_name, char *&buffer, long& size);
 
 // Returns the message "Data file is invalid or missing"
 // in the current language
 
-char *GetInvalidDataFileMessage();
+const char *GetInvalidDataFileMessage();
 
 #endif
diff -ruN jptui/jpdebug.h jptui.const/jpdebug.h
--- jptui/jpdebug.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/jpdebug.h	Tue Jun  5 17:51:10 2001
@@ -21,7 +21,7 @@
 
  #else
 
- #  define JPDEBUG_STOP(cause)            ProgrammingError(cause,__FILE__,__LINE__)
+ #  define JPDEBUG_STOP(cause)            ProgrammingError(cause, __FILE__, __LINE__)
  #  define JPDEBUG_TEST(cause,condition)  ((condition) ? (void)0 : JPDEBUG_STOP(cause))
 
  // Error codes
diff -ruN jptui/jpdemo/jpdemo.cpp jptui.const/jpdemo/jpdemo.cpp
--- jptui/jpdemo/jpdemo.cpp	Sat Nov 28 11:39:12 1998
+++ jptui.const/jpdemo/jpdemo.cpp	Tue Jun  5 18:12:44 2001
@@ -5,7 +5,7 @@
 /*--------------------------------------------------------------------------*/
 /* Author     : DELPRAT Jean-Pierre (jpdelprat@teaser.fr)                   */
 /* Crated on  : 15-APR-96                                                   */
-/* Modified on: 19-MAY-97                                                   */
+/* Modified on: 5-JUNE-2001 (michael@idisys.iae.nsk.su)                     */
 /****************************************************************************/
 
 
@@ -544,7 +544,7 @@
 
 //-- Callback called when an item of the dialog menu is clicked --
 
-void DialogMenuItemClickedCall(PObject /*sender*/,int item_nb,char */*arg*/)
+void DialogMenuItemClickedCall(PObject /*sender*/, int item_nb, const char */*arg*/)
 {
   char str[31];
 
@@ -567,7 +567,7 @@
 
 //-- Callback called when an item of the option menu is clicked --
 
-void OptionMenuItemClickedCall(PObject /*sender*/,int item_nb,char */*arg*/)
+void OptionMenuItemClickedCall(PObject /*sender*/, int item_nb, const char */*arg*/)
 {
   static int old_selected_mode=2;
   static int old_selected_mouse_aspect=4;
@@ -653,7 +653,7 @@
 
 //-- Callback called when an item of the language menu is clicked --
 
-void LanguageMenuItemClickedCall(PObject /*sender*/,int item_nb,char */*arg*/)
+void LanguageMenuItemClickedCall(PObject /*sender*/, int item_nb, const char */*arg*/)
 {
   int i;
   boolean cancel=FALSE;
@@ -695,7 +695,7 @@
 
 //-- Callback called when an item of the help menu is clicked --
 
-void HelpMenuItemClickedCall(PObject /*sender*/,int /*item_nb*/,char */*arg*/)
+void HelpMenuItemClickedCall(PObject /*sender*/, int /*item_nb*/, const char */*arg*/)
 {
   // Opens the window or brings it to front
 
@@ -704,7 +704,7 @@
 
 //-- Callback called when the button located near the gauge is pressed
 
-void GaugeStartButtonPressedCall(PObject /*sender*/, char */*arg*/)
+void GaugeStartButtonPressedCall(PObject /*sender*/, const char */*arg*/)
 {
 
   long value=Gauge.m_get_value();
@@ -727,14 +727,14 @@
 //-- Callback called when the quit button or the close button of the main
 //   windows are pressed
 
-void QuitCall(PObject /*sender*/,char */*arg*/)
+void QuitCall(PObject /*sender*/, const char */*arg*/)
 {
   JPStop();
 }
 
 //-- Test callback -- emits a BEEP when called
 
-void BipCall(PObject /*sender*/,char */*arg*/)
+void BipCall(PObject /*sender*/, const char */*arg*/)
 {
   PlaySound(BIP1);
 }
@@ -746,7 +746,7 @@
 
 int main(int argc, char* /*argv*/[])
 {
-  char *main_window_caption="JPTUI Demo - Running under @@@@@@@";
+  const char *main_window_caption="JPTUI Demo - Running under @@@@@@@";
 
   // Has the program been called with arguments
 
diff -ruN jptui/jpdemo/makefile jptui.const/jpdemo/makefile
--- jptui/jpdemo/makefile	Sat Nov 28 11:28:32 1998
+++ jptui.const/jpdemo/makefile	Tue Jun  5 18:14:00 2001
@@ -5,7 +5,7 @@
 all : jpdemo.exe jpdemo.hlp
 
 jpdemo.exe : jpdemo.o jptui.dat
-	gxx -s -o jpdemo.exe jpdemo.o ../libjptui.a
+	gcc -s -o jpdemo.exe jpdemo.o ../libjptui.a -lstdcxx
 	../tools/connect.exe jpdemo.exe jptui.dat
 	del jptui.dat
 
diff -ruN jptui/jptui.def jptui.const/jptui.def
--- jptui/jptui.def	Sat Nov 28 12:57:36 1998
+++ jptui.const/jptui.def	Tue Jun  5 17:51:10 2001
@@ -48,7 +48,6 @@
 #include "TRdioBut.h"
 #include "TPushBut.h"
 #include "TEdZone.h"
-#include "TPassEDZ.h"
 #include "TDecEdZn.h"
 #include "TIntEdZn.h"
 #include "TLabel.h"
diff -ruN jptui/jptui.mak jptui.const/jptui.mak
--- jptui/jptui.mak	Sat Jul  5 09:02:14 1997
+++ jptui.const/jptui.mak	Tue Jun  5 17:51:10 2001
@@ -45,8 +45,7 @@
    thelptz.obj\
    windows.obj\
    spchars.obj\
-   tpassedz.obj\
-	vocab.obj\
+   vocab.obj\
    jpdata.obj\
    filebox.obj\
    tfilelb.obj\
@@ -94,7 +93,6 @@
 -+thelptz.obj &
 -+windows.obj &
 -+spchars.obj &
--+tpassedz.obj &
 -+vocab.obj &
 -+jpdata.obj &
 -+filebox.obj &
@@ -158,11 +156,6 @@
  $(CEAT_jptuidlib) $(CNIEAT_jptuidlib) -o$@ spchars.cpp
 |
 
-tpassedz.obj :  tpassedz.cpp
-  $(BCCDOS) -c @&&|
- $(CEAT_jptuidlib) $(CNIEAT_jptuidlib) -o$@ tpassedz.cpp
-|
-
 vocab.obj :  vocab.cpp
   $(BCCDOS) -c @&&|
  $(CEAT_jptuidlib) $(CNIEAT_jptuidlib) -o$@ vocab.cpp
diff -ruN jptui/jpvocab.h jptui.const/jpvocab.h
--- jptui/jpvocab.h	Sun Nov  2 22:53:56 1997
+++ jptui.const/jpvocab.h	Tue Jun  5 17:51:10 2001
@@ -43,6 +43,9 @@
 #define VOC_ABORT_CAPTION                     55
 #define VOC_RETRY_CAPTION                     56
 #define VOC_IGNORE_CAPTION                    57
+#define VOC_CONTINUE_CAPTION                  58
+#define VOC_YES_TO_ALL_CAPTION                59
+#define VOC_REVIEW_CAPTION		      60
 
 #define VOC_FILENAME_CAPTION                  70
 #define VOC_SEARCH_CAPTION                    71
diff -ruN jptui/keyboard.cpp jptui.const/keyboard.cpp
--- jptui/keyboard.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/keyboard.cpp	Tue Jun  5 17:51:10 2001
@@ -246,8 +246,9 @@
 
 void WaitKeyRelease()
 {
-  while (!(inportb(0x60) & 0x80))
-    ResetKeyboard();
+//  Fix: keys don't work if not in time to catch release
+//  while (!(inportb(0x60) & 0x80))
+//    ResetKeyboard();
 }
 
 /****************************************************************************/
diff -ruN jptui/makefile jptui.const/makefile
--- jptui/makefile	Sun May 24 16:53:56 1998
+++ jptui.const/makefile	Tue Jun  5 17:51:10 2001
@@ -36,7 +36,6 @@
 	tmenu.o    \
 	tmenubar.o \
 	tobject.o  \
-	tpassedz.o \
 	tpushbut.o \
 	trdiobut.o \
 	trdiogrp.o \
diff -ruN jptui/mouse.cpp jptui.const/mouse.cpp
--- jptui/mouse.cpp	Sun Jan 25 14:53:06 1998
+++ jptui.const/mouse.cpp	Tue Jun  5 17:51:10 2001
@@ -28,10 +28,6 @@
 
 #define INT_MOUSE 0x33
 
-// 1er des caractres utiliss par le curseur graphique
-
-#define GMOUSE_1ST_CHAR 208
-
 // Hauteur maximum d'un pointer
 
 #define MAX_HEIGHT  16
diff -ruN jptui/mouse.h jptui.const/mouse.h
--- jptui/mouse.h	Mon Jun 30 21:15:38 1997
+++ jptui.const/mouse.h	Tue Jun  5 17:51:10 2001
@@ -46,6 +46,10 @@
 	       MPA_TEXTUAL,
 	       MPA_MOUSE_DRIVER } TMousePointerAspect;
 
+// 1er des caractres utiliss par le curseur graphique
+// Fix: moved to header (used in ToScreenChar())
+#define GMOUSE_1ST_CHAR 208
+
 /*ͻ*/
 /*                                 FONCTIONS                              */
 /*ͼ*/
diff -ruN jptui/mousegcc.cpp jptui.const/mousegcc.cpp
--- jptui/mousegcc.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/mousegcc.cpp	Tue Jun  5 17:51:10 2001
@@ -166,9 +166,9 @@
 	movl  $0xB8000,%%edi
 	addl  %%eax,%%edi
 
-	movw  %%es:(%%edi),%%eax
+	movw  %%es:(%%edi),%%ax
 	notb  %%ah
-	movw  %%eax,%%es:(%%edi)
+	movw  %%ax,%%es:(%%edi)
 
 	popw  %%es
 	jmp   9f
@@ -395,7 +395,7 @@
 	popl  %%ecx
 	popl  %%edi
 
-	addl  %%edi,%%esi   // 2*(pointer_height-1)
+	addl  %%edi,%%esi   # 2*(pointer_height-1)
 	addl  $2,%%esi
 
 #Loop2_2:
diff -ruN jptui/msgbox.cpp jptui.const/msgbox.cpp
--- jptui/msgbox.cpp	Sun Mar 15 07:25:06 1998
+++ jptui.const/msgbox.cpp	Tue Jun  5 17:51:10 2001
@@ -95,7 +95,7 @@
 /* Returns the text of a button of the message box 			    */
 /****************************************************************************/
 
-char *MsgBoxButtonText(int button_number)
+const char *MsgBoxButtonText(int button_number)
 {
   int temp=0;
 
@@ -218,7 +218,7 @@
 /* Function called when the users presses one of the buttons of the box     */
 /****************************************************************************/
 
-void MsgBoxButtonPressedCall(PObject /*sender*/,char *button_number)
+void MsgBoxButtonPressedCall(PObject /*sender*/, const char *button_number)
 {
   switch (button_number[0])
     {
@@ -281,11 +281,8 @@
 /* Returns the button pressed by the user				    */
 /****************************************************************************/
 
-int MessageBox(char *title,
-	       char *message,
-	       int window_style,
-	       int type,
-	       TSound sound_type)
+int MessageBox(const char *title, const char *message, int window_style,
+	       int type, TSound sound_type)
 {
   TMousePointer pointer;
 
diff -ruN jptui/msgbox.h jptui.const/msgbox.h
--- jptui/msgbox.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/msgbox.h	Tue Jun  5 17:51:10 2001
@@ -82,10 +82,7 @@
 /*                                 FUNCTIONS                              */
 /*ͼ*/
 
-int MessageBox(char *title,
-	       char *message,
-	       int window_style,
-	       int type=MB_OK,
-	       TSound sound_type=NO_SOUND);
+int MessageBox(const char *title, const char *message, int window_style,
+	       int type=MB_OK, TSound sound_type=NO_SOUND);
 
 #endif
\ No newline at end of file
diff -ruN jptui/screen.h jptui.const/screen.h
--- jptui/screen.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/screen.h	Tue Jun  5 17:51:28 2001
@@ -90,6 +90,7 @@
 #define CHAR_UP_BOTTOM_HLINES    ''  // 215
 #define TEXT_UP_BOTTOM_HLINES    ""  // 215
 
+#define CHAR_ALT_UP_LEFT_CORNER  ''  // 218
 
 /*ͻ*/
 /*                                 FUNCTIONS                              */
diff -ruN jptui/shortcut.cpp jptui.const/shortcut.cpp
--- jptui/shortcut.cpp	Thu Jul 31 07:56:10 1997
+++ jptui.const/shortcut.cpp	Tue Jun  5 17:51:10 2001
@@ -210,11 +210,12 @@
   char *letter="X";
 
   int available;
-  char *text;
 
   if (label1==NONE)
     return("");
 
+  const char *text;
+
   switch (label1)
     {
       case CTRL      : text=GetString(VOC_CTRL);break;
diff -ruN jptui/strings.cpp jptui.const/strings.cpp
--- jptui/strings.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/strings.cpp	Tue Jun  5 17:51:10 2001
@@ -22,7 +22,7 @@
 /* Returns the last char of string (or 0 if string is "")                   */
 /****************************************************************************/
 
-char EndOfString(char *string)
+char EndOfString(const char *string)
 {
   int length=strlen(string);
 
@@ -53,7 +53,7 @@
 /* Retourne TRUE si la chane tait valide (accepte des espaces en fin).    */
 /****************************************************************************/
 
-boolean StringToLong(char *string,long &value)
+boolean StringToLong(const char *string, long &value)
 {
   char *end_ptr;
 
@@ -82,7 +82,7 @@
 /* Retourne TRUE si la chane tait valide (accepte des espaces en fin).    */
 /****************************************************************************/
 
-boolean StringToDouble(char *string,double &value)
+boolean StringToDouble(const char *string, double &value)
 {
   char *end_ptr;
 
@@ -133,7 +133,7 @@
 /* ------   prcd de ~) ou 0 s'il n'y en a pas     */
 /*****************************************************/
 
-char HotKey(char *caption)
+char HotKey(const char *caption)
 {
   char *ptr=strchr(caption,'~');
 
@@ -149,7 +149,7 @@
 /*                 ou un autre ~                      */
 /******************************************************/
 
-int DisplayLength(char *string)
+int DisplayLength(const char *string)
 {
   register int i=0;
 
@@ -179,7 +179,7 @@
 /* -------------   (voir STRINGS.H pour le format)            */
 /**************************************************************/
 
-int GetTextHeight(char *text)
+int GetTextHeight(const char *text)
 {
   boolean  done;
 
@@ -213,7 +213,7 @@
 /* ------------   (voir STRINGS.H pour le format)            */
 /*************************************************************/
 
-int GetTextWidth(char *text)
+int GetTextWidth(const char *text)
 {
   boolean      done;
 
diff -ruN jptui/strings.h jptui.const/strings.h
--- jptui/strings.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/strings.h	Tue Jun  5 17:51:10 2001
@@ -28,7 +28,7 @@
 
 // Returns the last char of string (or 0 if string is "")
 
-char EndOfString(char *string);
+char EndOfString(const char *string);
 
 // Conversion d'un chiffre hexa en nombre dcimal
 
@@ -37,20 +37,20 @@
 // Conversion d'une chane en un nombre du type indiqu.
 // Retourne TRUE si la chane tait valide.
 
-boolean StringToLong(char *string,long &value);
-boolean StringToDouble(char *string,double &value);
+boolean StringToLong(const char *string, long &value);
+boolean StringToDouble(const char *string, double &value);
 
 // Conversion d'un nombre en une chane
 // (la chane doit tre alloue)
 
-void LongToString(long value,char *string);
-void DoubleToString(double value,char *string);
+void LongToString(long value, char *string);
+void DoubleToString(double value, char *string);
 
 // Manipulation des lgendes des lments de l'interface
 // (hot-key ventuelle prcde de ~, ~~ pour afficher ~)
 
-char HotKey(char *caption);        // Hot-key de caption
-int  DisplayLength(char *caption); // Longueur d'affichage de caption
+char HotKey(const char *caption);        // Hot-key de caption
+int  DisplayLength(const char *caption); // Longueur d'affichage de caption
 
 
 // Manipulation des textes
@@ -60,8 +60,8 @@
 // -> toute combinaison [..] ne fait pas partie des caractres affichs
 // -> [[ pour afficher le caractre [
 
-int  GetTextHeight(char *text);    // Hauteur d'affichage de text
-int  GetTextWidth(char *text);     // Largeur d'affichage de text
+int  GetTextHeight(const char *text);    // Hauteur d'affichage de text
+int  GetTextWidth(const char *text);     // Largeur d'affichage de text
 
 
 #endif
diff -ruN jptui/tapplica.cpp jptui.const/tapplica.cpp
--- jptui/tapplica.cpp	Sun May 24 17:48:48 1998
+++ jptui.const/tapplica.cpp	Tue Jun  5 17:51:10 2001
@@ -157,11 +157,11 @@
 
   // Callback : Fonction appele lorsqu'il n'y a pas d'vnement en cours
 
-  InitCallback(f_no_event_action,f_no_event_argument);
+  InitCallback(f_no_event_action, f_no_event_argument);
 
   // Callback : Fonction appele quand le contenu du clipboard change
 
-  InitCallback(f_clipboard_changed_action,f_clipboard_changed_argument);
+  InitCallback(f_clipboard_changed_action, f_clipboard_changed_argument);
 }
 
 /***************/
@@ -548,7 +548,7 @@
 /* Passer un texte o les lignes sont spares par un \n                    */
 /****************************************************************************/
 
-void TApplication::m_set_clipboard(char *text)
+void TApplication::m_set_clipboard(const char *text)
 {
   unsigned size=strlen(text)+1;
 
@@ -577,8 +577,8 @@
 /*                           de traitement                    */
 /**************************************************************/
 
-void TApplication::m_set_no_event_callback(void (*no_event_action)(char *),
-					   char *no_event_argument)
+void TApplication::m_set_no_event_callback(void (*no_event_action)(const char *),
+					   const char *no_event_argument)
 {
   SetCallback(f_no_event_action,f_no_event_argument,
               no_event_action,no_event_argument);
@@ -590,8 +590,8 @@
 /* Dfinition du callback associ  la modification du contenu du clipboard */
 /****************************************************************************/
 
-void TApplication::m_set_clipboard_changed_callback(void (*clipboard_changed_action)(char *),
-					            char *clipboard_changed_argument)
+void TApplication::m_set_clipboard_changed_callback(void (*clipboard_changed_action)(const char *),
+					            const char *clipboard_changed_argument)
 {
   SetCallback(f_clipboard_changed_action,f_clipboard_changed_argument,
               clipboard_changed_action,clipboard_changed_argument);
diff -ruN jptui/tapplica.h jptui.const/tapplica.h
--- jptui/tapplica.h	Sun May 24 14:30:54 1998
+++ jptui.const/tapplica.h	Tue Jun  5 17:51:10 2001
@@ -122,13 +122,13 @@
 
     // Callback invoked when no event occurs
 
-    void                (*f_no_event_action)(char *);
-    char                *f_no_event_argument;
+    void                (*f_no_event_action)(const char *);
+    const char *f_no_event_argument;
 
     // Callback invoked when the contents of the clipboard change.
 
-    void                (*f_clipboard_changed_action)(char *);
-    char                *f_clipboard_changed_argument;
+    void                (*f_clipboard_changed_action)(const char *);
+    const char *f_clipboard_changed_argument;
 
   /*----------------*/
   /* Public methods */
@@ -191,7 +191,7 @@
     // Clipboard reading and writing
 
 	    char        *m_get_clipboard()    { return(f_clipboard);};
-	    void        m_set_clipboard(char *text);
+	    void        m_set_clipboard(const char *text);
 
     // Enables/Disables callback processing
 
@@ -202,10 +202,10 @@
 
     // Defines the callbacks
 
-	    void        m_set_no_event_callback(void (*no_event_action)(char *),
-						char *no_event_argument);
-	    void        m_set_clipboard_changed_callback(void (*clipboard_changed_action)(char *),
-							 char *clipboard_changed_argument);
+	    void        m_set_no_event_callback(void (*no_event_action)(const char *),
+						const char *no_event_argument);
+	    void        m_set_clipboard_changed_callback(void (*clipboard_changed_action)(const char *),
+							 const char *clipboard_changed_argument);
 
   /*-----------------*/
   /* Private methods */
diff -ruN jptui/tchkbox.cpp jptui.const/tchkbox.cpp
--- jptui/tchkbox.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tchkbox.cpp	Tue Jun  5 17:51:10 2001
@@ -41,7 +41,7 @@
 
 TCheckBox::TCheckBox(PObject parent,
 		     int rel_x,int rel_y,
-		     int width,char *caption,
+		     int width, const char *caption,
 		     boolean checked,
                      boolean enabled)
 	  :TObject(parent,
@@ -61,8 +61,8 @@
 
   // Callbacks
 
-  InitCallback(f_checked_action,f_checked_argument);
-  InitCallback(f_unchecked_action,f_unchecked_argument);
+  InitCallback(f_checked_action, f_checked_argument);
+  InitCallback(f_unchecked_action, f_unchecked_argument);
 }
 
 /***************/
@@ -98,10 +98,10 @@
 /* ----------------------   au cochage de la case  cocher */
 /***********************************************************/
 
-void TCheckBox::m_set_checked_callback(void (*checked_action)(PObject,char *),
-				       char *checked_argument)
+void TCheckBox::m_set_checked_callback(void (*checked_action)(PObject, const char *),
+				       const char *checked_argument)
 {
-  SetCallback(f_checked_action,f_checked_argument,
+  SetCallback(f_checked_action, f_checked_argument,
               checked_action,checked_argument);
 }
 
@@ -110,10 +110,10 @@
 /* ------------------------   au dcochage de la case  cocher */
 /***************************************************************/
 
-void TCheckBox::m_set_unchecked_callback(void (*unchecked_action)(PObject,char *),
-					  char *unchecked_argument)
+void TCheckBox::m_set_unchecked_callback(void (*unchecked_action)(PObject, const char *),
+					 const char *unchecked_argument)
 {
-  SetCallback(f_unchecked_action,f_unchecked_argument,
+  SetCallback(f_unchecked_action, f_unchecked_argument,
               unchecked_action,unchecked_argument);
 }
 
diff -ruN jptui/tchkbox.h jptui.const/tchkbox.h
--- jptui/tchkbox.h	Sun May 24 14:31:30 1998
+++ jptui.const/tchkbox.h	Tue Jun  5 17:51:10 2001
@@ -32,14 +32,14 @@
     // Callback : Fonction appele si on coche la checkbox
     //            et son argument
 
-    void (*f_checked_action)(PObject,char *);
-    char *f_checked_argument;
+    void (*f_checked_action)(PObject, const char *);
+    const char *f_checked_argument;
 
     // Callback : Fonction appele si on dcoche la checkbox
     //            et son argument
 
-    void (*f_unchecked_action)(PObject,char *);
-    char *f_unchecked_argument;
+    void (*f_unchecked_action)(PObject, const char *);
+    const char *f_unchecked_argument;
 
   /*--------------------*/
   /* Mthodes publiques */
@@ -51,7 +51,7 @@
 
 		    TCheckBox(PObject parent,
 			      int rel_x,int rel_y,
-			      int width,char *caption,
+			      int width, const char *caption,
 			      boolean checked=FALSE,
                               boolean enabled=TRUE);
 
@@ -65,10 +65,10 @@
 
     // Dfinition des callbacks
 
-	    void    m_set_checked_callback(void (*checked_action)(PObject,char *),
-					  char *checked_argument);
-	    void    m_set_unchecked_callback(void (*unchecked_action)(PObject,char *),
-					     char *unchecked_argument);
+	    void    m_set_checked_callback(void (*checked_action)(PObject, const char *),
+					   const char *checked_argument);
+	    void    m_set_unchecked_callback(void (*unchecked_action)(PObject, const char *),
+					     const char *unchecked_argument);
 
   /*--------------------*/
   /* Mthodes protges */
diff -ruN jptui/tcombbox.cpp jptui.const/tcombbox.cpp
--- jptui/tcombbox.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tcombbox.cpp	Tue Jun  5 17:51:10 2001
@@ -232,10 +232,10 @@
 TComboBox::TComboBox(PObject parent,
 		     int rel_x,int rel_y,
 		     int xoffset_caption,int yoffset_caption,
-		     char *caption,
+		     const char *caption,
 		     int display_length,
 		     int max_length,
-		     char *string,
+		     const char *string,
 		     int list_height,
 		     TListItem items[],
 		     boolean string_must_be_in_list,
@@ -352,7 +352,7 @@
 /*          est affecte  la zone de saisie                                */
 /****************************************************************************/
 
-void TComboBox::m_set_string(char *string)
+void TComboBox::m_set_string(const char *string)
 {
   int index;
 
@@ -375,8 +375,8 @@
 /*                                   la zone d'dition               */
 /*********************************************************************/
 
-void TComboBox::m_set_string_validated_callback(void (*string_validated_action)(PObject,char *),
-						char *string_validated_argument)
+void TComboBox::m_set_string_validated_callback(void (*string_validated_action)(PObject, const char *),
+						const char *string_validated_argument)
 {
   SetCallback(f_string_validated_action,f_string_validated_argument,
 	      string_validated_action,string_validated_argument);
diff -ruN jptui/tcombbox.h jptui.const/tcombbox.h
--- jptui/tcombbox.h	Sun May 24 14:36:24 1998
+++ jptui.const/tcombbox.h	Tue Jun  5 17:51:10 2001
@@ -54,8 +54,8 @@
     // Callback : Fonction appele lorsque le contenu de la combo-box
     //            est valide
 
-    void    (*f_string_validated_action)(PObject,char *);
-    char    *f_string_validated_argument;
+    void (*f_string_validated_action)(PObject, const char *);
+    const char *f_string_validated_argument;
 
   /*--------------------*/
   /* Mthodes publiques */
@@ -67,10 +67,10 @@
 		    TComboBox(PObject parent,
 			     int rel_x,int rel_y,
 			     int xoffset_caption,int yoffset_caption,
-			     char *caption,
+			     const char *caption,
 			     int display_length,
 			     int max_length,
-			     char *string,
+			     const char *string,
 			     int list_height,
 			     TListItem items[],
 			     boolean string_must_be_in_list,
@@ -86,7 +86,7 @@
     virtual void    m_enable_modification()   {return;};
     virtual void    m_disable_modification()  {return;};
 
-    virtual void    m_set_string(char *string);
+    virtual void    m_set_string(const char *string);
 
     // Recopie d'un lment de la liste dans la zone d'dition
 
@@ -98,8 +98,8 @@
 
     // Dfinition des callbacks
 
-	    void    m_set_string_validated_callback(void (*string_validated_action)(PObject,char *),
-						    char *string_validated_argument);
+	    void    m_set_string_validated_callback(void (*string_validated_action)(PObject, const char *),
+						    const char *string_validated_argument);
 
   /*--------------------*/
   /* Mthodes protges */
diff -ruN jptui/tdecedzn.cpp jptui.const/tdecedzn.cpp
--- jptui/tdecedzn.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tdecedzn.cpp	Tue Jun  5 17:51:10 2001
@@ -40,13 +40,13 @@
 /****************************************************************************/
 
 TDecimalEditZone::TDecimalEditZone(PObject parent,
-		                   int rel_x,int rel_y,
-		                   int xoffset_caption,int yoffset_caption,
-                                   char *caption,
+		                   int rel_x, int rel_y,
+		                   int xoffset_caption, int yoffset_caption,
+                                   const char *caption,
                                    int display_length,
 		                   int max_length,
 		                   double min_value,double max_value,
-				   char *string,
+				   const char *string,
 				   boolean enabled)
 		 :TEditZone(parent,
 			    rel_x,rel_y,
@@ -118,7 +118,7 @@
 /* --------------   pour ce type de zone de saisie   */
 /*****************************************************/
 
-boolean TDecimalEditZone::m_string_valid(char *string)
+boolean TDecimalEditZone::m_string_valid(const char *string)
 {
   double value;
 
@@ -174,9 +174,9 @@
 /* Retourne un message indiquant pourquoi la chaine n'est pas valide        */
 /****************************************************************************/
 
-char *TDecimalEditZone::m_get_error_message()
+const char *TDecimalEditZone::m_get_error_message()
 {
-  char *msg=GetString(VOC_MUST_BE_DECIMAL_BETWEEN);
+  const char *msg=GetString(VOC_MUST_BE_DECIMAL_BETWEEN);
 
   if (f_error_message!=NULL)
     delete []f_error_message;
diff -ruN jptui/tdecedzn.h jptui.const/tdecedzn.h
--- jptui/tdecedzn.h	Sun May 24 14:31:52 1998
+++ jptui.const/tdecedzn.h	Tue Jun  5 17:51:10 2001
@@ -33,13 +33,13 @@
     // Constructeur / Destructeur
 
 		    TDecimalEditZone(PObject parent,
-				     int rel_x,int rel_y,
-				     int xoffset_caption,int yoffset_caption,
-				     char *caption,
+				     int rel_x, int rel_y,
+				     int xoffset_caption, int yoffset_caption,
+				     const char *caption,
 				     int display_length,
 				     int max_length,
 				     double min_value=-MAXDOUBLE,double max_value=MAXDOUBLE,
-				     char *string="0",
+				     const char *string = "0",
 				     boolean enabled=TRUE);
 
     virtual         ~TDecimalEditZone();
@@ -51,7 +51,7 @@
 
     // Validit d'une chane pour la zone
 
-    virtual boolean m_string_valid(char *string);
+    virtual boolean m_string_valid(const char *string);
 
   /*------------------*/
   /* Mthodes prives */
@@ -62,7 +62,7 @@
     // Validit de la saisie
 
     virtual boolean m_character_valid(int character);
-    virtual char    *m_get_error_message();
+    virtual const char *m_get_error_message();
 
 };
 
diff -ruN jptui/tedzone.cpp jptui.const/tedzone.cpp
--- jptui/tedzone.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tedzone.cpp	Tue Jun  5 17:51:12 2001
@@ -59,10 +59,10 @@
 TEditZone::TEditZone(PObject parent,
 		     int rel_x,int rel_y,
                      int xoffset_caption,int yoffset_caption,
-		     char *caption,
+		     const char *caption,
                      int display_length,
 		     int max_length,
-		     char *string,
+		     const char *string,
                      boolean enabled)
 	  :TObject(parent,
 		   OBJ_EDIT_ZONE,
@@ -73,7 +73,8 @@
 		   enabled,
 		   TRUE,  // FOCUS_DEPENDING_ASPECT
 		   TRUE,  // CAN_BE_ENABLED,
-		   TRUE)  // SIMPLE
+		   TRUE), // SIMPLE
+           in_password_mode(false)
 {
   char *str;
 
@@ -326,7 +327,7 @@
 /*          est affecte  la zone de saisie                              */
 /**************************************************************************/
 
-void TEditZone::m_set_string(char *string)
+void TEditZone::m_set_string(const char *string)
 {
   int          string_length;
   register int i;
@@ -399,7 +400,7 @@
 /* --------------   pour ce type de zone de saisie          */
 /************************************************************/
 
-boolean TEditZone::m_string_valid(char *string)
+boolean TEditZone::m_string_valid(const char *string)
 {
   // Chane trop longue ?
 
@@ -428,7 +429,7 @@
     {
       if (!m_string_valid(m_get_string()))
 	{
-	  MessageBox("",m_get_error_message(),ALERT,MB_ICONEXCLAMATION,
+	  MessageBox("", m_get_error_message(), ALERT,MB_ICONEXCLAMATION,
 		     ERROR_SOUND);
 
 	  // On vrifie que la zone a bien repris le focus
@@ -448,8 +449,8 @@
 /*                                 la zone d'dition               */
 /*******************************************************************/
 
-void TEditZone::m_set_string_changed_callback(void (*string_changed_action)(PObject,char *),
-					      char *string_changed_argument)
+void TEditZone::m_set_string_changed_callback(void (*string_changed_action)(PObject, const char *),
+					      const char *string_changed_argument)
 {
   SetCallback(f_string_changed_action,f_string_changed_argument,
 	      string_changed_action,string_changed_argument);
@@ -1135,9 +1136,9 @@
 /* Retourne un message indiquant pourquoi la chaine n'est pas valide        */
 /****************************************************************************/
 
-char *TEditZone::m_get_error_message()
+const char *TEditZone::m_get_error_message()
 {
-  return(GetString(VOC_INVALID_ENTRY));
+  return GetString(VOC_INVALID_ENTRY);
 }
 
 /*********************************************************************/
@@ -1235,6 +1236,8 @@
 
 void TEditZone::m_display_string_chars(unsigned background,int last_visible_char)
 {
+  if (!in_password_mode) {
+
   char *ptr2;
   char *ptr1;
 
@@ -1298,5 +1301,66 @@
 	  f_window->m_puts(ptr1);
           (*ptr2)=old_char;
         }
-    }
+     }
+ 
+   } else { // in_password_mode
+ 
+   int  ptr1,ptr2;
+   int  last_true_visible_char;
+ 
+   // EditZone avec focus et zone slectionne
+ 
+   ptr1=f_first_visible_char;
+   last_true_visible_char=MIN(f_useful_length-1,last_visible_char);
+ 
+   if ((f_focused) && (f_window->m_is_active()) && (f_zone_selected))
+     {
+       ptr2=MIN(f_min_selected_char-1,last_true_visible_char)+1;
+ 
+       if (ptr1<ptr2)
+ 	{
+	  f_window->m_putnch(ptr2-ptr1,'*');
+ 	  ptr1=ptr2;
+ 	}
+ 
+       f_window->m_set_inverse_attr(f_background);
+ 
+       ptr2=MIN(f_max_selected_char,last_true_visible_char)+1;
+ 
+       if (ptr1<ptr2)
+ 	{
+ 	  f_window->m_putnch(ptr2-ptr1,'*');
+ 	  ptr1=ptr2;
+ 	}
+ 
+       f_window->m_textattr(background);
+ 
+       ptr2=last_true_visible_char+1;
+       if (ptr1<ptr2)
+ 	{
+ 	  f_window->m_putnch(ptr2-ptr1,'*');
+ 	  ptr1=ptr2;
+ 	}
+    }
+ 
+   // Sinon
+ 
+   else
+     {
+       ptr2=last_true_visible_char+1;
+       if (ptr1<ptr2)
+ 	{
+ 	  f_window->m_putnch(ptr2-ptr1,'*');
+ 	  ptr1=ptr2;
+	}
+     }
+ 
+   // Affichage de la partie de la chaine avec des '.'
+ 
+   ptr2=last_visible_char+1;
+   if (ptr1<ptr2)
+     f_window->m_putnch(ptr2-ptr1,'');
+ 
+   } // in_password_mode
+ 
 }
\ No newline at end of file
diff -ruN jptui/tedzone.h jptui.const/tedzone.h
--- jptui/tedzone.h	Sun May 24 14:29:48 1998
+++ jptui.const/tedzone.h	Tue Jun  5 17:51:12 2001
@@ -108,8 +108,8 @@
     // Callback : Fonction appele  chaque modification de la chane
     //            et son argument
 
-    void    (*f_string_changed_action)(PObject,char *);
-    char    *f_string_changed_argument;
+    void (*f_string_changed_action)(PObject, const char *);
+    const char *f_string_changed_argument;
 
 
   /*--------------------*/
@@ -121,12 +121,12 @@
     // Constructeur / Destructeur
 
      	            TEditZone(PObject parent,
-		              int rel_x,int rel_y,
-                              int  xoffset_caption,int yoffset_caption,
-			      char *caption,
+		              int rel_x, int rel_y,
+                              int xoffset_caption, int yoffset_caption,
+			      const char *caption,
                               int display_length,
 			      int max_length,
-			      char *string="",
+			      const char *string = "",
 			      boolean enabled=TRUE);
     virtual         ~TEditZone();
 
@@ -145,7 +145,7 @@
 	    void    m_unselect();
             void    m_clear_selection();
 
-    virtual void    m_set_string(char *string);
+    virtual void    m_set_string(const char *string);
 
     // La chane peut tre manipule tant que l'objet existe
 
@@ -154,7 +154,7 @@
 
     // Validit d'une chane pour la zone
 
-    virtual boolean m_string_valid(char *string);
+    virtual boolean m_string_valid(const char *string);
 
     // La zone peut-elle perdre le focus
     // (si non, affiche une boite de dialogue)
@@ -164,8 +164,14 @@
 
     // Dfinition des callbacks
 
-	    void    m_set_string_changed_callback(void (*string_changed_action)(PObject,char *),
-						  char *string_changed_argument);
+	    void    m_set_string_changed_callback(void (*string_changed_action)(PObject, const char *),
+						  const char *string_changed_argument);
+
+            void set_password_mode(bool a_mode) 
+            {
+              in_password_mode = a_mode; 
+              m_display_string();
+            }; 
 
   /*--------------------*/
   /* Mthodes protges */
@@ -223,7 +229,7 @@
 
 	    void    m_calc_useful_length();
     virtual boolean m_character_valid(int character);
-    virtual char    *m_get_error_message();
+    virtual const char *m_get_error_message();
 
     // Dplacement du curseur
 
@@ -235,6 +241,7 @@
 	    void    m_show_cursor();
 
     // Pour l'affichage
+    bool in_password_mode; // to display every symbol as '*'
 
     virtual void    m_display_string_chars(unsigned background,int last_visible_char);
 
diff -ruN jptui/tfilelb.cpp jptui.const/tfilelb.cpp
--- jptui/tfilelb.cpp	Fri Mar  6 08:16:42 1998
+++ jptui.const/tfilelb.cpp	Tue Jun  5 17:51:12 2001
@@ -30,7 +30,7 @@
 TFileListBox::TFileListBox(PObject parent,
 			   int rel_x, int rel_y,
 			   int width, int height,
-			   char *dir_mask)
+			   const char *dir_mask)
 	     :TListBox(parent,
 		       rel_x,rel_y,
 		       width,height,
@@ -62,7 +62,7 @@
   DestroyCallback(f_refresh_done_action,f_refresh_done_argument);
 }
 
-TFLBError TFileListBox::m_refresh_file_list(char *dir_mask)
+TFLBError TFileListBox::m_refresh_file_list(const char *dir_mask)
 {
   boolean add;
   struct ffblk ffblk;
@@ -357,15 +357,15 @@
 /* Dfinition du callback associ au rafrachissement de la liste           */
 /****************************************************************************/
 
-void TFileListBox::m_set_refresh_done_callback(void (*refresh_done_action)(PObject,char *),
-					      char *refresh_done_argument)
+void TFileListBox::m_set_refresh_done_callback(void (*refresh_done_action)(PObject, const char *),
+					       const char *refresh_done_argument)
 {
   SetCallback(f_refresh_done_action,f_refresh_done_argument,
 	      refresh_done_action,refresh_done_argument);
 }
 
-void TFileListBox::m_set_file_chosen_callback(void (*file_chosen_action)(PObject,char *),
-					      char *file_chosen_argument)
+void TFileListBox::m_set_file_chosen_callback(void (*file_chosen_action)(PObject, const char *),
+					      const char *file_chosen_argument)
 {
   SetCallback(f_file_chosen_action,f_file_chosen_argument,
 	      file_chosen_action,file_chosen_argument);
@@ -421,7 +421,7 @@
 
 void TFileListBox::m_no_disk_in_drive_error(int drive)
 {
-  char *text=GetString(VOC_NO_DISK_IN_DRIVE);
+  const char *text=GetString(VOC_NO_DISK_IN_DRIVE);
   char *msg=new char[strlen(text)];   // Pas de +1 car %c: -> X:
 
   sprintf(msg,text,'A'+drive);
@@ -429,13 +429,13 @@
   delete []msg;
 }
 
-void TFileListBox::m_invalid_dir_error(char *dir)
+void TFileListBox::m_invalid_dir_error(const char *dir)
 {
-  MessageBox(dir,GetString(VOC_INVALID_DIRECTORY),ALERT,MB_ICONEXCLAMATION|MB_OK);
+  MessageBox(dir, GetString(VOC_INVALID_DIRECTORY),ALERT,MB_ICONEXCLAMATION|MB_OK);
 }
 
-void TFileListBox::m_invalid_file_error(char *file)
+void TFileListBox::m_invalid_file_error(const char *file)
 {
-  MessageBox(file,GetString(VOC_INVALID_FILE),ALERT,MB_ICONEXCLAMATION|MB_OK);
+  MessageBox(file, GetString(VOC_INVALID_FILE),ALERT,MB_ICONEXCLAMATION|MB_OK);
 }
 
diff -ruN jptui/tfilelb.h jptui.const/tfilelb.h
--- jptui/tfilelb.h	Sun Dec 21 23:03:46 1997
+++ jptui.const/tfilelb.h	Tue Jun  5 17:51:12 2001
@@ -49,13 +49,13 @@
     // Callback invoked if no errors occurs when the list of files
     // is refreshed
 
-    void    	        (*f_refresh_done_action)(PObject,char *);
-    char    	        *f_refresh_done_argument;
+    void (*f_refresh_done_action)(PObject, const char *);
+    const char *f_refresh_done_argument;
 
     // Callback invoked when a file has been chosen by the user
 
-    void    	        (*f_file_chosen_action)(PObject,char *);
-    char    	        *f_file_chosen_argument;
+    void (*f_file_chosen_action)(PObject, const char *);
+    const char *f_file_chosen_argument;
 
   /*----------------*/
   /* Public methods */
@@ -68,13 +68,13 @@
 			TFileListBox(PObject parent,
 				     int rel_x, int rel_y,
 				     int width, int height,
-				     char *dir_mask="*.*");
+				     const char *dir_mask = "*.*");
 			~TFileListBox();
 
 
     // Refreshes the list of files according to the specified mask
 
-	    TFLBError   m_refresh_file_list(char *dir_mask);
+	    TFLBError m_refresh_file_list(const char *dir_mask);
 
     // Returns the current dir/mask/file
 
@@ -88,10 +88,10 @@
 
     // Defines the callbacks
 
-	    void        m_set_refresh_done_callback(void (*refresh_done_action)(PObject,char *),
-						    char *refresh_done_argument);
-	    void        m_set_file_chosen_callback(void (*file_chosen_action)(PObject,char *),
-						   char *file_chosen_argument);
+	    void        m_set_refresh_done_callback(void (*refresh_done_action)(PObject, const char *),
+						    const char *refresh_done_argument);
+	    void        m_set_file_chosen_callback(void (*file_chosen_action)(PObject, const char *),
+						   const char *file_chosen_argument);
 
   /*-------------------*/
   /* Protected methods */
@@ -111,8 +111,8 @@
 
     virtual void        m_invalid_drive_error(int drive);
     virtual void        m_no_disk_in_drive_error(int drive);
-    virtual void        m_invalid_dir_error(char *dir);
-    virtual void        m_invalid_file_error(char *file);
+    virtual void        m_invalid_dir_error(const char *dir);
+    virtual void        m_invalid_file_error(const char *file);
 
 };
 
diff -ruN jptui/tframe.cpp jptui.const/tframe.cpp
--- jptui/tframe.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tframe.cpp	Tue Jun  5 17:51:12 2001
@@ -35,7 +35,7 @@
 TFrame::TFrame(PObject parent,
 	       int rel_x,int rel_y,
 	       int width,int height,
-	       char *caption,
+	       const char *caption,
 	       boolean enabled)
        :TGroup(parent,
 	       OBJ_FRAME_GROUP,
@@ -48,6 +48,7 @@
 	       TRUE,   // CAN_BE_ENABLED
 	       TRUE)   // NEED_FOCUSED_ELEMENT
 {
+  set_frame_color(f_background); // Fix: backward compability
 }
 
 /***************/
@@ -81,6 +82,6 @@
   x2=x1+f_width-1;
   y2=y1+f_height-1;
 
-  f_window->m_draw_frame(x1,y1,x2,y2,f_background,f_caption,f_enabled);
+  f_window->m_draw_frame(x1,y1,x2,y2,frame_color,f_caption,f_enabled);
 }
 
diff -ruN jptui/tframe.h jptui.const/tframe.h
--- jptui/tframe.h	Sun May 24 14:29:20 1998
+++ jptui.const/tframe.h	Tue Jun  5 17:51:12 2001
@@ -23,12 +23,16 @@
     // Constructeur/Destructeur
 
 		    TFrame(PObject parent,
-			   int rel_x,int rel_y,
+			   int rel_x, int rel_y,
 			   int width,int height,
-			   char *caption="",
+			   const char *caption = "",
 			   boolean enabled=TRUE);
     virtual         ~TFrame();
 
+    // Fix: frame color redefinition
+    void	     set_frame_color(unsigned a_color) 
+      { frame_color = a_color; };
+
   /*--------------------*/
   /* Mthodes protges */
   /*--------------------*/
@@ -39,6 +43,8 @@
 
     virtual void    m_display_caption();
 
+    // Fix: added frame color to be able to redefine
+    unsigned	    frame_color;	
 };
 
 
diff -ruN jptui/tgauge.cpp jptui.const/tgauge.cpp
--- jptui/tgauge.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tgauge.cpp	Tue Jun  5 17:51:12 2001
@@ -48,7 +48,9 @@
 		DISABLED,
 		FALSE,  // NOT_FOCUS_DEPENDING_ASPECT
 		FALSE,  // CANNOT_BE_ENABLED,
-		TRUE)   // SIMPLE
+		TRUE),  // SIMPLE
+	   bright_gauge_attr((WHITE<<4)+(unsigned)BLACK), 
+	   normal_gauge_attr((LIGHTGRAY<<4)+(unsigned)BLACK)
 {
   f_max_value=max_value;
   f_value=0;
@@ -201,10 +203,10 @@
   f_old_text_length=text_length;
 
 
-  f_window->m_textattr((WHITE<<4)+(unsigned)BLACK);
+  f_window->m_textattr(bright_gauge_attr);
   f_window->m_gotoxy(x,y+1);
   f_window->m_putnch(bright_width,' ');
-  f_window->m_textattr((LIGHTGRAY<<4)+(unsigned)BLACK);
+  f_window->m_textattr(normal_gauge_attr);
   f_window->m_putnch(f_width-bright_width,' ');
 
 }
diff -ruN jptui/tgauge.h jptui.const/tgauge.h
--- jptui/tgauge.h	Sun May 24 14:37:34 1998
+++ jptui.const/tgauge.h	Tue Jun  5 17:51:12 2001
@@ -35,6 +35,10 @@
 
     int     f_old_text_length;
 
+    unsigned  bright_gauge_attr;
+    unsigned  normal_gauge_attr;
+	
+
   /*--------------------*/
   /* Mthodes publiques */
   /*--------------------*/
@@ -61,6 +65,13 @@
 	    void    m_set_max_value(long max_value);
 	    long    m_get_max_value() {return(f_max_value);};
 
+	    void    set_gauge_attributes(unsigned bright, unsigned normal)
+            {
+              bright_gauge_attr = bright; normal_gauge_attr = normal;
+	      m_display_gauge();
+            };
+
+
   /*--------------------*/
   /* Mthodes protges */
   /*--------------------*/
diff -ruN jptui/tgroup.cpp jptui.const/tgroup.cpp
--- jptui/tgroup.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tgroup.cpp	Tue Jun  5 17:51:12 2001
@@ -50,7 +50,7 @@
 	       int rel_x,int rel_y,
 	       int width,int height,
 	       unsigned background,
-               char *caption,
+               const char *caption,
 	       boolean enabled,
 	       boolean focus_depending_aspect,
                boolean can_be_enabled,
diff -ruN jptui/tgroup.h jptui.const/tgroup.h
--- jptui/tgroup.h	Sun May 24 14:31:12 1998
+++ jptui.const/tgroup.h	Tue Jun  5 17:51:12 2001
@@ -52,7 +52,7 @@
 			   int rel_x,int rel_y,
 			   int width,int height,
 			   unsigned background,
-			   char *caption,
+			   const char *caption,
 			   boolean enabled,
 			   boolean focus_depending_aspect,
                            boolean can_be_enabled,
diff -ruN jptui/thelptz.cpp jptui.const/thelptz.cpp
--- jptui/thelptz.cpp	Sun Nov  9 20:44:50 1997
+++ jptui.const/thelptz.cpp	Tue Jun  5 17:51:12 2001
@@ -22,6 +22,7 @@
 
 #include "THelpWnd.h"
 #include "TPushBut.h"
+#include "Cursor.h" // HideTextCursor()
 
 #include "THelpTZ.h"
 
@@ -167,6 +168,9 @@
   // Disable text modification
 
   m_disable_modification();
+
+  saved_cursor_style = f_cursor_style;
+  f_cursor_style = _NOCURSOR;
 }
 
 /****************************************************************************/
@@ -177,6 +181,7 @@
 THelpTextZone::~THelpTextZone()
 {
   m_free_help_file();
+  f_cursor_style = saved_cursor_style;
 }
 
 
@@ -185,7 +190,7 @@
 /*--------------------------------------------------------------------------*/
 /****************************************************************************/
 
-boolean THelpTextZone::m_load_help_file(char *file_name)
+boolean THelpTextZone::m_load_help_file(const char *file_name)
 {
   long int   where;
   int            i;
@@ -279,12 +284,12 @@
   m_free_help_file();
 }
 
-boolean THelpTextZone::m_topic_exists(char *topic)
+boolean THelpTextZone::m_topic_exists(const char *topic)
 {
   return(((m_find_topic(topic)) != NULL)?TRUE:FALSE);
 }
 
-boolean THelpTextZone::m_display_topic(char *topic,boolean push_current_topic)
+boolean THelpTextZone::m_display_topic(const char *topic, boolean push_current_topic)
 {
   THelpTopic  *new_topic;
 
@@ -309,7 +314,12 @@
 	      f_help_file=NULL;
 	      if (!stricmp(topic,INDEX_TOPIC))
 		m_set_caption(GetString(VOC_INDEX));
-
+	      if (f_selected_link == NULL) { // Fix: jump to first item
+                TKey k; k.character = RIGHT;
+  	        boolean ff = f_focused; f_focused = TRUE;
+  	        m_key_pressed_event(k);
+  	        f_focused = ff;
+	      }
 	      return(TRUE);
 	    }
 	}
@@ -445,7 +455,9 @@
 			     normal_attr,selected_attr);
 }
 
-void THelpTextZone::m_display_help_string_part(char *string,int string_length,int col1,int col2,int min_selected_col,int max_selected_col,unsigned normal_attr,unsigned selected_attr)
+void THelpTextZone::m_display_help_string_part(const char *string, int string_length,
+  int col1, int col2, int min_selected_col, int max_selected_col, 
+  unsigned normal_attr, unsigned selected_attr)
 {
   if (col2<col1)
     return;
@@ -580,6 +592,7 @@
     case ESC    : f_window->m_close();
 		  break;
 
+    case RIGHT: case DOWN: // Fix: to jump to next help topic
     case TAB    : if (f_nb_lines == 0)
 		    break;
 
@@ -637,11 +650,12 @@
 		    }
 
 
-		  if (selected_link!=NULL)
+		  if (selected_link!=NULL) 
 		    m_set_cursor_at(selected_link->col1,line,TRUE);
 
 		  break;
 
+    case LEFT: case UP: // Fix: to jump to previous help topic
     case SHIFT_TAB :
 		  if (f_nb_lines == 0)
 		    break;
@@ -704,10 +718,11 @@
 		    m_set_cursor_at(selected_link->col1,line,TRUE);
 
 		  break;
+    case INSERT: break; // Fix: not allow cursor redefinition
 
 
 
-    default     : return(TTextZone::m_key_pressed_event(key));
+    default     : return (TTextZone::m_key_pressed_event(key));
   }
 
   return(TRUE);
@@ -749,7 +764,7 @@
   f_help_file_name=NULL;
 }
 
-boolean THelpTextZone::m_open_help_file(char *file_name)
+boolean THelpTextZone::m_open_help_file(const char *file_name)
 {
   int     help_file_handle;
   word    tree_count;
@@ -827,7 +842,7 @@
   return(TRUE);
 }
 
-THelpTopic *THelpTextZone::m_find_topic(char *topic)
+THelpTopic *THelpTextZone::m_find_topic(const char *topic)
 {
   int             i;
   THelpTopic   *thishelp = NULL;
@@ -1094,7 +1109,7 @@
     }
 }
 
-void THelpTextZone::m_display_string(char *caption,int string_number)
+void THelpTextZone::m_display_string(const char *caption, int string_number)
 {
   ((PHelpWindow)f_window)->f_previous_button->m_disable();
   ((PHelpWindow)f_window)->f_next_button->m_disable();
diff -ruN jptui/thelptz.h jptui.const/thelptz.h
--- jptui/thelptz.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/thelptz.h	Tue Jun  5 17:51:12 2001
@@ -68,7 +68,7 @@
   /*----------------*/
 
   private:
-
+	int	saved_cursor_style; // Fix: to restore cursor style
     // Help file
 
     FILE                *f_help_file;
@@ -115,10 +115,10 @@
     virtual         ~THelpTextZone();
 
 
-	    boolean m_load_help_file(char *file_name);
+	    boolean m_load_help_file(const char *file_name);
 	    void    m_unload_help_file();
-	    boolean m_topic_exists(char *topic);
-	    boolean m_display_topic(char *help,boolean push_current_topic);
+	    boolean m_topic_exists(const char *topic);
+	    boolean m_display_topic(const char *help, boolean push_current_topic);
 
 	    void    m_select_contents_topic();
 	    void    m_select_index_topic();
@@ -127,7 +127,9 @@
 	    void    m_select_next_topic();
 
     virtual void    m_display_string_node(PStringNode node,int line);
-	    void    m_display_help_string_part(char *string,int string_length,int col1,int col2,int min_selected_col,int max_selected_col,unsigned normal_attr,unsigned selected_attr);
+	    void m_display_help_string_part(const char *string, 
+              int string_length, int col1, int col2, int min_selected_col,
+              int max_selected_col, unsigned normal_attr, unsigned selected_attr);
 
   /*-------------------*/
   /* Protected methods */
@@ -150,11 +152,11 @@
   private:
 
 	    void    m_free_help_file();
-	    boolean m_open_help_file(char *file_name);
-	    THelpTopic *m_find_topic(char *topic);
+	    boolean m_open_help_file(const char *file_name);
+	    THelpTopic *m_find_topic(const char *topic);
 	    void    m_read_topic();
 	    void    m_seek_help_line(long offset,int bit);
-	    char    *m_get_help_line(char *line);
+	    char *m_get_help_line(char *line);
 	    void    m_select_topic(THelpTopic *new_topic,boolean push_current_topic);
 
 	    PLinkNode   m_pos_to_link(int col,int line);
@@ -163,7 +165,7 @@
 //	    void    m_select_previous_link();
 
 	    void    m_push_current_topic();
-	    void    m_display_string(char *caption,int string_number);
+	    void    m_display_string(const char *caption, int string_number);
 
 };
 
diff -ruN jptui/thelpwnd.cpp jptui.const/thelpwnd.cpp
--- jptui/thelpwnd.cpp	Mon Aug 18 21:36:34 1997
+++ jptui.const/thelpwnd.cpp	Tue Jun  5 17:51:12 2001
@@ -46,7 +46,7 @@
 
 THelpWindow::THelpWindow(int x,int y,
 			 int width,int height,
-			 char *caption,
+			 const char *caption,
 			 boolean modal,
 			 boolean movable)
 
@@ -122,7 +122,7 @@
 
   // Callbacks
 
-  m_set_close_button_pressed_callback(m_button_pressed_call,"0");
+//  m_set_close_button_pressed_callback(m_button_pressed_call,"0");
 
   f_contents_button->m_set_pressed_callback(m_button_pressed_call,"1");
   f_index_button   ->m_set_pressed_callback(m_button_pressed_call,"2");
@@ -155,7 +155,7 @@
 /*--------------------------------------------------------------------------*/
 /****************************************************************************/
 
-boolean THelpWindow::m_load_help_file(char *file_name)
+boolean THelpWindow::m_load_help_file(const char *file_name)
 {
   return (f_help_text_zone->m_load_help_file(file_name));
 }
@@ -165,7 +165,7 @@
   f_help_text_zone->m_unload_help_file();
 }
 
-boolean THelpWindow::m_display_topic(char *topic,boolean push_current_topic)
+boolean THelpWindow::m_display_topic(const char *topic, boolean push_current_topic)
 {
   return(f_help_text_zone->m_display_topic(topic,push_current_topic));
 }
@@ -195,7 +195,7 @@
   f_help_text_zone->m_select_back_topic();
 }
 
-void    THelpWindow::m_button_pressed_call(PObject button,char *argument)
+void    THelpWindow::m_button_pressed_call(PObject button, const char *argument)
 {
    PHelpWindow help_window=(PHelpWindow)(((PPushButton)button)->m_get_window());
    switch(argument[0])
diff -ruN jptui/thelpwnd.h jptui.const/thelpwnd.h
--- jptui/thelpwnd.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/thelpwnd.h	Tue Jun  5 17:51:12 2001
@@ -54,9 +54,9 @@
     // Constructor / Destructor
 
 
-		     THelpWindow(int x,int y,
-			     int width,int height,
-			     char *caption="",
+		     THelpWindow(int x ,int y,
+			     int width, int height,
+			     const char *caption= "",
 			     boolean modal=TRUE,
 			     boolean movable=TRUE);
 
@@ -64,9 +64,9 @@
 
     // Access methods
 
-	    boolean m_load_help_file(char *file_name);
+	    boolean m_load_help_file(const char *file_name);
 	    void    m_unload_help_file();
-	    boolean m_display_topic(char *topic,boolean push_current_topic=TRUE);
+	    boolean m_display_topic(const char *topic, boolean push_current_topic=TRUE);
 
 	    void    m_select_contents_topic();
 	    void    m_select_index_topic();
@@ -81,7 +81,7 @@
 
   protected:
 
-    static  void    m_button_pressed_call(PObject button,char *argument);
+    static  void    m_button_pressed_call(PObject button, const char *argument);
 
 
   /*-----------------*/
diff -ruN jptui/tintedzn.cpp jptui.const/tintedzn.cpp
--- jptui/tintedzn.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tintedzn.cpp	Tue Jun  5 17:51:12 2001
@@ -42,11 +42,11 @@
 TIntegerEditZone::TIntegerEditZone(PObject parent,
 		                   int rel_x,int rel_y,
 		                   int xoffset_caption,int yoffset_caption,
-                                   char *caption,
+                                   const char *caption,
                                    int display_length,
 		                   int max_length,
                                    long min_value,long max_value,
-		                   char *string,
+		                   const char *string,
 				   boolean enabled)
                  :TEditZone(parent,
 		            rel_x,rel_y,
@@ -118,7 +118,7 @@
 /* --------------   pour ce type de zone de saisie   */
 /*****************************************************/
 
-boolean TIntegerEditZone::m_string_valid(char *string)
+boolean TIntegerEditZone::m_string_valid(const char *string)
 {
   long value;
 
@@ -171,9 +171,9 @@
 /* Retourne un message indiquant pourquoi la chaine n'est pas valide        */
 /****************************************************************************/
 
-char *TIntegerEditZone::m_get_error_message()
+const char *TIntegerEditZone::m_get_error_message()
 {
-  char *msg=GetString(VOC_MUST_BE_INTEGER_BETWEEN);
+  const char *msg = GetString(VOC_MUST_BE_INTEGER_BETWEEN);
 
   if (f_error_message!=NULL)
     delete []f_error_message;
diff -ruN jptui/tintedzn.h jptui.const/tintedzn.h
--- jptui/tintedzn.h	Sun May 24 14:30:02 1998
+++ jptui.const/tintedzn.h	Tue Jun  5 17:51:12 2001
@@ -32,13 +32,13 @@
     // Constructeur / Destructeur
 
 		    TIntegerEditZone(PObject parent,
-				     int rel_x,int rel_y,
-				     int xoffset_caption,int yoffset_caption,
-				     char *caption,
+				     int rel_x, int rel_y,
+				     int xoffset_caption, int yoffset_caption,
+				     const char *caption,
 				     int display_length,
 				     int max_length,
 				     long min_value=-MAXLONG-1,long max_value=MAXLONG,
-				     char *string="0",
+				     const char *string="0",
 				     boolean enabled=TRUE);
 
 
@@ -52,7 +52,7 @@
 
     // Validit d'une chane pour la zone
 
-    virtual boolean m_string_valid(char *string);
+    virtual boolean m_string_valid(const char *string);
 
   /*------------------*/
   /* Mthodes prives */
@@ -64,7 +64,7 @@
 
   private:
     virtual boolean m_character_valid(int character);
-    virtual char    *m_get_error_message();
+    virtual const char *m_get_error_message();
 
 };
 
diff -ruN jptui/tlabel.cpp jptui.const/tlabel.cpp
--- jptui/tlabel.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tlabel.cpp	Tue Jun  5 17:51:12 2001
@@ -30,7 +30,7 @@
 
 TLabel::TLabel(PObject parent,
 	       int rel_x,int rel_y,
-	       char *text)
+	       const char *text)
        :TObject(parent,
 		OBJ_LABEL,
 		rel_x,rel_y,
@@ -60,7 +60,7 @@
 TLabel::TLabel(PObject parent,
 	       int rel_x,int rel_y,
 	       int width,int height,
-	       char *text)
+	       const char *text)
        :TObject(parent,
 		OBJ_LABEL,
 		rel_x,rel_y,
@@ -99,7 +99,7 @@
 /* Modifie le texte du label                                                */
 /****************************************************************************/
 
-void TLabel::m_set_text(char *text)
+void TLabel::m_set_text(const char *text)
 {
   int x=m_get_x_in_window();
   int y=m_get_y_in_window();
diff -ruN jptui/tlabel.h jptui.const/tlabel.h
--- jptui/tlabel.h	Sun May 24 14:38:54 1998
+++ jptui.const/tlabel.h	Tue Jun  5 17:51:12 2001
@@ -31,19 +31,19 @@
   public:
 		    TLabel(PObject parent,
 			   int rel_x,int rel_y,
-			   char *text);
+			   const char *text);
 
 		    TLabel(PObject parent,
 			   int rel_x,int rel_y,
 			   int width,int height,
-			   char *text="");
+			   const char *text="");
 
     virtual	    ~TLabel();
 
     // Mthodes d'accs
 
-            void    m_set_text(char *text);
-	    char    *m_get_text() {return(f_text);};
+            void    m_set_text(const char *text);
+	    char    *m_get_text() const {return(f_text);};
 
   /*--------------------*/
   /* Mthodes protges */
diff -ruN jptui/tlist.cpp jptui.const/tlist.cpp
--- jptui/tlist.cpp	Mon Nov  3 00:08:12 1997
+++ jptui.const/tlist.cpp	Tue Jun  5 17:51:12 2001
@@ -67,7 +67,7 @@
 	     int rel_x,int rel_y,
 	     int width,int height,
 	     unsigned background,
-	     char *caption,
+	     const char *caption,
 	     int list_rel_x,int list_rel_y,
 	     int  list_width,
 	     int  list_height,
@@ -254,7 +254,7 @@
 /* n'existe pas). Prend la 1re ocurrence de l'lment si plusieurs.        */
 /****************************************************************************/
 
-int TList::m_get_item_index(char *label)
+int TList::m_get_item_index(const char *label)
 {
   register PItemNode node=f_item_list;
   register int i=1;
@@ -402,7 +402,7 @@
 /* Dfinition du callback associ au changement de l'lment slectionn.   */
 /****************************************************************************/
 
-void TList::m_set_selected_item_changed_callback(void (*selected_item_changed_action)(PObject,char *),char *selected_item_changed_argument)
+void TList::m_set_selected_item_changed_callback(void (*selected_item_changed_action)(PObject, const char *), const char *selected_item_changed_argument)
 {
   SetCallback(f_selected_item_changed_action,f_selected_item_changed_argument,
 	      selected_item_changed_action,selected_item_changed_argument);
@@ -415,7 +415,7 @@
 /* liste.                                                                   */
 /****************************************************************************/
 
-void TList::m_set_visible_part_changed_callback(void (*visible_part_changed_action)(PObject,char *),char *visible_part_changed_argument)
+void TList::m_set_visible_part_changed_callback(void (*visible_part_changed_action)(PObject, const char *), const char *visible_part_changed_argument)
 {
   SetCallback(f_visible_part_changed_action,f_visible_part_changed_argument,
 	      visible_part_changed_action,visible_part_changed_argument);
@@ -428,7 +428,7 @@
 /* liste.                                                                   */
 /****************************************************************************/
 
-void TList::m_set_nb_items_changed_callback(void (*nb_items_changed_action)(PObject,char *),char *nb_items_changed_argument)
+void TList::m_set_nb_items_changed_callback(void (*nb_items_changed_action)(PObject, const char *), const char *nb_items_changed_argument)
 {
   SetCallback(f_nb_items_changed_action,f_nb_items_changed_argument,
 	      nb_items_changed_action,nb_items_changed_argument);
@@ -440,10 +440,10 @@
 /* Dfinition du callback associ au cochage/dcochage d'un lment.        */
 /****************************************************************************/
 
-void TList::m_set_item_check_changed_callback(void (*item_check_changed_action)(PObject,int,char *),char *item_check_changed_argument)
+void TList::m_set_item_check_changed_callback(void (*item_check_changed_action)(PObject, int, const char *), const char *item_check_changed_argument)
 {
-  SetCallback(f_item_check_changed_action,f_item_check_changed_argument,
-	      item_check_changed_action,item_check_changed_argument);
+  SetCallback(f_item_check_changed_action, f_item_check_changed_argument,
+	      item_check_changed_action, item_check_changed_argument);
 }
 
 /****************************************************************************/
@@ -452,10 +452,10 @@
 /* Dfinition du callback associ au double-cliquage d'un lment.          */
 /****************************************************************************/
 
-void TList::m_set_item_dbl_click_callback(void (*item_dbl_click_action)(PObject,int,char *),char *item_dbl_click_argument)
+void TList::m_set_item_dbl_click_callback(void (*item_dbl_click_action)(PObject, int, const char *), const char *item_dbl_click_argument)
 {
-  SetCallback(f_item_dbl_click_action,f_item_dbl_click_argument,
-	      item_dbl_click_action,item_dbl_click_argument);
+  SetCallback(f_item_dbl_click_action, f_item_dbl_click_argument,
+	      item_dbl_click_action, item_dbl_click_argument);
 }
 
 /****************************************************************************/
@@ -701,7 +701,7 @@
 /* Retourne son index ou 0 si l'ajout est impossible.                       */
 /****************************************************************************/
 
-int TList::m_add_item_to_list(int index,char *label,int attribute,PListItemProperties properties)
+int TList::m_add_item_to_list(int index, const char *label, int attribute,PListItemProperties properties)
 {
   char *search_label;
 
@@ -1113,7 +1113,7 @@
 
 void TList::m_item_dbl_clicked_callback(int index)
 {
-  CallCallback(this,f_item_dbl_click_action,f_item_dbl_click_argument,index);
+  CallCallback(this, f_item_dbl_click_action, index, f_item_dbl_click_argument);
 }
 
 /****************************************************************************/
@@ -1160,7 +1160,7 @@
 
 //  Static
 
-void TList::m_scrollbar_value_changed_call(PObject scrollbar,char */*argument*/)
+void TList::m_scrollbar_value_changed_call(PObject scrollbar, const char */*argument*/)
 {
   static boolean in_callback=FALSE;
   PList list;
@@ -1773,7 +1773,8 @@
       // Attribut LI_CHECKED modifi ?
 
       if ((old_attribute&LI_CHECKED)!=(new_attribute&LI_CHECKED))
-	CallCallback(this,f_item_check_changed_action,f_item_check_changed_argument,item_index);
+	CallCallback(this, f_item_check_changed_action, 
+                     item_index, f_item_check_changed_argument);
     }
 }
 
diff -ruN jptui/tlist.h jptui.const/tlist.h
--- jptui/tlist.h	Sun May 24 14:30:06 1998
+++ jptui.const/tlist.h	Tue Jun  5 17:51:12 2001
@@ -147,32 +147,32 @@
     // Callback : Fonction appele si l'lment slectionn change
     //            et son argument
 
-    void     (*f_selected_item_changed_action)(PObject,char *);
-    char     *f_selected_item_changed_argument;
+    void (*f_selected_item_changed_action)(PObject, const char *);
+    const char *f_selected_item_changed_argument;
 
     // Callback : Fonction appele si la partie visible de la liste
     //            change et son argument
 
-    void     (*f_visible_part_changed_action)(PObject,char *);
-    char     *f_visible_part_changed_argument;
+    void (*f_visible_part_changed_action)(PObject, const char *);
+    const char *f_visible_part_changed_argument;
 
     // Callback : Fonction appele si le nombre d'lments dans la liste
     //            change et son argument
 
-    void     (*f_nb_items_changed_action)(PObject,char *);
-    char     *f_nb_items_changed_argument;
+    void (*f_nb_items_changed_action)(PObject, const char *);
+    const char *f_nb_items_changed_argument;
 
     // Callback : Fonction appele si on coche un lment
     //            et son argument
 
-    void     (*f_item_check_changed_action)(PObject,int,char *);
-    char     *f_item_check_changed_argument;
+    void (*f_item_check_changed_action)(PObject, int, const char *);
+    const char *f_item_check_changed_argument;
 
     // Callback : Fonction appele si on a double-cliqu dans
     //            un lment de la liste et son argument
 
-    void     (*f_item_dbl_click_action)(PObject,int,char *);
-    char     *f_item_dbl_click_argument;
+    void (*f_item_dbl_click_action)(PObject, int, const char *);
+    const char *f_item_dbl_click_argument;
 
   /*--------------------*/
   /* Mthodes publiques */
@@ -187,7 +187,7 @@
 			  int rel_x,int rel_y,
 			  int width,int height,
 			  unsigned background,
-			  char *caption,
+			  const char *caption,
 			  int  list_rel_x,int list_rel_y,
 			  int  list_width,
 			  int  list_height,
@@ -208,7 +208,7 @@
 	    int     m_get_nb_items() { return (f_nb_items); };
 
 	    char    *m_get_item(int  index);       // "" si index inexistant
-	    int     m_get_item_index(char *label); // 0 si inexistant
+	    int     m_get_item_index(const char *label); // 0 si inexistant
 
 	    boolean m_set_selected_item_index(int  index);
 	    void    m_select_first_possible_item();
@@ -227,11 +227,11 @@
 	    int     m_get_x_list()      {return(m_get_x()+f_list_rel_x);};
 	    int     m_get_y_list()      {return(m_get_y()+f_list_rel_y);};
 
-	    void    m_set_selected_item_changed_callback(void (*selected_item_changed_action)(PObject,char *),char *selected_item_changed_argument);
-	    void    m_set_visible_part_changed_callback(void (*visible_part_changed_action)(PObject,char *),char *visible_part_changed_argument);
-	    void    m_set_nb_items_changed_callback(void (*nb_items_changed_action)(PObject,char *),char *nb_items_changed_argument);
-	    void    m_set_item_check_changed_callback(void (*item_check_changed_action)(PObject,int,char *),char *item_check_changed_argument);
-	    void    m_set_item_dbl_click_callback(void (*item_dbl_click_action)(PObject,int,char *),char *item_dbl_click_argument);
+	    void    m_set_selected_item_changed_callback(void (*selected_item_changed_action)(PObject, const char *), const char *selected_item_changed_argument);
+	    void    m_set_visible_part_changed_callback(void (*visible_part_changed_action)(PObject, const char *), const char *visible_part_changed_argument);
+	    void    m_set_nb_items_changed_callback(void (*nb_items_changed_action)(PObject, const char *), const char *nb_items_changed_argument);
+	    void    m_set_item_check_changed_callback(void (*item_check_changed_action)(PObject, int, const char *), const char *item_check_changed_argument);
+	    void    m_set_item_dbl_click_callback(void (*item_dbl_click_action)(PObject,int, const char *), const char *item_dbl_click_argument);
 
 	    // Suppression d'lments de la liste
 
@@ -262,7 +262,7 @@
     // Ajout d'lment  la liste
     // (retourne son index ou 0 s'il n'y a plus de place)
 
-    virtual int     m_add_item_to_list(int index,char *label,int attribute,PListItemProperties properties);
+    virtual int     m_add_item_to_list(int index, const char *label, int attribute,PListItemProperties properties);
 
     // Affichage
 
@@ -285,7 +285,7 @@
     virtual void    m_nb_items_changed_callback();
     virtual void    m_item_dbl_clicked_callback(int index);
 
-    static  void    m_scrollbar_value_changed_call(PObject scrollbar,char *argument);
+    static  void    m_scrollbar_value_changed_call(PObject scrollbar, const char *argument);
 
     virtual void    m_mouse_went_to_list_callback();
 
diff -ruN jptui/tlistbox.cpp jptui.const/tlistbox.cpp
--- jptui/tlistbox.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tlistbox.cpp	Tue Jun  5 17:51:12 2001
@@ -43,8 +43,8 @@
 TListBox::TListBox(PObject parent,
                    int rel_x,int rel_y,
                    int width,int height,
-	           char *caption,
-		   TListItem items[],
+	           const char *caption,
+		   const TListItem items[],
 		   boolean sorted,
 		   boolean enabled)
 	 :TSimpleList(parent,
diff -ruN jptui/tlistbox.h jptui.const/tlistbox.h
--- jptui/tlistbox.h	Sun May 24 14:31:26 1998
+++ jptui.const/tlistbox.h	Tue Jun  5 17:51:12 2001
@@ -26,10 +26,10 @@
     // Constructeur/Destructeur
 
 		    TListBox(PObject parent,
-			     int rel_x,int rel_y,
-			     int width,int height,
-			     char *caption="",
-			     TListItem items[]=NULL,
+			     int rel_x, int rel_y,
+			     int width, int height,
+			     const char *caption = "",
+			     const TListItem items[]=NULL,
 			     boolean sorted=FALSE,
 			     boolean enabled=TRUE);
     virtual         ~TListBox();
diff -ruN jptui/tmenu.cpp jptui.const/tmenu.cpp
--- jptui/tmenu.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tmenu.cpp	Tue Jun  5 17:51:12 2001
@@ -33,13 +33,13 @@
     int                 f_short_cut;
     char               *f_help_message;
 
-			TMenuItemProperties(int short_cut,char *help_message);
+			TMenuItemProperties(int short_cut, const char *help_message);
     virtual            ~TMenuItemProperties();
 };
 
 typedef TMenuItemProperties *PMenuItemProperties;
 
-TMenuItemProperties::TMenuItemProperties(int short_cut,char *help_message)
+TMenuItemProperties::TMenuItemProperties(int short_cut, const char *help_message)
 {
   f_short_cut=short_cut;
 
@@ -62,8 +62,8 @@
 /****************************************************************************/
 
 TMenu::TMenu(PMenuBar menu_bar,
-             char *caption,
-	     TMenuItem items[],
+             const char *caption,
+	     const TMenuItem items[],
 	     boolean enabled)
       :TList(NULL,
 	     OBJ_MENU,
@@ -191,7 +191,7 @@
 /* Dfinition du callback associ au clic d'un item du menu                 */
 /****************************************************************************/
 
-void TMenu::m_set_item_clicked_callback(void (*item_clicked_action)(PObject,int,char *),char *item_clicked_argument)
+void TMenu::m_set_item_clicked_callback(void (*item_clicked_action)(PObject, int, const char *), const char *item_clicked_argument)
 {
   SetCallback(f_item_clicked_action,f_item_clicked_argument,
 	      item_clicked_action,item_clicked_argument);
@@ -221,8 +221,9 @@
 /* Retourne son index ou 0 si l'ajout est impossible.                       */
 /****************************************************************************/
 
-int TMenu::m_insert_item(int index,char *label,
-			 int attribute,int short_cut,char *help_message)
+int TMenu::m_insert_item(int index, const char *label,
+			 int attribute, int short_cut,
+                         const char *help_message)
 {
   int item_nb;
   TMenuItemProperties *properties;
@@ -257,7 +258,7 @@
 /* Retourne le nombre d'lments effectivement ajout                       */
 /****************************************************************************/
 
-int TMenu::m_add_items(TMenuItem items[])
+int TMenu::m_add_items(const TMenuItem items[])
 {
   register int nb_items;
 
@@ -372,7 +373,8 @@
 
       // Callback utilisateur
 
-      CallCallback(this,f_item_clicked_action,f_item_clicked_argument,item_index);
+      CallCallback(this, f_item_clicked_action, item_index,
+                   f_item_clicked_argument);
     }
 }
 
diff -ruN jptui/tmenu.h jptui.const/tmenu.h
--- jptui/tmenu.h	Sun May 24 14:30:16 1998
+++ jptui.const/tmenu.h	Tue Jun  5 17:51:12 2001
@@ -18,10 +18,12 @@
 
 // Elment du menu
 
-typedef struct {char *label;
-		int   attribute;
-		int   short_cut;
-		char  *help_message;} TMenuItem;
+typedef struct {
+  const char *label;
+  int attribute;
+  int short_cut;
+  const char *help_message;
+} TMenuItem;
 
 
 /*ͻ*/
@@ -62,8 +64,8 @@
 
     // Callback invoked when an item of the menu is clicked
 
-    void     		(*f_item_clicked_action)(PObject,int,char *);
-    char     		*f_item_clicked_argument;
+    void (*f_item_clicked_action)(PObject, int, const char *);
+    const char *f_item_clicked_argument;
 
   /*----------------*/
   /* Public methods */
@@ -76,8 +78,8 @@
     // See TList.h for TMenuItem (m_add_items)
 
 			TMenu(PMenuBar menu_bar,
-			      char *caption,
-			      TMenuItem items[]=NULL,
+			      const char *caption,
+			      const TMenuItem items[]=NULL,
 			      boolean enabled=TRUE);
     virtual             ~TMenu();
 
@@ -105,8 +107,14 @@
     // Add a item to the menu
     // Returns its index or 0 if it couldn't have been added
 
-    virtual int         m_add_item(char *label,int attribute=LI_NOATTR,int short_cut=SC_NONE,char *help_message="") {return(m_insert_item(0,label,attribute,short_cut,help_message));};
-    virtual int         m_insert_item(int index,char *label,int attribute=LI_NOATTR,int short_cut=SC_NONE,char *help_message="");
+    virtual int         m_add_item(const char *label, int attribute=LI_NOATTR,
+                                   int short_cut = SC_NONE,
+                                   const char *help_message = "")
+    {return(m_insert_item(0,label,attribute,short_cut,help_message));};
+    virtual int         m_insert_item(int index, const char *label, 
+                                      int attribute = LI_NOATTR,
+                                      int short_cut = SC_NONE,
+                                      const char *help_message= "");
 
     // Add severals items to the menu
     // Each item is of type TListItem
@@ -114,7 +122,7 @@
 
     // Returns the number of items really added
 
-    virtual int         m_add_items(TMenuItem items[]);
+    virtual int         m_add_items(const TMenuItem items[]);
 
     // Deletes items
 
@@ -124,7 +132,7 @@
 
     // Defines the callbacks
 
-	    void        m_set_item_clicked_callback(void (*item_clicked_action)(PObject,int,char *),char *item_clicked_argument);
+	    void        m_set_item_clicked_callback(void (*item_clicked_action)(PObject, int, const char *), const char *item_clicked_argument);
 
   /*-------------------*/
   /* Protected methods */
diff -ruN jptui/tmenubar.cpp jptui.const/tmenubar.cpp
--- jptui/tmenubar.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tmenubar.cpp	Tue Jun  5 17:51:12 2001
@@ -644,8 +644,6 @@
 
 void TMenuBar::m_activate_menu_bar()
 {
-  char *msg;
-
   if (f_active)
     return;
 
@@ -659,7 +657,7 @@
   // Sauve le message d'info de la fenetre
   // et efface le message actuel
 
-  msg=f_window->m_get_info_message();
+  const char *msg = f_window->m_get_info_message();
   f_window_info_message=new char [strlen(msg)+1];
   strcpy(f_window_info_message,msg);
   f_window->m_set_info_message("");
diff -ruN jptui/tobject.cpp jptui.const/tobject.cpp
--- jptui/tobject.cpp	Sat Sep  6 21:56:02 1997
+++ jptui.const/tobject.cpp	Tue Jun  5 17:51:12 2001
@@ -50,7 +50,7 @@
 		 int rel_x,int rel_y,
 		 int width,int height,
 		 unsigned background,
-		 char *caption,
+		 const char *caption,
 		 boolean enabled,
 		 boolean focus_depending_aspect,
                  boolean can_be_enabled,
@@ -310,7 +310,7 @@
 /* Permet de modifier la lgende d'un objet (s'il en a dj une)            */
 /****************************************************************************/
 
-void TObject::m_set_caption(char *caption)
+void TObject::m_set_caption(const char *caption)
 {
   DEBUG_TEST(caption!=NULL);
 
@@ -505,8 +505,8 @@
 /* Dfinition du callback associ  la perte de focus de l'objet            */
 /****************************************************************************/
 
-void TObject::m_set_focus_lost_callback(void (*focus_lost_action)(PObject,char *),
-					char *focus_lost_argument)
+void TObject::m_set_focus_lost_callback(void (*focus_lost_action)(PObject, const char *),
+					const char *focus_lost_argument)
 {
   SetCallback(f_focus_lost_action,f_focus_lost_argument,
 	      focus_lost_action,focus_lost_argument);
@@ -518,8 +518,8 @@
 /* Dfinition du callback associ  la prise de focus de l'objet            */
 /****************************************************************************/
 
-void TObject::m_set_focus_taken_callback(void (*focus_taken_action)(PObject,char *),
-					 char *focus_taken_argument)
+void TObject::m_set_focus_taken_callback(void (*focus_taken_action)(PObject, const char *),
+					 const char *focus_taken_argument)
 {
   SetCallback(f_focus_taken_action,f_focus_taken_argument,
 	      focus_taken_action,focus_taken_argument);
@@ -531,8 +531,8 @@
 /* Defines the function called when this object is opened                   */
 /****************************************************************************/
 
-void TObject::m_set_opened_callback(void (*opened_action)(PObject,char *),
-					 char *opened_argument)
+void TObject::m_set_opened_callback(void (*opened_action)(PObject, const char *),
+			            const char *opened_argument)
 {
   SetCallback(f_opened_action,f_opened_argument,
 	      opened_action,opened_argument);
@@ -544,8 +544,8 @@
 /* Defines the function called when this object is closed                   */
 /****************************************************************************/
 
-void TObject::m_set_closed_callback(void (*closed_action)(PObject,char *),
-					 char *closed_argument)
+void TObject::m_set_closed_callback(void (*closed_action)(PObject, const char *),
+				    const char *closed_argument)
 {
   SetCallback(f_closed_action,f_closed_argument,
 	      closed_action,closed_argument);
diff -ruN jptui/tobject.h jptui.const/tobject.h
--- jptui/tobject.h	Sun May 24 14:29:10 1998
+++ jptui.const/tobject.h	Tue Jun  5 17:51:12 2001
@@ -124,24 +124,24 @@
     // Callback : Fonction appele lorsque l'objet perd le focus
     //            et son argument
 
-    void   (*f_focus_lost_action)(TObject*,char *);
-    char   *f_focus_lost_argument;
+    void   (*f_focus_lost_action)(TObject*, const char *);
+    const char *f_focus_lost_argument;
 
     // Callback : Fonction appele lorsque l'objet prend le focus
     //            et son argument
 
-    void   (*f_focus_taken_action)(TObject*,char *);
-    char   *f_focus_taken_argument;
+    void   (*f_focus_taken_action)(TObject*, const char *);
+    const char *f_focus_taken_argument;
 
     // Callback invoked when the object is opened
 
-    void   (*f_opened_action)(TObject*,char *);
-    char   *f_opened_argument;
+    void   (*f_opened_action)(TObject*, const char *);
+    const char *f_opened_argument;
 
     // Callback invoked when the object is closed
 
-    void   (*f_closed_action)(TObject*,char *);
-    char   *f_closed_argument;
+    void   (*f_closed_action)(TObject*, const char *);
+    const char *f_closed_argument;
 
 
   /*--------------------*/
@@ -157,7 +157,7 @@
 			    int rel_x,int rel_y,
 			    int width,int height,
 			    unsigned background,
-			    char *caption,
+			    const char *caption,
 			    boolean enabled,
 			    boolean focus_depending_aspect,
                             boolean can_be_enabled,
@@ -187,8 +187,12 @@
 
 	    unsigned  m_get_background()     { return(f_background);};
 
+ 	    // Fix: added to change colors of another objects
+	    void      m_set_background(unsigned a_backgorund) 
+              { f_background = a_backgorund;};
+
 	    char    *m_get_caption() { return (f_caption);};
-    virtual void    m_set_caption(char *caption);
+    virtual void    m_set_caption(const char *caption);
 
 	    char    m_get_hot_key(){ return (f_hot_key);};
 	    boolean m_is_open()    { return (f_open); };
@@ -213,14 +217,14 @@
 
     // Dfinition des callbacks
 
-	    void    m_set_focus_lost_callback(void (*focus_lost_action)(TObject *,char *),
-					       char *focus_lost_argument);
-	    void    m_set_focus_taken_callback(void (*focus_taken_action)(TObject *,char *),
-					       char *focus_taken_argument);
-	    void    m_set_opened_callback(void (*opened_action)(TObject *,char *),
-					  char *opened_argument);
-	    void    m_set_closed_callback(void (*closed_action)(TObject *,char *),
-					  char *closed_argument);
+	    void    m_set_focus_lost_callback(void (*focus_lost_action)(TObject *, const char *),
+					      const char *focus_lost_argument);
+	    void    m_set_focus_taken_callback(void (*focus_taken_action)(TObject *, const char *),
+					       const char *focus_taken_argument);
+	    void    m_set_opened_callback(void (*opened_action)(TObject *, const char *),
+					  const char *opened_argument);
+	    void    m_set_closed_callback(void (*closed_action)(TObject *, const char *),
+					  const char *closed_argument);
 
   /*--------------------*/
   /* Mthodes protges */
Binary files jptui/tools/jp_proto.exe and jptui.const/tools/jp_proto.exe differ
diff -ruN jptui/tools/jphc/jphc.cpp jptui.const/tools/jphc/jphc.cpp
--- jptui/tools/jphc/jphc.cpp	Tue Dec  2 23:55:50 1997
+++ jptui.const/tools/jphc/jphc.cpp	Tue Jun  5 17:51:12 2001
@@ -1806,7 +1806,7 @@
 
 static void WriteText(char *text)
   {
-    char           *np  = text ? text : "";
+    char           *np  = text ? text : (char*)"";
     short    len = strlen(np);
 
     fwrite(&len,sizeof(len),1,File);
Binary files jptui/tools/jphc.exe and jptui.const/tools/jphc.exe differ
diff -ruN jptui/tools/jphelp/jphelp.cpp jptui.const/tools/jphelp/jphelp.cpp
--- jptui/tools/jphelp/jphelp.cpp	Fri May 23 08:15:48 1997
+++ jptui.const/tools/jphelp/jphelp.cpp	Tue Jun  5 18:19:46 2001
@@ -5,7 +5,7 @@
 /*--------------------------------------------------------------------------*/
 /* Author     : DELPRAT Jean-Pierre (jpdelprat@teaser.fr)                   */
 /* Crated on  : 05-MAY-97                                                   */
-/* Modified on: 05-MAY-97                                                   */
+/* Modified on: 5-JUNE-2001 (michael@idisys.iae.nsk.su)                     */
 /****************************************************************************/
 
 
@@ -39,7 +39,7 @@
 				  NOT_MOVABLE);
 
 
-void QuitCall(PObject /*sender*/,char */*arg*/)
+void QuitCall(PObject /*sender*/, const char */*arg*/)
 {
   JPStop();
 }
@@ -49,7 +49,7 @@
 /*ͼ*/
 
 
-int main(int argc,char *argv[])
+int main(int argc, char *argv[])
 {
   boolean help_wanted=FALSE;
   char          no_ext_help_file [MAX_PATH];
Binary files jptui/tools/jphelp.exe and jptui.const/tools/jphelp.exe differ
diff -ruN jptui/tools/makefile jptui.const/tools/makefile
--- jptui/tools/makefile	Sat Nov 28 11:39:42 1998
+++ jptui.const/tools/makefile	Tue Jun  5 18:32:36 2001
@@ -2,20 +2,31 @@
 
 FLAGS = -MMD -Wall -m486 -O3
 
-all : jphc.exe jphelp.exe scankey.exe jp_proto.exe clean
+LIBS = -lstdcxx
+
+all : jp_proto.exe jphc.exe jphelp.exe scankey.exe clean
+
+# jp_proto
+
+jp_proto.exe : jp_proto.o
+	gcc -s -o jp_proto.exe jp_proto.o $(LIBS)
+
+jp_proto.o : jp_proto/jp_proto.cpp
+	gcc $(FLAGS) -c jp_proto/jp_proto.cpp -o jp_proto.o
+
 
 #jphc
 
 jphc.exe : jphc.o
-	gxx -s -o jphc.exe jphc.o
+	gcc -s -o jphc.exe jphc.o $(LIBS)
 
 jphc.o : jphc/jphc.cpp
-	gcc $(FLAGS) -c jphc/jphc.cpp -o jphc.o
+	gcc $(FLAGS) -c jphc/jphc.cpp -o jphc.o 
 
 #jphelp
 
 jphelp.exe : jphelp.o ../jptui.dat ../libjptui.a
-	gxx -s -o jphelp.exe jphelp.o ../libjptui.a
+	gcc -s -o jphelp.exe jphelp.o ../libjptui.a $(LIBS)
 	connect.exe jphelp.exe ../jptui.dat
 
 jphelp.o : jphelp/jphelp.cpp
@@ -24,7 +35,7 @@
 # scankey
 
 scankey.exe : scankey.o keyboard.o
-	gxx -s -o scankey.exe scankey.o keyboard.o
+	gcc -s -o scankey.exe scankey.o keyboard.o
 
 scankey.o : scankey/scankey.cpp
 	gcc $(FLAGS) -c scankey/scankey.cpp -o scankey.o
@@ -32,14 +43,6 @@
 keyboard.o : ../keyboard.cpp
 	gcc $(FLAGS) -c ../keyboard.cpp -o keyboard.o
 
-# jp_proto
-
-jp_proto.exe : jp_proto.o
-	gxx -s -o jp_proto.exe jp_proto.o
-
-jp_proto.o : jp_proto/jp_proto.cpp
-	gcc $(FLAGS) -c jp_proto/jp_proto.cpp -o jp_proto.o
-
 
 clean :
 	del *.o
Binary files jptui/tools/scankey.exe and jptui.const/tools/scankey.exe differ
diff -ruN jptui/tpassedz.cpp jptui.const/tpassedz.cpp
--- jptui/tpassedz.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tpassedz.cpp	Thu Jan  1 00:00:00 1970
@@ -1,131 +0,0 @@
-/****************************************************************************/
-/* TPASSEDZ                                                                 */
-/*--------------------------------------------------------------------------*/
-/* Class TPasswordEditZone (password editing zone)                          */
-/* TEDZONE                                                                  */
-/*--------------------------------------------------------------------------*/
-/* Author     : DELPRAT Jean-Pierre                                         */
-/* Created    : 11/02/95                                                    */
-/****************************************************************************/
-
-#include "Const.h"
-
-#include "TWindow.h"
-
-#include "TPassEdz.h"
-
-/*ͻ*/
-/*                 INITIALISATION DES VARIABLES STATIQUES                 */
-/*ͼ*/
-
-/*ͻ*/
-/*                           METHODES PUBLIQUES                           */
-/*ͼ*/
-
-/****************/
-/* Constructeur */
-/* ------------ */
-/****************************************************************************/
-/* parent           : Objet auquel appartient l'objet                       */
-/* rel_x,rel_y      : Coordonnes de la zone d'dition p/r au groupe        */
-/* xoffset_caption,                                                         */
-/* yoffset_caption  : Coordonnes du titre p/r au contenu de la zone d'dit.*/
-/* caption          : Titre de la zone d'dition (hot-key prcd de ~)     */
-/* display_length   : Longueur visible du contenu de la zone d'dition      */
-/* max_length       : Longueur maximale du contenu de la zone d'dition     */
-/* string           : Contenu initial de la zone d'dition                  */
-/* enabled          : ENABLED si la zone est activable (DISABLED sinon)     */
-/****************************************************************************/
-
-TPasswordEditZone::TPasswordEditZone(PObject parent,
-				     int rel_x,int rel_y,
-				     int xoffset_caption,int yoffset_caption,
-				     char *caption,
-				     int display_length,
-				     int max_length,
-				     char *string,
-				     boolean enabled)
-		  :TEditZone(parent,
-			     rel_x,rel_y,
-			     xoffset_caption,yoffset_caption,
-			     caption,
-			     display_length,
-			     max_length,
-			     string,
-			     enabled)
-{
-}
-
-/***************/
-/* Destructeur */
-/* ----------- */
-/***************/
-
-TPasswordEditZone::~TPasswordEditZone()
-{
-}
-
-/****************************************************************************/
-/* m_display_string_chars                                                   */
-/*--------------------------------------------------------------------------*/
-/* Appele par m_display_string                                              */
-/****************************************************************************/
-
-void TPasswordEditZone::m_display_string_chars(unsigned background,int last_visible_char)
-{
-  int  ptr1,ptr2;
-  int  last_true_visible_char;
-
-  // EditZone avec focus et zone slectionne
-
-  ptr1=f_first_visible_char;
-  last_true_visible_char=MIN(f_useful_length-1,last_visible_char);
-
-  if ((f_focused) && (f_window->m_is_active()) && (f_zone_selected))
-    {
-      ptr2=MIN(f_min_selected_char-1,last_true_visible_char)+1;
-
-      if (ptr1<ptr2)
-	{
-	  f_window->m_putnch(ptr2-ptr1,'*');
-	  ptr1=ptr2;
-	}
-
-      f_window->m_set_inverse_attr(f_background);
-
-      ptr2=MIN(f_max_selected_char,last_true_visible_char)+1;
-
-      if (ptr1<ptr2)
-	{
-	  f_window->m_putnch(ptr2-ptr1,'*');
-	  ptr1=ptr2;
-	}
-
-      f_window->m_textattr(background);
-
-      ptr2=last_true_visible_char+1;
-      if (ptr1<ptr2)
-	{
-	  f_window->m_putnch(ptr2-ptr1,'*');
-	  ptr1=ptr2;
-	}
-    }
-
-  // Sinon
-
-  else
-    {
-      ptr2=last_true_visible_char+1;
-      if (ptr1<ptr2)
-	{
-	  f_window->m_putnch(ptr2-ptr1,'*');
-	  ptr1=ptr2;
-	}
-    }
-
-  // Affichage de la partie de la chaine avec des '.'
-
-  ptr2=last_visible_char+1;
-  if (ptr1<ptr2)
-    f_window->m_putnch(ptr2-ptr1,'');
-}
\ No newline at end of file
diff -ruN jptui/tpassedz.h jptui.const/tpassedz.h
--- jptui/tpassedz.h	Sun May 24 14:31:04 1998
+++ jptui.const/tpassedz.h	Thu Jan  1 00:00:00 1970
@@ -1,54 +0,0 @@
-/****************************************************************************/
-/* TPASSEDZ                                                                 */
-/*--------------------------------------------------------------------------*/
-/* Class TPasswordEditZone (password editing zone)                          */
-/****************************************************************************/
-
-#ifndef _TPASSEDZ_H_
-#define _TPASSEDZ_H_
-
-#include "TEdZone.h"
-
-/*ͻ*/
-/*                             CLASS DEFINITION                           */
-/*ͼ*/
-
-
-class TPasswordEditZone:public TEditZone
-{
-  /*----------------*/
-  /* Private fields */
-  /*----------------*/
-
-  private:
-
-  /*----------------*/
-  /* Public methods */
-  /*----------------*/
-
-  public:
-
-    // Constructor / Destructor
-
-		    TPasswordEditZone(PObject parent,
-			      int rel_x,int rel_y,
-			      int  xoffset_caption,int yoffset_caption,
-			      char *caption,
-			      int display_length,
-			      int max_length,
-			      char *string="",
-			      boolean enabled=TRUE);
-    virtual         ~TPasswordEditZone();
-
-  /*----------------*/
-  /* Prvate methods */
-  /*----------------*/
-
-  private:
-
-    // Display
-
-    virtual void    m_display_string_chars(unsigned background,int last_visible_char);
-};
-
-#endif
\ No newline at end of file
diff -ruN jptui/tpushbut.cpp jptui.const/tpushbut.cpp
--- jptui/tpushbut.cpp	Mon Aug 18 22:21:44 1997
+++ jptui.const/tpushbut.cpp	Tue Jun  5 17:51:12 2001
@@ -43,8 +43,8 @@
 TPushButton::TPushButton(PObject parent,
 			 int rel_x,int rel_y,
                          int width,
-			 char *caption,
-			 int  type,
+			 const char *caption,
+			 int type,
 			 TShadowChoice shadows,
 			 boolean enabled)
 	    :TObject(parent,
@@ -144,8 +144,8 @@
 /* ----------------------   l'enfoncement du bouton          */
 /*************************************************************/
 
-void TPushButton::m_set_pressed_callback(void (*pressed_action)(PObject,char *),
-		                         char *pressed_argument)
+void TPushButton::m_set_pressed_callback(void (*pressed_action)(PObject, const char *),
+		                         const char *pressed_argument)
 {
   SetCallback(f_pressed_action,f_pressed_argument,
               pressed_action,pressed_argument);
diff -ruN jptui/tpushbut.h jptui.const/tpushbut.h
--- jptui/tpushbut.h	Sun May 24 14:41:18 1998
+++ jptui.const/tpushbut.h	Tue Jun  5 17:51:12 2001
@@ -67,8 +67,8 @@
     // Callback : Fonction appele si on presse et relche le bouton
     //            et son argument
 
-    void    (*f_pressed_action)(PObject,char *);
-    char    *f_pressed_argument;
+    void (*f_pressed_action)(PObject, const char *);
+    const char *f_pressed_argument;
 
 
   /*--------------------*/
@@ -82,7 +82,7 @@
 		    TPushButton(PObject parent,
 				int rel_x,int rel_y,
 				int width,
-				char *caption,
+				const char *caption,
 				int  type=PB_NORMAL,
 				TShadowChoice shadows=SHC_BOTH,
 				boolean enabled=TRUE);
@@ -96,8 +96,8 @@
 
     // Dfinition des callbacks
 
-	    void    m_set_pressed_callback(void (*pressed_action)(PObject,char *),
-					   char *pressed_argument);
+	    void    m_set_pressed_callback(void (*pressed_action)(PObject, const char *),
+					   const char *pressed_argument);
 
   /*--------------------*/
   /* Mthodes protges */
@@ -130,6 +130,7 @@
 	    void    m_take_cancel() { f_cancel_button=TRUE; };
 	    void    m_lose_cancel() { f_cancel_button=FALSE; };
 
+  protected: // Fix: to be able to redefine
     // Evnements
 
     virtual boolean m_left_button_pressed_event(int x,int y);
diff -ruN jptui/trdiobut.cpp jptui.const/trdiobut.cpp
--- jptui/trdiobut.cpp	Tue Jun 23 08:26:18 1998
+++ jptui.const/trdiobut.cpp	Tue Jun  5 17:51:12 2001
@@ -39,7 +39,7 @@
 
 TRadioButton::TRadioButton(PRadioGroup radio_group,
 			   int rel_x,int rel_y,
-			   int width,char *caption,
+			   int width, const char *caption,
                            boolean checked,
                            boolean enabled)
 	     :TCheckBox(radio_group,
diff -ruN jptui/trdiobut.h jptui.const/trdiobut.h
--- jptui/trdiobut.h	Tue Jun 23 08:26:08 1998
+++ jptui.const/trdiobut.h	Tue Jun  5 17:51:12 2001
@@ -26,7 +26,7 @@
 
 		    TRadioButton(PRadioGroup radio_group,
 				 int rel_x,int rel_y,
-				 int width,char *caption,
+				 int width, const char *caption,
 				 boolean checked=FALSE,
                                  boolean enabled=TRUE);
     virtual         ~TRadioButton();
diff -ruN jptui/tscrbar.cpp jptui.const/tscrbar.cpp
--- jptui/tscrbar.cpp	Sun May 24 14:41:56 1998
+++ jptui.const/tscrbar.cpp	Tue Jun  5 17:51:12 2001
@@ -144,8 +144,8 @@
 /* ----------------------------   modification de la valeur de la ScrollBar*/
 /***************************************************************************/
 
-void TScrollBar::m_set_value_changed_callback(void (*value_changed_action)(PObject,char *),
-					      char *value_changed_argument)
+void TScrollBar::m_set_value_changed_callback(void (*value_changed_action)(PObject, const char *),
+					      const char *value_changed_argument)
 {
   SetCallback(f_value_changed_action,f_value_changed_argument,
               value_changed_action,value_changed_argument);
diff -ruN jptui/tscrbar.h jptui.const/tscrbar.h
--- jptui/tscrbar.h	Sun May 24 14:41:38 1998
+++ jptui.const/tscrbar.h	Tue Jun  5 17:51:12 2001
@@ -57,8 +57,8 @@
     // Callback : Fonction appele quand la valeur de l'ascenseur change
     //            et son argument
 
-    void (*f_value_changed_action)(PObject,char *);
-    char *f_value_changed_argument;
+    void (*f_value_changed_action)(PObject, const char *);
+    const char *f_value_changed_argument;
 
   /*---------------*/
   /* Champs privs */
@@ -100,8 +100,8 @@
 
     // Dfinition des callbacks
 
-	    void    m_set_value_changed_callback(void (*value_changed_action)(PObject,char *),
-						 char *value_changed_argument);
+	    void    m_set_value_changed_callback(void (*value_changed_action)(PObject, const char *),
+						 const char *value_changed_argument);
 
   /*--------------------*/
   /* Mthodes protges */
diff -ruN jptui/tsmplist.cpp jptui.const/tsmplist.cpp
--- jptui/tsmplist.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/tsmplist.cpp	Tue Jun  5 17:51:12 2001
@@ -32,10 +32,10 @@
 
 TSimpleList::TSimpleList(PObject parent,
 			 int type,
-			 int rel_x,int rel_y,
-			 int width,int height,
+			 int rel_x, int rel_y,
+			 int width, int height,
 			 unsigned background,
-			 char *caption,
+			 const char *caption,
 			 int  list_rel_x,int list_rel_y,
 			 int  list_width,
 			 int  list_height,
@@ -86,7 +86,7 @@
 /* Retourne le nombre d'lments effectivement ajout                       */
 /****************************************************************************/
 
-int TSimpleList::m_add_items(TListItem items[])
+int TSimpleList::m_add_items(const TListItem items[])
 {
   register int nb_items;
 
diff -ruN jptui/tsmplist.h jptui.const/tsmplist.h
--- jptui/tsmplist.h	Sun May 24 14:28:44 1998
+++ jptui.const/tsmplist.h	Tue Jun  5 17:51:12 2001
@@ -18,8 +18,10 @@
 
 // Elment de la liste
 
-typedef struct {char *label;
-		int   attribute;} TListItem;
+typedef struct {
+  const char *label;
+  int attribute;
+} TListItem;
 
 /*ͻ*/
 /*                         DEFINITION DE L'OBJET                          */
@@ -46,10 +48,10 @@
 
 		    TSimpleList(PObject parent,
 				int type,
-				int rel_x,int rel_y,
-				int width,int height,
+				int rel_x, int rel_y,
+				int width, int height,
 				unsigned background,
-				char *caption,
+				const char *caption,
 				int  list_rel_x,int list_rel_y,
 				int  list_width,
 				int  list_height,
@@ -69,8 +71,8 @@
     // Ajout d'un lment  la liste
     // (retourne son index ou 0 s'il n'y a plus de place)
 
-    virtual int     m_add_item(char *label,int attribute=LI_NOATTR)             {return(TList::m_add_item_to_list(0,label,attribute,NULL));};
-    virtual int     m_insert_item(int index,char *label,int attribute=LI_NOATTR){return(TList::m_add_item_to_list(index,label,attribute,NULL));};
+    virtual int     m_add_item(const char *label, int attribute=LI_NOATTR)             {return(TList::m_add_item_to_list(0,label,attribute,NULL));};
+    virtual int     m_insert_item(int index, const char *label, int attribute=LI_NOATTR){return(TList::m_add_item_to_list(index,label,attribute,NULL));};
 
     // Ajout de plusieurs lments
     // Chaque lment est de type TListItem
@@ -78,7 +80,7 @@
 
     // Retourne le nombre d'lments effectivement ajout
 
-    virtual int     m_add_items(TListItem items[]);
+    virtual int     m_add_items(const TListItem items[]);
 
 
 };
diff -ruN jptui/ttab.cpp jptui.const/ttab.cpp
--- jptui/ttab.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/ttab.cpp	Tue Jun  5 17:51:12 2001
@@ -32,7 +32,7 @@
 /****************************************************************************/
 
 TTab::TTab(PTabGroup tab_group,
-	   char *caption)
+	   const char *caption)
 
      :TGroup(tab_group,
 	     OBJ_TAB,
@@ -82,8 +82,8 @@
 /* Dfinition du callback appel quand l'onglet devient visible             */
 /****************************************************************************/
 
-void TTab::m_set_visible_callback(void (*visible_action)(TObject *,char *),
-				  char *visible_argument)
+void TTab::m_set_visible_callback(void (*visible_action)(TObject *, const char *),
+				  const char *visible_argument)
 {
   SetCallback(f_visible_action,f_visible_argument,
 	      visible_action,visible_argument);
diff -ruN jptui/ttab.h jptui.const/ttab.h
--- jptui/ttab.h	Sun May 24 14:31:42 1998
+++ jptui.const/ttab.h	Tue Jun  5 17:51:12 2001
@@ -28,8 +28,8 @@
     // Callback : Fonction appele lorsque l'onglet devient visible
     //            et son argument
 
-    void   (*f_visible_action)(TObject*,char *);
-    char   *f_visible_argument;
+    void (*f_visible_action)(TObject*, const char *);
+    const char *f_visible_argument;
 
 
   /*--------------------*/
@@ -41,7 +41,7 @@
     // Constructeur / Destructeur
 
 		    TTab(PTabGroup tab_group,
-			 char *caption);
+			 const char *caption);
     virtual  	    ~TTab();
 
     // Mthodes d'accs
@@ -52,8 +52,8 @@
 
     // Dfinition des callbacks
 
-	    void    m_set_visible_callback(void (*visible_action)(TObject *,char *),
-					   char *visible_argument);
+	    void    m_set_visible_callback(void (*visible_action)(TObject *, const char *),
+					   const char *visible_argument);
 
   /*--------------------*/
   /* Mthodes protges */
diff -ruN jptui/ttextzn.cpp jptui.const/ttextzn.cpp
--- jptui/ttextzn.cpp	Sun May 24 16:43:24 1998
+++ jptui.const/ttextzn.cpp	Tue Jun  5 17:51:12 2001
@@ -85,7 +85,7 @@
 TTextZone::TTextZone(PObject parent,
 		     int rel_x,int rel_y,
                      int width,int height,
-                     char *caption,
+                     const char *caption,
 		     int nb_cols,
 		     TScrollbarChoice scrollbars,
 		     boolean enabled)
@@ -733,7 +733,7 @@
 /* Insre du texte  la position du curseur (lignes spares par des \n)    */
 /****************************************************************************/
 
-void TTextZone::m_insert_text(char *text)
+void TTextZone::m_insert_text(const char *text)
 {
   char        *string;
   char        *new_string;
@@ -750,7 +750,7 @@
 
   boolean     was_open;
 
-  char        *end_of_line;
+  char *end_of_line;
   char        end_character=0;
   int         y;
 
@@ -803,7 +803,7 @@
       was_open=f_open;
       f_open=FALSE;   // Pour ne pas afficher plusieurs fois la mme chose
       y=f_cursor_line;
-      end_of_line=text;
+      end_of_line=(char*)text;
 
       // Parcours des diffrentes lignes  ajouter
 
@@ -854,8 +854,9 @@
 	      delete []new_string;
 
 	    }
-	  else
-	    m_insert_line(y,(end_of_line==NULL)?"":text,NULL);
+	  else {
+	    m_insert_line(y, end_of_line==NULL ? "" : text, NULL);
+          }
 
 	  // On passe  la ligne suivante */
 
@@ -1071,9 +1072,8 @@
 /* Retourne FALSE en cas d'chec.                                           */
 /****************************************************************************/
 
-boolean TTextZone::m_save_text(char *filename)
+boolean TTextZone::m_save_text(const char *filename)
 {
-  int handle;
   FILE *file;
 
   register int i;
@@ -1082,13 +1082,14 @@
 
   boolean error;
 
-  handle = sopen(filename, O_WRONLY|O_CREAT|O_TEXT,SH_DENYWR,S_IWRITE);
-  if (handle<0)
-    return(FALSE);
-  file=fdopen(handle,"wt");
+//int handle = sopen(filename, O_WRONLY|O_CREAT|O_TEXT,SH_DENYWR,S_IWRITE);
+//  if (handle<0)
+//    return(FALSE);
+//  file=fdopen(handle,"wt");
+  file=fopen(filename,"wt"); // Fix: overwrite as text data
   if (file==NULL)
     {
-      close(handle);
+//      close(handle);
       return(FALSE);
     }
 
@@ -1103,7 +1104,8 @@
       if (fputs(line,file)==EOF)
 	error=TRUE;
       else
-	if (fputs("\n",file)==EOF)
+	// if (fputs("\n",file)==EOF)
+	if (i != f_nb_lines && fputs("\n",file)==EOF) // Fix: last line added '\n'
 	  error=TRUE;
 
       if (error)
@@ -1125,7 +1127,7 @@
 /* Retourne FALSE en cas d'chec.                                           */
 /****************************************************************************/
 
-boolean TTextZone::m_load_text(char *filename)
+boolean TTextZone::m_load_text(const char *filename)
 {
   int handle;
   FILE *file;
@@ -1500,8 +1502,8 @@
 /* texte                                                                    */
 /****************************************************************************/
 
-void TTextZone::m_set_nb_lines_changed_callback(void (*nb_lines_changed_action)(PObject,char *),
-                                               char *nb_lines_changed_argument)
+void TTextZone::m_set_nb_lines_changed_callback(void (*nb_lines_changed_action)(PObject, const char *),
+                                                const char *nb_lines_changed_argument)
 {
   SetCallback(f_nb_lines_changed_action,f_nb_lines_changed_argument,
 	      nb_lines_changed_action,nb_lines_changed_argument);
@@ -1514,8 +1516,8 @@
 /* de texte                                                                 */
 /****************************************************************************/
 
-void TTextZone::m_set_text_changed_callback(void (*text_changed_action)(PObject,char *),
-					      char *text_changed_argument)
+void TTextZone::m_set_text_changed_callback(void (*text_changed_action)(PObject, const char *),
+					    const char *text_changed_argument)
 
 {
   SetCallback(f_text_changed_action,f_text_changed_argument,
@@ -1528,24 +1530,24 @@
 /* Dfinition du callback associ au dplacement du curseur                 */
 /****************************************************************************/
 
-void TTextZone::m_set_cursor_line_changed_callback(void (*cursor_line_changed_action)(PObject,char *),
-					      char *cursor_line_changed_argument)
+void TTextZone::m_set_cursor_line_changed_callback(void (*cursor_line_changed_action)(PObject, const char *),
+					           const char *cursor_line_changed_argument)
 
 {
   SetCallback(f_cursor_line_changed_action,f_cursor_line_changed_argument,
 	      cursor_line_changed_action,cursor_line_changed_argument);
 }
 
-void TTextZone::m_set_cursor_col_changed_callback(void (*cursor_col_changed_action)(PObject,char *),
-					      char *cursor_col_changed_argument)
+void TTextZone::m_set_cursor_col_changed_callback(void (*cursor_col_changed_action)(PObject, const char *),
+					          const char *cursor_col_changed_argument)
 
 {
   SetCallback(f_cursor_col_changed_action,f_cursor_col_changed_argument,
 	      cursor_col_changed_action,cursor_col_changed_argument);
 }
 
-void TTextZone::m_set_cursor_pos_changed_callback(void (*cursor_pos_changed_action)(PObject,char *),
-					      char *cursor_pos_changed_argument)
+void TTextZone::m_set_cursor_pos_changed_callback(void (*cursor_pos_changed_action)(PObject, const char *),
+					          const char *cursor_pos_changed_argument)
 
 {
   SetCallback(f_cursor_pos_changed_action,f_cursor_pos_changed_argument,
@@ -1559,13 +1561,13 @@
 /* texte (en hauteur).                                                      */
 /****************************************************************************/
 
-void TTextZone::m_set_visible_lines_changed_callback(void (*visible_lines_changed_action)(PObject,char *),char *visible_lines_changed_argument)
+void TTextZone::m_set_visible_lines_changed_callback(void (*visible_lines_changed_action)(PObject, const char *), const char *visible_lines_changed_argument)
 {
   SetCallback(f_visible_lines_changed_action,f_visible_lines_changed_argument,
 	      visible_lines_changed_action,visible_lines_changed_argument);
 }
 
-void TTextZone::m_set_visible_cols_changed_callback(void (*visible_cols_changed_action)(PObject,char *),char *visible_cols_changed_argument)
+void TTextZone::m_set_visible_cols_changed_callback(void (*visible_cols_changed_action)(PObject,const char *), const char *visible_cols_changed_argument)
 {
   SetCallback(f_visible_cols_changed_action,f_visible_cols_changed_argument,
 	      visible_cols_changed_action,visible_cols_changed_argument);
@@ -1579,7 +1581,7 @@
 /* slectionne).                                                           */
 /****************************************************************************/
 
-void TTextZone::m_set_selection_status_changed_callback(void (*selection_status_changed_action)(PObject,char *),char *selection_status_changed_argument)
+void TTextZone::m_set_selection_status_changed_callback(void (*selection_status_changed_action)(PObject, const char *), const char *selection_status_changed_argument)
 {
   SetCallback(f_selection_status_changed_action,f_selection_status_changed_argument,
               selection_status_changed_action,selection_status_changed_argument);
@@ -1595,7 +1597,7 @@
 /* Modifie une des lignes du texte                                          */
 /****************************************************************************/
 
-void TTextZone::m_set_line(int line_nb,char *string,PLineProperties properties)
+void TTextZone::m_set_line(int line_nb, const char *string, PLineProperties properties)
 {
   PStringNode node;
   int length,size;
@@ -1603,7 +1605,7 @@
   int added_size;
   int col;
 
-  char *ptr,*ptr1,*ptr2;
+  char *ptr;
 
   if (!f_modification_enabled)
     return;
@@ -1652,8 +1654,8 @@
 
   // Remplissage de la chaine
 
-  ptr1=string;
-  ptr2=node->string;
+  const char* ptr1 = string;
+  char* ptr2 = node->string;
   ptr=strchr(ptr1,'\t');
   added_size=0;
   while ((length>0) && (ptr!=NULL))
@@ -1700,7 +1702,7 @@
 /* Insertion d'une ligne dans le texte                                      */
 /****************************************************************************/
 
-void TTextZone::m_insert_line(int line_nb,char *string,PLineProperties properties)
+void TTextZone::m_insert_line(int line_nb, const char *string, PLineProperties properties)
 {
   PStringNode node_before;
   PStringNode node;
@@ -2075,10 +2077,10 @@
 /* attribute             : Couleur d'affichage                              */
 /****************************************************************************/
 
-void TTextZone::m_display_string_part(char *string,int string_length,int min_col,int max_col,unsigned attribute)
+void TTextZone::m_display_string_part(const char *string, int string_length,
+  				      int min_col, int max_col,
+                                      unsigned attribute)
 {
-  char old_char;
-  char *ptr;
   int zone_length;
   int last_visible_col=f_first_visible_col+f_text_width-1;
 
@@ -2111,13 +2113,14 @@
     }
   else
     {
-      ptr=string+zone_length;
-      old_char=(*ptr);
+      char* ptr=(char*)string+zone_length;
+      char old_char=(*ptr);
       (*ptr)=0;
 
       f_window->m_puts(string);
       (*ptr)=old_char;
     }
+
 }
 
 /****************************************************************************/
@@ -2180,7 +2183,7 @@
 
 //  Static
 
-void TTextZone::m_vert_scrollbar_value_changed_call(PObject scrollbar,char */*argument*/)
+void TTextZone::m_vert_scrollbar_value_changed_call(PObject scrollbar, const char */*argument*/)
 {
   static boolean in_callback=FALSE;
 
@@ -2199,7 +2202,7 @@
     }
 }
 
-void TTextZone::m_horiz_scrollbar_value_changed_call(PObject scrollbar,char */*argument*/)
+void TTextZone::m_horiz_scrollbar_value_changed_call(PObject scrollbar, const char */*argument*/)
 {
   static boolean in_callback=FALSE;
 
diff -ruN jptui/ttextzn.h jptui.const/ttextzn.h
--- jptui/ttextzn.h	Sun May 24 16:43:08 1998
+++ jptui.const/ttextzn.h	Tue Jun  5 17:51:12 2001
@@ -155,40 +155,40 @@
     // Callback : Fonction appele si le nombre de lignes dans le texte
     //            change et son argument
 
-    void    (*f_nb_lines_changed_action)(PObject,char *);
-    char    *f_nb_lines_changed_argument;
+    void (*f_nb_lines_changed_action)(PObject, const char *);
+    const char *f_nb_lines_changed_argument;
 
     // Callback : Fonction appele  chaque modification de la chane
     //            et son argument
 
-    void    (*f_text_changed_action)(PObject,char *);
-    char    *f_text_changed_argument;
+    void (*f_text_changed_action)(PObject, const char *);
+    const char *f_text_changed_argument;
 
     // Callback : Fonction appele si la position du curseur change
     //            et son argument
 
-    void     (*f_cursor_line_changed_action)(PObject,char *);
-    char     *f_cursor_line_changed_argument;
+    void (*f_cursor_line_changed_action)(PObject, const char *);
+    const char *f_cursor_line_changed_argument;
 
-    void     (*f_cursor_col_changed_action)(PObject,char *);
-    char     *f_cursor_col_changed_argument;
+    void (*f_cursor_col_changed_action)(PObject, const char *);
+    const char *f_cursor_col_changed_argument;
 
-    void     (*f_cursor_pos_changed_action)(PObject,char *);
-    char     *f_cursor_pos_changed_argument;
+    void (*f_cursor_pos_changed_action)(PObject, const char *);
+    const char *f_cursor_pos_changed_argument;
 
     // Callback : Fonction appele si la partie visible (en hauteur)
     //            de la liste change et son argument
 
-    void     (*f_visible_lines_changed_action)(PObject,char *);
-    char     *f_visible_lines_changed_argument;
+    void (*f_visible_lines_changed_action)(PObject, const char *);
+    const char *f_visible_lines_changed_argument;
 
-    void     (*f_visible_cols_changed_action)(PObject,char *);
-    char     *f_visible_cols_changed_argument;
+    void (*f_visible_cols_changed_action)(PObject, const char *);
+    const char *f_visible_cols_changed_argument;
 
     // Callback : Fonction appele s'il y a/n'y a plus de zone slectionne
 
-    void     (*f_selection_status_changed_action)(PObject,char *);
-    char     *f_selection_status_changed_argument;
+    void (*f_selection_status_changed_action)(PObject, const char *);
+    const char *f_selection_status_changed_argument;
 
 
   /*--------------------*/
@@ -200,9 +200,9 @@
     // Constructeur / Destructeur
 
 		    TTextZone(PObject parent,
-		             int rel_x,int rel_y,
-			     int width,int height,
-			     char *caption,
+		             int rel_x, int rel_y,
+			     int width, int height,
+			     const char *caption,
 			     int max_text_nb_cols,
 			     TScrollbarChoice scrollbars=SBC_VERTICAL,
 			     boolean enabled=TRUE);
@@ -246,9 +246,9 @@
 
     // Modification du texte
 
-	    void    m_set_line(int line_nb,char *string)    {m_set_line(line_nb,string,NULL);};
-	    void    m_insert_line(int line_nb,char *string) {m_insert_line(line_nb,string,NULL);};
-	    void    m_insert_text(char *text);
+	    void    m_set_line(int line_nb, const char *string)    {m_set_line(line_nb,string,NULL);};
+	    void    m_insert_line(int line_nb, const char *string) {m_insert_line(line_nb,string,NULL);};
+	    void    m_insert_text(const char *text);
 
 
     // Lecture de texte
@@ -265,8 +265,8 @@
 
     // Chargement/Sauvegarde du texte (retourne FALSE si chec)
 
-            boolean m_save_text(char *filename);
-            boolean m_load_text(char *filename);
+            boolean m_save_text(const char *filename);
+            boolean m_load_text(const char *filename);
 
     // Modification de la partie slectionne du texte
 
@@ -294,29 +294,29 @@
 
     // Dfinition des callbacks
 
-	    void    m_set_nb_lines_changed_callback(void (*nb_lines_changed_action)(PObject,char *),
-						    char *nb_lines_changed_argument);
+	    void    m_set_nb_lines_changed_callback(void (*nb_lines_changed_action)(PObject, const char *),
+						    const char *nb_lines_changed_argument);
 
-	    void    m_set_text_changed_callback(void (*text_changed_action)(PObject,char *),
-						char *text_changed_argument);
+	    void    m_set_text_changed_callback(void (*text_changed_action)(PObject, const char *),
+						const char *text_changed_argument);
 
-	    void    m_set_cursor_line_changed_callback(void (*cursor_line_changed_action)(PObject,char *),
-						      char *cursor_line_changed_argument);
+	    void    m_set_cursor_line_changed_callback(void (*cursor_line_changed_action)(PObject, const char *),
+						       const char *cursor_line_changed_argument);
 
-	    void    m_set_cursor_col_changed_callback(void (*cursor_col_changed_action)(PObject,char *),
-						      char *cursor_col_changed_argument);
+	    void    m_set_cursor_col_changed_callback(void (*cursor_col_changed_action)(PObject, const char *),
+						      const char *cursor_col_changed_argument);
 
-	    void    m_set_cursor_pos_changed_callback(void (*cursor_pos_changed_action)(PObject,char *),
-						      char *cursor_pos_changed_argument);
+	    void    m_set_cursor_pos_changed_callback(void (*cursor_pos_changed_action)(PObject, const char *),
+						      const char *cursor_pos_changed_argument);
 
-	    void    m_set_visible_lines_changed_callback(void (*visible_lines_changed_action)(PObject,char *),
-							 char *visible_lines_changed_argument);
+	    void    m_set_visible_lines_changed_callback(void (*visible_lines_changed_action)(PObject, const char *),
+							 const char *visible_lines_changed_argument);
 
-	    void    m_set_visible_cols_changed_callback(void (*visible_cols_changed_action)(PObject,char *),
-							char *visible_cols_changed_argument);
+	    void    m_set_visible_cols_changed_callback(void (*visible_cols_changed_action)(PObject, const char *),
+							const char *visible_cols_changed_argument);
 
-	    void    m_set_selection_status_changed_callback(void (*selection_status_changed_action)(PObject,char *),
-							    char *selection_status_changed_argument);
+	    void    m_set_selection_status_changed_callback(void (*selection_status_changed_action)(PObject, const char *),
+							    const char *selection_status_changed_argument);
 
 
   /*--------------------*/
@@ -326,8 +326,8 @@
   protected:
 
 
-	    void    m_set_line(int line_nb,char *string,PLineProperties properties);
-	    void    m_insert_line(int line_nb,char *string,PLineProperties properties);
+	    void    m_set_line(int line_nb, const char *string, PLineProperties properties);
+	    void    m_insert_line(int line_nb, const char *string, PLineProperties properties);
 
     // Affichage
 
@@ -352,7 +352,7 @@
     // Affichage
 
     virtual void    m_display_string_node(PStringNode node,int line);
-    virtual void    m_display_string_part(char *string,int string_length,int min_col,int max_col,unsigned attribute);
+    virtual void    m_display_string_part(const char *string, int string_length, int min_col, int max_col, unsigned attribute);
 
 
     // Selected part of a line (0,0 if none)
@@ -361,8 +361,8 @@
 
     // Appel des callbacks
 
-    static  void    m_horiz_scrollbar_value_changed_call(PObject scrollbar,char *argument);
-    static  void    m_vert_scrollbar_value_changed_call(PObject scrollbar,char *argument);
+    static  void m_horiz_scrollbar_value_changed_call(PObject scrollbar, const char *argument);
+    static  void m_vert_scrollbar_value_changed_call(PObject scrollbar, const char *argument);
 
     virtual void    m_nb_lines_changed_callback();
 
@@ -433,7 +433,7 @@
 
     // Longueur utile d'une chaine
 
-	    int     m_useful_length(char *string);
+	    int m_useful_length(char *string);
 
     // Rduction/Expansion d'une ligne
     // (une ligne expanse a une longueur de f_nb_cols caractres,
diff -ruN jptui/twindow.cpp jptui.const/twindow.cpp
--- jptui/twindow.cpp	Tue Jun 23 08:25:38 1998
+++ jptui.const/twindow.cpp	Tue Jun  5 17:51:12 2001
@@ -47,7 +47,7 @@
 TWindow::TWindow(unsigned style,
 		 int x,int y,
 		 int width,int height,
-		 char *caption,
+		 const char *caption,
 		 boolean info_bar,
 		 boolean modal,
 		 boolean movable)
@@ -60,7 +60,8 @@
 		ENABLED,
 		(boolean)(caption[0]!=0),  // FOCUS_DEPENDING_ASPECT
 		TRUE,  // CAN_BE_ENABLED
-		TRUE)  // NEED_FOCUSED_ELEMENT
+		TRUE),  // NEED_FOCUSED_ELEMENT
+	 shadows(SHC_BOTH) // Fix: to redefine shadows type
 {
   // Application auquel appartient la fentre
 
@@ -329,7 +330,7 @@
 /* Modification du message d'information (si la barre d'information existe) */
 /****************************************************************************/
 
-void TWindow::m_set_info_message(char *message)
+void TWindow::m_set_info_message(const char *message)
 {
   if (!f_info_bar)
     return;
@@ -349,9 +350,9 @@
 /* Returns the info message                                                 */
 /****************************************************************************/
 
-char *TWindow::m_get_info_message()
+const char *TWindow::m_get_info_message()
 {
-  return((f_info_message==NULL)?"":f_info_message);
+  return f_info_message==NULL ?"" : f_info_message;
 }
 
 
@@ -392,9 +393,14 @@
 
 unsigned TWindow::m_get_normal_attr(unsigned background)
 {
-  if (background <=LIGHTBLUE)
-    return((background<<4)+(unsigned)WHITE);
-  return((background<<4)+(unsigned)BLACK);
+  // Fix: adding user defined colors
+  unsigned base = background & TWINDOW_COLOR_MASK;
+  unsigned color = (background>>TWINDOW_NORMAL_ATTR_SHIFT) & TWINDOW_COLOR_MASK;
+  if (color != 0)
+    return (base << 4) + color;
+  if (base <= LIGHTBLUE)
+    return((base<<4)+(unsigned)WHITE);
+  return((base<<4)+(unsigned)BLACK);
 }
 
 unsigned TWindow::m_get_inverse_attr(unsigned /*background*/)
@@ -404,14 +410,21 @@
 
 unsigned TWindow::m_get_bright_attr(unsigned background)
 {
-  if (background<=LIGHTBLUE)
-    return((background<<4)+(unsigned)YELLOW);
-  return((background<<4)+(unsigned)LIGHTBLUE);
+  // Fix: adding user defined colors
+  unsigned base = background & TWINDOW_COLOR_MASK;
+  unsigned color = (background>>TWINDOW_BRIGHT_ATTR_SHIFT) & TWINDOW_COLOR_MASK; 
+  if (color != 0)
+    return (base << 4) + color;
+  if (base <= LIGHTBLUE)
+    return((base<<4)+(unsigned)YELLOW);
+  return((base<<4)+(unsigned)LIGHTBLUE);
 }
 
 unsigned TWindow::m_get_inverse_bright_attr(unsigned background)
 {
-  if (background<=LIGHTBLUE)
+  // Fix: adding user defined colors
+  unsigned base = background & TWINDOW_COLOR_MASK;
+  if (base <= LIGHTBLUE)
     return((BLACK<<4)+(unsigned)YELLOW);
   return((BLACK<<4)+(unsigned)LIGHTBLUE);
 
@@ -419,7 +432,9 @@
 
 unsigned TWindow::m_get_inactive_attr(unsigned background)
 {
-  return((background<<4)+(unsigned)LIGHTGRAY);
+  // Fix: adding user defined colors
+  unsigned base = background & TWINDOW_COLOR_MASK;
+  return((base<<4)+(unsigned)LIGHTGRAY);
 }
 
 unsigned TWindow::m_get_inverse_inactive_attr(unsigned /*background*/)
@@ -667,7 +682,7 @@
 /* ------   dans la fentre (sans caractres spciaux (CrLf,Tab...) */
 /********************************************************************/
 
-void TWindow::m_puts(char *string)
+void TWindow::m_puts(const char *string)
 {
   word *last_char_ptr,
        *ptr;
@@ -770,9 +785,9 @@
 /* n'est pas mise en vidence                            */
 /*********************************************************/
 
-void TWindow::m_put_caption(char *main_string,
+void TWindow::m_put_caption(const char *main_string,
 			    boolean show_hot_key,
-			    int length,int position)
+			    int length, int position)
 
 {
   int normal_attribute=f_text_attribute;
@@ -893,7 +908,7 @@
 /*              (cf Strings.h)                           */
 /*********************************************************/
 
-void TWindow::m_put_text(char *text)
+void TWindow::m_put_text(const char *text)
 {
   boolean  done;
 
@@ -998,7 +1013,8 @@
 /* ------------   avec sa lgende      */
 /***************************************/
 
-void TWindow::m_draw_frame(int x1,int y1,int x2,int y2,unsigned background,char *caption,boolean enabled)
+void TWindow::m_draw_frame(int x1,int y1,int x2,int y2,unsigned background,
+                           const char *caption, boolean enabled)
 {
   register int i;
   int          caption_length=DisplayLength(caption);
@@ -1016,7 +1032,7 @@
 
   m_gotoxy(x1,y1);
 
-  m_putch('');
+  m_putch(CHAR_ALT_UP_LEFT_CORNER); // Fix: to use predefined symbol
 
   if (caption_length!=0)
     {
@@ -1083,8 +1099,8 @@
 /* -----------------------------------   au clic sur l'icone de fermeture*/
 /*************************************************************************/
 
-void TWindow::m_set_close_button_pressed_callback(void (*close_button_pressed_action)(PObject,char *),
-						  char *close_button_pressed_argument)
+void TWindow::m_set_close_button_pressed_callback(void (*close_button_pressed_action)(PObject, const char *),
+						  const char *close_button_pressed_argument)
 {
 
   // Une fentre sans titre ne peut pas avoir
@@ -1509,6 +1525,16 @@
 
 void TWindow::m_shadows_to_screen(int x1,int y1,int x2,int y2)
 {
+  // Fix: to redefine shadows type
+  bool vertical = false, horizontal = false;
+  switch (shadows) {
+    case SHC_NONE: break;
+    case SHC_HORIZONTAL: horizontal = true; break;
+    case SHC_VERTICAL: vertical = true; break;
+    case SHC_BOTH: vertical = true; horizontal = true; break;
+  }
+  if (vertical) {
+
   if ((y2>=1) && (y1<=(f_height-1)))
     {
       if ((x1<=f_width) && (x2>=f_width))
@@ -1522,12 +1548,17 @@
 		  f_y+MIN(f_height-1,y2));
     }
 
+  } // vertical
+  if (horizontal) {
+
   if ((x2>=2) && (x1<=(f_width+1)))
     if ((y1<=f_height) && (y2>=f_height))
       HorizontalShadow(f_x+MAX(2,x1),
 		  f_x+MIN(x2,f_width+1),
 		  f_y+f_height);
 
+  } // horizontal
+
 }
 
 /****************************/
diff -ruN jptui/twindow.h jptui.const/twindow.h
--- jptui/twindow.h	Tue Jun 23 08:24:12 1998
+++ jptui.const/twindow.h	Tue Jun  5 17:51:12 2001
@@ -45,6 +45,11 @@
 #define ALERT   (RED)
 #define HELP    (GREEN)
 
+// Fix: adding user defined colors
+#define TWINDOW_COLOR_MASK	   0xF
+#define TWINDOW_BRIGHT_ATTR_SHIFT  8
+#define TWINDOW_NORMAL_ATTR_SHIFT  16
+
 /*ͻ*/
 /*                         DEFINITION DE L'OBJET                          */
 /*ͼ*/
@@ -83,6 +88,10 @@
 
     unsigned    f_border_attribute;
 
+    // Fix: to redefine shadows type
+protected: TShadowChoice shadows; 
+public:    void 	 set_shadows(TShadowChoice a_shadows)
+	   { shadows = a_shadows; };
 
   /*----------------*/
   /* Private fields */
@@ -149,8 +158,8 @@
     //            fermeture de la fentre
     //            et son argument
 
-    void       (*f_close_button_pressed_action)(PObject,char *);
-    char       *f_close_button_pressed_argument;
+    void (*f_close_button_pressed_action)(PObject, const char *);
+    const char *f_close_button_pressed_argument;
 
 
   /*--------------------*/
@@ -162,9 +171,9 @@
     // Constructeur / Destructeur
 
 		     TWindow(unsigned style,
-			     int x,int y,
-			     int width,int height,
-			     char *caption="",
+			     int x, int y,
+			     int width, int height,
+			     const char *caption = "",
 			     boolean info_bar=FALSE,
 			     boolean modal=TRUE,
 			     boolean movable=TRUE);
@@ -214,8 +223,8 @@
 
     // Modification du message d'information
 
-	    void     m_set_info_message(char *message);
-	    char    *m_get_info_message();
+	    void     m_set_info_message(const char *message);
+	    const char *m_get_info_message();
 
     // Mthodes d'affichage dans la fentre
 
@@ -243,17 +252,17 @@
 
 	    void     m_putch(u_char character);
 	    void     m_putnch(int nb_chars,u_char character);
-	    void     m_puts(char *string);
+	    void     m_puts(const char *string);
 
-	    void     m_put_caption(char *main_string,boolean show_hot_key,int length,int position);
-	    void     m_put_text(char *text);
-	    void     m_draw_frame(int x1,int y1,int x2,int y2,unsigned background,char *caption,boolean enabled);
+	    void     m_put_caption(const char *main_string, boolean show_hot_key, int length, int position);
+	    void     m_put_text(const char *text);
+	    void     m_draw_frame(int x1,int y1,int x2,int y2,unsigned background, const char *caption, boolean enabled);
 	    void     m_display_arrow(int arrow_type);
 
     // Dfinition des callbacks
 
-	    void     m_set_close_button_pressed_callback(void (*close_button_pressed_action)(PObject,char *),
-							char *close_button_argument);
+	    void     m_set_close_button_pressed_callback(void (*close_button_pressed_action)(PObject, const char *),
+							 const char *close_button_argument);
 
   /*--------------------*/
   /* Mthodes protges */
diff -ruN jptui/types.h jptui.const/types.h
--- jptui/types.h	Sun May 24 17:47:50 1998
+++ jptui.const/types.h	Tue Jun  5 17:51:12 2001
@@ -107,9 +107,6 @@
 class                           TObject;
 typedef TObject                 *PObject;
 
-class				TPasswordEditZone;
-typedef TPasswordEditZone	*PPasswordEditZone;
-
 class                           TPushButton;
 typedef TPushButton             *PPushButton;
 
diff -ruN jptui/vocab.cpp jptui.const/vocab.cpp
--- jptui/vocab.cpp	Sun May 24 18:17:30 1998
+++ jptui.const/vocab.cpp	Tue Jun  5 17:51:12 2001
@@ -272,7 +272,7 @@
   return(ok);
 }
 
-char  *GetString(int string_number)
+const char *GetString(int string_number)
 {
   PVocabNode node;
   int i=string_number%10;
diff -ruN jptui/vocab.h jptui.const/vocab.h
--- jptui/vocab.h	Sun Jun 22 10:55:04 1997
+++ jptui.const/vocab.h	Tue Jun  5 17:51:12 2001
@@ -25,6 +25,6 @@
 
 // Returns the chosen string in the current language
 
-char     *GetString(int string_number);
+const char *GetString(int string_number);
 
 #endif
\ No newline at end of file
diff -ruN jptui/windows.cpp jptui.const/windows.cpp
--- jptui/windows.cpp	Sun Jun 22 10:55:04 1997
+++ jptui.const/windows.cpp	Tue Jun  5 17:51:12 2001
@@ -19,8 +19,6 @@
 /*                                 CONSTANTS                              */
 /*ͼ*/
 
-// Video interrupt
-
 #define INT_MULTIPLEXER 0x2F
 
 /*ͻ*/
@@ -35,12 +33,25 @@
 
 boolean RunningUnderWindows()
 {
+  // Fix: to determine Windows NT and Windows 2000
   __dpmi_regs regs;
 
-  regs.x.ax = 0x160A;
-  __dpmi_int(INT_MULTIPLEXER, &regs);
-
-  return((boolean)(regs.x.ax==0));
+  regs.x.ax = 0x160A; // MS Windows 3.1 - IDENTIFY WINDOWS VERSION AND TYPE
+  __dpmi_int(0x2f, &regs);
+  if (regs.x.ax==0) return TRUE; // successfull call
+
+  regs.x.ax = 0x3306; // DOS 5+ - GET TRUE VERSION NUMBER
+  __dpmi_int(0x21, &regs);
+  unsigned char major = regs.h.bl;
+  unsigned char minor = regs.h.bh;
+  // OS/2 v2.1 will return BX=0A14h (version 20.10)
+  // the Windows NT DOS box returns BX=3205h (version 5.50)
+  // Windows95 and Windows95 SP1 return version 7.00; Windows95 OSR2 returns
+  // version 7.10
+  if (major==20 && minor==10) return TRUE;  // OS/2
+  if (major==5 && minor==50) return TRUE;  // Windows NT DOS box (Windows 2000)
+  // Do not test 7.00/7.10 - 0x160A works
+  return FALSE;
 }
 
 /****************************************************************************/
diff -ruN jptui/zipexcl.dat jptui.const/zipexcl.dat
--- jptui/zipexcl.dat	Wed Jul 15 21:29:00 1998
+++ jptui.const/zipexcl.dat	Tue Jun  5 18:23:40 2001
@@ -6,15 +6,11 @@
 *.a
 *.s
 *.swp
-jpdemo.exe
-jphelp.exe
-jphc.exe
-scankey.exe
-lowcase.exe
-jp_proto.exe
-tuimaker.exe
-proj1.exe
+jpdemo\jpdemo.exe
+tools\jphelp.exe
+tools\jphc.exe
+tools\scankey.exe
+tools\jp_proto.exe
 *.hlp
 jptui.h
-*.~de
 jptui.dat
