diff -ruN jptui.version/screen.cpp jptui.screen/screen.cpp
--- jptui.version/screen.cpp	Sun May 24 17:51:50 1998
+++ jptui.screen/screen.cpp	Tue Jun  5 18:49:40 2001
@@ -101,6 +101,60 @@
 /*                                 FONCTIONS                              */
 /*ͼ*/
 
+bool TEXT_redefined_symbol(int ch, const char* text)
+{
+  for (size_t i = 0; text[i] != 0; i++) if 
+    ((unsigned char)text[i] == ch) return true;
+  return false;
+}
+
+bool redefined_symbol(int ch)
+{
+  bool redefined = false;
+  switch (ch) {
+    case GMOUSE_1ST_CHAR: case GMOUSE_1ST_CHAR+1:
+    case GMOUSE_1ST_CHAR+2:case GMOUSE_1ST_CHAR+3:
+    case (unsigned char)CHAR_UP_LEFT_CORNER:
+    case (unsigned char)CHAR_UP_HLINE:
+    case (unsigned char)CHAR_UP_RIGHT_CORNER:
+    case (unsigned char)CHAR_MIDDLE_RIGHT_CORNER:
+    case (unsigned char)CHAR_LEFT_VLINE:
+    case (unsigned char)CHAR_RIGHT_VLINE:
+    case (unsigned char)CHAR_BOTTOM_LEFT_CORNER:
+    case (unsigned char)CHAR_BOTTOM_HLINE:
+    case (unsigned char)CHAR_BOTTOM_RIGHT_CORNER:
+    case (unsigned char)CHAR_TICK:
+    case (unsigned char)CHAR_UP_BOTTOM_HLINES:
+    case (unsigned char)CHAR_ALT_UP_LEFT_CORNER:
+    case (unsigned char)ADDON_CHAR_UP_LEFT_CORNER:
+    case (unsigned char)ADDON_CHAR_UP_HLINE:
+    case (unsigned char)ADDON_CHAR_BOTTOM_LEFT_CORNER:
+    case (unsigned char)ADDON_CHAR_MIDDLE_UP_DOUBLE_LINE:
+    case (unsigned char)ADDON_CHAR_MIDDLE_UP_LINE:
+    case 16: // '' redefined too
+      redefined = true; break;
+    default: 
+      if (ch != ' ') {
+        if (redefined=TEXT_redefined_symbol(ch, TEXT_ARROW_UP)) break;
+        if (redefined=TEXT_redefined_symbol(ch, TEXT_ARROW_DOWN)) break;
+        if (redefined=TEXT_redefined_symbol(ch, TEXT_ARROW_LEFT)) break;
+        if (redefined=TEXT_redefined_symbol(ch, TEXT_ARROW_RIGHT)) break;
+        if (redefined=TEXT_redefined_symbol(ch, TEXT_CLOSE_BUTTON)) break;
+        if (redefined=TEXT_redefined_symbol(ch, TEXT_CHECKED_RADIO_BUTTON)) break;
+        if (redefined=TEXT_redefined_symbol(ch, TEXT_UNCHECKED_RADIO_BUTTON)) break;
+        if (redefined=TEXT_redefined_symbol(ch, TEXT_CHECKED_CHECK_BOX)) break;
+        if (redefined=TEXT_redefined_symbol(ch, TEXT_UNCHECKED_CHECK_BOX)) break;
+      }
+  }
+  return redefined;
+}
+
+int ToScreenChar(int ch)
+// Fix: converts all redefined font symbols to '.'
+{
+  return redefined_symbol(ch) ? '.' : ch;
+}
+
 /****************************************************************************/
 /* WaitRetrace                                                              */
 /*--------------------------------------------------------------------------*/
@@ -109,8 +163,9 @@
 
 void WaitRetrace()
 {
-  while (inportb(0x3da)&0x08);
-  while ((inportb(0x3da)&0x08)==0);
+//  Fix: too slow redrawing
+//  while (inportb(0x3da)&0x08);
+//  while ((inportb(0x3da)&0x08)==0);
 }
 
 /****************************************************************************/
@@ -519,8 +574,10 @@
       }
 
     // Modification de la police de caractres
-
-    DefineChars(256,0,char_definition);
+    // Fix: redefine only needed symbols
+    // DefineChars(256,0,char_definition);
+    for (int i=0; i<256; i++)
+      if (redefined_symbol(i)) DefineChars(1, i, char_definition+i*s_font_height);
     delete []char_definition;
   }
 
diff -ruN jptui.version/screen.h jptui.screen/screen.h
--- jptui.version/screen.h	Tue Jun  5 17:51:28 2001
+++ jptui.screen/screen.h	Tue Jun  5 20:12:12 2001
@@ -91,11 +91,29 @@
 #define TEXT_UP_BOTTOM_HLINES    ""  // 215
 
 #define CHAR_ALT_UP_LEFT_CORNER  ''  // 218
+ 
+#define ADDON_CHAR_UP_LEFT_CORNER ''  // looks as  218 - really 242
+#define ADDON_TEXT_UP_LEFT_CORNER "" 
+ 
+#define ADDON_CHAR_UP_HLINE      ''  // looks as  195 - really 243
+#define ADDON_TEXT_UP_HLINE      "" 
+ 
+#define ADDON_CHAR_BOTTOM_LEFT_CORNER	''  // looks like  192 - really 244 
+#define ADDON_TEXT_BOTTOM_LEFT_CORNER   ""
+                                                               
+#define ADDON_CHAR_MIDDLE_UP_DOUBLE_LINE  ''  // looks like  D0 - really 198
+#define ADDON_TEXT_MIDDLE_UP_DOUBLE_LINE  ""
 
+#define ADDON_CHAR_MIDDLE_UP_LINE  ''  // looks like  C1 - really 199
+#define ADDON_TEXT_MIDDLE_UP_LINE  ""
+  
 /*ͻ*/
 /*                                 FUNCTIONS                              */
 /*ͼ*/
 
+// Fix: converts all redefined font symbols to '.'
+extern int ToScreenChar(int ch);
+
 // Waits until the video beams enters retrace mode
 
 void    WaitRetrace();
