/****************************************************************************/
/* CALLBACK                                                                 */
/*--------------------------------------------------------------------------*/
/* Callback functions                                                       */
/****************************************************************************/

#ifndef _CALLBACK_H_
#define _CALLBACK_H_

#include "Types.h"

void InitCallback(void (*&callback_action)(const char *), 
                  const char *&callback_argument);
void SetCallback(void (*&callback_action)(const char *), 
                 const char *&callback_argument, void (*action)(const char *),
                 const char *argument);
void DestroyCallback(void (*&callback_action)(const char *), 
                     const char *&callback_argument);
void CallCallback(void (*callback_action)(const char *), 
                  const char *callback_argument);



void InitCallback(void (*&callback_action)(PObject, const char *), 
                  const char *&callback_argument);
void SetCallback(void (*&callback_action)(PObject, const char *), 
                 const char *&callback_argument,
                 void (*action)(PObject, const char *), const char *argument);
void DestroyCallback(void (*&callback_action)(PObject, const char *), 
                     const char *&callback_argument);
void CallCallback(PObject object, 
                  void (*callback_action)(PObject, const char *),
	          const char *callback_argument);



void InitCallback(void (*&callback_action)(PObject, int, const char *), 
                  const char *&callback_argument);
void SetCallback(void (*&callback_action)(PObject, int, const char *), 
                 const char *&callback_argument, 
                 void (*action)(PObject, int, const char *), 
                 const char *argument);
void DestroyCallback(void (*&callback_action)(PObject, int, const char *), 
                     const char *&callback_argument);
void CallCallback(PObject object, 
                  void (*callback_action)(PObject, int, const char *),
                  int index, const char *callback_argument);

#endif
