/****************************************************************************/
/* DEBUG                                                                    */
/*--------------------------------------------------------------------------*/
/* Debugging macros                                                         */
/****************************************************************************/

#ifndef _DEBUG_H
#define _DEBUG_H

#include "Settings.h"

/*ͻ*/
/*                                 FUNCTIONS                              */
/*ͼ*/

 // Don't use the following functions ! Use the corresponding macros below.

 #ifndef NDEBUG

   void    ProgrammingError(int error_nb, const char *file, int line);

   // These functions display the available memory.

   void    ShowMemory();
   void    HideMemory();
   void    DisplayMemory();

 #endif

/*ͻ*/
/*                                  MACROS                                */
/*ͼ*/

 #ifdef NDEBUG

 #  define NO_DEBUG(instruction)        instruction
 #  define DEBUG(instruction)
 #  define DEBUG_STOP()
 #  define DEBUG_TEST(condition)
 #  define DEBUG_SHOW_MEMORY()
 #  define DEBUG_HIDE_MEMORY()
 #  define DEBUG_DISPLAY_MEMORY()

 #else

 #  define NO_DEBUG(instruction)
 #  define DEBUG(instruction)           instruction
 #  define DEBUG_STOP()                 ProgrammingError(0, __FILE__, __LINE__)
 #  define DEBUG_TEST(condition)        ((condition) ? (void)0 : DEBUG_STOP())
 #  define DEBUG_SHOW_MEMORY()          ShowMemory()
 #  define DEBUG_HIDE_MEMORY()          HideMemory()
 #  define DEBUG_DISPLAY_MEMORY()       DisplayMemory()

 #endif

#endif
