#include <ctype.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "..\..\Types.h"


FILE *ProtoFile=NULL;
FILE *DescriptionFile=NULL;
FILE *IncludeFile=NULL;


void CloseFiles()
{
  if (ProtoFile!=NULL)
    fclose(ProtoFile);
  if (DescriptionFile!=NULL)
    fclose(DescriptionFile);
  if (IncludeFile!=NULL)
    fclose(IncludeFile);
}

void MakeJPTuiProto()
{
  char line_def[1024];
  char line_inc[1024];

  char *ptr,
       *ptr2,
       *ptr3;

  boolean error;

  // Ouverture des fichiers

  DescriptionFile=fopen("JPTUI.DEF","rt");
  if (DescriptionFile==NULL)
    {
      cerr << "\nImpossible d'ouvrir le fichier JPTUI.DEF\n\n";
      exit(-1);
    }

  ProtoFile=fopen("JPTUI.H","wt");
  if (ProtoFile==NULL)
    {
      CloseFiles();
      cerr << "\nImpossible de crer le fichier JPTUI.H\n\n";
      exit(-1);
    }

  // Parcours du fichier de dfinition

  while (fgets(line_def,1025,DescriptionFile))
    {
      ptr=strstr(line_def,"#include \"");

      // Rien de spcial dans la ligne

      if (!ptr)
	fputs(line_def,ProtoFile);

      // Sinon
      else
	{
	  ptr+=strlen("#include \"");
	  ptr2=strchr(ptr,'\"');
	  (*ptr2)=0;
          ptr2--;

	  ptr3=strrchr(ptr,'\\');
	  if (ptr3!=NULL)
	    ptr3=ptr3+1;
	  else
	    ptr3=ptr;

          for (;ptr2>=ptr;ptr2--)
            (*ptr2)=toupper(*ptr2);

	  cout << "Inclusion du fichier : " << ptr << "\n";

	  fputs("\n\n\n/*ͻ*/\n",ProtoFile);
          fputs("/*ۺ*/\n",ProtoFile);
	  fprintf(ProtoFile,"/*                          FILE : %-12s                         ޺*/\n",ptr3);
          fputs("/*ۺ*/\n",ProtoFile);
          fputs("/*ͼ*/\n\n",ProtoFile);

          // Lecture et recopie du fichier  inclure
          // (sauf les #include ", les #ifndef et les #endif)

          IncludeFile=fopen(ptr,"rt");
          if (IncludeFile==NULL)
            {
              CloseFiles();
              cerr << "\nImpossible d'ouvrir le fichier " << ptr << ".\n\n";
              exit (-1);
            }

          while (fgets(line_inc,1025,IncludeFile))
            {
              if (!strncmp(line_inc,"#ifndef",7))
                {
                  error=FALSE;

                  if (!fgets(line_inc,1025,IncludeFile))
                    error=TRUE;
                  else
                    if (!strstr(line_inc,"#define"))
                      error=TRUE;

                  if (error)
                    {
                      CloseFiles();
                      cerr << "\nDans les fichiers .H  inclure, une ligne #ifndef doit tre\n";
                      cerr <<   "suivie d'une ligne contenant le #define correspondant.\n\n";
                      exit(-1);
                    }
                }
              else
		{
                  if (   (!strstr(line_inc,"#include \""))
                      && (strncmp(line_inc,"#endif",6)))
                    fputs(line_inc,ProtoFile);
                }
	    }

          if (!feof(IncludeFile))
            {
              CloseFiles();
              cerr << "\nErreur lors de la lecture de ce fichier.\n\n";
              exit(-1);
            }

          fclose(IncludeFile);
	}
    }

  if (!feof(DescriptionFile))
    cerr << "\nErreur lors de la lecture du fichier JPTUI.DEF\n\n";
  else
    cout << "\nCration de JPTUI.H termine...\n\n";

  CloseFiles();

}

int main(int argc,char *argv[])
{
  boolean help_wanted=FALSE;
  register int i;

  cout << "\n\nJP_PROTO : Cre le fichier JPTUI.H contenant les prototypes\n";
  cout <<     "           de la librairie JPTUI.\n";
  cout <<     "           Jeepy Software - Avril 1995\n\n";

  // Aide demande explicitement

  for (i=1;i<argc;i++)
    {
      if (!strcmp(argv[i],"/?"))
	help_wanted=TRUE;
    }

  if ((help_wanted) || (argc!=1))
    {
      cout << "Syntaxe : [/?]\n\n";
      cout << "  Notes : Le fichier JPTUI.DEF doit contenir :\n";
      cout << "          - des lignes  inclure dans JPTUI.H,\n";
      cout << "          - des #include \"NomFichier\" pour chaque\n";
      cout << "            fichier  inclure dans JPTUI.H.\n\n";
      return(0);
    }

  MakeJPTuiProto();
  return(0);
}
