/****************************************************************************/
/* COMPAT                                                                   */
/*--------------------------------------------------------------------------*/
/* Compatibility macros between DJGPP and Turbo/Borland C++                 */
/****************************************************************************/


#ifndef _COMPAT_H
#define _COMPAT_H

  #ifdef __TCPLUSPLUS__

  #include <alloc.h>
  #include <dos.h>
  #include <dir.h>
  #include <io.h>

  #else

  #include <sys/nearptr.h>
  #include <pc.h>
  #include <go32.h>
  #include <dpmi.h>
  #include <unistd.h>
  #include <go32.h>
  #include <dos.h>
  #include <dir.h>
  #include <dpmi.h>
  #include <io.h>
  #include <unistd.h>
  #include <sys\stat.h>
  #include <sys\farptr.h>

  #endif


  #ifdef __TCPLUSPLUS__
  #define __dpmi_regs                             union REGS
  #define __dpmi_int(int_nb,regs)     		  int86(int_nb,regs,regs)

  #define _peekw(address)                         peek((address)>>4,(address) & 0xF)
  #define _peekb(address)                         peekb((address)>>4,(address) & 0xF)

  #define END_OF_FUNCTION(x)
  #define LOCK_VARIABLE(x)
  #define LOCK_FUNCTION(x)


  #else

  #define _peekw(address)                          _farpeekw(_dos_ds,(address))
  #define _peekb(address)                          _farpeekb(_dos_ds,(address))

  #define outport(a,b)				   outportw(a,b)

  #define END_OF_FUNCTION(x)    void x##_end() { }
  #define LOCK_VARIABLE(x)      _go32_dpmi_lock_data((void*)&x, sizeof(x))
  #define LOCK_FUNCTION(x)      _go32_dpmi_lock_code((void*)&x, (long)x##_end - (long)x)


  #endif


#endif
