/****************************************************************************/
/* MOUSE                                                                    */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation de la souris                                   */
/*--------------------------------------------------------------------------*/
/* Partie spcifique DJGPP          					    */
/****************************************************************************/


/****************************************************************************/
/* RestoreBackground                                                        */
/*--------------------------------------------------------------------------*/
/* Restaure les caractres situes sous le curseur de la souris             */
/* (rien n'a t stocke si s_text_x vaut -1)                           */
/****************************************************************************/

static void RestoreBackground()
{

	asm (
		"movl   _s_screen_ptr,%%ebx                 \n"
		"cmpl   $-1,%%ebx                           \n"
		"je     3f                                  \n"
		"                                           \n"
		"pushw  %%es                                \n"
		"movw   %0,%%es          # _dos_ds          \n"
		"movl   $0xB8000,%%edi                      \n"
		"addl   %%ebx,%%edi                         \n"
        "                                           \n"
		"movl   _s_mouse_pointer_aspect,%%ecx       \n"
		"cmpl   %1,%%ecx         # MPA_GRAPHICAL    \n"
		"jz     4f                                  \n"
        "                                           \n"
	"#Text:                                         \n"
		"movw   %%es:(%%edi),%%ax                   \n"
		"notb   %%ah                                \n"
		"movw   %%ax,%%es:(%%edi)                   \n"
		"jmp    2f                                  \n"
        "                                           \n"
	"#Graphical:                                    \n"
	"4:                                             \n"
		"movl   _s_text_y,%%edx                     \n"
		"movl   _s_text_x,%%ecx                     \n" 
        "                                           \n"
		"movl   $_s_pointer_background,%%esi        \n"
        "                                           \n"
		"movsb                                      \n"
		"incl   %%edi                               \n"
        "                                           \n"
		"cmpl   _s_last_col,%%ecx                   \n"
		"jae    1f                                  \n"
        "                                           \n"
		"# Le curseur prend 2 colonnes              \n"
        "                                           \n"
		"movsb                                      \n"
        "                                           \n"
		"cmpl   _s_last_line,%%edx                  \n"
		"jae    2f                                  \n"
        "                                           \n"
		"movl   _s_screen_width,%%eax               \n"
		"shll   $1,%%eax                            \n"
		"subl   $3,%%eax      # 2*screen_width-3    \n"

		"addl   %%eax,%%edi                         \n"
		"movsb                                      \n"
		"incl   %%edi                               \n"

		"movsb                                      \n"
		"jmp    2f                                  \n"

	"1:                                             \n"

		"cmpl   _s_last_line,%%edx                  \n"
		"jae    2f                                  \n"

		"incl   %%esi                               \n"
                                                    
		"movl   _s_screen_width,%%eax               \n"
		"shll   $1,%%eax                            \n"
		"subl   $2,%%eax      # 2*screen_width-2	\n"

		"addl   %%eax,%%edi                         \n"

		"movsb                                      \n"
                                                   
	"2:                                             \n"
		"popw   %%es                                \n"
                                                    
	"3:                                             \n"
    	:
       	:	"m" (_dos_ds),       // 0
	 		"g" (MPA_GRAPHICAL)   // 1
    	:	"%esi","%edi","%eax","%ebx","%ecx","%edx"
	);

}

static END_OF_FUNCTION(RestoreBackground);

/****************************************************************************/
/* DisplayMousePointer                                                      */
/*--------------------------------------------------------------------------*/
/* Affiche le curseur souris graphique                                      */
/****************************************************************************/

static void DisplayMousePointer()
{
  word  old_ds;

  char  font[4*MAX_HEIGHT];
  char  *font_ptr=font;

  word  mouse_pointer[MAX_HEIGHT];
  word  mouse_mask[MAX_HEIGHT]; // Curseur dcal

  word  *mouse_pointer_ptr=mouse_pointer,
	*mouse_mask_ptr  =mouse_mask;

  int   screen_ptr;

  int   xo,yo;

  int last_col;
  int last_line;
  int screen_width;
  int gap_mh,gap_32;
  int pointer_height;

	asm (
		"movl  _s_mouse_pointer_aspect,%%ecx	\n"
		"cmpl  %0,%%ecx  # MPA_GRAPHICAL        \n"
		"jz   8f                                \n"
                                                
	"#Text:                                     \n"

		:
       	:	"g" (MPA_GRAPHICAL)
       	:	"%ecx"
	);

  RestoreBackground();

	asm (
		"movl  _s_graph_y,%%eax                                           \n"
		"movl  %%eax,_s_text_y                                            \n"

		"movl  _s_graph_x,%%ecx                                           \n"
		"movl  %%ecx,_s_text_x                                            \n"

		"mull  _s_screen_width    # dx:ax = s_text_y*screen_width         \n"
		"shll  $1,%%eax           # ax=s_text_y*2*screen_width            \n"

		"movl  %%ecx,%%ebx        # bx=s_text_x                           \n"
		"shll  $1,%%ebx           # bx=s_text_x*2                         \n"

		"addl  %%ebx,%%eax        # ax=s_text_x*2+(s_text_y*screen_width) \n"
		"movl  %%eax,_s_screen_ptr                                        \n"

		"pushw %%es                                                       \n"

		"movw  %0,%%es         # _dos_ds                                  \n"
		"movl  $0xB8000,%%edi                                             \n"
		"addl  %%eax,%%edi                                                \n"

		"movw  %%es:(%%edi),%%ax                                          \n"
		"notb  %%ah                                                       \n"
		"movw  %%ax,%%es:(%%edi)                                          \n"

		"popw  %%es                                                       \n"
		"jmp   9f                                                         \n"
    	:
      	:	"m" (_dos_ds)
      	:	"%edi","%eax","%ebx","%ecx"
	);

	asm (
                                           
	"#Graphical:                            	\n"
	"8:                                     	\n"

		"movl  _s_screen_width,%%eax        	\n"
		"movl  %%eax,%1      # screen_width		\n"
		"decl  %%eax                        	\n"
		"movl  %%eax,%2      # last_col     	\n"
		"movl  _s_last_line,%%eax           	\n"
		"movl  %%eax,%3      # last_line    	\n"

		"movl  _s_font_height,%%eax         	\n"
		"movl  %%eax,%4      # pointer_height	\n"

		"movl  _s_gap_32,%%eax              	\n"
		"movl  %%eax,%5      # gap_32       	\n"

		"movl  _s_gap_max_height,%%ebx      	\n"
		"movl  %%ebx,%6      # gap_mh       	\n"

		"movw  %%ds,%0       # old_ds       	\n"

     	:	"=m" (old_ds),
	 		"=m" (screen_width),  // 1
	 		"=m" (last_col),      // 2
	 		"=m" (last_line),     // 3
	 		"=m" (pointer_height),// 4
	 		"=m" (gap_32),        // 5
	 		"=m" (gap_mh)         // 6
      	:	"g" (MAX_HEIGHT)
       	:	"%eax", "%ebx"
	);


  RestoreBackground();

  // Sauve le fond l o va tre affich le curseur

	asm (
		"movl  _s_graph_y,%%eax													\n"
		"movl  _s_font_height,%%ecx                                             \n"
		"divb  %%cl                                                             \n"
		"movb  $0,%%ah                                                          \n"
		"movl  %%eax,_s_text_y                                                  \n"
		"                                                                       \n"
		"movl  %%eax,%%edx                                                      \n"
		"movl  _s_graph_x,%%ecx                                                 \n"
		"shrl  $3,%%ecx                                                         \n"
		"movl  %%ecx,_s_text_x                                                  \n"
		"                                                                       \n"
		"mull  _s_screen_width                                                  \n"
		"shll  $1,%%eax                                                         \n"
		"                                                                       \n"
		"movl  %%ecx,%%ebx    # bx=s_text_x                                     \n"
		"shll  $1,%%ebx       # bx=s_text_x*2                                   \n"
		"                                                                       \n"
		"addl  %%ebx,%%eax    # ax=s_text_x*2+(s_text_y*screen_width)           \n"
		"movl  %%eax,_s_screen_ptr                                              \n"
		"                                                                       \n"
		"movl  $0xB8000,%%esi                                                   \n"
		"addl  %%eax,%%esi                                                      \n"
		"                                                                       \n"
		"movl  $_s_pointer_background,%%edi                                     \n"
		"movw  %2,%%ds        # dos_ds                                          \n"
		"                                                                       \n"
		"                                                                       \n"
		"                                                                       \n"
		"movsb                                                                  \n"
		"incl  %%esi                                                            \n"
		"                                                                       \n"
		"cmpl  %3,%%ecx       # ecx=LAST_COL ?                                  \n"
		"jae   1f                                                               \n"
		"                                                                       \n"
		"movsb                                                                  \n"
		"                                                                       \n"
		"cmpl  %4,%%edx       # edx=LAST_LINE ?                                 \n"
		"jae   2f                                                               \n"
		"                                                                       \n"
		"movl  %6,%%eax       # screen_width                                    \n"
		"shll  $1,%%eax                                                         \n"
		"subl  $3,%%eax       # 2*screen_width-3                                \n"
		"addl  %%eax,%%esi                                                      \n"
		"movsb                                                                  \n"
		"incl  %%esi                                                            \n"
		"                                                                       \n"
		"movsb                                                                  \n"
		"jmp   2f                                                               \n"
		"                                                                       \n"
		"                                                                       \n"
		"                                                                       \n"
	"1:                                                                         \n"
    	"                                                                       \n"
    	"                                                                       \n"
		"cmpl  %4,%%edx       # edx=LAST_LINE ?                                 \n"
		"jae   2f                                                               \n"
		"                                                                       \n"
		"incl  %%edi                                                            \n"
		"                                                                       \n"
		"movl  %6,%%eax       # screen_width                                    \n"
		"shll  $1,%%eax                                                         \n"
		"subl  $2,%%eax       # 2*screen_width-2                                \n"
		"                                                                       \n"
		"addl  %%eax,%%esi                                                      \n"
		"movsb                                                                  \n"
		"                                                                       \n"
	"2:                                                                         \n"
		"movw  %5,%%ds       # old_ds                                           \n"
		                                                                       
	    :	"=m" (screen_ptr),         // 0
			"=m" (s_pointer_background) // 1
	    :	"m" (_dos_ds),             // 2
			"m" (last_col),            // 3
			"m" (last_line),           // 4
			"m" (old_ds),              // 5
			"m" (screen_width)         // 6
    	:	"%esi","%edi","%eax","%ebx","%ecx","%edx","memory"
	);

  // Accs linaire  la carte VGA

  outport(0x3c4,0x0402);
  outport(0x3c4,0x0704);
  outport(0x3ce,0x0204);
  outport(0x3ce,0x0005);
  outport(0x3ce,0x0406);

  // Lecture de la dfinition des caractres sous le curseur

	asm (
		"movl  %1,%%edi      # font_ptr                 \n"
		"movl  $0,%%ebx                                 \n"
		"movl  %3,%%edx      # pointer_height           \n"
		"shrl  $1,%%edx                                 \n"
		"                                               \n"
	"0:                                                 \n"
		"movl  $0,%%eax                                 \n"
		"movb  _s_pointer_background(%%ebx),%%al        \n"
		"shll  $5,%%eax                                 \n"
		"movw  %2,%%ds       # _dos_ds                  \n"
		"                                               \n"
		"movl  $0xA0000,%%esi                           \n"
		"addl  %%eax,%%esi                              \n"
		"                                               \n"
		"movl  %%edx,%%ecx                              \n"
    	"rep;movsw                                      \n"
		"addl  %4,%%edi      # gap_mh                   \n"
		"incl  %%ebx                                    \n"
		"movw  %0,%%ds       # old_ds                   \n"
		"cmpl  $3,%%ebx                                 \n"
		"jle   0b                                       \n"
		:
       	:	"m" (old_ds),   // 0
	 		"m" (font_ptr), // 1
	 		"m" (_dos_ds),  // 2
	 		"m" (pointer_height), //3
	 		"m" (gap_mh)          // 4
     	:	"%esi","%edi","%eax","%ebx","%ecx","%edx"
	);


// Construction du curseur

	asm (
		"movl  _s_graph_x,%%eax                 \n"
		"andl  $7,%%eax                         \n"
		"movl  %%eax,%0      # xo               \n"
		"                                       \n"
		"movl  _s_graph_y,%%eax                 \n"
		"movl  %2,%%ecx      # pointer_height	\n"
		"divb  %%cl                             \n"
		"shrl  $8,%%eax                         \n"
		"movl  %%eax,%1      # yo               \n"
     	:	"=m" (xo),         // 0
	 		"=m" (yo)          // 1
       	:	"m" (pointer_height) // 2
       	:	"%eax","%ecx"
	);


// Dcalage du curseur et du fond en x

	asm (
		"movl  %3,%%edi      # pointer_height      \n"
		"decl  %%edi                               \n"
		"shll  $1,%%edi                            \n"
		"pushl %%edi                               \n"
		"movl  %1,%%edx      # mouse_pointer_ptr   \n"
		"                                          \n"
		"movl  $8,%%ecx                            \n"
		"subl  %0,%%ecx      # xo                  \n"
		"pushl %%ecx                               \n"
		"                                          \n"
		"movl  _s_pointer_definition_ptr,%%esi     \n"
		"incl  %%esi                               \n"
		"addl  %3,%%esi      # pointer_height      \n"
		"                                          \n"
		"                                          \n"
	"#Loop2_1:                                     \n"
	"1:                                            \n"
		"movl  $0,%%eax                            \n"
		"movb  (%%esi),%%al                        \n"
		"decl  %%esi                               \n"
		"                                          \n"
		"shll  %%cl,%%eax                          \n"
		"movw  %%ax,(%%edx,%%edi)                  \n"
		"subl  $2,%%edi                            \n"
		"jns   1b                                  \n"
		"                                          \n"
		"mov   %2,%%edx      # mouse_mask_ptr      \n"
		"popl  %%ecx                               \n"
		"popl  %%edi                               \n"
		"                                          \n"
		"addl  %%edi,%%esi   # 2*(pointer_height-1)\n"
		"addl  $2,%%esi                            \n"
		"                                          \n"
	"#Loop2_2:                                     \n"
	"2:                                            \n"
    	"                                          \n"
		"movl  $0,%%eax                            \n"
		"movb  (%%esi),%%al                        \n"
		"decl  %%esi                               \n"
		"                                          \n"
		"shll  %%cl,%%eax                          \n"
		"notl  %%eax                               \n"
		"movw  %%ax,(%%edx,%%edi)                  \n"
		"                                          \n"
		"subl  $2,%%edi                            \n"
		"jns   2b                                  \n"
    	:
       	:	"m" (xo),                // 0
	 		"m" (mouse_pointer_ptr),  // 1
			"m" (mouse_mask_ptr),     // 2
			"m" (pointer_height)      // 3
      	:	"%edi","%esi","%eax","%ecx","%edx","memory"
	);

// Dcalage en y et fusion curseur,masque,fond

  asm (
		"movl  $0,%%esi                                              \n"
		"movl  %3,%%edi      # yo                                    \n"
		"                                                            \n"
	"#Loop3_1:                                                       \n"
	"3:                                                              \n"
		"movl  %2,%%edx      # mouse_mask_ptr                        \n"
		"movw  (%%edx,%%esi),%%bx                                    \n"
		"movl  %1,%%edx      # mouse_pointer_ptr                     \n"
		"movw  (%%edx,%%esi),%%cx                                    \n"
		"                                                            \n"
		"movl  %0,%%edx      # font_ptr                              \n"
		"                                                            \n"
		"addl  %5,%%edi      # MAX_HEIGHT                            \n"
		"movb  (%%edx,%%edi),%%al                                    \n"
		"andb  %%bl,%%al                                             \n"
		"orb   %%cl,%%al                                             \n"
		"movb  %%al,(%%edx,%%edi)                                    \n"
		"subl  %5,%%edi      # MAX_HEIGHT                            \n"
		"                                                            \n"
		"movb  (%%edx,%%edi),%%al                                    \n"
		"andb  %%bh,%%al                                             \n"
		"orb   %%ch,%%al                                             \n"
		"movb  %%al,(%%edx,%%edi)                                    \n"
		"                                                            \n"
		"incl  %%edi                                                 \n"
		"cmpl  %4,%%edi      # pointer_height                        \n"
		"jne   4f                                                    \n"
		"movl  %6,%%edi      # MAX_HEIGHT*2                          \n"
		"                                                            \n"
	"#Loop3_2:                                                       \n"
	"4:                                                              \n"
		"addl  $2,%%esi                                              \n"
		"movl  %4,%%edx      # pointer_height                        \n"
		"shll  $1,%%edx                                              \n"
		"cmpl  %%edx,%%esi      # MAX_HEIGHT*2                       \n"
		"jne   3b                                                    \n"
    	:                                                            
       	:	"m" (font_ptr),           	// 0
			"m" (mouse_pointer_ptr),	// 1
	 		"m" (mouse_mask_ptr),     	// 2
	 		"m" (yo),                  	// 3
	 		"m" (pointer_height),      	// 4
	 		"g" (MAX_HEIGHT),           // 5
	 		"g" (MAX_HEIGHT << 1)
      	:	"%edi","%esi","%eax","%ebx","%ecx","%edx","memory"
	);

// Modification de la dfinition des caractres reprsentant la souris

	asm (
		"movw  %1,%%es         # _dos_ds                             \n"
		"movl  $0xA0000,%%edi                                        \n"
		"movl  %3,%%eax        # GMOUSE_1ST_CHAR                     \n"
		"shll  $5,%%eax                                              \n"
		"addl  %%eax,%%edi                                           \n"
		"                                                            \n"
		"movl  %2,%%esi        # font_ptr                            \n"
		"movl  $4,%%ebx                                              \n"
		"movl  %4,%%edx        # pointer_height                      \n"
		"shrl  $1,%%edx                                              \n"
		"                                                            \n"
	"#Loop4_1:                                                       \n"
	"5:                                                              \n"
		"movl  %%edx,%%ecx                                           \n"
    	"rep;movsw                                                   \n"
    	"                                                            \n"
		"addl  %5,%%edi        # gap_32                              \n"
		"addl  %6,%%esi        # gap_mh                              \n"
		"decl  %%ebx                                                 \n"
		"jnz   5b                                                    \n"
		"movw  %0,%%es         # old_ds                              \n"
    	:
       	:	"m" (old_ds),         // 0
		 	"m" (_dos_ds),        // 1
	 		"m" (font_ptr),       // 2
	 		"g" (GMOUSE_1ST_CHAR),// 3
	 		"m" (pointer_height), // 4
	 		"m" (gap_32),         // 5
	 		"m" (gap_mh)          // 6
     	:	"%edi","%esi","%eax","%ebx","%ecx","memory"
	);

  // Accs par plans  la carte VGA

  outport(0x3c4,0x0302);
  outport(0x3c4,0x0304);
  outport(0x3ce,0x0004);
  outport(0x3ce,0x1005);
  outport(0x3ce,0x0E06);

  // Affichage du curseur

	asm (
		"movl  _s_screen_ptr,%%edi									\n"
		"movw  %2,%%es       # _dos_ds                              \n"
		"addl  $0xB8000,%%edi                                       \n"
		"                                                           \n"
		"movl  _s_text_x,%%ecx                                      \n"
		"movl  _s_text_y,%%edx                                      \n"
		"                                                           \n"
		"movb  %3,%%al       # GMOUSE_1ST_CHAR                      \n"
		"movb  %%al,%%es:(%%edi)                                    \n"
		"addl  $2,%%edi                                             \n"
		"incb  %%al                                                 \n"
		"                                                           \n"
		"cmpl  %4,%%ecx      # LAST_COL                             \n"
		"jae   1f                                                   \n"
		"                                                           \n"
		"movb  %%al,%%es:(%%edi)                                    \n"
		"incl  %%edi                                                \n"
		"incb  %%al                                                 \n"
		"                                                           \n"
		"cmpl  %5,%%edx      # LAST_LINE                            \n"
		"jae   2f                                                   \n"
		"                                                           \n"
		"movl  %6,%%ebx       # screen_width                        \n"
		"shll  $1,%%ebx                                             \n"
		"subl  $3,%%ebx       # 2*screen_width-3                    \n"
		"addl  %%ebx,%%edi                                          \n"
		"                                                           \n"
		"movb  %%al,%%es:(%%edi)                                    \n"
		"addl  $2,%%edi                                             \n"
		"incb  %%al                                                 \n"
		"                                                           \n"
		"movb  %%al,%%es:(%%edi)                                    \n"
		"jmp   2f                                                   \n"
		"                                                           \n"
		"                                                           \n"
	"1:                                                             \n"
    	"                                                           \n"
    	"                                                           \n"
		"cmpl  %5,%%edx      # LAST_LINE                            \n"
		"jae   2f                                                   \n"
		"                                                           \n"
		"movl  %6,%%ebx       # screen_width                        \n"
		"shll  $1,%%ebx                                             \n"
		"subl  $2,%%ebx       # 2*screen_width-2                    \n"
		"                                                           \n"
		"addl  %%ebx,%%edi                                          \n"
		"incb  %%al                                                 \n"
		"movb  %%al,%%es:(%%edi)                                    \n"
		"                                                           \n"
		"                                                           \n"
	"2:                                                             \n"
		"movw  %0,%%es       # old_ds                               \n"
	"9:                                                             \n"
    	:
    	:	"m" (old_ds),              // 0
	 		"m" (screen_ptr),          // 1
	 		"m" (_dos_ds),             // 2
		 	"g" (GMOUSE_1ST_CHAR),     // 3
		 	"m" (last_col),            // 4
	 		"m" (last_line),           // 5
		 	"m" (screen_width)         // 6
       	:	"%edi","%eax","%ebx","%ecx","%edx"
	);

}

static END_OF_FUNCTION(DisplayMousePointer);

/****************************************************************************/
/* MouseMoveEvent                                                           */
/*--------------------------------------------------------------------------*/
/* Evnement appel par le pilote souris en cas de mouvement de celle-ci    */
/****************************************************************************/

static void MouseMovedEvent(_go32_dpmi_registers *regs)
{
  static bool s_in_event=false;

  if (s_in_event)
    return;

  disable();

  s_in_event=true;


  regs->x.cx >>= 3;
  regs->x.dx >>= 3;


  if ((regs->x.cx!=s_graph_x) || (regs->x.dx!=s_graph_y))
    {
      s_graph_x=regs->x.cx;
      s_graph_y=regs->x.dx;

      if (s_show_state>=0)
	DisplayMousePointer();
    }

  s_in_event=false;

  enable();
}

static END_OF_FUNCTION(MouseMovedEvent);

