/****************************************************************************/
/* TOBJECT                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TObject (type gnrique pour les lments de l'interface JPTUI     */
/****************************************************************************/

#ifndef _TOBJECT_H_
#define _TOBJECT_H_

#include <string>
#include "Compat.h"
#include "Types.h"
#include "Keyboard.h"
#include "JPAppli.h"
#include "Callback.hpp"

// Liste double-chane d'objets

typedef struct object_node
{
  PObject                    object;
  struct object_node        *next;
  struct object_node        *last;
} TObjectNode,*PObjectNode;


class TObject
{
  /*-------------*/
  /* Objets amis */
  /*-------------*/

  friend class TApplication;
  friend class TGroup;	// Pour que le groupe puisse contrler
			   			// les objets qu'il content
  /*---------------*/
  /* Champs privs */
  /*---------------*/

  private:

  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

    // Fentre qui contient l'objet

    PWindow f_window;
    bool f_dynamic_window; // Fentre alloue dynamiquement par l'objet

    // Groupe qui contient l'objet (NULL si l'objet est une fentre)

    PObject f_parent;

    // Numro de l'objet dans la fentre

    int     f_number;

    // Type de l'objet (cf CONST.H)
    // -> pas forcment redfini pour les objets drivs

    int     f_type;

    // Coordonnes de l'objet p/r au groupe le contenant
    // et ses dimensions

    int     f_rel_x,
	    f_rel_y,
	    f_width,
	    f_height;

    // Couleur de fond

    unsigned
	    f_background;


    // Lgende de l'objet

    char   *f_caption;

    // Hot-Key de l'objet (0 si aucune)

    char    f_hot_key;

    // Etat de l'objet

    bool f_open;          // L'objet est ouvert
    bool f_focused;       // L'objet a le focus
    bool f_enabled;       // L'objet est activable

    // L'objet est simple
    // (non compos d'autres objets)

    bool f_simple;


    // L'objet gre les acclrateurs
    // Elments de l'objet
    // (Objet compos)

    int     f_nb_elements;
    PObjectNode
            f_element_list,
            f_last_element;

    // L'objet peut-il devenir activable

    bool f_can_normally_be_enabled; // Dpend de l'objet
    bool f_can_be_enabled;         // Etat actuel. Peut tre modifi
                                      // si f_default_can_be_enabled est true

    // L'aspect de l'objet varie-t-il quand il prend ou perd le focus ?

    bool f_focus_depending_aspect;

    // L'affichage des lments est autoris

    bool f_elements_display_enabled;

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TObject(PObject parent,
			    int type,
			    int rel_x,int rel_y,
			    int width,int height,
			    unsigned background,
			    const char *caption,
			    bool enabled,
			    bool focus_depending_aspect,
                            bool can_be_enabled,
			    bool simple);

    virtual         ~TObject();

    // Mthodes d'accs

	    int     m_get_number() { return (f_number);};
	    int     m_get_type()   { return (f_type); };
	    PObject m_get_parent()  { return (f_parent);  };
            PWindow m_get_window() { return(f_window);};

	    int     m_get_x_in_window();
	    int     m_get_y_in_window();

    virtual int     m_get_x();
    virtual int     m_get_y();

	    int     m_get_width()  { return (f_width); };
	    int     m_get_height() { return (f_height); };

	    // Changement des dimensionnements (si objet ferm uniquement)

	    void    m_set_size(int width,int height);

	    unsigned  m_get_background()     { return(f_background);};

 	    // Fix: added to change colors of another objects
	    void      m_set_background(unsigned a_backgorund) 
              { f_background = a_backgorund;};

	    char    *m_get_caption() { return (f_caption);};
    virtual void    m_set_caption(const char *caption);

	    char    m_get_hot_key(){ return (f_hot_key);};
	    bool m_is_open()    { return (f_open); };
	    bool m_has_focus()  { return (f_focused);};
	    bool m_is_enabled() { return (f_enabled); };

    virtual void    m_enable();
    virtual void    m_disable();

	    // Seulement efficace pour des objets par nature activable

	    void    m_set_can_be_enabled(bool can_be_enabled);


    virtual bool m_can_lose_focus();

    // Donne le focus  l'objet

    virtual bool m_set_focus();
    virtual bool m_set_focus_to_last_element(); // Pareil dans ce cas


    // Callback : Fonction appele lorsque l'objet perd le focus
    //            et son argument

	jptui::CallbackHolder	focusLostAction_;

    // Callback : Fonction appele lorsque l'objet prend le focus
    //            et son argument

	jptui::CallbackHolder	focusTakenAction_;

    // Callback invoked when the object is opened

	jptui::CallbackHolder	openedAction_;

    // Callback invoked when the object is closed

	jptui::CallbackHolder	closedAction_;

  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    // Ajout d'un lment  l'objet

    virtual int     m_add_element(PObject object);
    virtual	    void    m_del_element(int object_number);

    PObject         m_object_number_to_element(int object_number);
    PObjectNode     m_object_number_to_element_node(int object_number);


    // Affichage

    virtual void    m_display();
    virtual void    m_display_focus_depending_part();
    virtual void    m_display_caption();
    virtual void    m_display_element(PObject element) { element->m_display();};

    // Attribution du focus  un lment de l'objet

    virtual bool m_set_focus_to_element(int object_number);

    // Prise/Perte du focus

    virtual void    m_lose_focus();

    virtual void    m_take_focus();

    // Ouverture/Fermeture de l'objet

    virtual void    m_set_open(bool open);

    // L'objet devient actif/inactif

    virtual void    m_set_active(bool active);

    // Callbacks

    virtual void    m_opened_callback();
    virtual void    m_closed_callback();

    // Evnements

    virtual bool m_left_button_pressed_event(int x,int y);
    virtual bool m_left_button_double_click_event(int x,int y);
    virtual bool m_key_pressed_event(TKey key);
    virtual bool m_short_cut_pressed_event(int short_cut);

    // Accs aux objets par les hritiers

	    void    m_set_element_open(PObject element,bool open) { element->m_set_open(open);};

	    bool m_left_button_pressed_event_on(PObject element,int x,int y){ return(element->m_left_button_pressed_event(x,y));};
	    bool m_left_button_dbl_click_event_on(PObject element,int x,int y){ return(element->m_left_button_double_click_event(x,y));};
	    bool m_key_pressed_event_on(PObject element,TKey key){ return(element->m_key_pressed_event(key));};
	    bool m_short_cut_pressed_event_on(PObject element,int short_cut){return(element->m_short_cut_pressed_event(short_cut));};

	    void    m_element_lose_focus(PObject element) { element->m_lose_focus();};
	    void    m_element_take_focus(PObject element) { element->m_take_focus();};

	    bool m_parent_set_focus_to_element(int element_nb) { return(f_parent->m_set_focus_to_element(element_nb));};

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Sert  obtenir l'objet d'un groupe qui a le focus

    virtual PObject m_get_focused_object() { return(this);};

    // L'objet peut obtenir le focus lors d'un dplacement
    // avec les touches flches

    virtual bool m_focus_can_be_set_by_arrow_key() { return true; };

    // Permet de modifier l'objet de la fentre qui possdait le focus
    // avant que le focus ne change d'objet

    void	m_set_previous_focused_object();

};

#endif
