/****************************************************************************/
/* TSMPLIST                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TSimpleList (Liste dont les lments n'ont pas de proprits       */
/*                    supplmentaires)                                      */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 13/05/96                                                    */
/****************************************************************************/

#include "TSmpList.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************************************************************************/
/* Constructeur                                                             */
/*--------------------------------------------------------------------------*/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x,rel_y      : Coordonnes de l'objet p/r au groupe                  */
/* width,height     : Dimensions de l'objet                                 */
/* caption          : Lgende de l'objet (hot-key prcd de ~)             */
/* list_rel_x,                                                              */
/* list_rel_y       : Position de la liste par rapport  l'objet            */
/* list_width,                                                              */
/* list_height      : Dimensions de la liste (le texte, sans les bordures)  */
/* items            : Elments de la liste                                  */
/* enabled          : ENABLED si l'objet est activable (DISABLED sinon)     */
/* focus_depending..: L'aspect de l'objet dpend du focus ou non            */
/****************************************************************************/

TSimpleList::TSimpleList(PObject parent,
			 int type,
			 int rel_x, int rel_y,
			 int width, int height,
			 unsigned background,
			 const char *caption,
			 int  list_rel_x,int list_rel_y,
			 int  list_width,
			 int  list_height,
			 bool sorted,
			 int     allowed_item_attribute,
			 bool always_one_item_selected,
			 bool item_hot_key_enabled,
			 bool scrollbar,
			 int     scrollbar_x,
			 int     scrollbar_y,
			 int     scrollbar_height,
			 bool enabled)
	    :TList(parent,
		   type,
		   rel_x,rel_y,
		   width,height,
		   background,
		   caption,
		   list_rel_x,list_rel_y,
		   list_width,list_height,
		   sorted,
		   allowed_item_attribute,
		   always_one_item_selected,
		   item_hot_key_enabled,
		   scrollbar,
		   scrollbar_x,
		   scrollbar_y,
		   scrollbar_height,
		   enabled)
{
}

/****************************************************************************/
/* Destructeur                                                              */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

TSimpleList::~TSimpleList()
{
}

/****************************************************************************/
/* m_add_items                                                              */
/*--------------------------------------------------------------------------*/
/* Ajout d'lments  la liste.                                             */
/* Chaque lment est de type TListItem                                     */
/* Dans le dernier lment, item[].label doit valoir NULL                   */
/* Retourne le nombre d'lments effectivement ajout                       */
/****************************************************************************/

int TSimpleList::m_add_items(const TListItem items[])
{
  register int nb_items;

  nb_items=0;
  while (items[nb_items].label!=NULL)
    {
      // Ajout d'un lment

      if (!m_add_item(items[nb_items].label,
		      items[nb_items].attribute))
	break;   // Plus de place pour ajouter

      nb_items++;
   }

  return(nb_items);
}


