/****************************************************************************/
/* TSMPLIST                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TSimpleList (Liste dont les lments n'ont pas de proprits       */
/*                    supplmentaires)                                      */
/****************************************************************************/

#ifndef _TSMPLIST_H_
#define _TSMPLIST_H_

#include <stdlib.h>

#include "TList.h"

/*ͻ*/
/*                                  TYPES                                 */
/*ͼ*/

// Elment de la liste

typedef struct {
  const char *label;
  int attribute;
} TListItem;

/*ͻ*/
/*                         DEFINITION DE L'OBJET                          */
/*ͼ*/

class TSimpleList:public TList
{
  /*--------------*/
  /* For TUIMaker */
  /*--------------*/

  #ifdef __TUIMAKER__
  friend class VComboBox;
  #endif


  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur/Destructeur

		    TSimpleList(PObject parent,
				int type,
				int rel_x, int rel_y,
				int width, int height,
				unsigned background,
				const char *caption,
				int  list_rel_x,int list_rel_y,
				int  list_width,
				int  list_height,
				bool sorted,
				int     allowed_item_attribute,
				bool always_one_item_selected,
				bool item_hot_key_enabled,
				bool scrollbar,
				int     scrollbar_x,
				int     scrollbar_y,
				int     scrollbar_height,
				bool enabled);

    virtual         ~TSimpleList();


    // Ajout d'un lment  la liste
    // (retourne son index ou 0 s'il n'y a plus de place)

    virtual int     m_add_item(const char *label, int attribute=LI_NOATTR)             {return(TList::m_add_item_to_list(0,label,attribute,NULL));};
    virtual int     m_insert_item(int index, const char *label, int attribute=LI_NOATTR){return(TList::m_add_item_to_list(index,label,attribute,NULL));};

    // Ajout de plusieurs lments
    // Chaque lment est de type TListItem
    // Dans le dernier lment, item[].label doit valoir NULL

    // Retourne le nombre d'lments effectivement ajout

    virtual int     m_add_items(const TListItem items[]);


};

#endif
