// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef CameraClass
#define CameraClass

#include <Lib3d/Node.H>


class Camera : public Node
{
public:
    Camera(Node &parent);
    ~Camera();

    const char *getName() const { return "Camera"; }

    void setYonPlane( float x )    { yon = x;    recalc = true; }
    void setHitherPlane( float x ) { hither = x; recalc = true; }
    void setAspectRatio( float x ) { aspect = x; recalc = true; }
    void setFieldOfView( float x ) { field = x;  recalc = true; }
    void setParameters( float hither, float yon, float field, float aspect );
    
    void setActiveCamera();	// Affects world.render().
    void prepareToRender( Viewport &viewport );  // called by world.render()
    void notifyResize();

private:
    bool recalc;
    float yon;
    float hither;
    float field;
    float aspect;

    Node *world; 

    Matrix34 worldToCamera;  
    Matrix34 cameraToCvv;
    Matrix34 worldToCvv;

    const Viewport *lastViewport;
};

#endif


