#ifndef ColourRampClass
#define ColourRampClass

#include <Lib3d/internals/types.H>

class Viewport;
class Vector3;

class ColourRamp
{
friend class Viewport;
public:
    ColourRamp();
    ~ColourRamp();

    Colour getColour( uint intensity ) const;
    void   setColour( uint intensity, Colour colour );
    void   build( Viewport &, const Vector3 &ambient, const Vector3 &diffuse );
    void   fallback( Viewport &, const Vector3 &colour );

    const Colour *getRamp() const;

private:
    Colour *data;
};


inline Colour 
ColourRamp::getColour( uint intensity ) const
{
    return data[intensity+50];
}

inline void
ColourRamp::setColour( uint intensity, Colour colour ) 
{
    data[intensity+50] = colour;
}

inline const Colour *
ColourRamp::getRamp() const
{
    return data+50;
}

#endif

