// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef LightClass
#define LightClass

#include <Lib3d/Node.H>
#include <Lib3d/Vector.H>

// Lights are currently directional only.

class Light : public Node
{
friend class World;
public:
    Light(Node &parent);
    ~Light();

    const char *getName() const { return "Light"; }

    void setParameters(Vector3 amb,
		       Vector3 dif,
		       Vector3 direction);

    bool isMonochrome() const { return monochrome; }
    const Vector3 &getCvvPov() const { return cvvPov; }
    const Vector3 &getAmbient() const { return ambient; }
    const Vector3 &getDiffuse() const { return diffuse; }

    Light *getNextLight() { return nextLight; }
    const Light *getNextLight() const { return nextLight; }
    
protected:
    void recalculateTransforms( const Matrix34 &parentToCvv );

private:
    bool monochrome;		
    Vector3 ambient;		// Colour vectors in RGB space
    Vector3 diffuse;
    Vector3 pov;		// Orientation vector in object space 
                                // (redundant - could just use (0,0,1))
    Vector3 cvvPov;		// Orientation vector in the cvv.

    Light *nextLight;		// Used by the World class.
};

#endif











