// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#include <Lib3d/Devices/FileDevice.H>

PointerArray<FileDevice> *FileDevice::children = 0;
const char **FileDevice::filetypes = 0;

FileDevice::FileDevice( Exemplar e )
    : Device(e),
      filename(0)
{
}

// No platform independent entry point - you wouldn't want one of these as
// your primary device.

FileDevice::FileDevice( uint width, uint height, uint min_depth )
    : Device(width, height, min_depth ),
      filename(0)
{
    if (isBad()) return;	// a little redundant.
}


const char **
FileDevice::getFileTypeArray( int &nr )
{
    if (!children) return 0;

    PointerArray<FileDevice> &c = *children;
    nr = c.getNr();

    delete [] filetypes;
    filetypes = new const char* [nr];
    
    for (int i = 0 ; i < nr ; i++) {
	filetypes[i] = c[i]->getFileType();
    }

    return filetypes;
}


FileDevice *
FileDevice::create( int index, uint width, uint height, uint min_depth )
{
    if (!children) return 0;

    PointerArray<FileDevice> &c = *children;
    FileDevice *dev = c[index]->cloneFileDevice( width, height, min_depth );

    if (dev && dev->isGood() && dev->initialize()) {
	return dev;
    } else {
	delete dev;
	return 0;
    }
}

void
FileDevice::registerChildClass( FileDevice *child )
{
    if (children == 0) children = new PointerArray<FileDevice>(1);
    children->nextFree() = child;
}

FileDevice::~FileDevice()
{
    delete filename; filename = 0;
}









