/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbsicmp.c,v 1.2 1996/07/03 13:34:28 jack Exp $ */

#include <ctype.h>
#include <stddef.h>
#include <mbstring.h>

int
_mbsicmp (const unsigned char *us1, const unsigned char *us2)
{
  size_t bytes1, bytes2;
  int c1, c2;

  while (1)
    {
      bytes1 = _mbclen (us1);
      bytes2 = _mbclen (us2);
      if (bytes1 != bytes2)
	{
	  c1 = _mbsnextc (us1);
	  c2 = _mbsnextc (us2);
	  return c1 - c2;
	}
      else if (bytes1 == 1)
	{
	  if (*us1++ != *us2++)
	    {
	      c1 = us1[-1];
	      c2 = us2[-1];
	      if (toupper (c1) != toupper (c2))
		return c1 - c2;
	    }
	  else if (us1[-1] == '\0')
	    break;
	}
      else
	{
	  while (bytes1-- > 0)
	    {
	      if (*us1++ != *us2++)
		{
		  c1 = us1[-1];
		  c2 = us2[-1];
		  return c1 - c2;
		}
	    }
	}
    }

  return 0;
}
