/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbsset.c,v 1.2 1996/07/03 13:34:28 jack Exp $ */

#include <stddef.h>
#include <mbstring.h>

unsigned char *
_mbsset (unsigned char *us, int c)
{
  unsigned char *top = us;
  size_t bytes;
  size_t len;

  /* check size */
  c &= 0x0000ffffU;
  if (c & 0xff00U)
    {
      if ((c & 0x00ffU) == 0)
	{
	  c >>= 8;
	  bytes = 1;
	}
      else
	bytes = 2;
    }
  else
    bytes = 1;
  len = _mbslen (us);

  /* fill buffer */
  while (len >= bytes)
    {
      us = _mbcset (us, c);
      len -= bytes;
    }

  /* handle the rest */
  if (len != 0)
    while (len-- > 0)
      *us++ = ' ';

  return top;
}
