/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wcprvt.h,v 1.5 1996/10/27 13:23:47 jack Exp $ */

#ifndef __wcprvt_h__
#define __wcprvt_h__

/* for wchar_t */
#include <stddef.h>
/* for wint_t */
#include <wctype.h>

/* following private definition */
struct __wcprop
{
  char *name; /* property name */
  struct __wcclass
  {
    /* num < 0: END
     * num = 0: code range, wchars[0] = minimum code, wchars[1] = maximum code,
     *          wchars[2] = value for upper-lower conversion
     * num > 0: array size
     */
    int num; /* type or array size */
    wchar_t *wchars; /* array of wchar_t */
  } *wcclass;
};

#if defined (__DJGPP__) || defined (__HUMAN68K__)
#ifndef __WCHAR_USE_BINARYMODE
#define __WCHAR_USE_BINARYMODE
#endif
#include <stdio.h>
#include <fcntl.h>

#if defined (__HUMAN68K__)
#include <unistd.h>
#include <sys/xunistd.h>
#define __WCHAR_BINARYMODE_OLDMODE(fd) \
(_fddb[fd].oflag & (O_TEXT | O_BINARY))
#elif defined (__DJGPP__)
#include <io.h>
#include <libc/dosio.h>
#define __WCHAR_BINARYMODE_OLDMODE(fd) \
(__file_handle_modes[fd] & (O_BINARY | O_TEXT))
#endif

#define __WCHAR_BINARYMODE_VARIABLES int oldmode
#define __WCHAR_BINARYMODE_PROLOGUE(fp) \
do							\
  {							\
    oldmode = __WCHAR_BINARYMODE_OLDMODE ((fp)->_file);	\
    if (oldmode == O_TEXT)				\
      {							\
	fflush ((fp));					\
	(void) setmode ((fp)->_file, O_BINARY);		\
      }							\
  }							\
while (0)
#define __WCHAR_BINARYMODE_EPILOGUE(fp) \
do							\
  {							\
    if (oldmode == O_TEXT)				\
      {							\
	fflush ((fp));					\
	(void) setmode ((fp)->_file, oldmode);		\
      }							\
  }							\
while (0)
#else /* !__DJGPP__ && !__HUMAN68K__ */
#define __WCHAR_BINARYMODE_VARIABLES
#define __WCHAR_BINARYMODE_PROLOGUE(fp)
#define __WCHAR_BINARYMODE_EPILOGUE(fp)
#endif /* !__DJGPP__ && !__HUMAN68K__ */

#ifdef __cplusplus
extern "C" {
#endif

/* variables */
extern struct __wcprop **__wcprops;
extern struct __wcprop **__wcprops_trans;
extern int __wcprops_num;
extern int __wcprops_trans_num;
extern struct __wcprop *__wcprops_c[];
extern struct __wcprop *__wcprops_trans_c[];
extern int __wcprops_c_num;
extern int __wcprops_trans_c_num;
extern struct __wcprop *__wcprops_ja_jp_sjis[];
extern struct __wcprop *__wcprops_trans_ja_jp_sjis[];
extern int __wcprops_ja_jp_sjis_num;
extern int __wcprops_trans_ja_jp_sjis_num;

/* functions */
extern void __wcinit (int category, const char *locale);
extern int _dowprnt (const wchar_t *format, va_list ap, FILE *fp,
		     wint_t (*outfunc) (wint_t, FILE *));
extern wint_t __fgetwc (FILE *fp);
extern wchar_t *__fgetws (wchar_t *ws, int n, FILE *fp);
extern wint_t __fputwc (wint_t wc, FILE *fp);
extern int __fputws (const wchar_t *ws, FILE *fp);
extern wint_t __ungetwc (wint_t wc, FILE *fp);

#ifdef __cplusplus
}
#endif

#endif /* !__wcprvt_h__ */
