/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: fgetwc.c,v 1.2 1996/07/13 20:40:34 jack Exp $ */

#include <stdio.h>
#include <wchar.h>
#include <wcprvt.h>

wint_t
fgetwc (FILE *fp)
{
  size_t bytes = sizeof (wchar_t);
  wchar_t wc = 0;
  int c;
  __WCHAR_BINARYMODE_VARIABLES;

  __WCHAR_BINARYMODE_PROLOGUE (fp);

  while (bytes-- > 0)
    {
      c = fgetc (fp);
      if (c == EOF)
	{
	  __WCHAR_BINARYMODE_EPILOGUE (fp);
	  return WEOF;
	}
      wc += c & 0x000000ffU;
      wc <<= 8;
    }

  __WCHAR_BINARYMODE_EPILOGUE (fp);

  return (wint_t) wc;
}
