/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
				Copyright (c)1995,1996 Malcolm Taylor

 -> EVENTS.H
 -> Event macros and structures.
*/

#ifndef _events_h
#define _events_h

#include <types.h>

/*==============================================*
 *          The Message Id definitions          *
 *==============================================*/

	// Mouse Messages.
#define FIRST_MOUSE_EVENT 0
#define W_MOUSEMOVE     0
#define W_MOVEOUTSIDE   1
#define W_LBUTTONDOWN   2
#define W_MBUTTONDOWN   3
#define W_RBUTTONDOWN   4
#define W_LBUTTONUP     5
#define W_MBUTTONUP     6
#define W_RBUTTONUP     7
#define LAST_MOUSE_EVENT 99

	// Keyboard Messages.
#define FIRST_KEYBOARD_EVENT 100
#define W_KEYPRESS      100
#define LAST_KEYBOARD_EVENT 199

	// Window Messages.
#define FIRST_WINDOW_EVENT 200
#define W_COMMAND       200
#define W_PAINT         201
#define W_NOTIFY        203
#define W_TIMER         204
#define W_REMOVE_CHILD  205
#define W_DOCUMENT      206
#define LAST_WINDOW_EVENT 299


/*==============================================*
 *       The Event Response Table Macros        *
 *==============================================*/

				// void CmXXXX(void);
#define E_COMMAND(CmID,function) \
	if(ev->Type==W_COMMAND && ev->p1==CmID) \
	{ \
		function(); \
		return TRUE; \
	}

				// void DocXXXX(void);
#define E_DOCUMENT(CmID,function) \
	if(ev->Type==W_DOCUMENT && ev->p1==CmID) \
	{ \
		function(); \
		return TRUE; \
	}

				// void Timer(void);
#define E_TIMER \
	if(ev->Type==W_TIMER) \
	{ \
		Timer(); \
		return TRUE; \
	}

				// void XXXX(int n);
#define E_NOTIFY(CmID,function) \
	if(ev->Type==W_NOTIFY && ev->p1==CmID) \
	{ \
		function(ev->p2); \
		return TRUE; \
	}

				// void MouseMove(int x,int y,int key_stat,int but_stat);
#define E_MOUSEMOVE \
	if(ev->Type==W_MOUSEMOVE) \
	{ \
		MouseMove(ev->p1,ev->p2,ev->p3,ev->p4); \
		return TRUE; \
	}

				// void MouseMove(int x,int y,int key_stat,int but_stat,int time);
#define E_MOUSEMOVET \
	if(ev->Type==W_MOUSEMOVE) \
	{ \
		MouseMove(ev->p1,ev->p2,ev->p3,ev->p4,ev->p5); \
		return TRUE; \
	}

				// void MoveOutside(int x,int y,int key_stat,int but_stat);
#define E_MOVEOUTSIDE \
	if(ev->Type==W_MOVEOUTSIDE) \
	{ \
		MoveOutside(ev->p1,ev->p2,ev->p3,ev->p4); \
		return TRUE; \
	}

				// void MoveOutside(int x,int y,int key_stat,int but_stat,int time);
#define E_MOVEOUTSIDET \
	if(ev->Type==W_MOVEOUTSIDE) \
	{ \
		MoveOutside(ev->p1,ev->p2,ev->p3,ev->p4,ev->p5); \
		return TRUE; \
	}

				// void LButtonDown(int x,int y,int key_stat);
#define E_LBUTTONDOWN \
	if(ev->Type==W_LBUTTONDOWN) \
	{ \
		LButtonDown(ev->p1,ev->p2,ev->p3); \
		return TRUE; \
	}

				// void LButtonDown(int x,int y,int key_stat,int time);
#define E_LBUTTONDOWNT \
	if(ev->Type==W_LBUTTONDOWN) \
	{ \
		LButtonDown(ev->p1,ev->p2,ev->p3,ev->p4); \
		return TRUE; \
	}

				// void MButtonDown(int x,int y,int key_stat);
#define E_MBUTTONDOWN \
	if(ev->Type==W_MBUTTONDOWN) \
	{ \
		MButtonDown(ev->p1,ev->p2,ev->p3); \
		return TRUE; \
	}

				// void MButtonDown(int x,int y,int key_stat,int time);
#define E_MBUTTONDOWNT \
	if(ev->Type==W_MBUTTONDOWN) \
	{ \
		MButtonDown(ev->p1,ev->p2,ev->p3,ev->p4); \
		return TRUE; \
	}

				// void RButtonDown(int x,int y,int key_stat);
#define E_RBUTTONDOWN \
	if(ev->Type==W_RBUTTONDOWN) \
	{ \
		RButtonDown(ev->p1,ev->p2,ev->p3); \
		return TRUE; \
	}

				// void RButtonDown(int x,int y,int key_stat,int time);
#define E_RBUTTONDOWNT \
	if(ev->Type==W_RBUTTONDOWN) \
	{ \
		RButtonDown(ev->p1,ev->p2,ev->p3,ev->p4); \
		return TRUE; \
	}

				// void LButtonUp(int x,int y,int key_stat);
#define E_LBUTTONUP \
	if(ev->Type==W_LBUTTONUP) \
	{ \
		LButtonUp(ev->p1,ev->p2,ev->p3); \
		return TRUE; \
	}

				// void LButtonUp(int x,int y,int key_stat,int time);
#define E_LBUTTONUPT \
	if(ev->Type==W_LBUTTONUP) \
	{ \
		LButtonUp(ev->p1,ev->p2,ev->p3,ev->p4); \
		return TRUE; \
	}

				// void MButtonUp(int x,int y,int key_stat);
#define E_MBUTTONUP \
	if(ev->Type==W_MBUTTONUP) \
	{ \
		MButtonUp(ev->p1,ev->p2,ev->p3); \
		return TRUE; \
	}

				// void MButtonUp(int x,int y,int key_stat,int time);
#define E_MBUTTONUPT \
	if(ev->Type==W_MBUTTONUP) \
	{ \
		MButtonUp(ev->p1,ev->p2,ev->p3,ev->p4); \
		return TRUE; \
	}

				// void RButtonUp(int x,int y,int key_stat);
#define E_RBUTTONUP \
	if(ev->Type==W_RBUTTONUP) \
	{ \
		RButtonUp(ev->p1,ev->p2,ev->p3); \
		return TRUE; \
	}

				// void RButtonUp(int x,int y,int key_stat,int time);
#define E_RBUTTONUPT \
	if(ev->Type==W_RBUTTONUP) \
	{ \
		RButtonUp(ev->p1,ev->p2,ev->p3,ev->p4); \
		return TRUE; \
	}


				// void KeyPress(int key,int scan,int key_stat);
#define E_KEYPRESS \
	if(ev->Type==W_KEYPRESS) \
	{ \
		KeyPress(ev->p1,ev->p2,ev->p3); \
		return TRUE; \
	}

				// void KeyPress(int key,int scan,int key_stat,int time);
#define E_KEYPRESST \
	if(ev->Type==W_KEYPRESS) \
	{ \
		KeyPress(ev->p1,ev->p2,ev->p3,ev->p4); \
		return TRUE; \
	}
				
				// void XXXX(int key_stat);
#define E_KEYCODE(key,scan,function) \
	if(ev->Type==W_KEYPRESS && ev->p1==key && ev->p2==scan) \
	{ \
		function(ev->p3); \
		return TRUE; \
	}



/*==============================================*
 * The Event Response Class to hold the event   *
 *    and Macros to declare and define the      *
 *             response tables                  *
 *==============================================*/

				// Macro to declare the response table.
#define DECLARE_RESPONSE_TABLE \
	protected: \
		virtual BOOL DoEvents(const event *ev)

				// Macro to begin the response table.
#define DEFINE_RESPONSE_TABLE(class,derived) \
	BOOL class::DoEvents(const event *ev) \
	{ \
		if(derived::DoEvents(ev)) \
			return TRUE;

				// Macro to end the response table.
#define END_RESPONSE_TABLE \
		return FALSE; \
	}


struct event {
	public:
		event(int t,int n1=0,int n2=0,int n3=0,int n4=0,int n5=0,int n6=0)
			:Type(t),p1(n1),p2(n2),p3(n3),p4(n4),p5(n5),p6(n6)
			{}
		event():Type(-1)
			{}
		
		int Type;
		int p1,p2,p3,p4,p5,p6;
};

#endif
