/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> QUEUE.H
 -> EventQueue class for holding the global event queue.
*/

#ifndef _queue_h
#define _queue_h

#include <tws/events.h>

#ifndef NULL
# define NULL 0
#endif

class Window;

class EventItem {
   public:
      EventItem(Window *w,const event &e)
         :to(w),ev(e),next(NULL) 
         {}

      inline event *GetEvent()
         { return &ev; }
      inline Window *GetWindow()
         { return to; }
      inline EventItem *GetNext()
         { return next; }
      inline void SetNext(EventItem *e)
         { next=e; }

   protected:
      Window *to;
      event ev;
      EventItem *next;
};

class EventQueue {
   public:
      EventQueue():list(NULL)
         {}

      void AddItem(Window *win,const event &ev);
      void DestroyMatchingItems(Window *win);
      inline BOOL isEvent()
         { return (BOOL)(list!=NULL); }
      void DetachEvent();

   protected:
      EventItem *list;
};

#endif

