/*************************************************************
 ****************    ===Picture Viewer===    *****************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> OPTIONS.CC
 -> Option variables and OptionDialogBox for changing them.
*/

#include "options.h"

#define DLG_WIDTH 250
#define DLG_HEIGHT 150

#define ID_CHECK_BOX    100
#define ID_EDIT_TEXT    200

int Option1=0;
int Option2=FALSE;
int Option3=0;


DEFINE_RESPONSE_TABLE(OptionDlg,TabWin)
   E_BUTTONUP(ID_OK,CmOK)
   E_BUTTONUP(ID_CANCEL,CmCancel)
   E_BUTTONUP(ID_SYSBOX,CmCancel)
END_RESPONSE_TABLE

OptionDlg::OptionDlg()
   :TabWin(NULL,"Demonstration Options",(VideoData.width-DLG_WIDTH)/2,(VideoData.height-DLG_HEIGHT)/2,
      (VideoData.width+DLG_WIDTH)/2,(VideoData.height+DLG_HEIGHT)/2,WA_VISABLE | WA_BORDER | WA_CAPTION | WA_SYSBOX | WA_SAVEAREA)
   ,isOK(FALSE)
{
   char temp[100];

   option1=new RadioButtonContainer(this,4+BORDER_WIDTH,4+CAPTION_HEIGHT+BORDER_WIDTH,246-BORDER_WIDTH,CAPTION_HEIGHT+BORDER_WIDTH+11+SysFont->height*3,RADIO_TYPE_DIP);
   option1->AddButton("&First selection",0);
   option1->AddButton("&Second selection",1);
   option1->AddButton("&Third selection",2);
   option1->SelectButton(Option1);
   option2=new CheckBox(this,ID_CHECK_BOX,"&Check box option",4+BORDER_WIDTH,64+CAPTION_HEIGHT+BORDER_WIDTH,150,Option2);
   option3=new EditText(this,ID_EDIT_TEXT,"&Number",10,4+BORDER_WIDTH,80+CAPTION_HEIGHT+BORDER_WIDTH,100,EDIT_TYPE_NUMBER);
   option3->SetText(itoa(Option3,temp,10));
   OK=new TextButton(this,ID_OK,184,95,244,97+SysFontBold->height,"&OK");
   Cancel=new TextButton(this,ID_CANCEL,184,124,244,124+SysFontBold->height,"&Cancel");
   AddTabStop(option1);
   AddTabStop(option2);
   AddTabStop(option3);
   AddTabStop(OK);
   AddTabStop(Cancel);
}

OptionDlg::~OptionDlg()
{
   delete Cancel;
   delete OK;
   delete option1;
   delete option2;
   delete option3;
}

void
OptionDlg::Run()
{
   Paint();
   RefreshWindow();
   SetFocus(OK);
   CatchMouse();
   CatchKeys();
   ws.RunEvents();
   ws.ResetEvents();
   ReleaseMouse();
   ReleaseKeys();
   if(isOK)
   {
      if(option2->isChecked())
         Option2=TRUE;
      else
         Option2=FALSE;
      Option1=option1->GetSelectedButton();
      Option3=atoi(option3->GetText());
   }
}

void
OptionDlg::CmOK()
{
   isOK=TRUE;
   ws.StopRunningEvents();
}

void
OptionDlg::CmCancel()
{
   isOK=FALSE;
   ws.StopRunningEvents();
}

