//  example7.cc - Demontrates	deadlock detection and message exchange.
//  Copyright (C) 1997 Paolo De Marino
//
//  This program is free software; you can redistribute it and/or modify
//  it freely; basically you can do whatever you want with it.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING. If not, write to the
//  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  For contacting the author send electronic mail to
//     paolodemarino@usa.net
//
//  Or paper mail to
//
//     Paolo De Marino
//     Via Donizetti 1/E
//     80127 Naples
//     Italy
#include <stdio.h>
#include <conio.h>
#include "lwp.h"
#include <dos.h>
#include <stdlib.h>
#include "threads.h"

class printThread : public Thread
{
public:
       printThread(unsigned stacksize) : Thread(stacksize) { };

       void execute(void)
       {
        char *theChar;

        while(1)
        {
         theChar = (char*) getMessage().Contents();
         printf("\"%s\" (%i Waiting)     \r",theChar,waitingMessages());
        }
       }
};

int main(int, char *[])
{
    InitLwp(RTC128);
    printf("Starting...\n");
    printf("Current Thread=%p\n",&Thread::currentThread());

    printThread myOwnThread(8192);

    myOwnThread.start();

    while(!kbhit())
    {
// We'll send messages so fast it won't be able to handle them!
     myOwnThread.postMessage("Good Morning!");
    }

    printf("\nMessages sent...\n");
    printf("\nChecking deadlock recognition...\n");
    myOwnThread.waitCompletion();

    DoneLwp();
    return 0;
}
