/***************************************************************************\
*									    *
*   EXCPT.H								    *
*									    *
*   C++ default exception handler					    *
*									    *
*   Wriiten by: 							    *
*    rainer@mathematik.uni-bielefeld.de 				    *
*									    *
\***************************************************************************/

#if !defined (_EXCPT_H)
#define _EXCPT_H

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(RC_INVOKED)

#define EXCEPTION_EXECUTE_HANDLER	 1
#define EXCEPTION_CONTINUE_SEARCH	 0
#define EXCEPTION_CONTINUE_EXECUTION	-1

typedef enum {
  ExceptionContinueExecution,
  ExceptionContinueSearch,
  ExceptionNestedException,
  ExceptionCollidedUnwind
} EXCEPTION_DISPOSITION;

struct _EXCEPTION_RECORD;
struct _CONTEXT;

EXCEPTION_DISPOSITION _except_handler
(
 struct _EXCEPTION_RECORD *ExceptionRecord,
 void * EstablisherFrame,
 struct _CONTEXT *ContextRecord,
 void * DispatcherContext
);

#if !defined(__cplusplus)
#define try			    __try
#define except			    __except
#define finally 		    __finally
#define leave			    __leave
#endif

#define GetExceptionCode	    *(unsigned long*)_exception_code
#define exception_code		    *(unsigned long*)_exception_code
#define GetExceptionInformation     (PEXCEPTION_POINTERS)_exception_info
#define exception_info		    (PEXCEPTION_POINTERS)_exception_info
#define AbnormalTermination	    _abnormal_termination
#define abnormal_termination	    _abnormal_termination

unsigned long _exception_code(void);
void * _exception_info(void);
int _abnormal_termination(void);

#endif /* RC_INVOKED */

#ifdef __cplusplus
}
#endif

#endif /* !defined (_EXCPT_H) */
