// Associated include file : Drivers/Time.H

#include "common/common.h"
#include "drivers/time.h"

#include <ctype.h>

// Local Vars

static char *DayInWeekStr[7] =
  { "sunday",   "monday", "tuesday", "wednesday",
    "thursday", "friday", "saturday" };

static char *ShortDayInWeekStr[7] =
  { "sun", "mon", "tue", "wed", "thu", "fri", "sat" };

static char *MonthStr[12] =
  { "january",   "feburary", "march",    "april",
    "may",       "june",     "july",     "august",
    "september", "october",  "november", "december" };

static char *ShortMonthStr[12] =
  { "jan", "feb", "mar", "apr", "may", "jun", "jul",
    "aug", "sep", "oct", "nov", "dec" };

// --- TTimeDate object

TTimeDate::TTimeDate()
{ // Get system Time
  time_t       Ts;
  time(&Ts);
  // Convert to TTimeDate datas
  SetFromSystemTime(Ts);
  // Init Formats with default values
  strcpy(TimeFormat,"HH:MM:SS");
  strcpy(DateFormat,"DT, MMT DD YY");
}

TTimeDate::TTimeDate(TTimeDate& T)
{ Second   =T.Second;
  Minute   =T.Minute;
  Hour     =T.Hour;
  DayInWeek=T.DayInWeek;
  Day      =T.Day;
  Month    =T.Month;
  Year     =T.Year;
  strcpy(TimeFormat,T.TimeFormat);
  strcpy(DateFormat,T.DateFormat);
}

void TTimeDate::SetTimeFormat(char *TF)
{ strcpy(TimeFormat,TF);
}

void TTimeDate::SetDateFormat(char *DF)
{ strcpy(DateFormat,DF);
}

void TTimeDate::WriteTime(char *Dest)
{ char *P=TimeFormat;
  char Tmp[20];
  *Dest=0;
  while(*P)
  { switch(toupper(*P))
    { case 'H' :
        P++;
        if (toupper(*P)=='H')
        { P++;
          sprintf(Tmp,"%02d",Hour);                        // HH format
        }
        else sprintf(Tmp,"%d",Hour);                       // H format
        break;
      case 'M' :
        P++;
        if (toupper(*P)=='M')
        { P++;
          sprintf(Tmp,"%02d",Minute);                      // MM format
        }
        else sprintf(Tmp,"%d",Minute);                     // M format
        break;
      case 'S' :
        P++;
        if (toupper(*P)=='S')
        { P++;
          sprintf(Tmp,"%02d",Second);                      // SS format
        }
        else sprintf(Tmp,"%d",Second);                     // S format
        break;
      default :
        Tmp[0]=*P;
        Tmp[1]=0;
        P++;
        break;
    }
    strcat(Dest,Tmp);
  }
}

void TTimeDate::WriteDate(char *Dest)
{ char *P=DateFormat;
  char Tmp[20];
  *Dest=0;
  while(*P)
  { switch(toupper(*P))
    { case 'D' :
        P++;
        switch(toupper(*P))
        { case 'T' :
            P++;
            strcpy(Tmp,ShortDayInWeekStr[DayInWeek]);      // DT format
            break;
          case 'D' :
            P++;
            if (toupper(*P)=='T')
            { P++;
              strcpy(Tmp,DayInWeekStr[DayInWeek]);         // DDT format
            }
            else sprintf(Tmp,"%02d",Day);                  // DD format
            break;
          default :
            sprintf(Tmp,"%d",Day);                         // D format
            break;
        }
        break;
      case 'M' :
        P++;
        switch(toupper(*P))
        { case 'T' :
            P++;
            strcpy(Tmp,ShortMonthStr[Month-1]);            // MT format
            break;
          case 'M' :
            P++;
            if (toupper(*P)=='T')
            { P++;
              strcpy(Tmp,MonthStr[Month-1]);               // MMT format
            }
            else sprintf(Tmp,"%02d",Month);                // MM format
            break;
          default :
            sprintf(Tmp,"%d",Month);                       // M format
            break;
        }
        break;
      case 'Y' :
        P++;
        if (toupper(*P)=='Y')
        { P++;
          sprintf(Tmp,"%04d",Year);                        // YY format
        }
        else sprintf(Tmp,"%02d",Year % 100);               // Y format
        break;
      case 'E' :
        P++;
        switch(Day)
        { case 1  : strcpy(Tmp,"st"); break;
          case 2  : strcpy(Tmp,"nd"); break;
          case 3  : strcpy(Tmp,"rd"); break;
          default : strcpy(Tmp,"th"); break;
        }
        break;
      default :
        Tmp[0]=*P;
        Tmp[1]=0;
        P++;
        break;
    }
    strcat(Dest,Tmp);
  }
}

void TTimeDate::SetFromSystemTime(time_t T)
{ struct tm   *Tm;
  Tm=localtime(&T);
  Second   =Tm->tm_sec;
  Minute   =Tm->tm_min;
  Hour     =Tm->tm_hour;
  DayInWeek=Tm->tm_wday;
  Day      =Tm->tm_mday;
  Month    =Tm->tm_mon+1;
  Year     =Tm->tm_year+1900;
}