// Associated include file : Graphics/StdWin.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// ----- TWindowFrameCorner

DEFINE(TWindowFrameCorner);

DEFINE_EVENTS_TABLE(TWindowFrameCorner,TZone)
  MOUSELDOWN()
END_EVENTS_TABLE

char *IdentTWindowFrameCorner = "TWindowFrameCorner";
short RegTWindowFrameCorner;

TWindowFrameCorner::TWindowFrameCorner()
{ Defaults();
}

TWindowFrameCorner::TWindowFrameCorner(int X, int Y, char *Descr, int NCurs,
                                       int _Number, int _Options)
{ Defaults();
  Init(X,Y,Descr,NCurs,_Number,_Options);
}

void TWindowFrameCorner::Defaults(void)
{ // Object Identification
  Register=RegTWindowFrameCorner;
  Ident=IdentTWindowFrameCorner;
  // Other default values
  Drawing=NULL;
}


void TWindowFrameCorner::Init(int X, int Y, char *Descr, int NCurs,
                              int _Number, int _Options)
{ // Herited creations
  TZone::Init(X,Y,10,10);
  // New creations
  SetOptions(_Options);
  Number=_Number;
  if (NCurs) MouseAspect=NCurs;
  if (Descr!=NULL) Drawing=new TSysIcone(10,10,Descr);
}

void TWindowFrameCorner::Done(void)
{ // Herited destructions
  TZone::Done();
  // New destructions
  if (Drawing!=NULL) delete Drawing;
}

void TWindowFrameCorner::Draw(TRect )
{ Drawing->Draw(Corner.X(),Corner.Y());
}

boolean TWindowFrameCorner::MouseLDown(TPoint Where, int )
{ if (GetStatus(sfMouseIn))
  { Father()->ChangeSize(Number,Where);
    return TRUE;
  }
  return FALSE;
}

// --- TStdWindow

DEFINE(TStdWindow);

DEFINE_EVENTS_TABLE(TStdWindow,TWindow)
  COMMAND(cmSelect,  doChangeSelect)
  COMMAND(cmUnSelect,doChangeSelect)
END_EVENTS_TABLE

short RegTStdWindow;
char *IdentTStdWindow = "TStdWindow";

TStdWindow::TStdWindow()
{ Defaults();
}

TStdWindow::TStdWindow(int X, int Y, int L, int H, char *Title, int Options)
{ Defaults();
  Init(X,Y,L,H,Title,Options);
}

TStdWindow::TStdWindow(TRect R, char *Title, int Options)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),Title,Options);
}

void TStdWindow::Defaults(void)
{ // Object Identification
  Register=RegTStdWindow;
  Ident=IdentTStdWindow;
  // Other default values
}

void TStdWindow::Init(int X, int Y, int L, int H, char *Title, int Options)
{ // Herited creations
  TWindow::Init(X,Y,L,H);
  // New creations
  TTitleBar *TitleBar;
  int        TitlePos=L-27;
  SetOptions(Options & (opWinSizeable | opWinCloseBox |
                        opWinMinimizeBox | opWinMaximizeBox));
  Inside.P1()+=TPoint(5,5);
  Inside.P2()-=TPoint(5,5);
  // Insert resize corner
  if (GetOptions(opWinSizeable))
  { Insert(new TWindowFrameCorner(0   ,0   ,ICO_Frame1,MouseCursorSize1,1,0));
    Insert(new TWindowFrameCorner(L-10,0   ,ICO_Frame2,MouseCursorSize2,2,opCSHiX | opCSLoX));
    Insert(new TWindowFrameCorner(L-10,H-10,ICO_Frame3,MouseCursorSize1,3,opCSAll));
    Insert(new TWindowFrameCorner(0   ,H-10,ICO_Frame4,MouseCursorSize2,4,opCSHiY | opCSLoY));
  }
  //
  TitleBar=new TTitleBar(Inside,Title);
  if (GetOptions(opWinCloseBox))
  { TitleBar->Insert(new TCloseBox(TitlePos,3,this));
    TitlePos-=17;
  }
  if (GetOptions(opWinMaximizeBox))
  { TitleBar->Insert(new TMaximizeBox(TitlePos,3,this));
    TitlePos-=17;
  }
  if (GetOptions(opWinMinimizeBox))
  { TitleBar->Insert(new TMinimizeBox(TitlePos,3,this));
    TitlePos-=17;
  }
  Insert(TitleBar);
}

// Graphics

void TStdWindow::Draw(TRect )
{ int Active=GetStatus(sfSelected);
  int L=Where.Width();
  int H=Where.Height();
  if (Active) SetSysColor(DarkGray);
         else SetSysColor(Black);
    Rectangle(2,2,L-3,H-3);
    Rectangle(3,3,L-4,H-4);
  SetSysColor(FaceGray);
    Bar(4,4,L-5,H-5);
}

boolean TStdWindow::doChangeSelect(void)
{ int L=Where.Width();
  int H=Where.Height();
  Invalidate(0,0,L-1,4);
  Invalidate(0,H-5,L-1,H-1);
  Invalidate(0,5,4,H-6);
  Invalidate(L-5,5,L-1,H-6);
  return FALSE;
}

void TStdWindow::ChangeSize(int CornerNo, TPoint mWhere)
{ //
  TEvent   Event;
  int      X1,Y1,X2,Y2;
  int      dX1,dY1,dX2,dY2;
  int      SX,SY,dX,dY;
  //,dXs,dYs;
  TRect    Rect;
  X1=Corner.X();
  Y1=Corner.Y();
  X2=X1+Where.Width()-1;
  Y2=Y1+Where.Height()-1;
  SX=MinimalSize.X();
  SY=MinimalSize.Y();
  switch(CornerNo)
  { case 1 :
		GrMouseWarp(X1,Y1);
		GrMouseSetLimits(0,0,X2-SX+1,Y2-SY+1);
		GrMouseSetCursorMode(GR_M_CUR_RUBBER,X2,Y2,NoSysColor[White]);
		break;
	 case 2 :
		GrMouseWarp(X2,Y1);
		GrMouseSetLimits(X1+SX-1,0,GrMaxX(),Y2-SY+1);
		GrMouseSetCursorMode(GR_M_CUR_RUBBER,X1,Y2,NoSysColor[White]);
		break;
	 case 3 :
		GrMouseWarp(X2,Y2);
		GrMouseSetLimits(X1+SX-1,Y1+SY-1,GrMaxX(),GrMaxY());
		GrMouseSetCursorMode(GR_M_CUR_RUBBER,X1,Y1,NoSysColor[White]);
      break;
    case 4 :
      GrMouseWarp(X1,Y2);
      GrMouseSetLimits(0,Y1+SY-1,X2-SX+1,GrMaxY());
		GrMouseSetCursorMode(GR_M_CUR_RUBBER,X2,Y1,NoSysColor[White]);
		break;
  }
  BeginDrag();
  do
  { GetEvent(&Event);
  } while(Event.What!=evMouseLUp);
  EndDrag();
  GrMouseSetCursorMode(GR_M_CUR_NORMAL);
  GrMouseSetLimits(0,0,GrMaxX(),GrMaxY());
  // Garde l'ancienne coordonne
  Rect=TRect(0,0,Where.Width()-1,Where.Height()-1)+Corner;
  // Change la taille et la position de la fentre
  dX=Event.Where.X()-mWhere.X();
  dY=Event.Where.Y()-mWhere.Y();
  if ((dX)||(dY))
  { dX1=0; dX2=0; dY1=0; dY2=0;
    switch(CornerNo)
    { case 1 : dX1=dX; dY1=dY; break;
      case 2 : dX2=dX; dY1=dY; break;
      case 3 : dX2=dX; dY2=dY; break;
      case 4 : dX1=dX; dY2=dY; break;
    }
    dX=-dX1+dX2;
    dY=-dY1+dY2;
    // Demande le retrac l'ancienne position/taille
    Invalidate();
    // Change la position/taille
    Where.P1()+=TPoint(dX1,dY1);
    Where.P2()+=TPoint(dX1,dY1);
    DoChangeSize(dX,dY);
    Desktop->CalculateClip();
    // Demande le retrac de la nouvelle position/taille
    Invalidate();
  }
}