/* Project SWORD
   V2.0

   SubSystem : Mathematical toolbox
   File      : LibSrc/ToolBox/Math/Math.CC
   Author    : Eric NICOLAS
   Overview  : General functions for Math toolbox initialization
   UpDate    : May 18, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <math.h>
#include "Common/Common.H"
#include "ToolBox/Math/Math.H"

static char *Messages[8]  =
       { "Acces to a vector out of its size",
			"Operations between vectors of different size",
			"Acces to a matrix out of its size",
			"Operations between matrixes of different size",
			"Operations with a vector of a wrong size",
			"Operation only possible on a square matrix",
			"Singular Matrix",
			"Impossible to factorise a constant"
		  };

static boolean ErrorMessages(char *Message)
{ int MessageNo;
  switch(Error)
  { case erVector_OutOfSize     : MessageNo=0; break;
    case erVector_MixingSizes   : MessageNo=1; break;
    case erMatrix_OutOfSize     : MessageNo=2; break;
    case erMatrix_MixingSizes   : MessageNo=3; break;
    case erMatrix_VectorSize    : MessageNo=4; break;
    case erMatrix_Rectangular   : MessageNo=5; break;
    case erMatrix_Singularity   : MessageNo=6; break;
    case erPoly_NoFactorisation : MessageNo=7; break;
    default:
      return FALSE;
  }
  strcpy(Message,Messages[MessageNo]);
  return TRUE;
}

void InitMath(void)
{ AddErrorHandler(ErrorMessages);
  InitEval();
}

void DoneMath(void)
{ DoneEval();
}
