/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Basic functions usefull for all the system
	File      : Include/Common/Error.H
	ErrNos    : 100..199
	Author    : Eric NICOLAS
	Overview  : Error management. Driver for showing errors in text mode.
	UpDate    : Feb 15, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _COMMON_ERROR_H_
#define _COMMON_ERROR_H_

// Common Errors constants

#define erNoError                0

#define erLowMemory              100
#define erDiskAccess_Open        110
#define erDiskAccess_Create      111
#define erDiskAccess_Read        112
#define erDiskAccess_Write       113
#define erDiskAccess_Close       114
#define erDiskAccess_Seek        115
#define erDiskAccess_EOF         116
#define erDiskAccess_LineTooLong 117
#define erNoMoreErrorHandlers    118

// Types

typedef boolean (*PErrorHandler)(char *Message);
typedef void    (*PErrorViewer)(void);

// Macros

#define SafeNew(a,b) { a=new b;                                            \
							  if (a==NULL) Error=erLowMemory;                     \
							}
#define SafeDelete(a) { if (a!=NULL) delete a; }

// Globals

extern int          Error;
extern PErrorViewer ErrorViewer;

// Init/Done for this file

void InitError(void);
void DoneError(void);

// Alloc/Free with common error handling

void *SafeMAlloc(int32 Size);
void  SafeFree(void **Block);

// Common error handling

void GetErrorMessage(char *Message);
void AddErrorHandler(PErrorHandler ErrorHandler);
void FatalError(void);

#endif // _COMMON_ERROR_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   15/02/96 :EN: First History remark
** ------------------------------------------------------------------------*/
