/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Screen graphics management
	File      : Include/Graphics/Zone.H
	Author    : Eric NICOLAS
	Overview  : TZone Object = a part of the screen
	UpDate    : Apr 08, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GRAPHICS_ZONE_H_
#define _GRAPHICS_ZONE_H_

// Defines

#define MouseCursorArrow      0
#define MouseCursorHand       1
#define MouseCursorSize1      2
#define MouseCursorSize2      3
#define MouseCursorButton     4
#define MouseCursorInactivity 5
#define MouseCursorText       6

//

#define wmREPLACE 0
#define wmXOR		1
#define wmOR		2
#define wmAND		3

struct TZone;

extern short     RegTZone;
extern char     *IdentTZone;
extern TRect     NoClip;
extern TZone    *MouseActiveZone;
extern char      CurrentMouseAspect;
extern GrCursor *CurMouse[7];

class TZone : public TObject
{ DECLARE(TZone);
  public:
    TRect        Where;
    TPoint       Corner;
    TColor       Color;
    TColor       ColorAddition;
    int          DrawStatus;
    int          MouseAspect;
    TRect        Inside;
  protected:
    // Clipping rectangles in local coordinates space
    TScreenZone *ClipSons;   // Clipping of the sons
    TScreenZone *Clipping;   // Clipping of others than the sons
  public:
  // Public Constructors
          TZone();
          TZone(int X, int Y, int L, int H);
          TZone(TRect R);
  // Creation / Destruction
          void     Defaults(void);
 	       void     Init(int X, int Y, int L, int H);
			 void     Done(void);
  virtual void     InitAfterInsert(void);
  // Graphics
  virtual void     Draw(TRect Clip);
  virtual void     Invalidate(TRect What);
  virtual void     Invalidate(int X1, int Y1, int X2, int Y2);
  virtual void     Invalidate(void);
  virtual void     DoDraw(TRect Clip);
  virtual void     BecomeActiveZone(void);
  virtual void     LeaveActiveZone(void);
  virtual void     ShowDrawingNow(void);
          void     DrawBegin(void);
	       void     DrawEnd(void);
  virtual void     MakeGlobal(TPoint Src, TPoint& Dest);
  virtual void     MakeLocal(TPoint Src, TPoint& Dest);
          void     PutPixel(int X, int Y);
          void     Bar(int X1, int Y1, int X2, int Y2);
	       void     Bar(TRect R);
	       void     Rectangle(int X1, int Y1, int X2, int Y2);
	       void     LineX(int X1, int Y1, int X2);
	       void     LineY(int X1, int Y1, int Y2);
	       void     Line(int X1, int Y1, int X2, int Y2);
          int      Frame3D(int Down);
          int      Frame3D(int Down, int X1, int Y1, int X2, int Y2);
	       void     PutStr(int X, int Y, char *Text, TFont *Font);
          void     PutChar(int X, int Y, char Ch, TFont *Font);
          void     PutSysStr(int X, int Y, char *Text, TFont *Font);
	       void     SetSysColor(int C);
	       void     SetColor(int C);
          void     SetWriteMode(int WM);
  // Linked list with TZone objects
          TZone*   First(void);
          TZone*   Last(void);
          TZone*   Next(void);
          TZone*   Previous(void);
          TZone*   Father(void);
          TZone*   Son(void);
  // Gestion du Clip
          void     ResetClip();
  virtual void     CalculateClip();
  virtual void     GetClipRect(TRect& R);
          void     ClipWithRect(TScreenZone *Clip, TRect R);
  // Objects stream
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
  // Events management
  virtual boolean  MouseTest(TPoint Where, int Buttons);
  // Others
  virtual void     ShrinkInside(TRect& InsideFather);
  virtual void     Insert(TAtom *A);
  virtual void     UnLink(void);
  virtual void     DoChangeSize(int dX, int dY);
  virtual void     SizeChanged(void);
  DECLARE_EVENTS_TABLE;
};

void ChangeMouseAspect(int MouseAspect);
void RestoreMouseAspect(void);

// Inline functions

inline void TZone::Bar(TRect R)
{ Bar(R.X1(), R.Y1(), R.X2(), R.Y2());
}

inline TZone* TZone::First(void)
{ return (TZone*)(TObject::First());
}

inline TZone* TZone::Last(void)
{ return (TZone*)(TObject::Last());
}

inline TZone* TZone::Next(void)
{ return (TZone*)(TObject::Next());
}

inline TZone* TZone::Previous(void)
{ return (TZone*)(TObject::Previous());
}

inline TZone* TZone::Son(void)
{ return (TZone*)(TObject::Son());
}

inline TZone* TZone::Father(void)
{ return (TZone*)(TObject::Father());
}

inline void TZone::Invalidate(int X1, int Y1, int X2, int Y2)
{ Invalidate(TRect(X1,Y1,X2,Y2));
}

inline void TZone::Invalidate()
{ Invalidate(TRect(0,0,Where.Width()-1,Where.Height()-1));
}

#endif // _GRAPHICS_ZONE_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   28/02/96 :EN: A step to a good model of Creating/Destructing objects
**   03/03/96 :EN: Changing color scheme so that it can be user-modified
**   04/04/96 :EN: Adding SetColor()
**   08/04/96 :EN: Adding DEFINE_EVENTS... macros
** ------------------------------------------------------------------------*/
