#include <stdio.h>
#include <go32.h>
#include "elib.h"

typedef unsigned char byte;

static byte hour = 0;
static unsigned long date = 0;

static unsigned long get_time ()
{
  unsigned long time;
  disable();
  dosmemget(0x46C,4,&time);
  enable();
  return time;
}

unsigned long set_timeout( unsigned short seconds )
{
  return get_time() + date + (1165 * (unsigned long)seconds) / 64;
}

unsigned long set_ttimeout( unsigned long ticks )
{
  return get_time() + date + ticks;
}

int chk_timeout( unsigned long timeout )
{
  unsigned long time;
  time = get_time();
  if ( ((byte *)(&time))[2] != hour )
  {
    if ( ((byte *)(&time))[2] < hour ) 
      date += 0x1800B0;
    hour = ((byte *)(&time))[2];
  }
  time += date;
  return (time > timeout);
}

char* itoa (int val, char *buf, int radix)
{
  char *i,*j;

  if (val == 0)
  {
    buf[0] = '0';
    buf[1] = 0;
    return buf;
  }

  i = buf;
  if (val<0)
  {
    *i++ = '-';
    val = -val;
  }    
  j = i;
  while (val != 0)
  {
    char ch = val % radix;
    val = val / radix;
    if (ch >= 10)
      ch += 'a' - 10;
    else
      ch += '0';
    *i++ = ch;
  }
  *i-- = 0;

  while (i > j)
  {
    char ch = *i;
    *i-- = *j;
    *j++ = ch;
  }
  return buf;
}

void outch( char ch )
{
  fprintf(stderr,"%c",ch);
}

void outs( char *s)
{
  fprintf(stderr,"%s",s);
}

void outhex( char ch )
{
  fprintf(stderr,"%01X",(int) ch);
}

void outhexes( char *ch, int n )
{
  while (n--)
    outhex(*ch++);
}
