awk

NNAAMMEE
       awk - pattern-directed scanning and processing language

SSYYNNOOPPSSIISS
       aawwkk  [ --FF _f_s ] [ --vv _v_a_r_=_v_a_l_u_e ] [ --mmrr_n ] [ --mmff_n ] [ _'_p_r_o_g_'
       | --ff _p_r_o_g_f_i_l_e ] [ _f_i_l_e _._._.  ]

DDEESSCCRRIIPPTTIIOONN
       _A_w_k scans each input _f_i_l_e for lines that match  any  of  a
       set  of  patterns specified literally in _p_r_o_g or in one or
       more files specified as --ff _p_r_o_g_f_i_l_e.   With  each  pattern
       there  can  be an associated action that will be performed
       when a line of a _f_i_l_e matches the pattern.  Each  line  is
       matched  against  the  pattern  portion  of every pattern-
       action statement; the associated action is  performed  for
       each  matched pattern.  The file name -- means the standard
       input.  Any _f_i_l_e of the form _v_a_r_=_v_a_l_u_e is  treated  as  an
       assignment, not a filename, and is executed at the time it
       would have been opened if it were a filename.  The  option
       --vv  followed  by  _v_a_r_=_v_a_l_u_e  is  an  assignment to be done
       before _p_r_o_g is executed; any number of --vv options  may  be
       present.  The --FF _f_s option defines the input field separa-
       tor to be the regular expression _f_s_.

       An input line is normally made up of fields  separated  by
       white  space, or by regular expression FFSS.  The fields are
       denoted $$11, $$22, ..., while $$00 refers to the  entire  line.
       If  FFSS is null, the input line is split into one field per
       character.

       To compensate for  inadequate  implementation  of  storage
       management,  the --mmrr option can be used to set the maximum
       size of the input record, and the --mmff option  to  set  the
       maximum number of fields.

       A pattern-action statement has the form

              _p_a_t_t_e_r_n {{ _a_c_t_i_o_n }}

       A  missing {{ _a_c_t_i_o_n }} means print the line; a missing pat-
       tern always matches.  Pattern-action statements are  sepa-
       rated by newlines or semicolons.

       An action is a sequence of statements.  A statement can be
       one of the following:

              iiff(( _e_x_p_r_e_s_s_i_o_n )) _s_t_a_t_e_m_e_n_t [ eellssee _s_t_a_t_e_m_e_n_t ]
              wwhhiillee(( _e_x_p_r_e_s_s_i_o_n )) _s_t_a_t_e_m_e_n_t
              ffoorr(( _e_x_p_r_e_s_s_i_o_n ;; _e_x_p_r_e_s_s_i_o_n ;; _e_x_p_r_e_s_s_i_o_n )) _s_t_a_t_e_m_e_n_t
              ffoorr(( _v_a_r iinn _a_r_r_a_y )) _s_t_a_t_e_m_e_n_t
              ddoo _s_t_a_t_e_m_e_n_t wwhhiillee(( _e_x_p_r_e_s_s_i_o_n ))
              bbrreeaakk
              ccoonnttiinnuuee
              {{ [ _s_t_a_t_e_m_e_n_t _._._. ] }}
              _e_x_p_r_e_s_s_i_o_n              ## commonly _v_a_r _= _e_x_p_r_e_s_s_i_o_n
              pprriinntt [ _e_x_p_r_e_s_s_i_o_n_-_l_i_s_t ] [ >> _e_x_p_r_e_s_s_i_o_n ]
              pprriinnttff _f_o_r_m_a_t [ ,, _e_x_p_r_e_s_s_i_o_n_-_l_i_s_t ] [ >> _e_x_p_r_e_s_s_i_o_n ]
              rreettuurrnn [ _e_x_p_r_e_s_s_i_o_n ]



                                                                1





AWK(1)                                                     AWK(1)


              nneexxtt                    ## skip remaining patterns on this input line
              nneexxttffiillee                ## skip rest of this file, open next, start at top
              ddeelleettee _a_r_r_a_y[[ _e_x_p_r_e_s_s_i_o_n ]]## delete an array element
              ddeelleettee _a_r_r_a_y            ## delete all elements of array
              eexxiitt [ _e_x_p_r_e_s_s_i_o_n ]     ## exit immediately; status is _e_x_p_r_e_s_s_i_o_n

       Statements are terminated by semicolons, newlines or right
       braces.   An  empty _e_x_p_r_e_s_s_i_o_n_-_l_i_s_t stands for $$00.  String
       constants are quoted "" "", with the usual C escapes  recog-
       nized  within.  Expressions take on string or numeric val-
       ues as appropriate, and are built using the operators ++  --
       **  // %% ^^ (exponentiation), and concatenation (indicated by
       white space).  The operators !! ++++ ---- ++== --== **== //== %%==  ^^==  >>
       >>== << <<== ==== !!== ??:: are also available in expressions.  Vari-
       ables may be scalars, array  elements  (denoted  _x[[_i]]_)  or
       fields.   Variables  are  initialized  to the null string.
       Array  subscripts  may  be  any  string,  not  necessarily
       numeric;  this  allows  for  a form of associative memory.
       Multiple subscripts such as  [[ii,,jj,,kk]]  are  permitted;  the
       constituents  are  concatenated, separated by the value of
       SSUUBBSSEEPP.

       The pprriinntt statement prints its arguments on  the  standard
       output (or on a file if >>_f_i_l_e or >>>>_f_i_l_e is present or on a
       pipe if ||_c_m_d is present), separated by the current  output
       field separator, and terminated by the output record sepa-
       rator.  _f_i_l_e and _c_m_d may be literal names or parenthesized
       expressions;  identical  string values in different state-
       ments denote the same open  file.   The  pprriinnttff  statement
       formats  its  expression list according to the format (see
       _p_r_i_n_t_f(3))_.  The built-in function cclloossee((_e_x_p_r)) closes  the
       file  or  pipe  _e_x_p_r.   The built-in function fffflluusshh((_e_x_p_r))
       flushes any buffered output for the file or pipe _e_x_p_r.

       The mathematical functions eexxpp, lloogg, ssqqrrtt, ssiinn,  ccooss,  and
       aattaann22 are built in.  Other built-in functions:

       lleennggtthh the length of its argument taken as a string, or of
              $$00 if no argument.

       rraanndd   random number on (0,1)

       ssrraanndd  sets seed for rraanndd and returns the previous seed.

       iinntt    truncates to an integer value

       ssuubbssttrr((_s,, _m,, _n))
              the _n-character substring of _s that begins at posi-
              tion _m counted from 1.

       iinnddeexx((_s,, _t))
              the  position  in _s where the string _t occurs, or 0
              if it does not.




                                                                2





AWK(1)                                                     AWK(1)


       mmaattcchh((_s,, _r))
              the position in _s where the  regular  expression  _r
              occurs,  or 0 if it does not.  The variables RRSSTTAARRTT
              and RRLLEENNGGTTHH are set to the position and  length  of
              the matched string.

       sspplliitt((_s,, _a,, _f_s))
              splits the string _s into array elements _a[[11]]_, _a[[22]]_,
              ..., _a[[_n]]_, and returns _n.  The separation  is  done
              with  the  regular  expression _f_s or with the field
              separator FFSS if _f_s is not given.  An  empty  string
              as field separator splits the string into one array
              element per character.

       ssuubb((_r,, _t,, _s))
              substitutes _t for the first occurrence of the regu-
              lar  expression  _r  in  the  string _s.  If _s is not
              given, $$00 is used.

       ggssuubb   same as ssuubb except that all occurrences of the reg-
              ular  expression  are replaced; ssuubb and ggssuubb return
              the number of replacements.

       sspprriinnttff((_f_m_t,, _e_x_p_r,, _._._. ))
              the  string  resulting  from  formatting  _e_x_p_r  _._._.
              according to the _p_r_i_n_t_f(3) format _f_m_t

       ssyysstteemm((_c_m_d))
              executes _c_m_d and returns its exit status

       ttoolloowweerr((_s_t_r))
              returns  a  copy of _s_t_r with all upper-case charac-
              ters translated to their  corresponding  lower-case
              equivalents.

       ttoouuppppeerr((_s_t_r))
              returns  a  copy of _s_t_r with all lower-case charac-
              ters translated to their  corresponding  upper-case
              equivalents.

       The  ``function'' ggeettlliinnee sets $$00 to the next input record
       from the current input file; ggeettlliinnee <<_f_i_l_e sets $$00 to  the
       next record from _f_i_l_e.  ggeettlliinnee _x sets variable _x instead.
       Finally, _c_m_d || ggeettlliinnee pipes the output of _c_m_d  into  ggeett--
       lliinnee; each call of ggeettlliinnee returns the next line of output
       from _c_m_d.  In all cases, ggeettlliinnee returns 1 for a  success-
       ful input, 0 for end of file, and -1 for an error.

       Patterns are arbitrary Boolean combinations (with !! |||| &&&&)
       of regular expressions and relational expressions.   Regu-
       lar  expressions  are  as in _e_g_r_e_p; see _g_r_e_p(1).  Isolated
       regular expressions in a pattern apply to the entire line.
       Regular  expressions  may also occur in relational expres-
       sions, using the operators ~~ and !!~~.  //_r_e// is  a  constant



                                                                3





AWK(1)                                                     AWK(1)


       regular  expression; any string (constant or variable) may
       be used as a regular expression, except in the position of
       an isolated regular expression in a pattern.

       A  pattern  may  consist  of  two  patterns separated by a
       comma; in this case, the action is performed for all lines
       from  an  occurrence of the first pattern though an occur-
       rence of the second.

       A relational expression is one of the following:

              _e_x_p_r_e_s_s_i_o_n _m_a_t_c_h_o_p _r_e_g_u_l_a_r_-_e_x_p_r_e_s_s_i_o_n
              _e_x_p_r_e_s_s_i_o_n _r_e_l_o_p _e_x_p_r_e_s_s_i_o_n
              _e_x_p_r_e_s_s_i_o_n iinn _a_r_r_a_y_-_n_a_m_e
              ((_e_x_p_r,,_e_x_p_r_,_._._.)) iinn _a_r_r_a_y_-_n_a_m_e

       where a relop is any of the six relational operators in C,
       and  a  matchop  is  either  ~~  (matches)  or !!~~ (does not
       match).  A conditional  is  an  arithmetic  expression,  a
       relational  expression, or a Boolean combination of these.

       The special patterns BBEEGGIINN and EENNDD may be used to  capture
       control  before the first input line is read and after the
       last.  BBEEGGIINN and EENNDD do not combine with other patterns.

       Variable names with special meanings:

       CCOONNVVFFMMTT
              conversion  format  used  when  converting  numbers
              (default %%..66gg)

       FFSS     regular  expression  used  to separate fields; also
              settable by option --FF_f_s_.

       NNFF     number of fields in the current record

       NNRR     ordinal number of the current record

       FFNNRR    ordinal number of the current record in the current
              file

       FFIILLEENNAAMMEE
              the name of the current input file

       RRSS     input record separator (default newline)

       OOFFSS    output field separator (default blank)

       OORRSS    output record separator (default newline)

       OOFFMMTT   output format for numbers (default %%..66gg)

       SSUUBBSSEEPP separates multiple subscripts (default 034)




                                                                4





AWK(1)                                                     AWK(1)


       AARRGGCC   argument count, assignable

       AARRGGVV   argument  array,  assignable;  non-null members are
              taken as filenames

       EENNVVIIRROONN
              array  of  environment  variables;  subscripts  are
              names.

       Functions  may  be  defined (at the position of a pattern-
       action statement) thus:

              ffuunnccttiioonn ffoooo((aa,, bb,, cc)) {{ ......;; rreettuurrnn xx }}

       Parameters are passed by value if scalar and by  reference
       if  array  name;  functions  may  be  called  recursively.
       Parameters are local to the function; all other  variables
       are  global.   Thus local variables may be created by pro-
       viding excess parameters in the function definition.

EEXXAAMMPPLLEESS
       lleennggtthh(($$00)) >> 7722
              Print lines longer than 72 characters.

       {{ pprriinntt $$22,, $$11 }}
              Print first two fields in opposite order.

       BBEEGGIINN {{ FFSS == "",,[[ \\tt]]**||[[ \\tt]]++"" }}
             {{ pprriinntt $$22,, $$11 }}
              Same, with input fields separated by  comma  and/or
              blanks and tabs.

            {{ ss ++== $$11 }}
       EENNDD  {{ pprriinntt ""ssuumm iiss"",, ss,, "" aavveerraaggee iiss"",, ss//NNRR }}
              Add up first column, print sum and average.

       //ssttaarrtt//,, //ssttoopp//
              Print all lines between start/stop pairs.

       BBEEGGIINN     {{    ## SSiimmuullaattee eecchhoo((11))
            ffoorr ((ii == 11;; ii << AARRGGCC;; ii++++)) pprriinnttff ""%%ss "",, AARRGGVV[[ii]]
            pprriinnttff ""\\nn""
            eexxiitt }}

SSEEEE AALLSSOO
       _l_e_x(1), _s_e_d(1)
       A. V. Aho, B. W. Kernighan, P. J. Weinberger, _T_h_e _A_W_K _P_r_o_-
       _g_r_a_m_m_i_n_g    _L_a_n_g_u_a_g_e_,    Addison-Wesley,    1988.     ISBN
       0-201-07981-X

BBUUGGSS
       There  are  no  explicit  conversions  between numbers and
       strings.  To force an expression to be treated as a number
       add  0  to  it;  to  force  it  to  be treated as a string



                                                                5





AWK(1)                                                     AWK(1)


       concatenate """" to it.
       The scope rules for variables in functions  are  a  botch;
       the syntax is worse.






















































                                                                6


