
#line	26	"awkgram.y"
#include <stdio.h>
#include <string.h>
#include "awk.h"

void checkdup(Node *list, Cell *item);
int yywrap(void) { return(1); }

Node	*beginloc = 0;
Node	*endloc = 0;
int	infunc	= 0;	/* = 1 if in arglist or body of func */
int	inloop	= 0;	/* = 1 if in while, for, do */
char	*curfname = 0;	/* current function name */
Node	*arglist = 0;	/* list of args for current function */

#line	41	"awkgram.y"
typedef union  {
	Node	*p;
	Cell	*cp;
	int	i;
	char	*s;
} YYSTYPE;
extern	int	yyerrflag;
#ifndef	YYMAXDEPTH
#define	YYMAXDEPTH	150
#endif
YYSTYPE	yylval;
YYSTYPE	yyval;
#define	FIRSTTOKEN	57346
#define	PROGRAM	57347
#define	PASTAT	57348
#define	PASTAT2	57349
#define	XBEGIN	57350
#define	XEND	57351
#define	NL	57352
#define	ARRAY	57353
#define	MATCH	57354
#define	NOTMATCH	57355
#define	MATCHOP	57356
#define	FINAL	57357
#define	DOT	57358
#define	ALL	57359
#define	CCL	57360
#define	NCCL	57361
#define	CHAR	57362
#define	OR	57363
#define	STAR	57364
#define	QUEST	57365
#define	PLUS	57366
#define	AND	57367
#define	BOR	57368
#define	APPEND	57369
#define	EQ	57370
#define	GE	57371
#define	GT	57372
#define	LE	57373
#define	LT	57374
#define	NE	57375
#define	IN	57376
#define	ARG	57377
#define	BLTIN	57378
#define	BREAK	57379
#define	CLOSE	57380
#define	CONTINUE	57381
#define	DELETE	57382
#define	DO	57383
#define	EXIT	57384
#define	FOR	57385
#define	FUNC	57386
#define	SUB	57387
#define	GSUB	57388
#define	IF	57389
#define	INDEX	57390
#define	LSUBSTR	57391
#define	MATCHFCN	57392
#define	NEXT	57393
#define	NEXTFILE	57394
#define	ADD	57395
#define	MINUS	57396
#define	MULT	57397
#define	DIVIDE	57398
#define	MOD	57399
#define	ASSIGN	57400
#define	ASGNOP	57401
#define	ADDEQ	57402
#define	SUBEQ	57403
#define	MULTEQ	57404
#define	DIVEQ	57405
#define	MODEQ	57406
#define	POWEQ	57407
#define	PRINT	57408
#define	PRINTF	57409
#define	SPRINTF	57410
#define	ELSE	57411
#define	INTEST	57412
#define	CONDEXPR	57413
#define	POSTINCR	57414
#define	PREINCR	57415
#define	POSTDECR	57416
#define	PREDECR	57417
#define	VAR	57418
#define	IVAR	57419
#define	VARNF	57420
#define	CALL	57421
#define	NUMBER	57422
#define	STRING	57423
#define	REGEXPR	57424
#define	GETLINE	57425
#define	RETURN	57426
#define	SPLIT	57427
#define	SUBSTR	57428
#define	WHILE	57429
#define	CAT	57430
#define	NOT	57431
#define	UMINUS	57432
#define	POWER	57433
#define	DECR	57434
#define	INCR	57435
#define	INDIRECT	57436
#define	LASTTOKEN	57437
#define YYEOFCODE 1
#define YYERRCODE 2

#line	444	"awkgram.y"


void setfname(Cell *p)
{
	if (isarr(p))
		ERROR "%s is an array, not a function", p->nval SYNTAX;
	else if (isfcn(p))
		ERROR "you can't define function %s more than once", p->nval SYNTAX;
	curfname = p->nval;
}

int constnode(Node *p)
{
	return isvalue(p) && ((Cell *) (p->narg[0]))->csub == CCON;
}

char *strnode(Node *p)
{
	return ((Cell *)(p->narg[0]))->sval;
}

Node *notnull(Node *n)
{
	switch (n->nobj) {
	case LE: case LT: case EQ: case NE: case GT: case GE:
	case BOR: case AND: case NOT:
		return n;
	default:
		return op2(NE, n, nullnode);
	}
}

void checkdup(Node *vl, Cell *cp)	/* check if name already in list */
{
	char *s = cp->nval;
	for ( ; vl; vl = vl->nnext) {
		if (strcmp(s, ((Cell *)(vl->narg[0]))->nval) == 0) {
			ERROR "duplicate argument %s", s SYNTAX;
			break;
		}
	}
}
short	yyexca[] =
{-1, 0,
	1, 28,
	8, 28,
	9, 28,
	12, 28,
	13, 28,
	16, 28,
	45, 28,
	46, 28,
	54, 28,
	55, 28,
	56, 28,
	58, 28,
	60, 28,
	78, 28,
	86, 28,
	87, 28,
	88, 28,
	89, 28,
	90, 28,
	91, 28,
	95, 28,
	97, 28,
	98, 28,
	101, 28,
	102, 28,
	105, 28,
	108, 28,
	109, 28,
	110, 28,
	-2, 0,
-1, 1,
	1, -1,
	-2, 0,
-1, 157,
	15, 30,
	-2, 0,
-1, 176,
	14, 0,
	24, 0,
	38, 0,
	39, 0,
	40, 0,
	41, 0,
	42, 0,
	43, 0,
	44, 0,
	-2, 63,
-1, 177,
	14, 0,
	24, 0,
	38, 0,
	39, 0,
	40, 0,
	41, 0,
	42, 0,
	43, 0,
	44, 0,
	-2, 64,
-1, 178,
	14, 0,
	24, 0,
	38, 0,
	39, 0,
	40, 0,
	41, 0,
	42, 0,
	43, 0,
	44, 0,
	-2, 65,
-1, 179,
	14, 0,
	24, 0,
	38, 0,
	39, 0,
	40, 0,
	41, 0,
	42, 0,
	43, 0,
	44, 0,
	-2, 66,
-1, 180,
	14, 0,
	24, 0,
	38, 0,
	39, 0,
	40, 0,
	41, 0,
	42, 0,
	43, 0,
	44, 0,
	-2, 67,
-1, 181,
	14, 0,
	24, 0,
	38, 0,
	39, 0,
	40, 0,
	41, 0,
	42, 0,
	43, 0,
	44, 0,
	-2, 68,
-1, 183,
	14, 0,
	24, 0,
	38, 0,
	39, 0,
	40, 0,
	41, 0,
	42, 0,
	43, 0,
	44, 0,
	-2, 70,
-1, 288,
	24, 0,
	44, 0,
	-2, 53,
-1, 332,
	17, 30,
	-2, 0,
-1, 354,
	17, 30,
	-2, 0,
};
#define	YYNPROD	184
#define	YYPRIVATE 57344
#define	YYLAST	4108
short	yyact[] =
{
  17, 137, 112,  66, 155, 228, 199,  24, 276, 124,
 185, 105,  42,  53, 253, 110, 100, 138, 243, 103,
 104, 307, 214, 102, 100, 249, 100, 100, 100,  42,
  62, 121, 122, 123,  82,  11, 223,  83, 313,   9,
  42,  50, 253,  79,  80, 110,  10, 252, 232,  42,
 205, 268, 244,  41,  22,  43, 113, 103, 104, 142,
 113, 146, 103, 104, 133, 149, 150, 152, 153, 190,
  41, 233,  43, 163, 234, 100, 148,  23, 315, 277,
  11,  41,  22,  43,  85, 275, 156, 190, 253, 132,
  41,  22,  43, 168, 169,  16, 257, 351, 134, 350,
 100, 182, 109, 111, 349,  23, 112, 100, 100, 100,
 100, 100, 100, 100,  23, 190, 190, 320, 317, 319,
 330, 334, 323,  42, 140, 100, 202, 204, 190, 139,
 107, 108, 109, 111, 277, 210, 112, 211,  86, 190,
 274, 190, 100, 219, 218, 283, 100, 221, 190, 190,
 190, 311, 100, 226, 264, 259, 258, 156, 170, 167,
 158, 230, 190, 100,  41, 216,  43, 157, 188, 130,
 140, 129, 100, 236, 100, 309, 100, 100, 100, 100,
 100, 100, 100,   3, 100,   6, 251, 100, 100,  47,
   7,   6, 154, 128,  48, 127,   7, 126, 125, 120,
  20, 100, 119,  51,  16, 140, 100, 273, 100, 100,
 100, 217, 143, 100, 100, 270,  96, 144, 131, 316,
   4, 346, 360, 363, 114,   1, 116, 117, 118,  49,
 269,  72, 100, 100, 100, 100, 163,  39, 163, 163,
 163, 163, 224,   5, 163,  58, 100, 238, 287,  67,
 222, 291,  61,  60, 292, 100, 100, 293, 248,  81,
   8, 159, 160,   2,   0,   0,   0,   0,   0, 299,
 300,   0,   0, 165,   0,  96,   0,   0,   0, 308,
   0,   0, 100,   0,   0, 100, 100, 100,   0, 100,
   0, 100, 156,   0, 312,   0, 100,   0, 100, 100,
 116, 239, 100,  54, 100, 100, 100,  96, 193, 194,
 195, 196, 197, 198, 332, 163,   0,   0,   0, 333,
   0,   0,  19,   0,   0, 206, 340, 156, 341,   0,
 339,   0, 100,   0,   0,   0, 230, 100, 345, 100,
   0,   0,  96, 100, 100,   0,  96, 337, 115, 354,
   0, 347,  96,   0, 355, 358,   0, 136, 230,   0,
 359, 162, 156, 242,   0, 147, 238,   0, 361, 238,
 238, 238,  96, 238,  96, 238,  96,  96,  96,  96,
  96,  96,  96,  21,  96,   0,   0,  96,  96,   0,
   0,   0,   0,   0,   0, 164,   0,   0,   0,   0,
   0,  96,   0,   0,   0,   0, 260,   0,  96,  96,
  96,   0,   0,  96,  96,   0,   0,   0,   0,   0,
 239, 238,   0, 239, 239, 239,   0, 239,   0, 239,
   0,   0,  96, 278, 279, 280, 165, 136, 165, 165,
 165, 165,   0,   0, 165,   0,  96,   0, 220,   0,
   0,   0, 136,   0,   0,  96,  96, 166, 227,   0,
   0, 256,  74,   0,   0,   0,   0,  15,   0,   0,
   0,   0, 136, 136,   0, 239,   0,   0, 184,   0,
   0, 106, 242,   0,   0, 242, 242, 242,   0, 242,
   0, 242,   0,   0,   0,   0,  96,   0,  96,  96,
   0,   0,  96,   0,  96,  96,  96,   0,   0,   0,
   0,   0,  15,   0,  15, 165,   0,   0,   0, 141,
   0,   0, 145,   0,   0,   0, 272,   0, 151,   0,
   0,   0,  96,   0,   0,   0,   0, 242,   0,  96,
   0, 229,   0,  96,  96,   0,   0, 171, 173, 175,
 176, 177, 178, 179, 180, 181, 183,   0, 164,   0,
 164, 164, 164, 164, 186, 187, 164, 189, 191,   0,
   0,   0,   0, 136,   0,   0, 200,   0,   0,   0,
   0,   0, 200, 200,   0,   0,   0,   0, 207, 208,
 209, 200, 212, 213,   0,   0,   0, 281,   0, 284,
 285, 286, 288,   0,   0, 290,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 231, 235,   0, 106, 289,   0,   0,   0,   0,
 245,   0,   0,   0,   0,   0, 296, 164,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 302,   0,   0,
 356, 136, 254,   0, 255, 140,   0,   0,  18, 310,
 139,  44,   0,   0, 362,   0,   0, 364,   0, 261,
 262, 263,   0, 265, 266, 267, 336,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  42,  28,   0,   0,   0,   0,   0, 335, 189,   0,
  45,  46,   0,  33,   0,  34,   0, 200,   0,   0,
 294,   0,   0, 295,   0,   0,   0,   0,   0, 297,
   0,   0,   0,  37, 298, 301,   0,   0, 303, 304,
 305,  41,  22,  43,  29,  35,  38,   0,   0,   0,
  32,   0,  36,  40,   0, 106,  27,  26,   0,   0,
  25,   0,   0,  30,  31,  23,   0,   0,   0,  75,
   0,   0,   0,   0, 322, 325, 327, 328,   0,  16,
  18, 331,  68,  44, 189, 357,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 338,   0,   0,   0,   0,
   0, 342,   0, 343,   0,   0,   0,   0,   0,   0,
   0,   0,  42,  28,  55,  56,  57,  73,  69,  59,
  70,   0,  45,  46,  71,  33,   0,  34,  63,  64,
   0,   0,   0,   0,   0,   0,   0,   0,  75,   0,
   0,   0,   0,  77,  78,  37,  52,   0,  16,  18,
   0,  68,  44,  41,  22,  43,  29,  35,  38,   0,
   0,   0,  32,  65,  36,  40,  76,   0,  27,  26,
   0,   0,  25,   0,   0,  30,  31,  23,   0,   0,
   0,  42,  28,  55,  56,  57,  73,  69,  59,  70,
   0,  45,  46,  71,  33,   0,  34,  63,  64,   0,
   0,   0,   0,   0,   0,  75,   0,   0,   0,   0,
   0,   0,  77,  78,  37,  16,  18,   0,  68,  44,
   0, 306,  41,  22,  43,  29,  35,  38,   0,   0,
   0,  32,  65,  36,  40,  76,   0,  27,  26,   0,
   0,  25,   0,   0,  30,  31,  23,   0,  42,  28,
  55,  56,  57,  73,  69,  59,  70,   0,  45,  46,
  71,  33,   0,  34,  63,  64,   0,   0,   0,   0,
   0,   0,   0,   0,  75,   0,   0,   0,   0,  77,
  78,  37, 271,   0,  16,  18,   0,  68,  44,  41,
  22,  43,  29,  35,  38,   0,   0,   0,  32,  65,
  36,  40,  76,   0,  27,  26,   0,   0,  25,   0,
   0,  30,  31,  23,   0,   0,   0,  42,  28,  55,
  56,  57,  73,  69,  59,  70,   0,  45,  46,  71,
  33,   0,  34,  63,  64,   0,   0,   0,   0,   0,
   0,  75,   0,   0,   0,   0,   0,   0,  77,  78,
  37,  16,  18,   0,  68,  44,   0, 247,  41,  22,
  43,  29,  35,  38,   0,   0,   0,  32,  65,  36,
  40,  76,   0,  27,  26,   0,   0,  25,   0,   0,
  30,  31,  23,   0,  42,  28,  55,  56,  57,  73,
  69,  59,  70,   0,  45,  46,  71,  33,   0,  34,
  63,  64,   0,   0,   0,   0,   0,   0,  75,   0,
   0,   0,   0,   0,   0,  77,  78,  37,  16,  18,
   0,  68,  44,   0, 246,  41,  22,  43,  29,  35,
  38,   0,   0,   0,  32,  65,  36,  40,  76,   0,
  27,  26,   0,   0,  25,   0,   0,  30,  31,  23,
   0,  42,  28,  55,  56,  57,  73,  69,  59,  70,
   0,  45,  46,  71,  33,   0,  34,  63,  64,   0,
   0,   0,   0,   0,   0,  75,   0,   0,   0,   0,
   0,   0,  77,  78,  37,  16,  18,   0,  68,  44,
   0, 225,  41,  22,  43,  29,  35,  38,   0,   0,
   0,  32,  65,  36,  40,  76,   0,  27,  26,   0,
   0,  25,   0,   0,  30,  31,  23,   0,  42,  28,
  55,  56,  57,  73,  69,  59,  70,   0,  45,  46,
  71,  33,   0,  34,  63,  64,   0,   0,   0,   0,
   0,   0,  75,   0,   0,   0,   0,   0,   0,  77,
  78,  37,  16,  18,   0,  68,  44,   0, 215,  41,
  22,  43,  29,  35,  38,   0,   0,   0,  32,  65,
  36,  40,  76,   0,  27,  26,   0,   0,  25,   0,
   0,  30,  31,  23,   0,  42,  28,  55,  56,  57,
  73,  69,  59,  70,   0,  45,  46,  71,  33,   0,
  34,  63,  64,   0,   0,   0,   0,   0,   0,  75,
   0,   0,   0,   0,   0,   0,  77,  78,  37,  16,
  18,   0,  68,  44,   0, 135,  41,  22,  43,  29,
  35,  38,   0,   0,   0,  32,  65,  36,  40,  76,
   0,  27,  26,   0,   0,  25,   0,   0,  30,  31,
  23,   0,  42,  28,  55,  56,  57,  73,  69,  59,
  70,   0,  45,  46,  71,  33,   0,  34,  63,  64,
   0,   0,   0,   0,   0,   0,  75,   0,   0,   0,
   0,   0,   0,  77,  78,  37,  16,  18,   0,  68,
  44,   0,   0,  41,  22,  43,  29,  35,  38,   0,
   0,   0,  32,  65,  36,  40,  76,   0,  27,  26,
   0,   0,  25,   0,   0,  30,  31,  23,   0,  42,
  28,  55,  56,  57,  73,  69,  59,  70,   0,  45,
  46,  71,  33,   0,  34,  63,  64,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  77,  78,  37,   0,   0,   0,   0,   0,   0,   0,
  41,  22,  43,  29,  35,  38,   0,   0,   0,  32,
  65,  36,  40,  76,   0,  27,  26,   0,   0,  25,
   0,   0,  30,  31,  23, 190,   0, 101,  95,   0,
   0, 329,   0,   0,   0,   0,   0,   0,  93,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  98,
  97,   0,  87,  88,  89,  90,  91,  92,  94,  42,
  28,   0,   0,   0,   0,   0,   0,   0,   0,  45,
  46,   0,  33,   0,  34,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  37,   0,   0,   0,   0,   0,   0,   0,
  41,  22,  43,  29,  35,  38,   0,  84,   0,  32,
   0,  36,  40,   0,   0,  27,  26,   0,   0,  99,
   0,   0,  30,  31,  23, 190,   0, 101,  95,   0,
   0, 326,   0,   0,   0,   0,   0,   0,  93,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  98,
  97,   0,  87,  88,  89,  90,  91,  92,  94,  42,
  28,   0,   0,   0,   0,   0,   0,   0,   0,  45,
  46,   0,  33,   0,  34,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  37,   0,   0,   0,   0,   0,   0,   0,
  41,  22,  43,  29,  35,  38,   0,  84,   0,  32,
   0,  36,  40,   0,   0,  27,  26,   0,   0,  99,
   0,   0,  30,  31,  23, 190,   0, 101,  95,   0,
   0, 324,   0,   0,   0,   0,   0,   0,  93,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  98,
  97,   0,  87,  88,  89,  90,  91,  92,  94,  42,
  28,   0,   0,   0,   0,   0,   0,   0,   0,  45,
  46,   0,  33,   0,  34,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  37,   0,   0,   0,   0,   0,   0,   0,
  41,  22,  43,  29,  35,  38,   0,  84,   0,  32,
   0,  36,  40,   0,   0,  27,  26,   0,   0,  99,
   0,   0,  30,  31,  23, 140,   0,   0, 101,  95,
 139,   0,   0,   0,   0,   0,   0,   0,   0,  93,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  98,  97,   0,  87,  88,  89,  90,  91,  92,  94,
  42,  28,   0,   0,   0,   0,   0,   0,   0,   0,
  45,  46,   0,  33,   0,  34,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  37,   0,   0,   0,   0,   0,   0,
   0,  41,  22,  43,  29,  35,  38,   0,  84,   0,
  32,   0,  36,  40,   0,   0,  27,  26,   0,   0,
  99,   0,   0,  30,  31,  23, 190,   0, 101,  95,
   0,   0, 192,   0,   0,   0,   0,   0,   0,  93,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  98,  97,   0,  87,  88,  89,  90,  91,  92,  94,
  42,  28,   0,   0,   0,   0,   0,   0,   0,   0,
  45,  46,   0,  33,   0,  34,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  37,   0,   0,   0,   0,   0,   0,
   0,  41,  22,  43,  29,  35,  38,   0,  84,   0,
  32,   0,  36,  40,   0,   0,  27,  26, 101,  95,
  99,   0, 353,  30,  31,  23,   0,   0,   0,  93,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  98,  97,   0,  87,  88,  89,  90,  91,  92,  94,
  42,  28,   0,   0,   0,   0,   0,   0,   0,   0,
  45,  46,   0,  33,   0,  34,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  37,   0,   0,   0,   0,   0,   0,
   0,  41,  22,  43,  29,  35,  38,   0,  84,   0,
  32,   0,  36,  40,   0,   0,  27,  26, 101,  95,
  99,   0, 352,  30,  31,  23,   0,   0,   0,  93,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  98,  97,   0,  87,  88,  89,  90,  91,  92,  94,
  42,  28,   0,   0,   0,   0,   0,   0,   0,   0,
  45,  46,   0,  33,   0,  34,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  37,   0,   0,   0,   0,   0,   0,
   0,  41,  22,  43,  29,  35,  38,   0,  84,   0,
  32,   0,  36,  40,   0,   0,  27,  26, 101,  95,
  99,   0, 348,  30,  31,  23,   0,   0,   0,  93,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  98,  97,   0,  87,  88,  89,  90,  91,  92,  94,
  42,  28,   0,   0,   0,   0,   0,   0,   0,   0,
  45,  46,   0,  33,   0,  34,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  37,   0,   0,   0,   0,   0,   0,
   0,  41,  22,  43,  29,  35,  38,   0,  84,   0,
  32,   0,  36,  40,   0,   0,  27,  26,   0,   0,
  99,   0,   0,  30,  31,  23, 101,  95, 344,   0,
   0,   0,   0,   0,   0,   0,   0,  93,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  98,  97,
   0,  87,  88,  89,  90,  91,  92,  94,  42,  28,
   0,   0,   0,   0,   0,   0,   0,   0,  45,  46,
   0,  33,   0,  34,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  37,   0,   0,   0,   0,   0,   0,   0,  41,
  22,  43,  29,  35,  38,   0,  84,   0,  32,   0,
  36,  40,   0,   0,  27,  26, 101,  95,  99,   0,
 321,  30,  31,  23,   0,   0,   0,  93,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  98,  97,
   0,  87,  88,  89,  90,  91,  92,  94,  42,  28,
   0,   0,   0,   0,   0,   0,   0,   0,  45,  46,
   0,  33,   0,  34,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  37,   0,   0,   0,   0,   0,   0,   0,  41,
  22,  43,  29,  35,  38,   0,  84,   0,  32,   0,
  36,  40,   0,   0,  27,  26, 101,  95,  99,   0,
 318,  30,  31,  23,   0,   0,   0,  93,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  98,  97,
   0,  87,  88,  89,  90,  91,  92,  94,  42,  28,
   0,   0,   0,   0,   0,   0,   0,   0,  45,  46,
   0,  33,   0,  34,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  37,   0,   0,   0,   0,   0,   0,   0,  41,
  22,  43,  29,  35,  38,   0,  84,   0,  32,   0,
  36,  40,   0,   0,  27,  26, 101,  95,  99,   0,
 277,  30,  31,  23,   0,   0,   0,  93,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  98,  97,
   0,  87,  88,  89,  90,  91,  92,  94,  42,  28,
   0,   0,   0,   0,   0,   0,   0,   0,  45,  46,
   0,  33,   0,  34,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  37,   0,   0,   0,   0,   0,   0,   0,  41,
  22,  43,  29,  35,  38,   0,  84,   0,  32,   0,
  36,  40,   0,   0,  27,  26,   0, 190,  99, 101,
  95,  30,  31,  23,   0,   0,   0,   0,   0,   0,
  93,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  98,  97,   0,  87,  88,  89,  90,  91,  92,
  94,  42,  28,   0,   0,   0,   0,   0,   0,   0,
   0,  45,  46,   0,  33,   0,  34,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  37,   0,   0,   0,   0,   0,
   0,   0,  41,  22,  43,  29,  35,  38,   0,  84,
   0,  32,   0,  36,  40,   0,   0,  27,  26, 101,
  95,  99,   0, 192,  30,  31,  23,   0,   0,   0,
  93,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  98,  97,   0,  87,  88,  89,  90,  91,  92,
  94,  42,  28,   0,   0,   0,   0,   0,   0,   0,
   0,  45,  46,   0,  33,   0,  34,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  37,   0,   0,   0,   0,   0,
   0,   0,  41,  22,  43,  29,  35,  38,   0,  84,
   0,  32,   0,  36,  40,   0,   0,  27,  26, 101,
  95,  99,   0,   0,  30,  31,  23,   0,   0,   0,
  93,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  98,  97,   0,  87,  88,  89,  90,  91,  92,
  94,  42,  28,   0,   0,   0,   0,   0,   0,   0,
   0,  45,  46,   0,  33,   0,  34,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  37,   0,   0,   0,   0,   0,
   0,   0,  41,  22,  43,  29,  35,  38,   0,  84,
 250,  32,   0,  36,  40,   0,   0,  27,  26, 101,
  95,  99,   0,   0,  30,  31,  23,   0,   0,   0,
  93,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  98,  97,   0,  87,  88,  89,  90,  91,  92,
  94,  42,  28,   0,   0,   0,   0,   0,   0,   0,
   0,  45,  46,   0,  33,   0,  34,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  37,   0,   0,   0,   0,   0,
   0,   0,  41,  22,  43,  29,  35,  38,   0,  84,
   0,  32,   0,  36,  40,   0,   0,  27,  26, 101,
  95,  99,   0,   0,  30,  31,  23,   0,   0,   0,
  93,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  98,   0,   0,  87,  88,  89,  90,  91,  92,
  94,  42,  28,   0,   0,   0,   0,   0,   0,   0,
   0,  45,  46,   0,  33,   0,  34,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  37,   0,   0,   0,   0,   0,
   0,   0,  41,  22,  43,  29,  35,  38, 101,  95,
   0,  32,   0,  36,  40,   0,   0,  27,  26,  93,
   0,  99,   0,   0,  30,  31,  23,   0,   0,   0,
   0,   0,   0,  87,  88,  89,  90,  91,  92,  94,
  42,  28,   0,   0,   0,   0,   0,   0,   0,   0,
  45,  46,   0,  33,   0,  34,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  37,   0,   0, 101,   0,   0,   0,
   0,  41,  22,  43,  29,  35,  38, 240,   0,   0,
  32,   0,  36,  40,   0,   0,  27,  26,  98,  97,
  99,   0,   0,  30,  31,  23,   0, 241,  42,  28,
   0,   0,   0,   0,   0,   0,   0,   0,  45,  46,
   0,  33,   0,  34,   0,   0,  75,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  18,   0,   0,
  44,  37,   0,   0,   0,   0,   0,   0,   0,  41,
  22,  43,  29,  35,  38,   0, 237, 314,  32,   0,
  36,  40,   0,   0,  27,  26,   0,   0,  99,  42,
  28,  30,  31,  23,  73,   0,   0,   0,   0,  45,
  46,   0,  33,   0,  34,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  77,  78,  37,   0,   0, 101,   0,   0,   0,   0,
  41,  22,  43,  29,  35,  38, 240,   0,   0,  32,
   0,  36,  40,   0,   0,  27,  26,  98,  97,  25,
   0,   0,  30,  31,  23,   0, 241,  42,  28,   0,
   0,   0,   0,   0,   0,   0,   0,  45,  46,   0,
  33,   0,  34,   0,   0,   0,   0,   0,  12,  13,
   0,   0,  16,  18,   0,   0,  44,   0,   0,   0,
  37,   0,   0,   0,   0,   0,   0,   0,  41,  22,
  43,  29,  35,  38,   0, 237,   0,  32,   0,  36,
  40,   0,   0,  27,  26,  42,  28,  99,   0,   0,
  30,  31,  23,   0,  14,  45,  46,   0,  33,   0,
  34,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  37,   0,
   0, 101,   0,   0,   0,   0,  41,  22,  43,  29,
  35,  38, 240,   0,   0,  32,   0,  36,  40,   0,
   0,  27,  26,  98,   0,  25,   0,   0,  30,  31,
  23,   0, 241,  42,  28,   0,   0,   0,   0,   0,
   0,   0,   0,  45,  46,   0,  33,   0,  34,   0,
   0,   0,   0,   0,   0,   0, 253,   0,   0,  18,
   0,   0,  44,   0,   0,   0,  37,   0,   0,   0,
   0,   0,   0,   0,  41,  22,  43,  29,  35,  38,
   0,   0,   0,  32, 101,  36,  40,   0,   0,  27,
  26,  42,  28,  99,   0, 240,  30,  31,  23,   0,
   0,  45,  46,   0,  33,   0,  34,   0,   0,   0,
   0,   0,   0,   0,   0, 241,  42,  28,   0,   0,
   0,   0,   0,   0,  37,   0,  45,  46,   0,  33,
   0,  34,  41,  22,  43,  29,  35,  38,   0, 174,
   0,  32, 282,  36,  40,  44,   0,  27,  26,  37,
   0,  25,   0,   0,  30,  31,  23,  41,  22,  43,
  29,  35,  38,   0, 172,   0,  32, 282,  36,  40,
  44,   0,  27,  26,  42,  28,  99,   0,   0,  30,
  31,  23,   0,   0,  45,  46,   0,  33,   0,  34,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  42,
  28,   0,   0,   0,   0,   0,   0,  37,   0,  45,
  46,   0,  33,   0,  34,  41,  22,  43,  29,  35,
  38,   0, 253,   0,  32, 282,  36,  40,  44,   0,
  27,  26,  37,   0,  25,   0,   0,  30,  31,  23,
  41,  22,  43,  29,  35,  38,   0,   0,   0,  32,
  18,  36,  40,  44, 203,  27,  26,  42,  28,  25,
   0,   0,  30,  31,  23,   0,   0,  45,  46,   0,
  33,   0,  34,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  42,  28,   0,   0,   0,   0,   0,   0,
  37,   0,  45,  46,   0,  33,   0,  34,  41,  22,
  43,  29,  35,  38,   0,   0,   0,  32,  18,  36,
  40,  44, 201,  27,  26,  37,   0,  25,   0,   0,
  30,  31,  23,  41,  22,  43,  29,  35,  38,   0,
 174,   0,  32,  18,  36,  40,  44,   0,  27,  26,
  42,  28,  25,   0,   0,  30,  31,  23,   0,   0,
  45,  46,   0,  33,   0,  34,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  42,  28,   0,   0,   0,
   0,   0,   0,  37,   0,  45,  46,   0,  33,   0,
  34,  41,  22,  43,  29,  35,  38,   0, 172,   0,
  32,  18,  36,  40,  44,   0,  27,  26,  37,   0,
  25,   0,   0,  30,  31,  23,  41,  22,  43,  29,
  35,  38,   0,   0,   0,  32,  18,  36,  40,  44,
   0,  27,  26,  42,  28,  25,   0,   0,  30,  31,
  23,   0,   0,  45,  46,   0,  33,   0,  34,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  42,  28,
   0,   0,   0,   0,   0,   0,  37,   0,  45,  46,
   0,  33,   0,  34,  41,  22,  43,  29,  35,  38,
   0,   0,   0,  32, 282,  36,  40,  44,   0,  27,
  26,  37,   0,  25,   0,   0,  30,  31,  23,  41,
  22,  43,  29,  35,  38,   0,   0,   0,  32, 161,
  36,  40,  44,   0,  27,  26,  42,  28,  25,   0,
   0,  30,  31,  23,   0,   0,  45,  46,   0,  33,
   0,  34,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  42,  28,   0,   0,   0,   0,   0,   0,  37,
   0,  45,  46,   0,  33,   0,  34,  41,  22,  43,
  29,  35,  38,   0,   0,   0,  32, 101,  36,  40,
  44,   0,  27,  26,  37,   0,  25,   0,   0,  30,
  31,  23,  41,  22,  43,  29,  35,  38,   0,   0,
   0,  32, 101,  36,  40,   0,   0,  27,  26,  42,
  28,  25,   0,   0,  30,  31,  23,   0,   0,  45,
  46,   0,  33,   0,  34,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  42,  28,   0,   0,   0,   0,
   0,   0,  37,   0,  45,  46,   0,  33,   0,  34,
  41,  22,  43,  29,  35,  38,   0,   0,   0,  32,
 101,  36,  40,   0,   0,  27,  26,  37,   0,  25,
   0,   0,  30,  31,  23,  41,  22,  43,  29,  35,
  38,   0,   0,   0,  32,   0,  36,  40,   0,   0,
  27,  26,  42,  28,  99,   0,   0,  30,  31,  23,
   0,   0,  45,  46,   0,  33,   0,  34,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  37,   0,   0,   0,   0,
   0,   0,   0,  41,  22,  43,  29,  35,  38,   0,
   0,   0,   0,   0,  36,  40,   0,   0,  27,  26,
   0,   0,  99,   0,   0,  30,  31,  23
};
short	yypact[] =
{
 181,-1000,-1000,-1000,3290, 179,-1000,-1000, 175,-1000,
 192, 826,  83,  83, -52,2866,-1000, -46,3773,-1000,
  29,  37,-1000,3939,-1000,3914,3939,3939, 189, 186,
  -5,  -5, -33, 185, 184,-1000, 182, 180,-1000, 158,
 156,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,3290,
 826,3773,-1000,1297,-1000, 114,3773, 114, 202, 645,
-1000,1364, 826, 114, 114, 645, 114,-1000, 195,-1000,
 154, 147,3856, -16,2866,-1000, 146,-1000,-1000, 826,
 826, 145,-1000,-1000,3773,3748,3690,3773,3773,3773,
3773,3773,3773,3773, -16, -85,  29,-1000,-1000,3939,
 -89,3773,3773,-1000,-1000, 151,1865,3939,3939,3939,
3939,3939,3939,3773,-1000,-1000,-105,-105,-105,3665,
3607,-1000,-1000,   8,3939,3773,3773,3773,3773,3773,
3773, -70,-1000,1230,  83,-1000,-1000,-1000, 201, 195,
-1000,1765,-1000,-1000,1364,1765,-1000, -43,1163,-1000,
-1000,1765,-1000,-1000,1364,-1000, 201,3164,3773,  34,
 130,3773,3232, -51,-1000,  29,  33,3773,1096,1029,
 -61,2776,-1000,2956,-1000,3035,3997,3997,3997,3997,
3997,3997,-1000,3997,-1000,  -5,2686,2866,   3,3416,
-1000,3416,-1000,  -1,  -1,-105,-105,-105,-105,  76,
2866,-1000, 139,-1000, 138,3939,  29,2596,2596,2596,
 137, 130,2596,2596,  35,-1000, 826,-1000,-1000,-1000,
-1000,-1000, 962,-1000, 197,-1000,-1000,-1000, 125,  41,
-1000,2503,3939,3939,3939,3582, 128,3831,3524,3499,
3831, -16,  29,3831,3773,2503,-1000,-1000, 117,-1000,
3773,-1000, -16,-1000,2866,2866,3416,-1000,-1000,-1000,
  29,3416,3416,  78,-1000,3416,3416,3416,-1000, 893,
 -78,-1000,-1000,-1000, 160, -16, 141,-1000,  29,  29,
  29,3232,3773,  -6,3103,3358,3441,-1000,3997,-1000,
3232,  58, 141, 141,  32,2866,-1000,2866,2413, 102,
 100,2323, 105,1664,1564,1464,-1000, 107,3773, 195,
  62,-1000, 104, -16,3831,-1000,  83,-1000,-1000,-1000,
-1000,-1000,3416,-1000,-1000,   4,-1000,   4,3416,-1000,
3773,2233,3164, 141,  -6,-1000,3232, 826,2135,  87,
  82,  80,2045,1955, 195,  62,1364, 757,-1000,-1000,
-1000,-1000,-1000, 114,3164, 141,-1000,-1000,-1000,  62,
1364, 141,-1000,1364,-1000
};
short	yypgo[] =
{
   0, 263, 462, 361,  11, 262,   6, 261, 200, 322,
  46,  39, 260,   7,   3,   5, 303,  13,   0, 383,
 259, 258, 253, 252, 250, 249, 245,   1, 243, 220,
  30, 242,   8, 461,  17,   4, 138,  84, 237, 231,
 225, 223, 222, 221, 219, 218, 217, 215, 192
};
short	yyr1[] =
{
   0,  40,  40,  36,  36,  37,  37,  33,  33,  26,
  26,  24,  24,  41,  22,  42,  22,  43,  22,  20,
  20,  23,  30,  30,  34,  34,  35,  35,  29,  29,
  15,  15,   1,   1,  10,  11,  11,  11,  11,  11,
  11,  11,  44,  11,  12,  12,   6,   6,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   4,   4,
   5,   5,   7,   7,   7,  39,  39,  28,  28,  28,
  28,  31,  31,   9,   9,  45,  13,  32,  32,  14,
  14,  14,  14,  14,  14,  14,  14,  27,  27,  16,
  16,  16,  46,  47,  16,  16,  16,  16,  16,  16,
  16,  16,  16,  16,  16,  16,  48,  16,  16,  17,
  17,  38,  38,   8,   8,   8,   8,   8,   8,   8,
   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,
   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,
   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,
   8,   8,   8,  18,  18,  18,  18,  21,  21,  21,
  19,  19,  19,  25
};
short	yyr2[] =
{
   0,   1,   1,   1,   2,   1,   2,   1,   2,   1,
   2,   1,   2,   0,  12,   0,  10,   0,   8,   1,
   1,   4,   1,   2,   1,   2,   0,   1,   0,   1,
   0,   1,   1,   3,   1,   1,   4,   3,   6,   3,
   4,   4,   0,   9,   1,   3,   1,   3,   3,   5,
   3,   3,   3,   3,   3,   5,   2,   1,   1,   3,
   5,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   5,   4,   3,   2,   1,   1,   3,   3,
   1,   3,   0,   1,   3,   1,   1,   1,   1,   2,
   2,   1,   2,   1,   2,   0,   4,   1,   2,   4,
   4,   4,   2,   5,   2,   1,   1,   1,   2,   2,
   3,   2,   0,   0,   9,   3,   2,   1,   4,   2,
   3,   2,   2,   3,   2,   2,   0,   3,   2,   1,
   2,   1,   1,   3,   3,   3,   3,   3,   3,   2,
   2,   2,   3,   4,   1,   3,   4,   2,   2,   2,
   2,   4,   3,   2,   1,   6,   6,   3,   6,   6,
   1,   8,   8,   6,   4,   1,   6,   6,   8,   8,
   8,   6,   1,   1,   4,   1,   2,   0,   1,   3,
   1,   1,   1,   4
};
short	yychk[] =
{
-1000, -40,  -1,   2, -29, -28,  10,  15, -12, -11,
 -10, -30,   8,   9,  54,  -2,  12, -18,  13,  -9,
  -8, -19,  87, 110, -13, 105, 102, 101,  46,  89,
 108, 109,  95,  58,  60,  90,  97,  78,  91, -38,
  98,  86,  45,  88,  16,  55,  56,  10,  15, -29,
 -30,  11,  10, -17, -16,  47,  48,  49, -26,  52,
 -22, -23, -30,  61,  62,  96, -14, -25,  15,  51,
  53,  57, -39,  50,  -2,   2,  99,  76,  77, -30,
 -30, -20,  86,  89,  93, -37, -36,  38,  39,  40,
  41,  42,  43,  24,  44,  14,  -8,  36,  35, 105,
 -18,  13,  69, 108, 109,  -4,  -2, 101, 102, 103,
  16, 104, 107,  19,  -8,  -9,  -8,  -8,  -8,  13,
  13, -18, -18, -18,  42,  13,  13,  13,  13,  13,
  13, -45, -11, -17, -10,  18, -16, -27, -34,  15,
  10,  -2, -27,  10, -46,  -2, -27, -16, -17, -27,
 -27,  -2, -27, -27, -48, -35, -34,  13,  13,  -7,
  -5,  13,  -3, -18,  -9,  -8, -19,  13, -17, -17,
  13,  -2,  10,  -2,  10,  -2,  -2,  -2,  -2,  -2,
  -2,  -2, -13,  -2, -19,  95,  -2,  -2,  17, -33,
  11, -33,  17,  -8,  -8,  -8,  -8,  -8,  -8,  -6,
  -2,  17,  -6,  17,  -6,  42,  -8,  -2,  -2,  -2,
  -6, -13,  -2,  -2,  92,  18, -30,  10, -35, -27,
 -16, -27, -24,  79, -31,  18, -27, -16, -15, -19,
 -14,  -2,  14,  37,  40, -33,  -4,  93, -37, -36,
  24,  44,  -8,  69,  19,  -2,  18,  18, -21,  86,
  94, -18,  44,  10,  -2,  -2, -33,  20,  17,  17,
  -8, -33, -33, -33,  17, -33, -33, -33,  16, -17,
 -47,  10, -16,  10,  15,  44, -32,  17,  -8,  -8,
  -8,  -3,  13,  17,  -3,  -3,  -3, -13,  -3, -19,
  -3,  -6, -32, -32, -33,  -2, -19,  -2,  -2, -13,
 -13,  -2, -19,  -2,  -2,  -2,  18,  99, -35,  15,
 -19,  10,  -4,  44,  94,  20, -44,  86,  17,  17,
  17,  17, -33,  17,  17, -33,  17, -33, -33,  17,
  13,  -2, -35, -32,  17, -19,  -3, -30,  -2, -13,
 -18, -18,  -2,  -2,  15, -15, -43, -17,  17,  17,
  17,  17,  17,  17, -35, -32, -16,  18, -27, -15,
 -42, -32, -16, -41, -16
};
short	yydef[] =
{
  -2,  -2,   1,   2,  32,  29,  87,  88,  28,  44,
  35,   0,   0,   0,   0,  34,  22, 172,   0,  76,
  77, 173, 175,   0,  93,   0,   0,   0, 144,   0,
   0,   0, 154,   0,   0, 160,   0,   0, 165,   0,
   0, 180, 181, 182,  95, 131, 132,  89,  90,  33,
   0,   0,  23,   0, 129,   0,   0,   0, 112,   0,
 117,   0,   0,   0,   0,   0,   0, 126,  26,   9,
   0,   0,  82,   0, 105, 106,   0,  85,  86,   0,
   0,   0,  19,  20,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  75,   5,   3,   0,
 172,   0,   0, 149, 150,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 176,  94, 141, 139, 140,   0,
   0, 147, 148, 153,   0,   0,   0,   0,   0,   0,
   0,   0,  45,   0,  37,  39, 130, 109, 107,  26,
  24,   0, 111,  10,   0,   0, 116, 119,   0, 121,
 122,   0, 124, 125,   0, 128,  27,  -2,   0, 102,
  83,   0,  80, 172,  57,  58, 104,   0,   0,   0,
 177,   0,   6,  61,   4,  62,  -2,  -2,  -2,  -2,
  -2,  -2,  69,  -2,  71,  74,   0,  59,   0,   0,
   7,   0, 157, 133, 134, 135, 136, 137, 138,   0,
  46, 142,   0, 145,   0,   0, 152,   0,   0,   0,
   0,  93,   0,   0,   0,  36,   0,  25, 108, 110,
 113, 115,   0,  11, 120,  91, 123, 127,   0, 173,
  31,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  56,   0,   0,   0,  40,  41,   0, 178,
   0,  73,   0,   8,  79,  78,   0, 174, 143, 146,
 151,   0,   0,   0, 164,   0,   0,   0,  96,   0,
   0,  12, 118,  92,  26,   0,  21,  97,  99, 100,
 101,  81,   0,  84,   0,  50,  51,  52,  -2,  54,
  48,   0, 183,  42,   0,  60,  72,  47,   0,  93,
  93,   0,   0,   0,   0,   0,  38,   0,   0,  26,
   0,  98,   0,   0,   0, 103,   0, 179, 155, 156,
 158, 159,   0, 163, 166,   0, 167,   0,   0, 171,
   0,   0,  -2,  17,   0,  55,  49,   0,   0,  93,
   0,   0,   0,   0,  26,   0,   0,   0, 161, 162,
 168, 169, 170,   0,  -2,  15,  18,  43, 114,   0,
   0,  13,  16,   0,  14
};
short	yytok1[] =
{
   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 104,   0,   0,
  13,  17, 103, 101,  11, 102,   0,  16,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  94,  15,
   0,   0,   0,  93,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  19,   0,  20,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  12,  14,  18
};
short	yytok2[] =
{
   2,   3,   4,   5,   6,   7,   8,   9,  10,  21,
  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,
  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,
  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,
  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,
  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,
  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,
  92,  95,  96,  97,  98,  99, 100, 105, 106, 107,
 108, 109, 110, 111
};
long	yytok3[] =
{
   0
};
#define YYFLAG 		-1000
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define	yyclearin	yychar = -1
#define	yyerrok		yyerrflag = 0

#ifdef	yydebug
#include	"y.debug"
#else
#define	yydebug		0
char*	yytoknames[1];		/* for debugging */
char*	yystates[1];		/* for debugging */
#endif

/*	parser for yacc output	*/

int	yynerrs = 0;		/* number of errors */
int	yyerrflag = 0;		/* error recovery flag */

extern	int	fprint(int, char*, ...);
extern	int	sprint(char*, char*, ...);

char*
yytokname(int yyc)
{
	static char x[10];

	if(yyc > 0 && yyc <= sizeof(yytoknames)/sizeof(yytoknames[0]))
	if(yytoknames[yyc-1])
		return yytoknames[yyc-1];
	sprintf(x, "<%d>", yyc);
	return x;
}

char*
yystatname(int yys)
{
	static char x[10];

	if(yys >= 0 && yys < sizeof(yystates)/sizeof(yystates[0]))
	if(yystates[yys])
		return yystates[yys];
	sprintf(x, "<%d>\n", yys);
	return x;
}

long
yylex1(void)
{
	long yychar;
	long *t3p;
	int c;

	yychar = yylex();
	if(yychar <= 0) {
		c = yytok1[0];
		goto out;
	}
	if(yychar < sizeof(yytok1)/sizeof(yytok1[0])) {
		c = yytok1[yychar];
		goto out;
	}
	if(yychar >= YYPRIVATE)
		if(yychar < YYPRIVATE+sizeof(yytok2)/sizeof(yytok2[0])) {
			c = yytok2[yychar-YYPRIVATE];
			goto out;
		}
	for(t3p=yytok3;; t3p+=2) {
		c = t3p[0];
		if(c == yychar) {
			c = t3p[1];
			goto out;
		}
		if(c == 0)
			break;
	}
	c = 0;

out:
	if(c == 0)
		c = yytok2[1];	/* unknown char */
	if(yydebug >= 3)
		printf("lex %.4X %s\n", yychar, yytokname(c));
	return c;
}

int
yyparse(void)
{
	struct
	{
		YYSTYPE	yyv;
		int	yys;
	} yys[YYMAXDEPTH], *yyp, *yypt;
	short *yyxi;
	int yyj, yym, yystate, yyn, yyg;
	YYSTYPE save1, save2;
	int save3, save4;
	long yychar;

	save1 = yylval;
	save2 = yyval;
	save3 = yynerrs;
	save4 = yyerrflag;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyp = &yys[-1];
	goto yystack;

ret0:
	yyn = 0;
	goto ret;

ret1:
	yyn = 1;
	goto ret;

ret:
	yylval = save1;
	yyval = save2;
	yynerrs = save3;
	yyerrflag = save4;
	return yyn;

yystack:
	/* put a state and value onto the stack */
	if(yydebug >= 4)
		printf("char %s in %s", yytokname(yychar), yystatname(yystate));

	yyp++;
	if(yyp >= &yys[YYMAXDEPTH]) { 
		yyerror("yacc stack overflow"); 
		goto ret1; 
	}
	yyp->yys = yystate;
	yyp->yyv = yyval;

yynewstate:
	yyn = yypact[yystate];
	if(yyn <= YYFLAG)
		goto yydefault; /* simple state */
	if(yychar < 0)
		yychar = yylex1();
	yyn += yychar;
	if(yyn < 0 || yyn >= YYLAST)
		goto yydefault;
	yyn = yyact[yyn];
	if(yychk[yyn] == yychar) { /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if(yyerrflag > 0)
			yyerrflag--;
		goto yystack;
	}

yydefault:
	/* default state action */
	yyn = yydef[yystate];
	if(yyn == -2) {
		if(yychar < 0)
			yychar = yylex1();

		/* look through exception table */
		for(yyxi=yyexca;; yyxi+=2)
			if(yyxi[0] == -1 && yyxi[1] == yystate)
				break;
		for(yyxi += 2;; yyxi += 2) {
			yyn = yyxi[0];
			if(yyn < 0 || yyn == yychar)
				break;
		}
		yyn = yyxi[1];
		if(yyn < 0)
			goto ret0;
	}
	if(yyn == 0) {
		/* error ... attempt to resume parsing */
		switch(yyerrflag) {
		case 0:   /* brand new error */
			yyerror("syntax error");
			if(yydebug >= 1) {
				printf("%s", yystatname(yystate));
				printf("saw %s\n", yytokname(yychar));
			}
yyerrlab:
			yynerrs++;

		case 1:
		case 2: /* incompletely recovered error ... try again */
			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */
			while(yyp >= yys) {
				yyn = yypact[yyp->yys] + YYERRCODE;
				if(yyn >= 0 && yyn < YYLAST) {
					yystate = yyact[yyn];  /* simulate a shift of "error" */
					if(yychk[yystate] == YYERRCODE)
						goto yystack;
				}

				/* the current yyp has no shift onn "error", pop stack */
				if(yydebug >= 2)
					printf("error recovery pops state %d, uncovers %d\n",
						yyp->yys, (yyp-1)->yys );
				yyp--;
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1;

		case 3:  /* no shift yet; clobber input char */
			if(yydebug >= YYEOFCODE)
				printf("error recovery discards %s\n", yytokname(yychar));
			if(yychar == YYEOFCODE)
				goto ret1;
			yychar = -1;
			goto yynewstate;   /* try again in the same state */
		}
	}

	/* reduction by production yyn */
	if(yydebug >= 2)
		printf("reduce %d in:\n\t%s", yyn, yystatname(yystate));

	yypt = yyp;
	yyp -= yyr2[yyn];
	yyval = (yyp+1)->yyv;
	yym = yyn;

	/* consult goto table to find next state */
	yyn = yyr1[yyn];
	yyg = yypgo[yyn];
	yyj = yyg + yyp->yys + 1;

	if(yyj >= YYLAST || yychk[yystate=yyact[yyj]] != -yyn)
		yystate = yyact[yyg];
	switch(yym) {
		
case 1:
#line	98	"awkgram.y"
{ if (errorflag==0)
			winner = (Node *)stat3(PROGRAM, beginloc, yypt[-0].yyv.p, endloc); } break;
case 2:
#line	100	"awkgram.y"
{ yyclearin; bracecheck(); ERROR "bailing out" SYNTAX; } break;
case 13:
#line	124	"awkgram.y"
{inloop++;} break;
case 14:
#line	125	"awkgram.y"
{ --inloop; yyval.p = stat4(FOR, yypt[-9].yyv.p, notnull(yypt[-6].yyv.p), yypt[-3].yyv.p, yypt[-0].yyv.p); } break;
case 15:
#line	126	"awkgram.y"
{inloop++;} break;
case 16:
#line	127	"awkgram.y"
{ --inloop; yyval.p = stat4(FOR, yypt[-7].yyv.p, NIL, yypt[-3].yyv.p, yypt[-0].yyv.p); } break;
case 17:
#line	128	"awkgram.y"
{inloop++;} break;
case 18:
#line	129	"awkgram.y"
{ --inloop; yyval.p = stat3(IN, yypt[-5].yyv.p, makearr(yypt[-3].yyv.p), yypt[-0].yyv.p); } break;
case 19:
#line	133	"awkgram.y"
{ setfname(yypt[-0].yyv.cp); } break;
case 20:
#line	134	"awkgram.y"
{ setfname(yypt[-0].yyv.cp); } break;
case 21:
#line	138	"awkgram.y"
{ yyval.p = notnull(yypt[-1].yyv.p); } break;
case 26:
#line	150	"awkgram.y"
{ yyval.i = 0; } break;
case 28:
#line	155	"awkgram.y"
{ yyval.i = 0; } break;
case 30:
#line	161	"awkgram.y"
{ yyval.p = 0; } break;
case 32:
#line	166	"awkgram.y"
{ yyval.p = 0; } break;
case 33:
#line	167	"awkgram.y"
{ yyval.p = yypt[-1].yyv.p; } break;
case 34:
#line	171	"awkgram.y"
{ yyval.p = notnull(yypt[-0].yyv.p); } break;
case 35:
#line	175	"awkgram.y"
{ yyval.p = stat2(PASTAT, yypt[-0].yyv.p, stat2(PRINT, rectonode(), NIL)); } break;
case 36:
#line	176	"awkgram.y"
{ yyval.p = stat2(PASTAT, yypt[-3].yyv.p, yypt[-1].yyv.p); } break;
case 37:
#line	177	"awkgram.y"
{ yyval.p = pa2stat(yypt[-2].yyv.p, yypt[-0].yyv.p, stat2(PRINT, rectonode(), NIL)); } break;
case 38:
#line	178	"awkgram.y"
{ yyval.p = pa2stat(yypt[-5].yyv.p, yypt[-3].yyv.p, yypt[-1].yyv.p); } break;
case 39:
#line	179	"awkgram.y"
{ yyval.p = stat2(PASTAT, NIL, yypt[-1].yyv.p); } break;
case 40:
#line	181	"awkgram.y"
{ beginloc = linkum(beginloc, yypt[-1].yyv.p); yyval.p = 0; } break;
case 41:
#line	183	"awkgram.y"
{ endloc = linkum(endloc, yypt[-1].yyv.p); yyval.p = 0; } break;
case 42:
#line	184	"awkgram.y"
{infunc++;} break;
case 43:
#line	185	"awkgram.y"
{ infunc--; curfname=0; defn((Cell *)yypt[-7].yyv.p, yypt[-5].yyv.p, yypt[-1].yyv.p); yyval.p = 0; } break;
case 45:
#line	190	"awkgram.y"
{ yyval.p = linkum(yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 47:
#line	195	"awkgram.y"
{ yyval.p = linkum(yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 48:
#line	199	"awkgram.y"
{ yyval.p = op2(yypt[-1].yyv.i, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 49:
#line	201	"awkgram.y"
{ yyval.p = op3(CONDEXPR, notnull(yypt[-4].yyv.p), yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 50:
#line	203	"awkgram.y"
{ yyval.p = op2(BOR, notnull(yypt[-2].yyv.p), notnull(yypt[-0].yyv.p)); } break;
case 51:
#line	205	"awkgram.y"
{ yyval.p = op2(AND, notnull(yypt[-2].yyv.p), notnull(yypt[-0].yyv.p)); } break;
case 52:
#line	206	"awkgram.y"
{ yyval.p = op3(yypt[-1].yyv.i, NIL, yypt[-2].yyv.p, (Node*)makedfa(yypt[-0].yyv.s, 0)); } break;
case 53:
#line	208	"awkgram.y"
{ if (constnode(yypt[-0].yyv.p))
			yyval.p = op3(yypt[-1].yyv.i, NIL, yypt[-2].yyv.p, (Node*)makedfa(strnode(yypt[-0].yyv.p), 0));
		  else
			yyval.p = op3(yypt[-1].yyv.i, (Node *)1, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 54:
#line	212	"awkgram.y"
{ yyval.p = op2(INTEST, yypt[-2].yyv.p, makearr(yypt[-0].yyv.p)); } break;
case 55:
#line	213	"awkgram.y"
{ yyval.p = op2(INTEST, yypt[-3].yyv.p, makearr(yypt[-0].yyv.p)); } break;
case 56:
#line	214	"awkgram.y"
{ yyval.p = op2(CAT, yypt[-1].yyv.p, yypt[-0].yyv.p); } break;
case 59:
#line	220	"awkgram.y"
{ yyval.p = op2(yypt[-1].yyv.i, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 60:
#line	222	"awkgram.y"
{ yyval.p = op3(CONDEXPR, notnull(yypt[-4].yyv.p), yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 61:
#line	224	"awkgram.y"
{ yyval.p = op2(BOR, notnull(yypt[-2].yyv.p), notnull(yypt[-0].yyv.p)); } break;
case 62:
#line	226	"awkgram.y"
{ yyval.p = op2(AND, notnull(yypt[-2].yyv.p), notnull(yypt[-0].yyv.p)); } break;
case 63:
#line	227	"awkgram.y"
{ yyval.p = op2(yypt[-1].yyv.i, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 64:
#line	228	"awkgram.y"
{ yyval.p = op2(yypt[-1].yyv.i, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 65:
#line	229	"awkgram.y"
{ yyval.p = op2(yypt[-1].yyv.i, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 66:
#line	230	"awkgram.y"
{ yyval.p = op2(yypt[-1].yyv.i, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 67:
#line	231	"awkgram.y"
{ yyval.p = op2(yypt[-1].yyv.i, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 68:
#line	232	"awkgram.y"
{ yyval.p = op2(yypt[-1].yyv.i, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 69:
#line	233	"awkgram.y"
{ yyval.p = op3(yypt[-1].yyv.i, NIL, yypt[-2].yyv.p, (Node*)makedfa(yypt[-0].yyv.s, 0)); } break;
case 70:
#line	235	"awkgram.y"
{ if (constnode(yypt[-0].yyv.p))
			yyval.p = op3(yypt[-1].yyv.i, NIL, yypt[-2].yyv.p, (Node*)makedfa(strnode(yypt[-0].yyv.p), 0));
		  else
			yyval.p = op3(yypt[-1].yyv.i, (Node *)1, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 71:
#line	239	"awkgram.y"
{ yyval.p = op2(INTEST, yypt[-2].yyv.p, makearr(yypt[-0].yyv.p)); } break;
case 72:
#line	240	"awkgram.y"
{ yyval.p = op2(INTEST, yypt[-3].yyv.p, makearr(yypt[-0].yyv.p)); } break;
case 73:
#line	241	"awkgram.y"
{ 
			if (safe) ERROR "cmd | getline is unsafe" SYNTAX;
			else yyval.p = op3(GETLINE, yypt[-0].yyv.p, (Node*)yypt[-2].yyv.i, yypt[-3].yyv.p); } break;
case 74:
#line	244	"awkgram.y"
{ 
			if (safe) ERROR "cmd | getline is unsafe" SYNTAX;
			else yyval.p = op3(GETLINE, (Node*)0, (Node*)yypt[-1].yyv.i, yypt[-2].yyv.p); } break;
case 75:
#line	247	"awkgram.y"
{ yyval.p = op2(CAT, yypt[-1].yyv.p, yypt[-0].yyv.p); } break;
case 78:
#line	253	"awkgram.y"
{ yyval.p = linkum(yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 79:
#line	254	"awkgram.y"
{ yyval.p = linkum(yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 81:
#line	259	"awkgram.y"
{ yyval.p = linkum(yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 82:
#line	263	"awkgram.y"
{ yyval.p = rectonode(); } break;
case 84:
#line	265	"awkgram.y"
{ yyval.p = yypt[-1].yyv.p; } break;
case 93:
#line	282	"awkgram.y"
{ yyval.p = op3(MATCH, NIL, rectonode(), (Node*)makedfa(yypt[-0].yyv.s, 0)); } break;
case 94:
#line	283	"awkgram.y"
{ yyval.p = op1(NOT, notnull(yypt[-0].yyv.p)); } break;
case 95:
#line	287	"awkgram.y"
{startreg();} break;
case 96:
#line	287	"awkgram.y"
{ yyval.s = yypt[-1].yyv.s; } break;
case 99:
#line	295	"awkgram.y"
{ 
			if (safe) ERROR "print | is unsafe" SYNTAX;
			else yyval.p = stat3(yypt[-3].yyv.i, yypt[-2].yyv.p, (Node *) yypt[-1].yyv.i, yypt[-0].yyv.p); } break;
case 100:
#line	298	"awkgram.y"
{
			if (safe) ERROR "print >> is unsafe" SYNTAX;
			else yyval.p = stat3(yypt[-3].yyv.i, yypt[-2].yyv.p, (Node *) yypt[-1].yyv.i, yypt[-0].yyv.p); } break;
case 101:
#line	301	"awkgram.y"
{
			if (safe) ERROR "print > is unsafe" SYNTAX;
			else yyval.p = stat3(yypt[-3].yyv.i, yypt[-2].yyv.p, (Node *) yypt[-1].yyv.i, yypt[-0].yyv.p); } break;
case 102:
#line	304	"awkgram.y"
{ yyval.p = stat3(yypt[-1].yyv.i, yypt[-0].yyv.p, NIL, NIL); } break;
case 103:
#line	305	"awkgram.y"
{ yyval.p = stat2(DELETE, makearr(yypt[-3].yyv.p), yypt[-1].yyv.p); } break;
case 104:
#line	306	"awkgram.y"
{ yyval.p = stat2(DELETE, makearr(yypt[-0].yyv.p), 0); } break;
case 105:
#line	307	"awkgram.y"
{ yyval.p = exptostat(yypt[-0].yyv.p); } break;
case 106:
#line	308	"awkgram.y"
{ yyclearin; ERROR "illegal statement" SYNTAX; } break;
case 109:
#line	317	"awkgram.y"
{ if (!inloop) ERROR "break illegal outside of loops" SYNTAX;
				  yyval.p = stat1(BREAK, NIL); } break;
case 110:
#line	319	"awkgram.y"
{ yyval.p = stat1(CLOSE, yypt[-1].yyv.p); } break;
case 111:
#line	320	"awkgram.y"
{  if (!inloop) ERROR "continue illegal outside of loops" SYNTAX;
				  yyval.p = stat1(CONTINUE, NIL); } break;
case 112:
#line	322	"awkgram.y"
{inloop++;} break;
case 113:
#line	322	"awkgram.y"
{--inloop;} break;
case 114:
#line	323	"awkgram.y"
{ yyval.p = stat2(DO, yypt[-6].yyv.p, notnull(yypt[-2].yyv.p)); } break;
case 115:
#line	324	"awkgram.y"
{ yyval.p = stat1(EXIT, yypt[-1].yyv.p); } break;
case 116:
#line	325	"awkgram.y"
{ yyval.p = stat1(EXIT, NIL); } break;
case 118:
#line	327	"awkgram.y"
{ yyval.p = stat3(IF, yypt[-3].yyv.p, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 119:
#line	328	"awkgram.y"
{ yyval.p = stat3(IF, yypt[-1].yyv.p, yypt[-0].yyv.p, NIL); } break;
case 120:
#line	329	"awkgram.y"
{ yyval.p = yypt[-1].yyv.p; } break;
case 121:
#line	330	"awkgram.y"
{ if (infunc)
				ERROR "next is illegal inside a function" SYNTAX;
			  yyval.p = stat1(NEXT, NIL); } break;
case 122:
#line	333	"awkgram.y"
{ if (infunc)
				ERROR "nextfile is illegal inside a function" SYNTAX;
			  yyval.p = stat1(NEXTFILE, NIL); } break;
case 123:
#line	336	"awkgram.y"
{ yyval.p = stat1(RETURN, yypt[-1].yyv.p); } break;
case 124:
#line	337	"awkgram.y"
{ yyval.p = stat1(RETURN, NIL); } break;
case 126:
#line	339	"awkgram.y"
{inloop++;} break;
case 127:
#line	339	"awkgram.y"
{ --inloop; yyval.p = stat2(WHILE, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 128:
#line	340	"awkgram.y"
{ yyval.p = 0; } break;
case 130:
#line	345	"awkgram.y"
{ yyval.p = linkum(yypt[-1].yyv.p, yypt[-0].yyv.p); } break;
case 133:
#line	353	"awkgram.y"
{ yyval.p = op2(ADD, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 134:
#line	354	"awkgram.y"
{ yyval.p = op2(MINUS, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 135:
#line	355	"awkgram.y"
{ yyval.p = op2(MULT, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 136:
#line	356	"awkgram.y"
{ yyval.p = op2(DIVIDE, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 137:
#line	357	"awkgram.y"
{ yyval.p = op2(MOD, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 138:
#line	358	"awkgram.y"
{ yyval.p = op2(POWER, yypt[-2].yyv.p, yypt[-0].yyv.p); } break;
case 139:
#line	359	"awkgram.y"
{ yyval.p = op1(UMINUS, yypt[-0].yyv.p); } break;
case 140:
#line	360	"awkgram.y"
{ yyval.p = yypt[-0].yyv.p; } break;
case 141:
#line	361	"awkgram.y"
{ yyval.p = op1(NOT, notnull(yypt[-0].yyv.p)); } break;
case 142:
#line	362	"awkgram.y"
{ yyval.p = op2(BLTIN, (Node *) yypt[-2].yyv.i, rectonode()); } break;
case 143:
#line	363	"awkgram.y"
{ yyval.p = op2(BLTIN, (Node *) yypt[-3].yyv.i, yypt[-1].yyv.p); } break;
case 144:
#line	364	"awkgram.y"
{ yyval.p = op2(BLTIN, (Node *) yypt[-0].yyv.i, rectonode()); } break;
case 145:
#line	365	"awkgram.y"
{ yyval.p = op2(CALL, celltonode(yypt[-2].yyv.cp,CVAR), NIL); } break;
case 146:
#line	366	"awkgram.y"
{ yyval.p = op2(CALL, celltonode(yypt[-3].yyv.cp,CVAR), yypt[-1].yyv.p); } break;
case 147:
#line	367	"awkgram.y"
{ yyval.p = op1(PREDECR, yypt[-0].yyv.p); } break;
case 148:
#line	368	"awkgram.y"
{ yyval.p = op1(PREINCR, yypt[-0].yyv.p); } break;
case 149:
#line	369	"awkgram.y"
{ yyval.p = op1(POSTDECR, yypt[-1].yyv.p); } break;
case 150:
#line	370	"awkgram.y"
{ yyval.p = op1(POSTINCR, yypt[-1].yyv.p); } break;
case 151:
#line	371	"awkgram.y"
{ yyval.p = op3(GETLINE, yypt[-2].yyv.p, (Node *)yypt[-1].yyv.i, yypt[-0].yyv.p); } break;
case 152:
#line	372	"awkgram.y"
{ yyval.p = op3(GETLINE, NIL, (Node *)yypt[-1].yyv.i, yypt[-0].yyv.p); } break;
case 153:
#line	373	"awkgram.y"
{ yyval.p = op3(GETLINE, yypt[-0].yyv.p, NIL, NIL); } break;
case 154:
#line	374	"awkgram.y"
{ yyval.p = op3(GETLINE, NIL, NIL, NIL); } break;
case 155:
#line	376	"awkgram.y"
{ yyval.p = op2(INDEX, yypt[-3].yyv.p, yypt[-1].yyv.p); } break;
case 156:
#line	378	"awkgram.y"
{ ERROR "index() doesn't permit regular expressions" SYNTAX;
		  yyval.p = op2(INDEX, yypt[-3].yyv.p, (Node*)yypt[-1].yyv.s); } break;
case 157:
#line	380	"awkgram.y"
{ yyval.p = yypt[-1].yyv.p; } break;
case 158:
#line	382	"awkgram.y"
{ yyval.p = op3(MATCHFCN, NIL, yypt[-3].yyv.p, (Node*)makedfa(yypt[-1].yyv.s, 1)); } break;
case 159:
#line	384	"awkgram.y"
{ if (constnode(yypt[-1].yyv.p))
			yyval.p = op3(MATCHFCN, NIL, yypt[-3].yyv.p, (Node*)makedfa(strnode(yypt[-1].yyv.p), 1));
		  else
			yyval.p = op3(MATCHFCN, (Node *)1, yypt[-3].yyv.p, yypt[-1].yyv.p); } break;
case 160:
#line	388	"awkgram.y"
{ yyval.p = celltonode(yypt[-0].yyv.cp, CCON); } break;
case 161:
#line	390	"awkgram.y"
{ yyval.p = op4(SPLIT, yypt[-5].yyv.p, makearr(yypt[-3].yyv.p), yypt[-1].yyv.p, (Node*)STRING); } break;
case 162:
#line	392	"awkgram.y"
{ yyval.p = op4(SPLIT, yypt[-5].yyv.p, makearr(yypt[-3].yyv.p), (Node*)makedfa(yypt[-1].yyv.s, 1), (Node *)REGEXPR); } break;
case 163:
#line	394	"awkgram.y"
{ yyval.p = op4(SPLIT, yypt[-3].yyv.p, makearr(yypt[-1].yyv.p), NIL, (Node*)STRING); } break;
case 164:
#line	395	"awkgram.y"
{ yyval.p = op1(yypt[-3].yyv.i, yypt[-1].yyv.p); } break;
case 165:
#line	396	"awkgram.y"
{ yyval.p = celltonode(yypt[-0].yyv.cp, CCON); } break;
case 166:
#line	398	"awkgram.y"
{ yyval.p = op4(yypt[-5].yyv.i, NIL, (Node*)makedfa(yypt[-3].yyv.s, 1), yypt[-1].yyv.p, rectonode()); } break;
case 167:
#line	400	"awkgram.y"
{ if (constnode(yypt[-3].yyv.p))
			yyval.p = op4(yypt[-5].yyv.i, NIL, (Node*)makedfa(strnode(yypt[-3].yyv.p), 1), yypt[-1].yyv.p, rectonode());
		  else
			yyval.p = op4(yypt[-5].yyv.i, (Node *)1, yypt[-3].yyv.p, yypt[-1].yyv.p, rectonode()); } break;
case 168:
#line	405	"awkgram.y"
{ yyval.p = op4(yypt[-7].yyv.i, NIL, (Node*)makedfa(yypt[-5].yyv.s, 1), yypt[-3].yyv.p, yypt[-1].yyv.p); } break;
case 169:
#line	407	"awkgram.y"
{ if (constnode(yypt[-5].yyv.p))
			yyval.p = op4(yypt[-7].yyv.i, NIL, (Node*)makedfa(strnode(yypt[-5].yyv.p), 1), yypt[-3].yyv.p, yypt[-1].yyv.p);
		  else
			yyval.p = op4(yypt[-7].yyv.i, (Node *)1, yypt[-5].yyv.p, yypt[-3].yyv.p, yypt[-1].yyv.p); } break;
case 170:
#line	412	"awkgram.y"
{ yyval.p = op3(SUBSTR, yypt[-5].yyv.p, yypt[-3].yyv.p, yypt[-1].yyv.p); } break;
case 171:
#line	414	"awkgram.y"
{ yyval.p = op3(SUBSTR, yypt[-3].yyv.p, yypt[-1].yyv.p, NIL); } break;
case 174:
#line	420	"awkgram.y"
{ yyval.p = op2(ARRAY, makearr(yypt[-3].yyv.p), yypt[-1].yyv.p); } break;
case 175:
#line	421	"awkgram.y"
{ yyval.p = op1(INDIRECT, celltonode(yypt[-0].yyv.cp, CVAR)); } break;
case 176:
#line	422	"awkgram.y"
{ yyval.p = op1(INDIRECT, yypt[-0].yyv.p); } break;
case 177:
#line	426	"awkgram.y"
{ arglist = yyval.p = 0; } break;
case 178:
#line	427	"awkgram.y"
{ arglist = yyval.p = celltonode(yypt[-0].yyv.cp,CVAR); } break;
case 179:
#line	428	"awkgram.y"
{
			checkdup(yypt[-2].yyv.p, yypt[-0].yyv.cp);
			arglist = yyval.p = linkum(yypt[-2].yyv.p,celltonode(yypt[-0].yyv.cp,CVAR)); } break;
case 180:
#line	434	"awkgram.y"
{ yyval.p = celltonode(yypt[-0].yyv.cp, CVAR); } break;
case 181:
#line	435	"awkgram.y"
{ yyval.p = op1(ARG, (Node *) yypt[-0].yyv.i); } break;
case 182:
#line	436	"awkgram.y"
{ yyval.p = op1(VARNF, (Node *) yypt[-0].yyv.cp); } break;
case 183:
#line	441	"awkgram.y"
{ yyval.p = notnull(yypt[-1].yyv.p); } break;
	}
	goto yystack;  /* stack new state and value */
}
