/* Copyright (C) 1990, 1993 Free Software Foundation, Inc.

   This file is part of GNU ISPELL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <stdlib.h>

#undef __STDC__

#include <stdio.h>
#include <signal.h>
#include <setjmp.h>

#include <signal.h>
#include <process.h>
#include "ispell.h"
#include <conio.h>

#define __STDC__

void shellfun (void);
void shellescape (char *);
int dochild ( void (*fun) (void));
void termuninit (void);
void termreinit (void);

extern int reading_interactive_command;
extern jmp_buf command_loop;

int erasechar, killchar;

static int li;

/*
void tputs (char *str, int (*put) (int ))
{
  while (*str)
    (*put) (*str++);
}
*/


void
erase ()
{
//   cputs ( "\b \b" ) ;
    clrscr ();
}

void
move (int row, int col)
{
  gotoxy ( col + 1 , row + 1 ) ;
}


void
inverse ()
{
  textcolor(BLACK);
  textbackground(WHITE);
}

void
normal ()
{
  textcolor(WHITE);
  textbackground(BLACK);
}

void
backup ()
{
  putchar ( '\b');
}

// static int termchanged = 0;

void
terminit ()
{
   clrscr();
}

void
termflush (NOARGS)
{
   clrscr();
}

void
termuninit (NOARGS)
{
}

void
termreinit (NOARGS)
{
}

static char *shellcmd, *shellsh;;

void
shellfun (NOARGS)
{
  if ( spawnlp ( P_WAIT , shellsh, shellsh,
                 ( strcmp ( shellcmd , "" ) ? "/C" : NULL ) ,
		   shellcmd , NULL ) )
          perror ( "shellfun:" ) ;
}


void
shellescape (char *buf)
{
  shellsh = (char *) getenv ( "COMSPEC" );
  if (shellsh == NULL)
    shellsh = "c:\\command.com";
  shellcmd = buf;
  (void) dochild (shellfun);
  (void) printf ("\n-- Type space to continue --");
  getch ();
}

int
dochild ( void (*fun) (void))
{
  termuninit ();
  (*fun) () ;
  termreinit ();
  return (0);
}


void
stop (void)
{
}

void
termbeep ()
{
  putch ( '\a' ) ;
}
