/* -*- c -*-
 * GNU m4 -- A simple macro processor
 * Copyright (C) 1989, 1990, 1991 Free Software Foundation, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <ctype.h>
#include <varargs.h>

#include "obstack.h"

extern char *malloc();
extern char *realloc();
extern void free();
extern char *mktemp();
extern int mkstemp();
#ifdef MSDOS
extern FILE *popen(char *, char *);
extern int pclose(FILE *);
#endif

#ifdef USG
#include <string.h>
#define	index(s, c)	strchr((s), (c))
#define	rindex(s, c)	strrchr((s), (c))

#include <memory.h>
#define bcmp(s1, s2, n)	memcmp ((s1), (s2), (n))
#define bzero(s, n)	memset ((s), 0, (n))
#define bcopy(s, d, n)	memcpy ((d), (s), (n))

#else /* not USG */
#include <strings.h>

extern int bcmp ();
extern void bzero (), bcopy ();
#endif /* USG */


#define obstack_chunk_alloc	xmalloc
#define obstack_chunk_free	xfree

#ifdef __STDC__
#define nil NULL
#else
#define nil 0
#endif

typedef enum boolean { false = 0, true = 1 } boolean;

extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];

#define syserr() ((errno > 0 && errno < sys_nerr) ? sys_errlist[errno] : "Unknown error")


/* miscellaneous, that must be first */
typedef void builtin_func();


/* File: m4.c  --- global definitions*/

/* Option flags */
extern int interactive;			/* -e */
extern int sync_output;			/* -s */
extern int debug_level;			/* -d */
extern int hash_table_size;		/* -H */
extern int ndivertion;			/* -N */
extern int no_gnu_extensions;		/* -g */
extern int max_debug_argument_length;	/* -l */

/* Error handling */
extern void warning();
extern void error();
extern void fatal();
extern void internal_error();

/* Memory allocation */
extern char *xmalloc();
extern char *xrealloc();
extern void xfree();
extern char *xstrdup();


/* File: debug.c  --- debugging and tracing function */

/* debug_level is a bitmask of these */
enum debug_info {
    debug_trace_args = 0x01,		/* a: show arglist in trace output */
    debug_trace_expansion = 0x02,	/* e: show expansion in trace output */
    debug_trace_quote = 0x04,		/* q: quote args and expansion in trace output */
    debug_trace_all = 0x08,		/* t: trace all macros -- overrides trace{on,off} */
    debug_trace_line = 0x10,		/* l: add line numbers to trace output */
    debug_trace_file  = 0x20,		/* f: add file name to trace output */
    debug_trace_path = 0x40,		/* p: trace path search of include files */
    debug_trace_call = 0x80,		/* c: show macro call before args collection */
    debug_trace_input = 0x100,		/* i: trace changes of input files */
    debug_trace_callid = 0x200,		/* x: add call id to trace output */

    debug_trace_verbose = 0x3ff,	/* V: very verbose --  print everything */
    debug_trace_default = 0x07,		/* default flags -- equiv: aeq */
};

extern void debug_init();
extern int debug_decode_flags();
extern boolean debug_set_output();
extern void debug_print();
extern void debug_message();

extern void trace_prepre();
extern void trace_pre();
extern void trace_post();


/* File: input.c  --- lexical definitions */

/* Various different token types */
enum token_type {
    TOKEN_EOF,				/* end of file */
    TOKEN_STRING,			/* a quoted string */
    TOKEN_WORD,				/* an identifier */
    TOKEN_SIMPLE,			/* a single character */
    TOKEN_MACDEF,			/* a macros definition (see "defn") */
};

/* The amount of data for a token, a macro argument, and a macro definition */
enum token_data_type {
    TOKEN_VOID,
    TOKEN_TEXT,
    TOKEN_FUNC,
};

struct token_data {
    enum token_data_type type;
    union {
	struct {
	    char *text;
	} u_t;
	struct {
	    builtin_func *func;
	    boolean traced;
	} u_f;
    } u;
};

#define TOKEN_DATA_TYPE(td)		((td)->type)
#define TOKEN_DATA_TEXT(td)		((td)->u.u_t.text)
#define TOKEN_DATA_FUNC(td)		((td)->u.u_f.func)
#define TOKEN_DATA_FUNC_TRACED(td) 	((td)->u.u_f.traced)

typedef enum token_type token_type;
typedef enum token_data_type token_data_type;
typedef struct token_data token_data;

extern void input_init();
extern int peek_input();
extern token_type next_token();
extern void skip_line();

/* push back input */
extern void push_file();
extern void push_macro();

extern void push_string();
extern struct obstack *push_string_init();
extern char *push_string_finish();

extern void push_wrapup();
extern boolean pop_wrapup();

/* current input file, and line */
extern char *current_file;
extern int current_line;

/* left and right quote, begin and end comment */
extern char *bcomm, *ecomm;
extern char *lquote, *rquote;
/* lenght of quote strings */
extern int len_lquote, len_rquote;

#define DEF_LQUOTE "`"
#define DEF_RQUOTE "\'"
#define DEF_BCOMM "#"
#define DEF_ECOMM "\n"

extern void set_quotes();
extern void set_comment();


/* File: output.c --- output functions */
extern int output_lines;
extern int output_current_line;

#define NDIVERTIONS	10		/* Default, overridden by -Nnum */

extern void output_init();
extern void sync_line();
extern void shipout_text();
extern void make_divertion();
extern void insert_divertion();
extern void insert_file();


/* File symtab.c  --- symbol table definitions */

/* Operation modes for lookup_symbol() */
enum symbol_lookup {
    SYMBOL_LOOKUP,
    SYMBOL_INSERT,
    SYMBOL_DELETE,
    SYMBOL_PUSHDEF,
    SYMBOL_POPDEF,
};

/* Symbol table entry */
struct symbol {
    struct symbol *next;
    boolean traced;
    boolean shadowed;
    boolean macro_args;

    char *name;
    token_data data;
};

#define SYMBOL_NEXT(s)		((s)->next)
#define SYMBOL_TRACED(s)	((s)->traced)
#define SYMBOL_SHADOWED(s)	((s)->shadowed)
#define SYMBOL_MACRO_ARGS(s)	((s)->macro_args)
#define SYMBOL_NAME(s)		((s)->name)
#define SYMBOL_TYPE(s)		(TOKEN_DATA_TYPE(&(s)->data))
#define SYMBOL_TEXT(s)		(TOKEN_DATA_TEXT(&(s)->data))
#define SYMBOL_FUNC(s)		(TOKEN_DATA_FUNC(&(s)->data))

typedef enum symbol_lookup symbol_lookup;
typedef struct symbol symbol;
typedef void hack_symbol();

#define HASHMAX 509			/* Default, overridden by -Hsize */

extern symbol **symtab;

extern void symtab_init();
extern symbol *lookup_symbol();

extern void hack_all_symbols();


/* File: macro.c  --- macro expansion */

extern void expand_input();
extern void call_macro();


/* File: builtin.c  --- builtins */

struct builtin {
    char *name;
    boolean gnu_extension;
    boolean groks_macro_args;
    builtin_func *func;
};

struct predefined {
    char *unix_name;
    char *gnu_name;
    char *func;
};

typedef struct builtin builtin;
typedef struct predefined predefined;

extern void builtin_init();
extern void define_user_macro();
extern void undivert_all();
extern void expand_user_macro();

extern builtin *find_builtin_by_addr();


/* File: path.c  --- path search for include files */

extern void include_init();
extern void include_env_init();
extern void add_include_directory();
extern FILE *path_search();


/* File: eval.c  --- expression evaluation */

extern boolean evaluate();


/* File: format.c  --- printf like formatting */

extern void format();


/* Debug stuff */

#ifdef DEBUG
#define DEBUG_INPUT
#define DEBUG_MACRO
#define DEBUG_SYM
#define DEBUG_INCL
#endif
