NAME
     csplit - split a file into sections determined by context lines

SYNOPSIS
     csplit [-sk] [-f prefix] [-n digits] [--prefix=prefix]  [--digits=digits]
     [--quiet] [--silent] [--keep-files] file pattern...

DESCRIPTION
     This manual page documents the GNU version  of  csplit.   csplit  creates
     zero or more output files containing sections of the given input file, or
     the standard input if the name `-' is given.  By default,  csplit  prints
     the  number  of  bytes  written  to  each  output  file after it has been
     created.

     The contents of the output files are determined by the pattern arguments.
     An error occurs if a pattern argument refers to a nonexistent line of the
     input file, such  as  if  no  remaining  line  matches  a  given  regular
     expression.  The types of pattern arguments are:

     line
          Create an output file containing the current line  up  to  (but  not
          including)  line  line  (a  positive integer) of the input file.  If
          followed by a repeat count, also create an  output  file  containing
          the next line lines of the input file once for each repeat.

     /regexp/[offset]
          Create an output file containing the current line  up  to  (but  not
          including) the next line of the input file that contains a match for
          regexp.  The optional offset is a `+' or `-' followed by a  positive
          integer;  if  it  is given, the line that starts the next section of
          the input file is the line that contains the match for  regexp  plus
          the offset.

     %regexp%[offset]
          Like the previous type, except that it does  not  create  an  output
          file, so that section of the input file is effectively ignored.

     {repeat-count}
          Repeat  the  previous  pattern  repeat-count  (a  positive  integer)
          additional times.

     The output file names consist of a prefix followed by a number,  so  that
     concatenating  the output files in sorted order by file name produces the
     original input file, in order.  The default output file  name  prefix  is
     `xx'.

     By  default,  if  csplit  encounters  an  error  or  receives  a  hangup,
     interrupt, quit, or terminate signal, it removes any output files that it
     has created so far before it exits.

     OPTIONS

     -f, --prefix=prefix
          Use prefix as the output file name prefix.

     -k, --keep-files
          Do not remove output files.

     -n, --digits=digits
          Use output file names containing numbers that are digits digits long
          instead of the default 2.

     -s, --silent, --quiet
          Do not print counts of output file sizes.

     The long-named options can be introduced with `+' as well  as  `--',  for
     compatibility with previous releases.  Eventually support for `+' will be
     removed, because it is incompatible with the POSIX.2 standard.
