#define	CURSES_LIBRARY	1
#include <curses.h>
#undef init_pair

#ifdef PDCDEBUG
char *rcsid_initpair = "$Header: C:\CURSES\portable\RCS\initpair.c 2.1 1993/06/18 20:20:09 MH Rel MH $";
#endif




/*man-start*********************************************************************

  initpair()	- Change the definition of a color-pair.

  PDCurses Description:

 	This routine is used to change the definition of a color-pair.
 	The routine takes three arguments: the number of the color-pair
 	to be redefined, and the new values of the foreground and
 	background colors.

 	The value of colorpair must be between 1 and COLOR_PAIRS-1.
 	The values of foreground and background must be between 0 and
 	COLORS-1.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with values outside of the
 	ranges specified above.

  Portability:
 	PDCurses	int init_pair( int colorpair, short foreground, short background);
 	SYS V Curses	int init_pair( int colorpair, short foreground, short background);

**man-end**********************************************************************/

unsigned char    atrtab[MAX_ATRTAB] = /* COLOR_PAIR to attribute encoding table. */
 {0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,0x07,0x0F,0x70,0x78,0x87,0x8F,0xF0,0xF8,
  0x70,0x00,0x17,0x00,0x00,0x00,0x00,0x00
  };

int init_pair(int colorpair,short foreground,short background)
{
 extern int COLOR_PAIRS;
 unsigned char norm,reverse;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("init_pair() - called: colorpair %d fore %d back %d\n",colorpair,foreground,background);
#endif

 if (colorpair >= COLOR_PAIRS || colorpair < 1)
    return(ERR);

 norm = (unsigned char)(foreground & 0x0007) + ((background & 0x0007)<<4);
 reverse = (unsigned char)(background & 0x0007) + ((foreground & 0x0007)<<4);

#ifdef CHTYPE_LONG
 atrtab[colorpair] = norm;
#else
 atrtab[(colorpair*8)+0] = norm;                             /* normal */
 atrtab[(colorpair*8)+1] = norm + 8;                       /* bold */
 atrtab[(colorpair*8)+2] = reverse;                     /* reverse */
 atrtab[(colorpair*8)+3] = reverse + 8;            /* bold-reverse */
 atrtab[(colorpair*8)+4] = norm + 128;                    /* blink */
 atrtab[(colorpair*8)+5] = norm + 8 + 128;           /* bold-blink */
 atrtab[(colorpair*8)+6] = reverse + 128;         /* reverse-blink */
 atrtab[(colorpair*8)+7] = reverse + 8 + 128;/* reverse-bold-blink */
#endif
 return(OK);
}
