#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	newpad

#ifdef PDCDEBUG
char *rcsid_newpad = "$Header: C:\CURSES\portable\RCS\newpad.c 2.1 1993/06/18 20:20:29 MH Rel MH $";
#endif




/*man-start*********************************************************************

  newpad()	- Create new pad

  X/Open Description:
 	Creates a new pad data structure.  A pad is a special case of a
 	window, which is not restricted by the screen size, and is not
 	necessarily associated with a particular part of the screen.  A
 	pad can be used when a large window is needed, and only a part
 	of the window will be on the screen at one tme.  Automatic
 	refreshes of pads (e.g., from scrolling or echoing of input) do
 	not occur.  It is not legal to call refresh() with a pad as an
 	argument; the routines prefresh() or pnoutrefresh() should be
 	called instead.  Note that these routines require additional
 	parameters to specify the part of the pad to be displayed and
 	the location on the screen to be used for display.

  PDCurses Description:
 	PDCurses (as a library) provides the developer with the ability to
 	hook in their own malloc debugging  package.  See the details in
 	INITSCR.C for details on how to accomplish this.

  X/Open Return Value:
 	The newpad() function returns a pointer to the new WINDOW structure
 	created on success and returns a null pointer on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	WINDOW* newpad( int nlines, int ncols );
 	X/Open Dec '88	WINDOW* newpad( int nlines, int ncols );
 	SYS V Curses	WINDOW* newpad( int nlines, int ncols );

**man-end**********************************************************************/

WINDOW* newpad( int nlines, int ncols )
{
extern	void*	(*mallc)( size_t );
extern	void*	(*callc)( size_t, size_t );
extern	void	(*fre)( void* );

	WINDOW* win;
	chtype* ptr;
	int	i;
	int	j;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("newpad() - called: lines=%d cols=%d\n",nlines,ncols);
#endif

	if ((win = PDC_makenew( nlines, ncols, -1, -1 )) == (WINDOW *)NULL)
		return( (WINDOW *)NULL );

	for (i = 0; i < nlines; i++)
	{
		/*
		 * make and clear the lines
		 */
		if ((win->_y[i] = (*callc)(ncols, sizeof(chtype))) == NULL)
		{
			for (j = 0; j < i; j++)
			{
				/*
				 * if error, free all the data
				 */
				(*fre)(win->_y[j]);
			}
			(*fre)(win->_firstch);
			(*fre)(win->_lastch);
			(*fre)(win->_y);
			(*fre)(win);
			return( (WINDOW *)NULL );
		}
		else
		{
			for (ptr = win->_y[i];
			     ptr < win->_y[i] + ncols;)
			{
				/*
				* Retain the original screen attributes...
				*/

				*ptr++ = _cursvar.blank;	
			}
		}
	}
	win->_flags = _PAD;
	return( win );
}
