#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	reset_prog_mode

#ifdef PDCDEBUG
char *rcsid_reset_pr = "$Header: C:\CURSES\portable\RCS\reset_pr.c 2.1 1993/06/18 20:20:56 MH Rel MH $";
#endif

#ifndef UNIX

/*man-start*********************************************************************

  reset_prog_mode()	- restore terminal mode

  X/Open Description:
 	Restore the terminal to "program" (in curses) or "shell" (out
 	of curses) state.  These are done automatically by endwin()
 	and doupdate() after an endwin(), so they would normally not
 	be called before these functions.

  PDCurses Description:
 	Under the Flexos platform, PDCurses operates in 16-bit mode.
 	Normally, the Flexos shell operates in 8-bit mode.

  X/Open Return Value:
 	The reset_prog_mode() routine returns OK on success otherwise ERR
 	is returned.

  Portability:
 	PDCurses	int reset_prog_mode( void );
 	X/Open Dec '88	int reset_prog_mode( void );
 	SysV Curses	int reset_prog_mode( void );
 	BSD Curses	int reset_prog_mode( void );

**man-end**********************************************************************/

int	reset_prog_mode(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("reset_prog_mode() - called\n");
#endif

	if	(c_pr_tty.been_set == TRUE)
	{

		memcpy(&_cursvar, &c_pr_tty.saved, sizeof(SCREEN));

		mvcur(0, 0, c_pr_tty.saved.cursrow, c_pr_tty.saved.curscol);
		if (PDC_get_ctrl_break() != c_pr_tty.saved.orgcbr)
			PDC_set_ctrl_break(c_pr_tty.saved.orgcbr);
		if (c_pr_tty.saved.raw_out)
			raw();
		if (c_pr_tty.saved.visible_cursor)
			curson();
		_cursvar.font = PDC_get_font();
		PDC_set_font(c_pr_tty.saved.font);
		if (!PDC_scrn_modes_equal (PDC_get_scrn_mode(),  c_pr_tty.saved.scrnmode))
			PDC_set_scrn_mode(c_pr_tty.saved.scrnmode);

		PDC_set_rows(c_pr_tty.saved.lines);
	}
#ifdef	FLEXOS
	_flexos_16bitmode();
#endif
	return( OK );
}
#endif
