-- Source Ex3.Ada
-- By Arthur V. Lopes, 7/12/94
-- This program implements a solution for the problem exibited
-- by the program Concurrent_Programming_1.

-- It shows you how to exploit one of the advantages of a protected unit.
-- Remember that protected units are available only in Ada 9X.

-- By definition, a procedured defined within the specification part
-- of a protected unit can be executed by only one task and no other
-- task can make use of any entity visible of this protected unit while
-- this procedure is executing. See ARM 9.4 for more information.
-- Therefore we will encapsulate calls to services provided by package
-- VT100 into a protected unit.
-- But this will not be sufficient. We will also have to place a layer
-- protecton on top of procedure MoveCursor. 
-- We need to move the cursor and display the character as one atomic 
-- instruction. Procedure Display_At will do this.
-- Compile and run this program.
-- It worked but still does not produces the same effect on the screen
-- as the Sequential_Programming (Ex1.Ada) program did. Why?
-- The next program, Concurrent_Programming_3 will solve the remaining
-- problem.

WITH Ada.Text_IO, VT100; USE Ada.Text_IO;
PROCEDURE Concurrent_Programming_2 IS

	PROTECTED Screen IS
		PROCEDURE ClearScreen;
		PROCEDURE Display_At(Column, Row : Integer; C : Character);
	END Screen;

	PROTECTED BODY Screen IS

		PROCEDURE ClearScreen IS
		BEGIN
			VT100.ClearScreen;
		END ClearScreen;

		PROCEDURE Display_At(Column, Row : Integer; C : Character) IS
	
		BEGIN
			VT100.MoveCursor(Column,Row);
			Put(C);
		END Display_At;  
	END Screen;

	SUBTYPE Interval IS INTEGER RANGE 1 .. 10;

	TASK Display_A; -- This is the specification part of Display_A
	TASK Display_B;

	TASK BODY Display_A IS -- This is the body part of Display_A
	BEGIN
		FOR I IN Interval LOOP
			Display_At(I,1,'A');
			DELAY 0.01;
		END LOOP;
	END Display_A;

	TASK BODY Display_B IS
	BEGIN
		FOR I IN Interval LOOP
			Display_At(I,2,'B');
			DELAY 0.01;
		END LOOP;
	END Display_B;

BEGIN
	ClearScreen;
	New_Line;
END Concurrent_Programming_2;