
with TEXT_IO;

package DRGEN is

	-- I/O RELATED ISSUES

	procedure PUT(x: in CHARACTER);
	procedure GET(x: out CHARACTER);
	procedure GET_LINE(x: out CHARACTER);
	procedure PUT_LINE(x: in CHARACTER);

	procedure PUT(x: in INTEGER);
	procedure GET(x: out INTEGER);
	procedure GET_LINE(x: out INTEGER);
	procedure PUT_LINE(x: in INTEGER);

	procedure PUT(x: in FLOAT);
	procedure GET(x: out FLOAT);
	procedure GET_LINE(x: out FLOAT);
	procedure PUT_LINE(x: in FLOAT);
	procedure PUT_LINE(x: in FLOAT; width: in NATURAL;
		mantissa: in NATURAL);

	procedure GET(x: out STRING);
	procedure PUT(x: in STRING);
	procedure GET_LINE(x: out STRING; last: out NATURAL);
	procedure PUT_LINE(x: in STRING);

	procedure NEW_LINE;

	-- PARSING RELATED ISSUES

	type Token is
		record
			str: string(1..40);
			size: natural;
		end record;

	type TokenArray is array (positive range <>) of Token;

	function upcase (c : in character) return character;
	procedure uppercase(str: in out string; size: in natural);

	procedure parse (str :in string;  size : in natural; TokenList:
		in out TokenArray; TokenCount : out Integer);

	function number (C : in character) return integer;
	function atoi(in_str: in string; size: in natural) return integer;
	function atob(str: in string; size: in natural) return boolean;
	function atof(in_str: in string; size: in natural) return float;
	function atoc(in_str: in string; size: in natural) return character;

	function is_digit(C: in character) return boolean;

	function is_integer(in_str: in string; size: in natural)
			return boolean;
	function is_boolean(in_str: in string; size: in natural)
			return boolean;
	function is_float(in_str: in string; size: in natural)
			return boolean;
	function is_character(in_str: in string; size: in natural)
			return boolean;

	-- HISTORY RELATED ISSUES

	type NODE;
	type NODE_PTR is access NODE;
	type NODE is
		record
			Operation: string(1..200);
			size: natural;
			next: NODE_PTR;
		end record;
	type HISTORY_LIST is
		record
			head: NODE_PTR;
			tail: NODE_PTR;
		end record;

	procedure INIT_LIST(L1: in out HISTORY_LIST);
	procedure INSERT(L1: in out HISTORY_LIST; istring: in STRING;
		size: in INTEGER);
	procedure DISPLAY(L1: IN HISTORY_LIST);

	error_condition: exception;
end DRGEN;
