
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adadomen.adb "adatui-do_menu.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure do_menu ( mp: a_menu_t ) is
   y       : aliased integer;
   x       : aliased integer;
   nitems  : aliased integer;
   barlen  : aliased integer;
   mheight : integer;
   mw      : integer;
   old     : integer := -1;
   cur     : integer :=  0;
   cur0    : integer;
   stop    : boolean := FALSE;
   menu_window : pdcurses.A_WINDOW_T;
   void    : c.signed_int;

begin
   hide_cursor;
   get_menu_position ( y'access, x'access );
   menu_dimension ( mp, nitems'access, barlen'access );
   mheight := nitems + 2;
   mw := barlen + 2;

   declare
      parm1 : c.signed_int;
      parm2 : c.signed_int;
      parm3 : c.signed_int;
      parm4 : c.signed_int;

   begin
      parm1 := c.signed_int ( mheight );
      parm2 := c.signed_int ( mw      );
      parm3 := c.signed_int ( y       );
      parm4 := c.signed_int ( x       );
      menu_window := pdcurses.newwin ( parm1, parm2, parm3, parm4 );
   end;
	 
   color_box (  
      window => menu_window,
      color  => SUBMENUCOLOR,
      hasbox => TRUE ); 

   repaint_menu (
      menu_window  => menu_window,
      a_menu => mp ); 

   key := pdcurses.ERR;
   while not stop and not quit loop
      if cur /= old then
	 declare
	    temp       : c.signed_int;
	    temp_str   : bstrings.bounded_string;
	    temp_str2  : bstrings.bounded_string;
	    temp_charv : aliased c.charv(1..80); 
	    temp_charp : c.charp;

	 begin
	    if old /= -1 then
	       temp_str := pad_string (
		  str    => mp.all(old).item_name.all,
		  length => barlen - 1 );

	       temp_str2 := prepad_string (
		  str    => bstrings.to_string ( temp_str ),
		  length => 1 );

	       make_charv (
		  source => temp_str2,
		  target => temp_charv );

	       temp := c.signed_int ( old + 1 );
	    --
            -- using unchecked access because c.charp is defined at a higher
            -- level than temp_charv - creates a potential for dangling pointers
            --
	       temp_charp := temp_charv'unchecked_access;
	       
	       void := pdcurses.mvwaddstr
		  ( menu_window, temp, 1, temp_charp );
	    end if;

	    set_color (
	       window => menu_window,
	       color  => SUBMENUREVCOLOR );

	    temp_str := pad_string (
	       str    => mp.all(cur).item_name.all,
	       length => barlen - 1 );

	    temp_str2 := prepad_string (
	       str    => bstrings.to_string ( temp_str ),
	       length => 1 );

	    make_charv (
	       source => temp_str2,
	       target => temp_charv );
         --
         -- using unchecked access because type c.charp is defined at a higher
         -- level than temp_charv - creates a potential for dangling pointers
         --
	    temp_charp := temp_charv'unchecked_access;

	    temp := c.signed_int ( cur + 1 );
	    void := pdcurses.mvwaddstr( menu_window, temp, 1, temp_charp );

	    set_color (
	       window => menu_window,
	       color  => SUBMENUCOLOR );

	    status_message ( msg => mp.all(cur).item_desc.all );
	    old := cur;
	    void := pdcurses.wrefresh ( menu_window );
	 end;
      end if;

      if key = pdcurses.ERR then
	 key := wait_for_key;
      end if; 

      case key is
  	 when NEWLINE | pdcurses.PADENTER =>  
	    void := pdcurses.touchwin ( body_window );
	    void := pdcurses.wrefresh ( body_window );

	    set_menu_position ( 
	       y => y + 1,
	       x => x + 1 );

	    rmerror;
	    key := pdcurses.ERR;
	    normal_cursor;
	    mp.all(cur).item_func.all;
	    hide_cursor;

	    repaint_menu (
	       menu_window  => menu_window,
	       a_menu => mp   ); 

	    old := -1;

	 when pdcurses.KEY_UP | KEY_UP =>
	    cur := ( cur + nitems - 1 ) mod nitems;
	    key := pdcurses.ERR;

	 when pdcurses.KEY_DOWN | KEY_DOWN =>
	    cur := ( cur + 1 ) mod nitems;
	    key := pdcurses.ERR;

	 when KEY_ESC | pdcurses.KEY_LEFT  | KEY_LEFT | 
                        pdcurses.KEY_RIGHT | KEY_RIGHT =>
	    if key = KEY_ESC then
	       key := pdcurses.ERR;
	    end if;

	    stop := TRUE;

	 when others =>
	    declare
	       A, B      : boolean;
	    begin
	       cur0 := cur;
	       loop
		  cur := (cur + 1) mod nitems;
		  A := ( cur /= cur0 ); 
		  B := ( hotkey ( mp.all(cur).item_name.all ) /= 
		     ( ada.characters.handling.to_upper (
			 character'val(key)) ) );

		  exit when not (A and B);
	       end loop;

	       if not B then 
		  key := NEWLINE;
	       else
		  key := pdcurses.ERR;
	       end if;
	    end;
      end case;
   end loop;

   rmerror;
   void := pdcurses.delwin   ( menu_window );
   void := pdcurses.touchwin ( body_window );
   void := pdcurses.wrefresh ( body_window );

exception
   when others =>
      error_message ( msg => "ERROR : do_menu" );
end do_menu;
