
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adcolbox.adb "adatui-color_box.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure color_box (  
   window : pdcurses.A_WINDOW_T;
   color  : integer;
   hasbox : boolean )
is  
   attr : pdcurses.chtype;
   parm : pdcurses.chtype;
   void : c.signed_int;
   subtype ch is pdcurses.chtype;
   use type ch;

begin
   attr := ch(color) and ch(A_ATTR);

   set_color (
      window => window,
      color  => color );

   if pdcurses.has_colors /= pdcurses.FALSE then
      parm := pdcurses.color_pair( ch(color) and ch(pdcurses.A_CHARTEXT) );
      parm := parm or ( attr and not ch(pdcurses.A_REVERSE) );
      void := pdcurses.wbkgd ( window, parm );
   else
      void := pdcurses.wbkgd ( window, ch(color) );
   end if;

   void := pdcurses.werase ( window );

   if hasbox and ( pdcurses.getmaxy(window) > 2 ) then
      void := pdcurses.box ( window, 0, 0 );
   end if;

   void := pdcurses.touchwin ( window );
   void := pdcurses.wrefresh ( window );
end color_box;
